/*     */ package org.jboss.resource.adapter.jms;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import javax.jms.BytesMessage;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.IllegalStateException;
/*     */ import javax.jms.InvalidDestinationException;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.MapMessage;
/*     */ import javax.jms.Message;
/*     */ import javax.jms.MessageConsumer;
/*     */ import javax.jms.MessageListener;
/*     */ import javax.jms.MessageProducer;
/*     */ import javax.jms.ObjectMessage;
/*     */ import javax.jms.Queue;
/*     */ import javax.jms.QueueBrowser;
/*     */ import javax.jms.QueueReceiver;
/*     */ import javax.jms.QueueSender;
/*     */ import javax.jms.QueueSession;
/*     */ import javax.jms.Session;
/*     */ import javax.jms.StreamMessage;
/*     */ import javax.jms.TemporaryQueue;
/*     */ import javax.jms.TemporaryTopic;
/*     */ import javax.jms.TextMessage;
/*     */ import javax.jms.Topic;
/*     */ import javax.jms.TopicPublisher;
/*     */ import javax.jms.TopicSession;
/*     */ import javax.jms.TopicSubscriber;
/*     */ import javax.resource.spi.ConnectionEvent;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JmsSession
/*     */   implements Session, QueueSession, TopicSession
/*     */ {
/*  67 */   private static final Logger log = Logger.getLogger(JmsSession.class);
/*     */   private JmsManagedConnection mc;
/*     */   private JmsConnectionRequestInfo info;
/*     */   private JmsSessionFactory sf;
/*  79 */   private HashSet consumers = new HashSet();
/*     */ 
/*  82 */   private HashSet producers = new HashSet();
/*     */ 
/*  85 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public JmsSession(JmsManagedConnection mc, JmsConnectionRequestInfo info)
/*     */   {
/*  94 */     this.mc = mc;
/*  95 */     this.info = info;
/*  96 */     if (this.trace)
/*  97 */       log.trace("new JmsSession " + this + " mc=" + mc + " cri=" + info);
/*     */   }
/*     */ 
/*     */   public void setJmsSessionFactory(JmsSessionFactory sf)
/*     */   {
/* 102 */     this.sf = sf;
/*     */   }
/*     */ 
/*     */   Session getSession()
/*     */     throws JMSException
/*     */   {
/* 115 */     if (this.mc == null) {
/* 116 */       throw new IllegalStateException("The session is closed");
/*     */     }
/* 118 */     Session session = this.mc.getSession();
/* 119 */     if (this.trace)
/* 120 */       log.trace("getSession " + session + " for " + this);
/* 121 */     return session;
/*     */   }
/*     */ 
/*     */   public BytesMessage createBytesMessage()
/*     */     throws JMSException
/*     */   {
/* 128 */     Session session = getSession();
/* 129 */     if (this.trace)
/* 130 */       log.trace("createBytesMessage" + session);
/* 131 */     return session.createBytesMessage();
/*     */   }
/*     */ 
/*     */   public MapMessage createMapMessage() throws JMSException
/*     */   {
/* 136 */     Session session = getSession();
/* 137 */     if (this.trace)
/* 138 */       log.trace("createMapMessage" + session);
/* 139 */     return session.createMapMessage();
/*     */   }
/*     */ 
/*     */   public Message createMessage() throws JMSException
/*     */   {
/* 144 */     Session session = getSession();
/* 145 */     if (this.trace)
/* 146 */       log.trace("createMessage" + session);
/* 147 */     return session.createMessage();
/*     */   }
/*     */ 
/*     */   public ObjectMessage createObjectMessage() throws JMSException
/*     */   {
/* 152 */     Session session = getSession();
/* 153 */     if (this.trace)
/* 154 */       log.trace("createObjectMessage" + session);
/* 155 */     return session.createObjectMessage();
/*     */   }
/*     */ 
/*     */   public ObjectMessage createObjectMessage(Serializable object) throws JMSException
/*     */   {
/* 160 */     Session session = getSession();
/* 161 */     if (this.trace)
/* 162 */       log.trace("createObjectMessage(Object)" + session);
/* 163 */     return session.createObjectMessage(object);
/*     */   }
/*     */ 
/*     */   public StreamMessage createStreamMessage() throws JMSException
/*     */   {
/* 168 */     Session session = getSession();
/* 169 */     if (this.trace)
/* 170 */       log.trace("createStreamMessage" + session);
/* 171 */     return session.createStreamMessage();
/*     */   }
/*     */ 
/*     */   public TextMessage createTextMessage() throws JMSException
/*     */   {
/* 176 */     Session session = getSession();
/* 177 */     if (this.trace)
/* 178 */       log.trace("createTextMessage" + session);
/* 179 */     return session.createTextMessage();
/*     */   }
/*     */ 
/*     */   public TextMessage createTextMessage(String string) throws JMSException
/*     */   {
/* 184 */     Session session = getSession();
/* 185 */     if (this.trace)
/* 186 */       log.trace("createTextMessage(String)" + session);
/* 187 */     return session.createTextMessage(string);
/*     */   }
/*     */ 
/*     */   public boolean getTransacted()
/*     */     throws JMSException
/*     */   {
/* 193 */     getSession();
/* 194 */     return this.info.isTransacted();
/*     */   }
/*     */ 
/*     */   public MessageListener getMessageListener()
/*     */     throws JMSException
/*     */   {
/* 204 */     throw new IllegalStateException("Method not allowed");
/*     */   }
/*     */ 
/*     */   public void setMessageListener(MessageListener listener)
/*     */     throws JMSException
/*     */   {
/* 214 */     throw new IllegalStateException("Method not allowed");
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/* 225 */     throw new Error("Method not allowed");
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws JMSException
/*     */   {
/* 236 */     this.sf.closeSession(this);
/* 237 */     closeSession();
/*     */   }
/*     */ 
/*     */   public void commit()
/*     */     throws JMSException
/*     */   {
/* 243 */     Session session = getSession();
/* 244 */     if (!this.info.isTransacted())
/* 245 */       throw new IllegalStateException("Session is not transacted");
/* 246 */     if (this.trace)
/* 247 */       log.trace("Commit session " + this);
/* 248 */     session.commit();
/*     */   }
/*     */ 
/*     */   public void rollback() throws JMSException
/*     */   {
/* 253 */     Session session = getSession();
/* 254 */     if (!this.info.isTransacted())
/* 255 */       throw new IllegalStateException("Session is not transacted");
/* 256 */     if (this.trace)
/* 257 */       log.trace("Rollback session " + this);
/* 258 */     session.rollback();
/*     */   }
/*     */ 
/*     */   public void recover() throws JMSException
/*     */   {
/* 263 */     Session session = getSession();
/* 264 */     if (this.info.isTransacted())
/* 265 */       throw new IllegalStateException("Session is transacted");
/* 266 */     if (this.trace)
/* 267 */       log.trace("Recover session " + this);
/* 268 */     session.recover();
/*     */   }
/*     */ 
/*     */   public Topic createTopic(String topicName)
/*     */     throws JMSException
/*     */   {
/* 275 */     if (this.info.getType() == 1)
/*     */     {
/* 277 */       throw new IllegalStateException("Cannot create topic for javax.jms.QueueSession");
/*     */     }
/*     */ 
/* 280 */     Session session = getSession();
/* 281 */     if (this.trace)
/* 282 */       log.trace("createTopic " + session + " topicName=" + topicName);
/* 283 */     Topic result = session.createTopic(topicName);
/* 284 */     if (this.trace)
/* 285 */       log.trace("createdTopic " + session + " topic=" + result);
/* 286 */     return result;
/*     */   }
/*     */ 
/*     */   public TopicSubscriber createSubscriber(Topic topic) throws JMSException
/*     */   {
/* 291 */     TopicSession session = getTopicSession();
/* 292 */     if (this.trace)
/* 293 */       log.trace("createSubscriber " + session + " topic=" + topic);
/* 294 */     TopicSubscriber result = session.createSubscriber(topic);
/* 295 */     result = new JmsTopicSubscriber(result, this);
/* 296 */     if (this.trace)
/* 297 */       log.trace("createdSubscriber " + session + " JmsTopicSubscriber=" + result);
/* 298 */     addConsumer(result);
/* 299 */     return result;
/*     */   }
/*     */ 
/*     */   public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException
/*     */   {
/* 304 */     TopicSession session = getTopicSession();
/* 305 */     if (this.trace)
/* 306 */       log.trace("createSubscriber " + session + " topic=" + topic + " selector=" + messageSelector + " noLocal=" + noLocal);
/* 307 */     TopicSubscriber result = session.createSubscriber(topic, messageSelector, noLocal);
/* 308 */     result = new JmsTopicSubscriber(result, this);
/* 309 */     if (this.trace)
/* 310 */       log.trace("createdSubscriber " + session + " JmsTopicSubscriber=" + result);
/* 311 */     addConsumer(result);
/* 312 */     return result;
/*     */   }
/*     */ 
/*     */   public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException
/*     */   {
/* 317 */     if (this.info.getType() == 1)
/*     */     {
/* 319 */       throw new IllegalStateException("Cannot create durable subscriber from javax.jms.QueueSession");
/*     */     }
/*     */ 
/* 322 */     Session session = getSession();
/* 323 */     if (this.trace)
/* 324 */       log.trace("createDurableSubscriber " + session + " topic=" + topic + " name=" + name);
/* 325 */     TopicSubscriber result = session.createDurableSubscriber(topic, name);
/* 326 */     result = new JmsTopicSubscriber(result, this);
/* 327 */     if (this.trace)
/* 328 */       log.trace("createdDurableSubscriber " + session + " JmsTopicSubscriber=" + result);
/* 329 */     addConsumer(result);
/* 330 */     return result;
/*     */   }
/*     */ 
/*     */   public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal)
/*     */     throws JMSException
/*     */   {
/* 336 */     Session session = getSession();
/* 337 */     if (this.trace)
/* 338 */       log.trace("createDurableSubscriber " + session + " topic=" + topic + " name=" + name + " selector=" + messageSelector + " noLocal=" + noLocal);
/* 339 */     TopicSubscriber result = session.createDurableSubscriber(topic, name, messageSelector, noLocal);
/* 340 */     result = new JmsTopicSubscriber(result, this);
/* 341 */     if (this.trace)
/* 342 */       log.trace("createdDurableSubscriber " + session + " JmsTopicSubscriber=" + result);
/* 343 */     addConsumer(result);
/* 344 */     return result;
/*     */   }
/*     */ 
/*     */   public TopicPublisher createPublisher(Topic topic) throws JMSException
/*     */   {
/* 349 */     TopicSession session = getTopicSession();
/* 350 */     if (this.trace)
/* 351 */       log.trace("createPublisher " + session + " topic=" + topic);
/* 352 */     TopicPublisher result = session.createPublisher(topic);
/* 353 */     if (this.trace)
/* 354 */       log.trace("createdPublisher " + session + " publisher=" + result);
/* 355 */     addProducer(result);
/* 356 */     return result;
/*     */   }
/*     */ 
/*     */   public TemporaryTopic createTemporaryTopic() throws JMSException
/*     */   {
/* 361 */     if (this.info.getType() == 1)
/*     */     {
/* 363 */       throw new IllegalStateException("Cannot create temporary topic for javax.jms.QueueSession");
/*     */     }
/*     */ 
/* 366 */     Session session = getSession();
/* 367 */     if (this.trace)
/* 368 */       log.trace("createTemporaryTopic " + session);
/* 369 */     TemporaryTopic temp = session.createTemporaryTopic();
/* 370 */     if (this.trace)
/* 371 */       log.trace("createdTemporaryTopic " + session + " temp=" + temp);
/* 372 */     this.sf.addTemporaryTopic(temp);
/* 373 */     return temp;
/*     */   }
/*     */ 
/*     */   public void unsubscribe(String name) throws JMSException
/*     */   {
/* 378 */     if (this.info.getType() == 1)
/*     */     {
/* 380 */       throw new IllegalStateException("Cannot unsubscribe for javax.jms.QueueSession");
/*     */     }
/*     */ 
/* 383 */     Session session = getSession();
/* 384 */     if (this.trace)
/* 385 */       log.trace("unsubscribe " + session + " name=" + name);
/* 386 */     session.unsubscribe(name);
/*     */   }
/*     */ 
/*     */   public QueueBrowser createBrowser(Queue queue)
/*     */     throws JMSException
/*     */   {
/* 394 */     if (this.info.getType() == 2)
/*     */     {
/* 396 */       throw new IllegalStateException("Cannot create browser for javax.jms.TopicSession");
/*     */     }
/*     */ 
/* 400 */     Session session = getSession();
/* 401 */     if (this.trace)
/* 402 */       log.trace("createBrowser " + session + " queue=" + queue);
/* 403 */     QueueBrowser result = session.createBrowser(queue);
/* 404 */     if (this.trace)
/* 405 */       log.trace("createdBrowser " + session + " browser=" + result);
/* 406 */     return result;
/*     */   }
/*     */ 
/*     */   public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException
/*     */   {
/* 411 */     Session session = getSession();
/* 412 */     if (this.trace)
/* 413 */       log.trace("createBrowser " + session + " queue=" + queue + " selector=" + messageSelector);
/* 414 */     QueueBrowser result = session.createBrowser(queue, messageSelector);
/* 415 */     if (this.trace)
/* 416 */       log.trace("createdBrowser " + session + " browser=" + result);
/* 417 */     return result;
/*     */   }
/*     */ 
/*     */   public Queue createQueue(String queueName) throws JMSException
/*     */   {
/* 422 */     if (this.info.getType() == 2)
/*     */     {
/* 424 */       throw new IllegalStateException("Cannot create browser or javax.jms.TopicSession");
/*     */     }
/*     */ 
/* 428 */     Session session = getSession();
/* 429 */     if (this.trace)
/* 430 */       log.trace("createQueue " + session + " queueName=" + queueName);
/* 431 */     Queue result = session.createQueue(queueName);
/* 432 */     if (this.trace)
/* 433 */       log.trace("createdQueue " + session + " queue=" + result);
/* 434 */     return result;
/*     */   }
/*     */ 
/*     */   public QueueReceiver createReceiver(Queue queue) throws JMSException
/*     */   {
/* 439 */     QueueSession session = getQueueSession();
/* 440 */     if (this.trace)
/* 441 */       log.trace("createReceiver " + session + " queue=" + queue);
/* 442 */     QueueReceiver result = session.createReceiver(queue);
/* 443 */     result = new JmsQueueReceiver(result, this);
/* 444 */     if (this.trace)
/* 445 */       log.trace("createdReceiver " + session + " receiver=" + result);
/* 446 */     addConsumer(result);
/* 447 */     return result;
/*     */   }
/*     */ 
/*     */   public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException
/*     */   {
/* 452 */     QueueSession session = getQueueSession();
/* 453 */     if (this.trace)
/* 454 */       log.trace("createReceiver " + session + " queue=" + queue + " selector=" + messageSelector);
/* 455 */     QueueReceiver result = session.createReceiver(queue, messageSelector);
/* 456 */     result = new JmsQueueReceiver(result, this);
/* 457 */     if (this.trace)
/* 458 */       log.trace("createdReceiver " + session + " receiver=" + result);
/* 459 */     addConsumer(result);
/* 460 */     return result;
/*     */   }
/*     */ 
/*     */   public QueueSender createSender(Queue queue) throws JMSException
/*     */   {
/* 465 */     QueueSession session = getQueueSession();
/* 466 */     if (this.trace)
/* 467 */       log.trace("createSender " + session + " queue=" + queue);
/* 468 */     QueueSender result = session.createSender(queue);
/* 469 */     if (this.trace)
/* 470 */       log.trace("createdSender " + session + " sender=" + result);
/* 471 */     addProducer(result);
/* 472 */     return result;
/*     */   }
/*     */ 
/*     */   public TemporaryQueue createTemporaryQueue() throws JMSException
/*     */   {
/* 477 */     if (this.info.getType() == 2)
/*     */     {
/* 479 */       throw new IllegalStateException("Cannot create temporary queue for javax.jms.TopicSession");
/*     */     }
/*     */ 
/* 482 */     Session session = getSession();
/* 483 */     if (this.trace)
/* 484 */       log.trace("createTemporaryQueue " + session);
/* 485 */     TemporaryQueue temp = session.createTemporaryQueue();
/* 486 */     if (this.trace)
/* 487 */       log.trace("createdTemporaryQueue " + session + " temp=" + temp);
/* 488 */     this.sf.addTemporaryQueue(temp);
/* 489 */     return temp;
/*     */   }
/*     */ 
/*     */   public MessageConsumer createConsumer(Destination destination)
/*     */     throws JMSException
/*     */   {
/* 496 */     Session session = getSession();
/* 497 */     if (this.trace)
/* 498 */       log.trace("createConsumer " + session + " dest=" + destination);
/* 499 */     MessageConsumer result = session.createConsumer(destination);
/* 500 */     result = new JmsMessageConsumer(result, this);
/* 501 */     if (this.trace)
/* 502 */       log.trace("createdConsumer " + session + " consumer=" + result);
/* 503 */     addConsumer(result);
/* 504 */     return result;
/*     */   }
/*     */ 
/*     */   public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException
/*     */   {
/* 509 */     Session session = getSession();
/* 510 */     if (this.trace)
/* 511 */       log.trace("createConsumer " + session + " dest=" + destination + " messageSelector=" + messageSelector);
/* 512 */     MessageConsumer result = session.createConsumer(destination, messageSelector);
/* 513 */     result = new JmsMessageConsumer(result, this);
/* 514 */     if (this.trace)
/* 515 */       log.trace("createdConsumer " + session + " consumer=" + result);
/* 516 */     addConsumer(result);
/* 517 */     return result;
/*     */   }
/*     */ 
/*     */   public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal)
/*     */     throws JMSException
/*     */   {
/* 523 */     Session session = getSession();
/* 524 */     if (this.trace)
/* 525 */       log.trace("createConsumer " + session + " dest=" + destination + " messageSelector=" + messageSelector + " noLocal=" + noLocal);
/* 526 */     MessageConsumer result = session.createConsumer(destination, messageSelector, noLocal);
/* 527 */     result = new JmsMessageConsumer(result, this);
/* 528 */     if (this.trace)
/* 529 */       log.trace("createdConsumer " + session + " consumer=" + result);
/* 530 */     addConsumer(result);
/* 531 */     return result;
/*     */   }
/*     */ 
/*     */   public MessageProducer createProducer(Destination destination) throws JMSException
/*     */   {
/* 536 */     Session session = getSession();
/* 537 */     if (this.trace)
/* 538 */       log.trace("createProducer " + session + " dest=" + destination);
/* 539 */     MessageProducer result = getSession().createProducer(destination);
/* 540 */     if (this.trace)
/* 541 */       log.trace("createdProducer " + session + " producer=" + result);
/* 542 */     addProducer(result);
/* 543 */     return result;
/*     */   }
/*     */ 
/*     */   public int getAcknowledgeMode() throws JMSException
/*     */   {
/* 548 */     getSession();
/* 549 */     return this.info.getAcknowledgeMode();
/*     */   }
/*     */ 
/*     */   void setManagedConnection(JmsManagedConnection mc)
/*     */   {
/* 556 */     if (this.mc != null)
/* 557 */       this.mc.removeHandle(this);
/* 558 */     this.mc = mc;
/*     */   }
/*     */ 
/*     */   void destroy()
/*     */   {
/* 563 */     this.mc = null;
/*     */   }
/*     */ 
/*     */   void start() throws JMSException
/*     */   {
/* 568 */     if (this.mc != null)
/* 569 */       this.mc.start();
/*     */   }
/*     */ 
/*     */   void stop() throws JMSException
/*     */   {
/* 574 */     if (this.mc != null)
/* 575 */       this.mc.stop();
/*     */   }
/*     */ 
/*     */   void checkStrict() throws JMSException
/*     */   {
/* 580 */     if ((this.mc != null) && (this.mc.getManagedConnectionFactory().isStrict()))
/* 581 */       throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
/*     */   }
/*     */ 
/*     */   void closeSession() throws JMSException
/*     */   {
/* 586 */     if (this.mc != null)
/*     */     {
/* 588 */       log.trace("Closing session");
/*     */       try
/*     */       {
/* 592 */         this.mc.stop();
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 596 */         log.trace("Error stopping managed connection", t);
/*     */       }
/*     */       Iterator i;
/* 599 */       synchronized (this.consumers)
/*     */       {
/* 601 */         for (i = this.consumers.iterator(); i.hasNext(); )
/*     */         {
/* 603 */           JmsMessageConsumer consumer = (JmsMessageConsumer)i.next();
/*     */           try
/*     */           {
/* 606 */             consumer.closeConsumer();
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/* 610 */             log.trace("Error closing consumer", t);
/*     */           }
/* 612 */           i.remove();
/*     */         }
/*     */       }
/*     */       Iterator i;
/* 616 */       synchronized (this.producers)
/*     */       {
/* 618 */         for (i = this.producers.iterator(); i.hasNext(); )
/*     */         {
/* 620 */           MessageProducer producer = (MessageProducer)i.next();
/*     */           try
/*     */           {
/* 623 */             producer.close();
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/* 627 */             log.trace("Error closing producer", t);
/*     */           }
/* 629 */           i.remove();
/*     */         }
/*     */       }
/*     */ 
/* 633 */       this.mc.removeHandle(this);
/* 634 */       ConnectionEvent ev = new ConnectionEvent(this.mc, 1);
/* 635 */       ev.setConnectionHandle(this);
/* 636 */       this.mc.sendEvent(ev);
/* 637 */       this.mc = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   void addConsumer(MessageConsumer consumer)
/*     */   {
/* 643 */     synchronized (this.consumers)
/*     */     {
/* 645 */       this.consumers.add(consumer);
/*     */     }
/*     */   }
/*     */ 
/*     */   void removeConsumer(MessageConsumer consumer)
/*     */   {
/* 651 */     synchronized (this.consumers)
/*     */     {
/* 653 */       this.consumers.remove(consumer);
/*     */     }
/*     */   }
/*     */ 
/*     */   void addProducer(MessageProducer producer)
/*     */   {
/* 659 */     synchronized (this.producers)
/*     */     {
/* 661 */       this.producers.add(producer);
/*     */     }
/*     */   }
/*     */ 
/*     */   void removeProducer(MessageProducer producer)
/*     */   {
/* 667 */     synchronized (this.producers)
/*     */     {
/* 669 */       this.producers.remove(producer);
/*     */     }
/*     */   }
/*     */ 
/*     */   QueueSession getQueueSession() throws JMSException
/*     */   {
/* 675 */     Session s = getSession();
/* 676 */     if (!(s instanceof QueueSession))
/* 677 */       throw new InvalidDestinationException("Attempting to use QueueSession methods on: " + this);
/* 678 */     return (QueueSession)s;
/*     */   }
/*     */ 
/*     */   TopicSession getTopicSession() throws JMSException
/*     */   {
/* 683 */     Session s = getSession();
/* 684 */     if (!(s instanceof TopicSession))
/* 685 */       throw new InvalidDestinationException("Attempting to use TopicSession methods on: " + this);
/* 686 */     return (TopicSession)s;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.JmsSession
 * JD-Core Version:    0.6.0
 */