/*     */ package org.jboss.resource.adapter.jms;
/*     */ 
/*     */ import java.util.Enumeration;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.Message;
/*     */ 
/*     */ public class JmsMessage
/*     */   implements Message
/*     */ {
/*     */   Message message;
/*     */   JmsSession session;
/*     */ 
/*     */   public JmsMessage(Message message, JmsSession session)
/*     */   {
/*  52 */     this.message = message;
/*  53 */     this.session = session;
/*     */   }
/*     */ 
/*     */   public void acknowledge() throws JMSException
/*     */   {
/*  58 */     this.session.getSession();
/*  59 */     this.message.acknowledge();
/*     */   }
/*     */ 
/*     */   public void clearBody() throws JMSException
/*     */   {
/*  64 */     this.message.clearBody();
/*     */   }
/*     */ 
/*     */   public void clearProperties() throws JMSException
/*     */   {
/*  69 */     this.message.clearProperties();
/*     */   }
/*     */ 
/*     */   public boolean getBooleanProperty(String name) throws JMSException
/*     */   {
/*  74 */     return this.message.getBooleanProperty(name);
/*     */   }
/*     */ 
/*     */   public byte getByteProperty(String name) throws JMSException
/*     */   {
/*  79 */     return this.message.getByteProperty(name);
/*     */   }
/*     */ 
/*     */   public double getDoubleProperty(String name) throws JMSException
/*     */   {
/*  84 */     return this.message.getDoubleProperty(name);
/*     */   }
/*     */ 
/*     */   public float getFloatProperty(String name) throws JMSException
/*     */   {
/*  89 */     return this.message.getFloatProperty(name);
/*     */   }
/*     */ 
/*     */   public int getIntProperty(String name) throws JMSException
/*     */   {
/*  94 */     return this.message.getIntProperty(name);
/*     */   }
/*     */ 
/*     */   public String getJMSCorrelationID() throws JMSException
/*     */   {
/*  99 */     return this.message.getJMSCorrelationID();
/*     */   }
/*     */ 
/*     */   public byte[] getJMSCorrelationIDAsBytes() throws JMSException
/*     */   {
/* 104 */     return this.message.getJMSCorrelationIDAsBytes();
/*     */   }
/*     */ 
/*     */   public int getJMSDeliveryMode() throws JMSException
/*     */   {
/* 109 */     return this.message.getJMSDeliveryMode();
/*     */   }
/*     */ 
/*     */   public Destination getJMSDestination() throws JMSException
/*     */   {
/* 114 */     return this.message.getJMSDestination();
/*     */   }
/*     */ 
/*     */   public long getJMSExpiration() throws JMSException
/*     */   {
/* 119 */     return this.message.getJMSExpiration();
/*     */   }
/*     */ 
/*     */   public String getJMSMessageID() throws JMSException
/*     */   {
/* 124 */     return this.message.getJMSMessageID();
/*     */   }
/*     */ 
/*     */   public int getJMSPriority() throws JMSException
/*     */   {
/* 129 */     return this.message.getJMSPriority();
/*     */   }
/*     */ 
/*     */   public boolean getJMSRedelivered() throws JMSException
/*     */   {
/* 134 */     return this.message.getJMSRedelivered();
/*     */   }
/*     */ 
/*     */   public Destination getJMSReplyTo() throws JMSException
/*     */   {
/* 139 */     return this.message.getJMSReplyTo();
/*     */   }
/*     */ 
/*     */   public long getJMSTimestamp() throws JMSException
/*     */   {
/* 144 */     return this.message.getJMSTimestamp();
/*     */   }
/*     */ 
/*     */   public String getJMSType() throws JMSException
/*     */   {
/* 149 */     return this.message.getJMSType();
/*     */   }
/*     */ 
/*     */   public long getLongProperty(String name) throws JMSException
/*     */   {
/* 154 */     return this.message.getLongProperty(name);
/*     */   }
/*     */ 
/*     */   public Object getObjectProperty(String name) throws JMSException
/*     */   {
/* 159 */     return this.message.getObjectProperty(name);
/*     */   }
/*     */ 
/*     */   public Enumeration getPropertyNames() throws JMSException
/*     */   {
/* 164 */     return this.message.getPropertyNames();
/*     */   }
/*     */ 
/*     */   public short getShortProperty(String name) throws JMSException
/*     */   {
/* 169 */     return this.message.getShortProperty(name);
/*     */   }
/*     */ 
/*     */   public String getStringProperty(String name) throws JMSException
/*     */   {
/* 174 */     return this.message.getStringProperty(name);
/*     */   }
/*     */ 
/*     */   public boolean propertyExists(String name) throws JMSException
/*     */   {
/* 179 */     return this.message.propertyExists(name);
/*     */   }
/*     */ 
/*     */   public void setBooleanProperty(String name, boolean value) throws JMSException
/*     */   {
/* 184 */     this.message.setBooleanProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setByteProperty(String name, byte value) throws JMSException
/*     */   {
/* 189 */     this.message.setByteProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setDoubleProperty(String name, double value) throws JMSException
/*     */   {
/* 194 */     this.message.setDoubleProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setFloatProperty(String name, float value) throws JMSException
/*     */   {
/* 199 */     this.message.setFloatProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setIntProperty(String name, int value) throws JMSException
/*     */   {
/* 204 */     this.message.setIntProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setJMSCorrelationID(String correlationID) throws JMSException
/*     */   {
/* 209 */     this.message.setJMSCorrelationID(correlationID);
/*     */   }
/*     */ 
/*     */   public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException
/*     */   {
/* 214 */     this.message.setJMSCorrelationIDAsBytes(correlationID);
/*     */   }
/*     */ 
/*     */   public void setJMSDeliveryMode(int deliveryMode) throws JMSException
/*     */   {
/* 219 */     this.message.setJMSDeliveryMode(deliveryMode);
/*     */   }
/*     */ 
/*     */   public void setJMSDestination(Destination destination) throws JMSException
/*     */   {
/* 224 */     this.message.setJMSDestination(destination);
/*     */   }
/*     */ 
/*     */   public void setJMSExpiration(long expiration) throws JMSException
/*     */   {
/* 229 */     this.message.setJMSExpiration(expiration);
/*     */   }
/*     */ 
/*     */   public void setJMSMessageID(String id) throws JMSException
/*     */   {
/* 234 */     this.message.setJMSMessageID(id);
/*     */   }
/*     */ 
/*     */   public void setJMSPriority(int priority) throws JMSException
/*     */   {
/* 239 */     this.message.setJMSPriority(priority);
/*     */   }
/*     */ 
/*     */   public void setJMSRedelivered(boolean redelivered) throws JMSException
/*     */   {
/* 244 */     this.message.setJMSRedelivered(redelivered);
/*     */   }
/*     */ 
/*     */   public void setJMSReplyTo(Destination replyTo) throws JMSException
/*     */   {
/* 249 */     this.message.setJMSReplyTo(replyTo);
/*     */   }
/*     */ 
/*     */   public void setJMSTimestamp(long timestamp) throws JMSException
/*     */   {
/* 254 */     this.message.setJMSTimestamp(timestamp);
/*     */   }
/*     */ 
/*     */   public void setJMSType(String type) throws JMSException
/*     */   {
/* 259 */     this.message.setJMSType(type);
/*     */   }
/*     */ 
/*     */   public void setLongProperty(String name, long value) throws JMSException
/*     */   {
/* 264 */     this.message.setLongProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setObjectProperty(String name, Object value) throws JMSException
/*     */   {
/* 269 */     this.message.setObjectProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setShortProperty(String name, short value) throws JMSException
/*     */   {
/* 274 */     this.message.setShortProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setStringProperty(String name, String value) throws JMSException
/*     */   {
/* 279 */     this.message.setStringProperty(name, value);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 284 */     return this.message.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 289 */     if ((object != null) && ((object instanceof JmsMessage))) {
/* 290 */       return this.message.equals(((JmsMessage)object).message);
/*     */     }
/* 292 */     return this.message.equals(object);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 297 */     return this.message.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.JmsMessage
 * JD-Core Version:    0.6.0
 */