/*     */ package org.jboss.resource.adapter.jms;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.jms.ConnectionMetaData;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ConnectionManager;
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import javax.resource.spi.ManagedConnection;
/*     */ import javax.resource.spi.ManagedConnectionFactory;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.jms.jndi.JMSProviderAdapter;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JmsManagedConnectionFactory
/*     */   implements ManagedConnectionFactory
/*     */ {
/*     */   private static final long serialVersionUID = -923483284031773011L;
/*  50 */   private static final Logger log = Logger.getLogger(JmsManagedConnection.class);
/*     */ 
/*  53 */   private JmsMCFProperties mcfProperties = new JmsMCFProperties();
/*     */ 
/*  56 */   private boolean strict = true;
/*     */   private JMSProviderAdapter adapter;
/*     */ 
/*     */   public Object createConnectionFactory()
/*     */     throws ResourceException
/*     */   {
/*  71 */     return createConnectionFactory(null);
/*     */   }
/*     */ 
/*     */   public Object createConnectionFactory(ConnectionManager cxManager)
/*     */     throws ResourceException
/*     */   {
/*  79 */     Object cf = new JmsConnectionFactoryImpl(this, cxManager);
/*     */ 
/*  81 */     if (log.isTraceEnabled())
/*     */     {
/*  83 */       log.trace("Created connection factory: " + cf + ", using connection manager: " + cxManager);
/*     */     }
/*     */ 
/*  86 */     return cf;
/*     */   }
/*     */ 
/*     */   public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info)
/*     */     throws ResourceException
/*     */   {
/*  95 */     boolean trace = log.isTraceEnabled();
/*     */ 
/*  97 */     info = getInfo(info);
/*  98 */     if (trace) {
/*  99 */       log.trace("connection request info: " + info);
/*     */     }
/* 101 */     JmsCred cred = JmsCred.getJmsCred(this, subject, info);
/* 102 */     if (trace) {
/* 103 */       log.trace("jms credentials: " + cred);
/*     */     }
/*     */ 
/* 106 */     JmsManagedConnection mc = new JmsManagedConnection(this, info, cred.name, cred.pwd);
/*     */ 
/* 108 */     if (trace) {
/* 109 */       log.trace("created new managed connection: " + mc);
/*     */     }
/*     */ 
/* 117 */     return mc;
/*     */   }
/*     */ 
/*     */   public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info)
/*     */     throws ResourceException
/*     */   {
/* 126 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 129 */     info = getInfo(info);
/* 130 */     JmsCred cred = JmsCred.getJmsCred(this, subject, info);
/*     */ 
/* 132 */     if (trace) {
/* 133 */       log.trace("Looking for connection matching credentials: " + cred);
/*     */     }
/*     */ 
/* 137 */     Iterator connections = connectionSet.iterator();
/*     */ 
/* 139 */     while (connections.hasNext())
/*     */     {
/* 141 */       Object obj = connections.next();
/*     */ 
/* 144 */       if ((obj instanceof JmsManagedConnection))
/*     */       {
/* 147 */         JmsManagedConnection mc = (JmsManagedConnection)obj;
/*     */ 
/* 150 */         ManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
/*     */ 
/* 158 */         if (((mc.getUserName() == null) || ((mc.getUserName() != null) && (mc.getUserName().equals(cred.name)))) && (mcf.equals(this)))
/*     */         {
/* 162 */           if (info.equals(mc.getInfo()))
/*     */           {
/* 165 */             if (trace) {
/* 166 */               log.trace("Found matching connection: " + mc);
/*     */             }
/* 168 */             return mc;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 174 */     if (trace) {
/* 175 */       log.trace("No matching connection was found");
/*     */     }
/* 177 */     return null;
/*     */   }
/*     */ 
/*     */   public void setLogWriter(PrintWriter out)
/*     */     throws ResourceException
/*     */   {
/*     */   }
/*     */ 
/*     */   public PrintWriter getLogWriter()
/*     */     throws ResourceException
/*     */   {
/* 193 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 201 */     if (obj == null)
/* 202 */       return false;
/* 203 */     if ((obj instanceof JmsManagedConnectionFactory))
/*     */     {
/* 205 */       return this.mcfProperties.equals(((JmsManagedConnectionFactory)obj).getProperties());
/*     */     }
/*     */ 
/* 209 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 215 */     return this.mcfProperties.hashCode();
/*     */   }
/*     */ 
/*     */   public void setJmsProviderAdapterJNDI(String jndi)
/*     */   {
/* 222 */     this.mcfProperties.setProviderJNDI(jndi);
/*     */   }
/*     */ 
/*     */   public String getJmsProviderAdapterJNDI()
/*     */   {
/* 227 */     return this.mcfProperties.getProviderJNDI();
/*     */   }
/*     */ 
/*     */   public void setUserName(String userName)
/*     */   {
/* 235 */     this.mcfProperties.setUserName(userName);
/*     */   }
/*     */ 
/*     */   public String getUserName()
/*     */   {
/* 243 */     return this.mcfProperties.getUserName();
/*     */   }
/*     */ 
/*     */   public void setPassword(String password)
/*     */   {
/* 251 */     this.mcfProperties.setPassword(password);
/*     */   }
/*     */ 
/*     */   public String getPassword()
/*     */   {
/* 259 */     return this.mcfProperties.getPassword();
/*     */   }
/*     */ 
/*     */   public String getClientID()
/*     */   {
/* 267 */     return this.mcfProperties.getClientID();
/*     */   }
/*     */ 
/*     */   public void setClientID(String clientID)
/*     */   {
/* 275 */     this.mcfProperties.setClientID(clientID);
/*     */   }
/*     */ 
/*     */   public boolean isStrict()
/*     */   {
/* 280 */     return this.strict;
/*     */   }
/*     */ 
/*     */   public void setStrict(boolean strict)
/*     */   {
/* 285 */     this.strict = strict;
/*     */   }
/*     */ 
/*     */   public void setStrict(Boolean strict)
/*     */   {
/* 290 */     this.strict = strict.booleanValue();
/*     */   }
/*     */ 
/*     */   public void setSessionDefaultType(String type)
/*     */     throws ResourceException
/*     */   {
/* 302 */     this.mcfProperties.setSessionDefaultType(type);
/*     */   }
/*     */ 
/*     */   public String getSessionDefaultType()
/*     */   {
/* 307 */     return this.mcfProperties.getSessionDefaultType();
/*     */   }
/*     */ 
/*     */   public void setJmsProviderAdapter(JMSProviderAdapter adapter)
/*     */   {
/* 315 */     this.adapter = adapter;
/*     */   }
/*     */ 
/*     */   public JMSProviderAdapter getJmsProviderAdapter()
/*     */   {
/* 320 */     return this.adapter;
/*     */   }
/*     */ 
/*     */   private ConnectionRequestInfo getInfo(ConnectionRequestInfo info)
/*     */   {
/* 325 */     if (info == null)
/*     */     {
/* 328 */       return new JmsConnectionRequestInfo(this.mcfProperties);
/*     */     }
/*     */ 
/* 333 */     ((JmsConnectionRequestInfo)info).setDefaults(this.mcfProperties);
/* 334 */     return info;
/*     */   }
/*     */ 
/*     */   public ConnectionMetaData getMetaData()
/*     */   {
/* 340 */     return new JmsConnectionMetaData();
/*     */   }
/*     */ 
/*     */   protected JmsMCFProperties getProperties()
/*     */   {
/* 347 */     return this.mcfProperties;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.JmsManagedConnectionFactory
 * JD-Core Version:    0.6.0
 */