/*     */ package org.jboss.resource.adapter.jms;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import java.util.Vector;
/*     */ import javax.jms.Connection;
/*     */ import javax.jms.ExceptionListener;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.QueueConnection;
/*     */ import javax.jms.QueueSession;
/*     */ import javax.jms.Session;
/*     */ import javax.jms.TopicConnection;
/*     */ import javax.jms.TopicSession;
/*     */ import javax.jms.XAConnection;
/*     */ import javax.jms.XAQueueConnection;
/*     */ import javax.jms.XAQueueSession;
/*     */ import javax.jms.XASession;
/*     */ import javax.jms.XATopicConnection;
/*     */ import javax.jms.XATopicSession;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.resource.NotSupportedException;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ConnectionEvent;
/*     */ import javax.resource.spi.ConnectionEventListener;
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import javax.resource.spi.IllegalStateException;
/*     */ import javax.resource.spi.LocalTransaction;
/*     */ import javax.resource.spi.ManagedConnection;
/*     */ import javax.resource.spi.ManagedConnectionMetaData;
/*     */ import javax.resource.spi.SecurityException;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import org.jboss.jms.ConnectionFactoryHelper;
/*     */ import org.jboss.jms.jndi.JMSProviderAdapter;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.JBossResourceException;
/*     */ 
/*     */ public class JmsManagedConnection
/*     */   implements ManagedConnection, ExceptionListener
/*     */ {
/* 136 */   private static final Logger log = Logger.getLogger(JmsManagedConnection.class);
/*     */   private JmsManagedConnectionFactory mcf;
/*     */   private JmsConnectionRequestInfo info;
/*     */   private String user;
/*     */   private String pwd;
/*     */   private boolean isDestroyed;
/*     */   private Connection con;
/*     */   private Session session;
/*     */   private TopicSession topicSession;
/*     */   private QueueSession queueSession;
/*     */   private XASession xaSession;
/*     */   private XATopicSession xaTopicSession;
/*     */   private XAQueueSession xaQueueSession;
/*     */   private XAResource xaResource;
/*     */   private boolean xaTransacted;
/* 156 */   private Set handles = Collections.synchronizedSet(new HashSet());
/*     */ 
/* 159 */   private Vector listeners = new Vector();
/*     */ 
/*     */   public JmsManagedConnection(JmsManagedConnectionFactory mcf, ConnectionRequestInfo info, String user, String pwd)
/*     */     throws ResourceException
/*     */   {
/* 177 */     this.mcf = mcf;
/*     */ 
/* 180 */     this.info = ((JmsConnectionRequestInfo)info);
/* 181 */     this.user = user;
/* 182 */     this.pwd = pwd;
/*     */ 
/* 184 */     setup();
/*     */   }
/*     */ 
/*     */   public Object getConnection(Subject subject, ConnectionRequestInfo info)
/*     */     throws ResourceException
/*     */   {
/* 212 */     JmsCred cred = JmsCred.getJmsCred(this.mcf, subject, info);
/*     */ 
/* 215 */     if ((this.user != null) && (!this.user.equals(cred.name))) {
/* 216 */       throw new SecurityException("Password credentials not the same, reauthentication not allowed");
/*     */     }
/* 218 */     if ((cred.name != null) && (this.user == null)) {
/* 219 */       throw new SecurityException("Password credentials not the same, reauthentication not allowed");
/*     */     }
/*     */ 
/* 223 */     this.user = cred.name;
/*     */ 
/* 225 */     if (this.isDestroyed) {
/* 226 */       throw new IllegalStateException("ManagedConnection already destroyd");
/*     */     }
/*     */ 
/* 229 */     JmsSession handle = new JmsSession(this, (JmsConnectionRequestInfo)info);
/* 230 */     this.handles.add(handle);
/* 231 */     return handle;
/*     */   }
/*     */ 
/*     */   private void destroyHandles()
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/* 243 */       if (this.con != null)
/* 244 */         this.con.stop();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 248 */       log.trace("Ignored error stopping connection", t);
/*     */     }
/*     */ 
/* 251 */     Iterator iter = this.handles.iterator();
/* 252 */     while (iter.hasNext()) {
/* 253 */       ((JmsSession)iter.next()).destroy();
/*     */     }
/*     */ 
/* 256 */     this.handles.clear();
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */     throws ResourceException
/*     */   {
/* 267 */     if (this.isDestroyed) return;
/*     */ 
/* 269 */     this.isDestroyed = true;
/*     */     try
/*     */     {
/* 273 */       this.con.setExceptionListener(null);
/*     */     }
/*     */     catch (JMSException e)
/*     */     {
/* 277 */       log.debug("Error unsetting the exception listener " + this, e);
/*     */     }
/*     */ 
/* 281 */     destroyHandles();
/*     */     try
/*     */     {
/*     */       try
/*     */       {
/* 288 */         if (this.info.getType() == 2)
/*     */         {
/* 290 */           this.topicSession.close();
/* 291 */           if (this.xaTransacted) {
/* 292 */             this.xaTopicSession.close();
/*     */           }
/*     */         }
/* 295 */         else if (this.info.getType() == 1)
/*     */         {
/* 297 */           this.queueSession.close();
/* 298 */           if (this.xaTransacted)
/* 299 */             this.xaQueueSession.close();
/*     */         }
/*     */         else
/*     */         {
/* 303 */           this.session.close();
/* 304 */           if (this.xaTransacted)
/* 305 */             this.xaSession.close();
/*     */         }
/*     */       }
/*     */       catch (JMSException e)
/*     */       {
/* 310 */         log.debug("Error closing session " + this, e);
/*     */       }
/* 312 */       this.con.close();
/*     */     }
/*     */     catch (JMSException e)
/*     */     {
/* 316 */       throw new JBossResourceException("Could not properly close the session and connection", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void cleanup()
/*     */     throws ResourceException
/*     */   {
/* 330 */     if (this.isDestroyed) {
/* 331 */       throw new IllegalStateException("ManagedConnection already destroyed");
/*     */     }
/*     */ 
/* 334 */     destroyHandles();
/*     */   }
/*     */ 
/*     */   public void associateConnection(Object obj)
/*     */     throws ResourceException
/*     */   {
/* 352 */     if ((!this.isDestroyed) && ((obj instanceof JmsSession)))
/*     */     {
/* 354 */       JmsSession h = (JmsSession)obj;
/* 355 */       h.setManagedConnection(this);
/* 356 */       this.handles.add(h);
/*     */     }
/*     */     else {
/* 359 */       throw new IllegalStateException("ManagedConnection in an illegal state");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addConnectionEventListener(ConnectionEventListener l)
/*     */   {
/* 370 */     this.listeners.addElement(l);
/*     */ 
/* 372 */     if (log.isTraceEnabled())
/* 373 */       log.trace("ConnectionEvent listener added: " + l);
/*     */   }
/*     */ 
/*     */   public void removeConnectionEventListener(ConnectionEventListener l)
/*     */   {
/* 383 */     this.listeners.removeElement(l);
/*     */   }
/*     */ 
/*     */   public XAResource getXAResource()
/*     */     throws ResourceException
/*     */   {
/* 399 */     if (!this.xaTransacted) {
/* 400 */       throw new NotSupportedException("Non XA transaction not supported");
/*     */     }
/* 402 */     if (this.xaResource == null)
/*     */     {
/* 404 */       if (this.info.getType() == 2)
/* 405 */         this.xaResource = this.xaTopicSession.getXAResource();
/* 406 */       else if (this.info.getType() == 1)
/* 407 */         this.xaResource = this.xaQueueSession.getXAResource();
/*     */       else {
/* 409 */         this.xaResource = this.xaSession.getXAResource();
/*     */       }
/*     */     }
/* 412 */     if (log.isTraceEnabled()) {
/* 413 */       log.trace("XAResource=" + this.xaResource);
/*     */     }
/* 415 */     return this.xaResource;
/*     */   }
/*     */ 
/*     */   public LocalTransaction getLocalTransaction()
/*     */     throws ResourceException
/*     */   {
/* 427 */     LocalTransaction tx = new JmsLocalTransaction(this);
/* 428 */     if (log.isTraceEnabled())
/* 429 */       log.trace("LocalTransaction=" + tx);
/* 430 */     return tx;
/*     */   }
/*     */ 
/*     */   public ManagedConnectionMetaData getMetaData()
/*     */     throws ResourceException
/*     */   {
/* 443 */     if (this.isDestroyed) {
/* 444 */       throw new IllegalStateException("ManagedConnection already destroyd");
/*     */     }
/* 446 */     return new JmsMetaData(this);
/*     */   }
/*     */ 
/*     */   public void setLogWriter(PrintWriter out)
/*     */     throws ResourceException
/*     */   {
/*     */   }
/*     */ 
/*     */   public PrintWriter getLogWriter()
/*     */     throws ResourceException
/*     */   {
/* 474 */     return null;
/*     */   }
/*     */ 
/*     */   public void onException(JMSException exception)
/*     */   {
/* 481 */     if (this.isDestroyed)
/*     */     {
/* 483 */       if (log.isTraceEnabled())
/* 484 */         log.trace("Ignoring error on already destroyed connection " + this, exception);
/* 485 */       return;
/*     */     }
/*     */ 
/* 488 */     log.warn("Handling jms exception failure: " + this, exception);
/*     */     try
/*     */     {
/* 492 */       this.con.setExceptionListener(null);
/*     */     }
/*     */     catch (JMSException e)
/*     */     {
/* 496 */       log.debug("Unable to unset exception listener", e);
/*     */     }
/*     */ 
/* 499 */     ConnectionEvent event = new ConnectionEvent(this, 5, exception);
/* 500 */     sendEvent(event);
/*     */   }
/*     */ 
/*     */   protected Session getSession()
/*     */   {
/* 512 */     if (this.info.getType() == 2)
/* 513 */       return this.topicSession;
/* 514 */     if (this.info.getType() == 1) {
/* 515 */       return this.queueSession;
/*     */     }
/* 517 */     return this.session;
/*     */   }
/*     */ 
/*     */   protected void sendEvent(ConnectionEvent event)
/*     */   {
/* 527 */     int type = event.getId();
/*     */ 
/* 529 */     if (log.isTraceEnabled()) {
/* 530 */       log.trace("Sending connection event: " + type);
/*     */     }
/*     */ 
/* 533 */     ConnectionEventListener[] list = (ConnectionEventListener[])(ConnectionEventListener[])this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
/*     */ 
/* 536 */     for (int i = 0; i < list.length; i++)
/*     */     {
/* 538 */       switch (type) {
/*     */       case 1:
/* 540 */         list[i].connectionClosed(event);
/* 541 */         break;
/*     */       case 2:
/* 544 */         list[i].localTransactionStarted(event);
/* 545 */         break;
/*     */       case 3:
/* 548 */         list[i].localTransactionCommitted(event);
/* 549 */         break;
/*     */       case 4:
/* 552 */         list[i].localTransactionRolledback(event);
/* 553 */         break;
/*     */       case 5:
/* 556 */         list[i].connectionErrorOccurred(event);
/* 557 */         break;
/*     */       default:
/* 560 */         throw new IllegalArgumentException("Illegal eventType: " + type);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void removeHandle(JmsSession handle)
/*     */   {
/* 572 */     this.handles.remove(handle);
/*     */   }
/*     */ 
/*     */   protected ConnectionRequestInfo getInfo()
/*     */   {
/* 584 */     return this.info;
/*     */   }
/*     */ 
/*     */   protected JmsManagedConnectionFactory getManagedConnectionFactory()
/*     */   {
/* 594 */     return this.mcf;
/*     */   }
/*     */ 
/*     */   void start() throws JMSException
/*     */   {
/* 599 */     this.con.start();
/*     */   }
/*     */ 
/*     */   void stop() throws JMSException
/*     */   {
/* 604 */     this.con.stop();
/*     */   }
/*     */ 
/*     */   protected String getUserName()
/*     */   {
/* 616 */     return this.user;
/*     */   }
/*     */ 
/*     */   private JMSProviderAdapter getProviderAdapter()
/*     */     throws NamingException
/*     */   {
/*     */     JMSProviderAdapter adapter;
/* 633 */     if (this.mcf.getJmsProviderAdapterJNDI() != null)
/*     */     {
/* 636 */       Context ctx = new InitialContext();
/*     */       try
/*     */       {
/* 639 */         adapter = (JMSProviderAdapter)ctx.lookup(this.mcf.getJmsProviderAdapterJNDI());
/*     */       }
/*     */       finally
/*     */       {
/*     */         JMSProviderAdapter adapter;
/* 644 */         ctx.close();
/*     */       }
/*     */     }
/*     */     else {
/* 648 */       adapter = this.mcf.getJmsProviderAdapter();
/*     */     }
/* 650 */     return adapter;
/*     */   }
/*     */ 
/*     */   private void setup()
/*     */     throws ResourceException
/*     */   {
/* 660 */     boolean trace = log.isTraceEnabled();
/*     */     try
/*     */     {
/* 664 */       JMSProviderAdapter adapter = getProviderAdapter();
/* 665 */       Context context = adapter.getInitialContext();
/*     */ 
/* 667 */       boolean transacted = this.info.isTransacted();
/* 668 */       int ack = 1;
/*     */ 
/* 670 */       if (this.info.getType() == 2)
/*     */       {
/* 672 */         String jndi = adapter.getTopicFactoryRef();
/* 673 */         if (jndi == null)
/* 674 */           throw new IllegalStateException("No configured 'TopicFactoryRef' on the jms provider " + this.mcf.getJmsProviderAdapterJNDI());
/* 675 */         Object factory = context.lookup(jndi);
/* 676 */         this.con = ConnectionFactoryHelper.createTopicConnection(factory, this.user, this.pwd);
/* 677 */         if (this.info.getClientID() != null)
/* 678 */           this.con.setClientID(this.info.getClientID());
/* 679 */         this.con.setExceptionListener(this);
/* 680 */         if (trace) {
/* 681 */           log.trace("created connection: " + this.con);
/*     */         }
/* 683 */         if ((this.con instanceof XATopicConnection))
/*     */         {
/* 685 */           this.xaTopicSession = ((XATopicConnection)this.con).createXATopicSession();
/* 686 */           this.topicSession = this.xaTopicSession.getTopicSession();
/* 687 */           this.xaTransacted = true;
/*     */         }
/* 689 */         else if ((this.con instanceof TopicConnection))
/*     */         {
/* 691 */           this.topicSession = ((TopicConnection)this.con).createTopicSession(transacted, ack);
/*     */ 
/* 693 */           if (trace)
/* 694 */             log.trace("Using a non-XA TopicConnection.  It will not be able to participate in a Global UOW");
/*     */         }
/*     */         else
/*     */         {
/* 698 */           throw new JBossResourceException("Connection was not recognizable: " + this.con);
/*     */         }
/* 700 */         if (trace)
/* 701 */           log.trace("xaTopicSession=" + this.xaTopicSession + ", topicSession=" + this.topicSession);
/*     */       }
/* 703 */       else if (this.info.getType() == 1)
/*     */       {
/* 705 */         String jndi = adapter.getQueueFactoryRef();
/* 706 */         if (jndi == null)
/* 707 */           throw new IllegalStateException("No configured 'QueueFactoryRef' on the jms provider " + this.mcf.getJmsProviderAdapterJNDI());
/* 708 */         Object factory = context.lookup(jndi);
/* 709 */         this.con = ConnectionFactoryHelper.createQueueConnection(factory, this.user, this.pwd);
/* 710 */         if (this.info.getClientID() != null)
/* 711 */           this.con.setClientID(this.info.getClientID());
/* 712 */         this.con.setExceptionListener(this);
/* 713 */         if (trace) {
/* 714 */           log.debug("created connection: " + this.con);
/*     */         }
/* 716 */         if ((this.con instanceof XAQueueConnection))
/*     */         {
/* 718 */           this.xaQueueSession = ((XAQueueConnection)this.con).createXAQueueSession();
/*     */ 
/* 720 */           this.queueSession = this.xaQueueSession.getQueueSession();
/* 721 */           this.xaTransacted = true;
/*     */         }
/* 723 */         else if ((this.con instanceof QueueConnection))
/*     */         {
/* 725 */           this.queueSession = ((QueueConnection)this.con).createQueueSession(transacted, ack);
/*     */ 
/* 727 */           if (trace)
/* 728 */             log.trace("Using a non-XA QueueConnection.  It will not be able to participate in a Global UOW");
/*     */         }
/*     */         else
/*     */         {
/* 732 */           throw new JBossResourceException("Connection was not reconizable: " + this.con);
/*     */         }
/* 734 */         if (trace)
/* 735 */           log.trace("xaQueueSession=" + this.xaQueueSession + ", queueSession=" + this.queueSession);
/*     */       }
/*     */       else
/*     */       {
/* 739 */         String jndi = adapter.getFactoryRef();
/* 740 */         if (jndi == null)
/* 741 */           throw new IllegalStateException("No configured 'FactoryRef' on the jms provider " + this.mcf.getJmsProviderAdapterJNDI());
/* 742 */         Object factory = context.lookup(jndi);
/* 743 */         this.con = ConnectionFactoryHelper.createConnection(factory, this.user, this.pwd);
/* 744 */         if (this.info.getClientID() != null)
/* 745 */           this.con.setClientID(this.info.getClientID());
/* 746 */         this.con.setExceptionListener(this);
/* 747 */         if (trace) {
/* 748 */           log.trace("created connection: " + this.con);
/*     */         }
/* 750 */         if ((this.con instanceof XAConnection))
/*     */         {
/* 752 */           this.xaSession = ((XAConnection)this.con).createXASession();
/*     */ 
/* 754 */           this.session = this.xaSession.getSession();
/* 755 */           this.xaTransacted = true;
/*     */         }
/*     */         else
/*     */         {
/* 759 */           this.session = this.con.createSession(transacted, ack);
/* 760 */           if (trace) {
/* 761 */             log.trace("Using a non-XA Connection.  It will not be able to participate in a Global UOW");
/*     */           }
/*     */         }
/*     */ 
/* 765 */         if (trace) {
/* 766 */           log.debug("xaSession=" + this.xaQueueSession + ", Session=" + this.session);
/*     */         }
/*     */       }
/* 769 */       if (trace)
/* 770 */         log.debug("transacted=" + transacted + ", ack=" + ack);
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 774 */       throw new JBossResourceException("Unable to setup connection", e);
/*     */     }
/*     */     catch (JMSException e)
/*     */     {
/* 778 */       throw new JBossResourceException("Unable to setup connection", e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.JmsManagedConnection
 * JD-Core Version:    0.6.0
 */