/*     */ package org.jboss.resource.adapter.jms;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import javax.resource.spi.ManagedConnectionFactory;
/*     */ import javax.resource.spi.SecurityException;
/*     */ import javax.resource.spi.security.PasswordCredential;
/*     */ import javax.security.auth.Subject;
/*     */ 
/*     */ public class JmsCred
/*     */ {
/*     */   public String name;
/*     */   public String pwd;
/*     */ 
/*     */   public static JmsCred getJmsCred(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info)
/*     */     throws SecurityException
/*     */   {
/*  61 */     JmsCred jc = new JmsCred();
/*  62 */     if ((subject == null) && (info != null))
/*     */     {
/*  65 */       jc.name = ((JmsConnectionRequestInfo)info).getUserName();
/*  66 */       jc.pwd = ((JmsConnectionRequestInfo)info).getPassword();
/*     */     }
/*  68 */     else if (subject != null)
/*     */     {
/*  71 */       PasswordCredential pwdc = GetCredentialAction.getCredential(subject, mcf);
/*  72 */       if (pwdc == null)
/*     */       {
/*  75 */         throw new SecurityException("No Password credentials found");
/*     */       }
/*  77 */       jc.name = pwdc.getUserName();
/*  78 */       jc.pwd = new String(pwdc.getPassword());
/*     */     }
/*     */     else
/*     */     {
/*  82 */       throw new SecurityException("No Subject or ConnectionRequestInfo set, could not get credentials");
/*     */     }
/*  84 */     return jc;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  89 */     return super.toString() + "{ username=" + this.name + ", password=**** }";
/*     */   }
/*     */   private static class GetCredentialAction implements PrivilegedAction {
/*     */     Subject subject;
/*     */     ManagedConnectionFactory mcf;
/*     */ 
/*     */     GetCredentialAction(Subject subject, ManagedConnectionFactory mcf) {
/*  98 */       this.subject = subject;
/*  99 */       this.mcf = mcf;
/*     */     }
/*     */ 
/*     */     public Object run() {
/* 103 */       Set creds = this.subject.getPrivateCredentials(PasswordCredential.class);
/* 104 */       PasswordCredential pwdc = null;
/* 105 */       Iterator credentials = creds.iterator();
/* 106 */       while (credentials.hasNext())
/*     */       {
/* 108 */         PasswordCredential curCred = (PasswordCredential)credentials.next();
/* 109 */         if (curCred.getManagedConnectionFactory().equals(this.mcf))
/*     */         {
/* 111 */           pwdc = curCred;
/* 112 */           break;
/*     */         }
/*     */       }
/* 115 */       return pwdc;
/*     */     }
/*     */ 
/*     */     static PasswordCredential getCredential(Subject subject, ManagedConnectionFactory mcf) {
/* 119 */       GetCredentialAction action = new GetCredentialAction(subject, mcf);
/* 120 */       PasswordCredential pc = (PasswordCredential)AccessController.doPrivileged(action);
/* 121 */       return pc;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.JmsCred
 * JD-Core Version:    0.6.0
 */