/*     */ package org.jboss.resource.adapter.jms;
/*     */ 
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import org.jboss.util.Strings;
/*     */ 
/*     */ public class JmsConnectionRequestInfo
/*     */   implements ConnectionRequestInfo
/*     */ {
/*     */   private String userName;
/*     */   private String password;
/*     */   private String clientID;
/*  44 */   private boolean transacted = true;
/*  45 */   private int acknowledgeMode = 1;
/*  46 */   private int type = 0;
/*     */ 
/*     */   public JmsConnectionRequestInfo(JmsMCFProperties prop)
/*     */   {
/*  53 */     this.userName = prop.getUserName();
/*  54 */     this.password = prop.getPassword();
/*  55 */     this.clientID = prop.getClientID();
/*  56 */     this.type = prop.getType();
/*     */   }
/*     */ 
/*     */   public JmsConnectionRequestInfo(boolean transacted, int acknowledgeMode, int type)
/*     */   {
/*  66 */     this.transacted = transacted;
/*  67 */     this.acknowledgeMode = acknowledgeMode;
/*  68 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public void setDefaults(JmsMCFProperties prop)
/*     */   {
/*  76 */     if (this.userName == null)
/*  77 */       this.userName = prop.getUserName();
/*  78 */     if (this.password == null)
/*  79 */       this.password = prop.getPassword();
/*  80 */     if (this.clientID == null)
/*  81 */       this.clientID = prop.getClientID();
/*     */   }
/*     */ 
/*     */   public String getUserName()
/*     */   {
/*  86 */     return this.userName;
/*     */   }
/*     */ 
/*     */   public void setUserName(String name)
/*     */   {
/*  91 */     this.userName = name;
/*     */   }
/*     */ 
/*     */   public String getPassword()
/*     */   {
/*  96 */     return this.password;
/*     */   }
/*     */ 
/*     */   public void setPassword(String password)
/*     */   {
/* 101 */     this.password = password;
/*     */   }
/*     */ 
/*     */   public String getClientID()
/*     */   {
/* 106 */     return this.clientID;
/*     */   }
/*     */ 
/*     */   public void setClientID(String clientID)
/*     */   {
/* 111 */     this.clientID = clientID;
/*     */   }
/*     */ 
/*     */   public boolean isTransacted()
/*     */   {
/* 116 */     return this.transacted;
/*     */   }
/*     */ 
/*     */   public int getAcknowledgeMode()
/*     */   {
/* 121 */     return this.acknowledgeMode;
/*     */   }
/*     */ 
/*     */   public int getType()
/*     */   {
/* 126 */     return this.type;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 131 */     if (obj == null) return false;
/* 132 */     if ((obj instanceof JmsConnectionRequestInfo))
/*     */     {
/* 134 */       JmsConnectionRequestInfo you = (JmsConnectionRequestInfo)obj;
/* 135 */       return (this.transacted == you.isTransacted()) && (this.acknowledgeMode == you.getAcknowledgeMode()) && (this.type == you.getType()) && (Strings.compare(this.userName, you.getUserName())) && (Strings.compare(this.password, you.getPassword())) && (Strings.compare(this.clientID, you.getClientID()));
/*     */     }
/*     */ 
/* 143 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 148 */     int hashCode = 0;
/* 149 */     if (this.transacted)
/* 150 */       hashCode++;
/* 151 */     if (this.type == 1)
/* 152 */       hashCode += 3;
/* 153 */     else if (this.type == 2)
/* 154 */       hashCode += 5;
/* 155 */     if (this.acknowledgeMode == 1)
/* 156 */       hashCode += 7;
/* 157 */     else if (this.acknowledgeMode == 3)
/* 158 */       hashCode += 11;
/* 159 */     if (this.userName != null)
/* 160 */       hashCode += this.userName.hashCode();
/* 161 */     if (this.password != null)
/* 162 */       hashCode += this.password.hashCode();
/* 163 */     if (this.clientID != null) {
/* 164 */       hashCode += this.clientID.hashCode();
/*     */     }
/* 166 */     return hashCode;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.JmsConnectionRequestInfo
 * JD-Core Version:    0.6.0
 */