/*    */ package org.jboss.resource.adapter.jms;
/*    */ 
/*    */ import javax.resource.ResourceException;
/*    */ import javax.resource.spi.ConnectionManager;
/*    */ import javax.resource.spi.ConnectionRequestInfo;
/*    */ import javax.resource.spi.ManagedConnection;
/*    */ import javax.resource.spi.ManagedConnectionFactory;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class JmsConnectionManager
/*    */   implements ConnectionManager
/*    */ {
/*    */   private static final long serialVersionUID = -3638293323045716739L;
/* 47 */   private static final Logger log = Logger.getLogger(JmsConnectionManager.class);
/*    */ 
/*    */   public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo)
/*    */     throws ResourceException
/*    */   {
/* 69 */     boolean trace = log.isTraceEnabled();
/* 70 */     if (trace) {
/* 71 */       log.trace("Allocating connection; mcf=" + mcf + ", cxRequestInfo=" + cxRequestInfo);
/*    */     }
/* 73 */     ManagedConnection mc = mcf.createManagedConnection(null, cxRequestInfo);
/* 74 */     Object c = mc.getConnection(null, cxRequestInfo);
/*    */ 
/* 76 */     if (trace) {
/* 77 */       log.trace("Allocated connection: " + c + ", with managed connection: " + mc);
/*    */     }
/* 79 */     return c;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.JmsConnectionManager
 * JD-Core Version:    0.6.0
 */