/*     */ package org.jboss.resource.adapter.jms;
/*     */ 
/*     */ import javax.jms.Connection;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.QueueConnection;
/*     */ import javax.jms.TopicConnection;
/*     */ import javax.naming.Reference;
/*     */ import javax.resource.Referenceable;
/*     */ import javax.resource.spi.ConnectionManager;
/*     */ import javax.resource.spi.ManagedConnectionFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JmsConnectionFactoryImpl
/*     */   implements JmsConnectionFactory, Referenceable
/*     */ {
/*     */   private static final long serialVersionUID = -5135366013101194277L;
/*  52 */   private static final Logger log = Logger.getLogger(JmsConnectionFactoryImpl.class);
/*     */   private ManagedConnectionFactory mcf;
/*     */   private ConnectionManager cm;
/*     */   private Reference reference;
/*     */ 
/*     */   public JmsConnectionFactoryImpl(ManagedConnectionFactory mcf, ConnectionManager cm)
/*     */   {
/*  63 */     this.mcf = mcf;
/*     */ 
/*  65 */     boolean trace = log.isTraceEnabled();
/*  66 */     if (cm == null)
/*     */     {
/*  69 */       this.cm = new JmsConnectionManager();
/*  70 */       if (trace)
/*  71 */         log.trace("Created new connection manager");
/*     */     }
/*     */     else {
/*  74 */       this.cm = cm;
/*     */     }
/*  76 */     if (trace)
/*  77 */       log.trace("Using ManagedConnectionFactory=" + mcf + ", ConnectionManager=" + cm);
/*     */   }
/*     */ 
/*     */   public void setReference(Reference reference)
/*     */   {
/*  82 */     this.reference = reference;
/*     */ 
/*  84 */     if (log.isTraceEnabled())
/*  85 */       log.trace("Using Reference=" + reference);
/*     */   }
/*     */ 
/*     */   public Reference getReference()
/*     */   {
/*  90 */     return this.reference;
/*     */   }
/*     */ 
/*     */   public QueueConnection createQueueConnection()
/*     */     throws JMSException
/*     */   {
/*  97 */     QueueConnection qc = new JmsSessionFactoryImpl(this.mcf, this.cm, 1);
/*     */ 
/*  99 */     if (log.isTraceEnabled()) {
/* 100 */       log.trace("Created queue connection: " + qc);
/*     */     }
/* 102 */     return qc;
/*     */   }
/*     */ 
/*     */   public QueueConnection createQueueConnection(String userName, String password)
/*     */     throws JMSException
/*     */   {
/* 108 */     JmsSessionFactoryImpl s = new JmsSessionFactoryImpl(this.mcf, this.cm, 1);
/* 109 */     s.setUserName(userName);
/* 110 */     s.setPassword(password);
/*     */ 
/* 112 */     if (log.isTraceEnabled()) {
/* 113 */       log.trace("Created queue connection: " + s);
/*     */     }
/* 115 */     return s;
/*     */   }
/*     */ 
/*     */   public TopicConnection createTopicConnection()
/*     */     throws JMSException
/*     */   {
/* 122 */     TopicConnection tc = new JmsSessionFactoryImpl(this.mcf, this.cm, 2);
/*     */ 
/* 124 */     if (log.isTraceEnabled()) {
/* 125 */       log.trace("Created topic connection: " + tc);
/*     */     }
/* 127 */     return tc;
/*     */   }
/*     */ 
/*     */   public TopicConnection createTopicConnection(String userName, String password)
/*     */     throws JMSException
/*     */   {
/* 133 */     JmsSessionFactoryImpl s = new JmsSessionFactoryImpl(this.mcf, this.cm, 2);
/* 134 */     s.setUserName(userName);
/* 135 */     s.setPassword(password);
/*     */ 
/* 137 */     if (log.isTraceEnabled()) {
/* 138 */       log.trace("Created topic connection: " + s);
/*     */     }
/* 140 */     return s;
/*     */   }
/*     */ 
/*     */   public Connection createConnection()
/*     */     throws JMSException
/*     */   {
/* 148 */     Connection c = new JmsSessionFactoryImpl(this.mcf, this.cm, 0);
/*     */ 
/* 150 */     if (log.isTraceEnabled()) {
/* 151 */       log.trace("Created connection: " + c);
/*     */     }
/* 153 */     return c;
/*     */   }
/*     */ 
/*     */   public Connection createConnection(String userName, String password)
/*     */     throws JMSException
/*     */   {
/* 159 */     JmsSessionFactoryImpl s = new JmsSessionFactoryImpl(this.mcf, this.cm, 0);
/* 160 */     s.setUserName(userName);
/* 161 */     s.setPassword(password);
/*     */ 
/* 163 */     if (log.isTraceEnabled()) {
/* 164 */       log.trace("Created connection: " + s);
/*     */     }
/* 166 */     return s;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.JmsConnectionFactoryImpl
 * JD-Core Version:    0.6.0
 */