/*    */ package org.jboss.resource.adapter.jdbc.vendor;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.sql.Connection;
/*    */ import java.sql.ResultSet;
/*    */ import java.sql.SQLException;
/*    */ import java.sql.Statement;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;
/*    */ 
/*    */ public class SybaseValidConnectionChecker
/*    */   implements ValidConnectionChecker, Serializable
/*    */ {
/* 20 */   private static final Logger log = Logger.getLogger(SybaseValidConnectionChecker.class);
/*    */   private static final long serialVersionUID = 4179707462244257791L;
/*    */   private static final String VALID_QUERY = "SELECT getdate()";
/*    */ 
/*    */   public SQLException isValidConnection(Connection c)
/*    */   {
/* 31 */     SQLException sqe = null;
/* 32 */     Statement s = null;
/* 33 */     ResultSet rs = null;
/*    */     try
/*    */     {
/* 37 */       s = c.createStatement();
/* 38 */       rs = s.executeQuery("SELECT getdate()");
/*    */     }
/*    */     catch (SQLException ignore)
/*    */     {
/* 43 */       sqe = e;
/*    */     }
/*    */     finally
/*    */     {
/*    */       try
/*    */       {
/* 50 */         if (s != null)
/*    */         {
/* 52 */           s.close();
/*    */         }
/*    */ 
/*    */       }
/*    */       catch (SQLException ignore)
/*    */       {
/* 59 */         log.warn("JDBC resource for " + this + " could not be closed");
/*    */       }
/*    */ 
/*    */       try
/*    */       {
/* 65 */         if (rs != null)
/*    */         {
/* 67 */           rs.close();
/*    */         }
/*    */ 
/*    */       }
/*    */       catch (SQLException ignore)
/*    */       {
/* 73 */         log.warn("JDBC resource for " + this + " could not be closed");
/*    */       }
/*    */ 
/*    */     }
/*    */ 
/* 78 */     return sqe;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.vendor.SybaseValidConnectionChecker
 * JD-Core Version:    0.6.0
 */