/*    */ package org.jboss.resource.adapter.jdbc.vendor;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import javax.management.MBeanServer;
/*    */ import javax.management.ObjectName;
/*    */ import javax.transaction.xa.XAException;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.system.ServiceMBeanSupport;
/*    */ import org.jboss.tm.XAExceptionFormatter;
/*    */ 
/*    */ public class OracleXAExceptionFormatter extends ServiceMBeanSupport
/*    */   implements XAExceptionFormatter, OracleXAExceptionFormatterMBean
/*    */ {
/*    */   private static final String EXCEPTION_CLASS_NAME = "oracle.jdbc.xa.OracleXAException";
/* 44 */   private static final Object[] NOARGS = new Object[0];
/*    */   private ObjectName transactionManagerService;
/*    */   private Class oracleXAExceptionClass;
/*    */   private Method getXAError;
/*    */   private Method getXAErrorMessage;
/*    */   private Method getOracleError;
/*    */   private Method getOracleSQLError;
/*    */ 
/*    */   public ObjectName getTransactionManagerService()
/*    */   {
/* 64 */     return this.transactionManagerService;
/*    */   }
/*    */ 
/*    */   public void setTransactionManagerService(ObjectName transactionManagerService)
/*    */   {
/* 69 */     this.transactionManagerService = transactionManagerService;
/*    */   }
/*    */ 
/*    */   protected void startService() throws Exception
/*    */   {
/* 74 */     this.oracleXAExceptionClass = Thread.currentThread().getContextClassLoader().loadClass("oracle.jdbc.xa.OracleXAException");
/* 75 */     this.getXAError = this.oracleXAExceptionClass.getMethod("getXAError", new Class[0]);
/* 76 */     this.getXAErrorMessage = this.oracleXAExceptionClass.getMethod("getXAErrorMessage", new Class[] { this.getXAError.getReturnType() });
/* 77 */     this.getOracleError = this.oracleXAExceptionClass.getMethod("getOracleError", new Class[0]);
/* 78 */     this.getOracleSQLError = this.oracleXAExceptionClass.getMethod("getOracleSQLError", new Class[0]);
/*    */ 
/* 80 */     getServer().invoke(this.transactionManagerService, "registerXAExceptionFormatter", new Object[] { this.oracleXAExceptionClass, this }, new String[] { Class.class.getName(), OracleXAExceptionFormatterMBean.class.getName() });
/*    */   }
/*    */ 
/*    */   protected void stopService() throws Exception
/*    */   {
/* 85 */     getServer().invoke(this.transactionManagerService, "unregisterXAExceptionFormatter", new Object[] { this.oracleXAExceptionClass }, new String[] { Class.class.getName() });
/*    */ 
/* 87 */     this.oracleXAExceptionClass = null;
/*    */ 
/* 89 */     this.getXAError = null;
/* 90 */     this.getXAErrorMessage = null;
/* 91 */     this.getOracleError = null;
/* 92 */     this.getOracleSQLError = null;
/*    */   }
/*    */ 
/*    */   public void formatXAException(XAException xae, Logger log)
/*    */   {
/*    */     try
/*    */     {
/* 99 */       log.warn("xa error: " + this.getXAError.invoke(xae, NOARGS) + " (" + this.getXAErrorMessage.invoke(xae, new Object[] { this.getXAError.invoke(xae, NOARGS) }) + "); " + "oracle error: " + this.getOracleError.invoke(xae, NOARGS) + "; " + "oracle sql error: " + this.getOracleSQLError.invoke(xae, NOARGS) + ";", xae);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 105 */       log.warn("Problem trying to format XAException: ", e);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.vendor.OracleXAExceptionFormatter
 * JD-Core Version:    0.6.0
 */