/*     */ package org.jboss.resource.adapter.jdbc.remote;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Reader;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.sql.CallableStatement;
/*     */ import java.sql.Connection;
/*     */ import java.sql.DatabaseMetaData;
/*     */ import java.sql.ParameterMetaData;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.ResultSetMetaData;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.BinaryRefAddr;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.StringRefAddr;
/*     */ import javax.resource.Referenceable;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.invocation.InvokerInterceptor;
/*     */ import org.jboss.invocation.MarshalledInvocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.proxy.ClientMethodInterceptor;
/*     */ import org.jboss.proxy.GenericProxyFactory;
/*     */ import org.jboss.resource.connectionmanager.ConnectionFactoryBindingService;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.util.Classes;
/*     */ import org.jboss.util.naming.NonSerializableFactory;
/*     */ import org.jboss.util.naming.Util;
/*     */ 
/*     */ public class WrapperDataSourceService extends ConnectionFactoryBindingService
/*     */   implements WrapperDataSourceServiceMBean
/*     */ {
/*  82 */   private static Logger log = Logger.getLogger(WrapperDataSourceService.class);
/*     */   private ObjectName jmxInvokerName;
/*     */   private Invoker delegateInvoker;
/*     */   private Object theProxy;
/*  87 */   private HashMap marshalledInvocationMapping = new HashMap();
/*  88 */   private HashMap connectionMap = new HashMap();
/*  89 */   private HashMap statementMap = new HashMap();
/*  90 */   private HashMap resultSetMap = new HashMap();
/*  91 */   private HashMap lobMap = new HashMap();
/*  92 */   private HashMap databaseMetaDataMap = new HashMap();
/*  93 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/*  97 */     determineBindName();
/*  98 */     createConnectionFactory();
/*  99 */     if (this.jmxInvokerName != null)
/*     */     {
/* 101 */       createProxy();
/* 102 */       calculateMethodHases();
/* 103 */       bindConnectionFactory();
/*     */     }
/*     */     else
/*     */     {
/* 107 */       super.bindConnectionFactory();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 113 */     unbindConnectionFactory();
/* 114 */     if (this.jmxInvokerName != null)
/* 115 */       destroyProxy();
/*     */   }
/*     */ 
/*     */   protected void bindConnectionFactory() throws Exception
/*     */   {
/* 120 */     InitialContext ctx = new InitialContext();
/*     */     try
/*     */     {
/* 123 */       log.debug("Binding object '" + this.cf + "' into JNDI at '" + this.bindName + "'");
/*     */ 
/* 125 */       NonSerializableFactory.rebind(this.bindName, this.cf);
/*     */ 
/* 133 */       Referenceable referenceable = (Referenceable)this.cf;
/*     */ 
/* 135 */       ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 136 */       ObjectOutputStream oos = new ObjectOutputStream(baos);
/* 137 */       oos.writeObject(this.theProxy);
/* 138 */       oos.close();
/* 139 */       byte[] proxyBytes = baos.toByteArray();
/* 140 */       BinaryRefAddr dsAddr = new BinaryRefAddr("ProxyData", proxyBytes);
/* 141 */       String factory = DataSourceFactory.class.getName();
/* 142 */       Reference dsRef = new Reference("javax.sql.DataSource", dsAddr, factory, null);
/* 143 */       referenceable.setReference(dsRef);
/*     */ 
/* 145 */       baos.reset();
/* 146 */       ObjectOutputStream oos2 = new ObjectOutputStream(baos);
/* 147 */       oos2.writeObject(DataSourceFactory.vmID);
/* 148 */       oos2.close();
/* 149 */       byte[] id = baos.toByteArray();
/* 150 */       BinaryRefAddr localAddr = new BinaryRefAddr("VMID", id);
/* 151 */       dsRef.add(localAddr);
/*     */ 
/* 156 */       StringRefAddr jndiRef = new StringRefAddr("JndiName", this.bindName);
/* 157 */       dsRef.add(jndiRef);
/* 158 */       Util.rebind(ctx, this.bindName, this.cf);
/* 159 */       log.info("Bound ConnectionManager '" + this.serviceName + "' to JNDI name '" + this.bindName + "'");
/*     */     }
/*     */     catch (NamingException ne)
/*     */     {
/* 163 */       throw new DeploymentException("Could not bind ConnectionFactory into jndi: " + this.bindName, ne);
/*     */     }
/*     */     finally
/*     */     {
/* 167 */       ctx.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   public ObjectName getJMXInvokerName()
/*     */   {
/* 173 */     return this.jmxInvokerName;
/*     */   }
/*     */ 
/*     */   public void setJMXInvokerName(ObjectName jmxInvokerName)
/*     */   {
/* 178 */     this.jmxInvokerName = jmxInvokerName;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Exception
/*     */   {
/* 184 */     if ((invocation instanceof MarshalledInvocation))
/*     */     {
/* 186 */       MarshalledInvocation mi = (MarshalledInvocation)invocation;
/* 187 */       mi.setMethodMap(this.marshalledInvocationMapping);
/*     */     }
/*     */ 
/* 190 */     Method method = invocation.getMethod();
/* 191 */     Class methodClass = method.getDeclaringClass();
/* 192 */     Object[] args = invocation.getArguments();
/* 193 */     Object value = null;
/*     */     try
/*     */     {
/* 197 */       if (methodClass.isAssignableFrom(DataSource.class))
/*     */       {
/* 199 */         InitialContext ctx = new InitialContext();
/* 200 */         DataSource ds = (DataSource)ctx.lookup(this.bindName);
/* 201 */         value = doDataSourceMethod(ds, method, args);
/*     */       }
/* 203 */       else if (methodClass.isAssignableFrom(Connection.class))
/*     */       {
/* 205 */         Integer id = (Integer)invocation.getId();
/* 206 */         Connection conn = (Connection)this.connectionMap.get(id);
/* 207 */         if (conn == null)
/*     */         {
/* 209 */           throw new IllegalAccessException("Failed to find connection: " + id);
/*     */         }
/* 211 */         value = doConnectionMethod(conn, method, args);
/*     */       }
/* 213 */       else if ((methodClass.isAssignableFrom(Statement.class)) || (methodClass.isAssignableFrom(PreparedStatement.class)) || (methodClass.isAssignableFrom(CallableStatement.class)))
/*     */       {
/* 217 */         Integer id = (Integer)invocation.getId();
/* 218 */         Statement stmt = (Statement)this.statementMap.get(id);
/* 219 */         if (stmt == null)
/*     */         {
/* 221 */           throw new SQLException("Failed to find Statement: " + id);
/*     */         }
/* 223 */         value = doStatementMethod(stmt, method, args);
/*     */       }
/* 225 */       else if (methodClass.isAssignableFrom(ResultSet.class))
/*     */       {
/* 227 */         Integer id = (Integer)invocation.getId();
/* 228 */         ResultSet results = (ResultSet)this.resultSetMap.get(id);
/* 229 */         if (results == null)
/*     */         {
/* 231 */           throw new IllegalAccessException("Failed to find ResultSet: " + id);
/*     */         }
/* 233 */         value = doResultSetMethod(results, method, args);
/*     */       }
/* 235 */       else if (methodClass.isAssignableFrom(DatabaseMetaData.class))
/*     */       {
/* 237 */         Integer id = (Integer)invocation.getId();
/* 238 */         DatabaseMetaData dbMetaData = (DatabaseMetaData)this.databaseMetaDataMap.get(id);
/* 239 */         if (dbMetaData == null)
/*     */         {
/* 241 */           throw new IllegalAccessException("Failed to find DatabaseMetaData: " + id);
/*     */         }
/* 243 */         value = doDatabaseMetaDataMethod(dbMetaData, method, args);
/*     */       }
/*     */       else
/*     */       {
/* 247 */         throw new UnsupportedOperationException("Do not know how to handle method=" + method);
/*     */       }
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 252 */       Throwable t = e.getTargetException();
/* 253 */       if ((t instanceof Exception)) {
/* 254 */         throw ((Exception)t);
/*     */       }
/* 256 */       throw new UndeclaredThrowableException(t, method.toString());
/*     */     }
/*     */ 
/* 259 */     return value;
/*     */   }
/*     */ 
/*     */   protected void createProxy()
/*     */     throws Exception
/*     */   {
/* 272 */     this.delegateInvoker = ((Invoker)Registry.lookup(this.jmxInvokerName));
/* 273 */     log.debug("Using delegate: " + this.delegateInvoker + " for invoker=" + this.jmxInvokerName);
/*     */ 
/* 275 */     ObjectName targetName = getServiceName();
/* 276 */     Integer nameHash = new Integer(targetName.hashCode());
/* 277 */     Registry.bind(nameHash, targetName);
/*     */ 
/* 279 */     Object cacheID = null;
/* 280 */     String proxyBindingName = null;
/* 281 */     String jndiName = null;
/* 282 */     Class[] ifaces = { DataSource.class };
/*     */ 
/* 285 */     ArrayList interceptorClasses = new ArrayList();
/* 286 */     interceptorClasses.add(ClientMethodInterceptor.class);
/* 287 */     interceptorClasses.add(InvokerInterceptor.class);
/* 288 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 289 */     GenericProxyFactory proxyFactory = new GenericProxyFactory();
/* 290 */     this.theProxy = proxyFactory.createProxy(cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
/*     */ 
/* 293 */     log.debug("Created proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", nameHash=" + nameHash);
/*     */   }
/*     */ 
/*     */   protected void destroyProxy()
/*     */     throws Exception
/*     */   {
/* 302 */     ObjectName name = getServiceName();
/* 303 */     Integer nameHash = new Integer(name.hashCode());
/* 304 */     Registry.unbind(nameHash);
/*     */   }
/*     */ 
/*     */   protected void calculateMethodHases()
/*     */     throws Exception
/*     */   {
/* 312 */     Method[] methods = DataSource.class.getMethods();
/* 313 */     for (int m = 0; m < methods.length; m++)
/*     */     {
/* 315 */       Method method = methods[m];
/* 316 */       Long hash = new Long(MarshalledInvocation.calculateHash(method));
/* 317 */       this.marshalledInvocationMapping.put(hash, method);
/*     */     }
/*     */ 
/* 321 */     Map m = MarshalledInvocation.methodToHashesMap(Connection.class);
/* 322 */     displayHashes(m);
/* 323 */     this.marshalledInvocationMapping.putAll(m);
/* 324 */     m = MarshalledInvocation.methodToHashesMap(Statement.class);
/* 325 */     displayHashes(m);
/* 326 */     this.marshalledInvocationMapping.putAll(m);
/* 327 */     m = MarshalledInvocation.methodToHashesMap(CallableStatement.class);
/* 328 */     displayHashes(m);
/* 329 */     this.marshalledInvocationMapping.putAll(m);
/* 330 */     m = MarshalledInvocation.methodToHashesMap(PreparedStatement.class);
/* 331 */     displayHashes(m);
/* 332 */     this.marshalledInvocationMapping.putAll(m);
/* 333 */     m = MarshalledInvocation.methodToHashesMap(ResultSet.class);
/* 334 */     displayHashes(m);
/* 335 */     this.marshalledInvocationMapping.putAll(m);
/* 336 */     m = MarshalledInvocation.methodToHashesMap(DatabaseMetaData.class);
/* 337 */     displayHashes(m);
/* 338 */     this.marshalledInvocationMapping.putAll(m);
/*     */   }
/*     */ 
/*     */   private Object doDataSourceMethod(DataSource ds, Method method, Object[] args)
/*     */     throws InvocationTargetException, IllegalAccessException
/*     */   {
/* 344 */     Object value = method.invoke(ds, args);
/* 345 */     if ((value instanceof Connection))
/*     */     {
/* 347 */       value = createConnectionProxy(value);
/*     */     }
/* 349 */     else if ((value != null) && (!(value instanceof Serializable)))
/*     */     {
/* 351 */       throw new IllegalAccessException("Method=" + method + " does not return Serializable");
/*     */     }
/* 353 */     return value;
/*     */   }
/*     */ 
/*     */   private Object doConnectionMethod(Connection conn, Method method, Object[] args)
/*     */     throws InvocationTargetException, IllegalAccessException, SQLException
/*     */   {
/* 359 */     if (this.trace)
/*     */     {
/* 361 */       log.trace("doConnectionMethod, conn=" + conn + ", method=" + method);
/*     */     }
/* 363 */     Object value = method.invoke(conn, args);
/* 364 */     if ((value instanceof Statement))
/*     */     {
/* 366 */       value = createStatementProxy(value);
/*     */     }
/* 368 */     else if ((value instanceof DatabaseMetaData))
/*     */     {
/* 370 */       value = createDatabaseMetaData(value);
/*     */     }
/* 372 */     else if ((value != null) && (!(value instanceof Serializable)))
/*     */     {
/* 374 */       throw new IllegalAccessException("Method=" + method + " does not return Serializable");
/*     */     }
/* 376 */     return value;
/*     */   }
/*     */ 
/*     */   private Object doStatementMethod(Statement stmt, Method method, Object[] args)
/*     */     throws InvocationTargetException, IllegalAccessException, SQLException
/*     */   {
/* 382 */     if (this.trace)
/*     */     {
/* 384 */       log.trace("doStatementMethod, conn=" + stmt + ", method=" + method);
/*     */     }
/*     */ 
/* 387 */     if (method.getName().equals("close"))
/*     */     {
/* 389 */       Integer id = new Integer(stmt.hashCode());
/* 390 */       this.statementMap.remove(id);
/* 391 */       log.debug("Closed Statement=" + id);
/*     */     }
/*     */ 
/* 394 */     Object value = method.invoke(stmt, args);
/* 395 */     if ((value instanceof ResultSet))
/*     */     {
/* 397 */       value = createResultSetProxy(value);
/*     */     }
/* 399 */     else if ((value instanceof ResultSetMetaData))
/*     */     {
/* 401 */       ResultSetMetaData rmd = (ResultSetMetaData)value;
/* 402 */       value = new SerializableResultSetMetaData(rmd);
/*     */     }
/* 404 */     else if ((value instanceof ParameterMetaData))
/*     */     {
/* 406 */       ParameterMetaData pmd = (ParameterMetaData)value;
/* 407 */       value = new SerializableParameterMetaData(pmd);
/*     */     }
/* 409 */     else if ((value != null) && (!(value instanceof Serializable)))
/*     */     {
/* 411 */       throw new IllegalAccessException("Method=" + method + " does not return Serializable");
/*     */     }
/* 413 */     return value;
/*     */   }
/*     */ 
/*     */   private Object doResultSetMethod(ResultSet results, Method method, Object[] args)
/*     */     throws InvocationTargetException, IllegalAccessException, SQLException, IOException
/*     */   {
/* 419 */     if (this.trace)
/*     */     {
/* 421 */       log.trace("doStatementMethod, results=" + results + ", method=" + method);
/*     */     }
/*     */ 
/* 424 */     if (method.getName().equals("close"))
/*     */     {
/* 426 */       Integer id = new Integer(results.hashCode());
/* 427 */       this.resultSetMap.remove(id);
/* 428 */       log.debug("Closed ResultSet=" + id);
/*     */     }
/*     */ 
/* 431 */     Object value = method.invoke(results, args);
/* 432 */     if ((value instanceof ResultSetMetaData))
/*     */     {
/* 434 */       ResultSetMetaData rmd = (ResultSetMetaData)value;
/* 435 */       value = new SerializableResultSetMetaData(rmd);
/*     */     }
/*     */ 
/* 438 */     if ((("getBinaryStream".equals(method.getName())) || ("getAsciiStream".equals(method.getName()))) && ((value instanceof InputStream)))
/*     */     {
/* 440 */       InputStream ins = (InputStream)value;
/* 441 */       value = new SerializableInputStream(ins);
/*     */     }
/* 443 */     else if (("getCharacterStream".equals(method.getName())) && ((value instanceof Reader)))
/*     */     {
/* 445 */       Reader ins = (Reader)value;
/* 446 */       value = new SerializableReader(ins);
/*     */     }
/* 448 */     else if (("getClob".equals(method.getName())) || ("getBlob".equals(method.getName())))
/*     */     {
/* 450 */       value = createLobProxy(value);
/*     */     }
/*     */ 
/* 453 */     if ((value != null) && (!(value instanceof Serializable)))
/*     */     {
/* 455 */       throw new IllegalAccessException("Method=" + method + " does not return Serializable");
/*     */     }
/* 457 */     return value;
/*     */   }
/*     */ 
/*     */   private Object doDatabaseMetaDataMethod(DatabaseMetaData dbMetaData, Method method, Object[] args)
/*     */     throws InvocationTargetException, IllegalAccessException
/*     */   {
/* 463 */     if (this.trace)
/*     */     {
/* 465 */       log.trace("doDatabaseMetaDataMethod, dbMetaData=" + dbMetaData + ", method=" + method);
/*     */     }
/*     */ 
/* 468 */     Object value = method.invoke(dbMetaData, args);
/* 469 */     if ((value instanceof ResultSet))
/*     */     {
/* 471 */       value = createResultSetProxy(value);
/*     */     }
/* 473 */     else if ((value instanceof Connection))
/*     */     {
/* 475 */       value = createConnectionProxy(value);
/*     */     }
/* 477 */     if ((value != null) && (!(value instanceof Serializable)))
/*     */     {
/* 479 */       throw new IllegalAccessException("Method=" + method + " does not return Serializable");
/*     */     }
/* 481 */     return value;
/*     */   }
/*     */ 
/*     */   private Object createConnectionProxy(Object conn)
/*     */   {
/* 486 */     Object cacheID = new Integer(conn.hashCode());
/* 487 */     ObjectName targetName = getServiceName();
/* 488 */     String proxyBindingName = null;
/* 489 */     String jndiName = null;
/* 490 */     Class[] ifaces = { Connection.class };
/* 491 */     ArrayList interceptorClasses = new ArrayList();
/* 492 */     interceptorClasses.add(ClientMethodInterceptor.class);
/* 493 */     interceptorClasses.add(InvokerInterceptor.class);
/* 494 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 495 */     GenericProxyFactory proxyFactory = new GenericProxyFactory();
/* 496 */     Object connProxy = proxyFactory.createProxy(cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
/*     */ 
/* 499 */     this.connectionMap.put(cacheID, conn);
/* 500 */     log.debug("Created Connection proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", cacheID=" + cacheID);
/*     */ 
/* 502 */     return connProxy;
/*     */   }
/*     */ 
/*     */   private Object createStatementProxy(Object stmt)
/*     */   {
/* 507 */     Object cacheID = new Integer(stmt.hashCode());
/* 508 */     ObjectName targetName = getServiceName();
/* 509 */     String proxyBindingName = null;
/* 510 */     String jndiName = null;
/*     */ 
/* 512 */     Class[] ifaces = getJavaInterfaces(stmt.getClass());
/* 513 */     ArrayList interceptorClasses = new ArrayList();
/* 514 */     interceptorClasses.add(StatementInterceptor.class);
/* 515 */     interceptorClasses.add(ClientMethodInterceptor.class);
/* 516 */     interceptorClasses.add(InvokerInterceptor.class);
/* 517 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 518 */     GenericProxyFactory proxyFactory = new GenericProxyFactory();
/* 519 */     Object stmtProxy = proxyFactory.createProxy(cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
/*     */ 
/* 522 */     this.statementMap.put(cacheID, stmt);
/* 523 */     log.debug("Created Statement proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", cacheID=" + cacheID);
/*     */ 
/* 525 */     return stmtProxy;
/*     */   }
/*     */ 
/*     */   private Object createResultSetProxy(Object results)
/*     */   {
/* 530 */     Object cacheID = new Integer(results.hashCode());
/* 531 */     ObjectName targetName = getServiceName();
/* 532 */     String proxyBindingName = null;
/* 533 */     String jndiName = null;
/*     */ 
/* 535 */     Class[] ifaces = getJavaInterfaces(results.getClass());
/*     */ 
/* 537 */     ArrayList interceptorClasses = new ArrayList();
/* 538 */     interceptorClasses.add(ClientMethodInterceptor.class);
/* 539 */     interceptorClasses.add(InvokerInterceptor.class);
/* 540 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 541 */     GenericProxyFactory proxyFactory = new GenericProxyFactory();
/* 542 */     Object resultsProxy = proxyFactory.createProxy(cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
/*     */ 
/* 545 */     this.resultSetMap.put(cacheID, results);
/* 546 */     log.debug("Created ResultSet proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", cacheID=" + cacheID);
/*     */ 
/* 548 */     return resultsProxy;
/*     */   }
/*     */ 
/*     */   private Object createLobProxy(Object results)
/*     */   {
/* 553 */     Object cacheID = new Integer(results.hashCode());
/* 554 */     ObjectName targetName = getServiceName();
/* 555 */     String proxyBindingName = null;
/* 556 */     String jndiName = null;
/* 557 */     Class[] ifaces = results.getClass().getInterfaces();
/* 558 */     ArrayList interceptorClasses = new ArrayList();
/* 559 */     interceptorClasses.add(ClientMethodInterceptor.class);
/* 560 */     interceptorClasses.add(InvokerInterceptor.class);
/* 561 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 562 */     GenericProxyFactory proxyFactory = new GenericProxyFactory();
/* 563 */     Object resultsProxy = proxyFactory.createProxy(cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
/*     */ 
/* 566 */     this.lobMap.put(cacheID, results);
/* 567 */     log.debug("Created LOB proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", cacheID=" + cacheID);
/*     */ 
/* 569 */     return resultsProxy;
/*     */   }
/*     */ 
/*     */   private Object createDatabaseMetaData(Object dbMetaData)
/*     */   {
/* 574 */     Object cacheID = new Integer(dbMetaData.hashCode());
/* 575 */     ObjectName targetName = getServiceName();
/* 576 */     String proxyBindingName = null;
/* 577 */     String jndiName = null;
/* 578 */     Class[] ifaces = { DatabaseMetaData.class };
/* 579 */     ArrayList interceptorClasses = new ArrayList();
/* 580 */     interceptorClasses.add(ClientMethodInterceptor.class);
/* 581 */     interceptorClasses.add(InvokerInterceptor.class);
/* 582 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 583 */     GenericProxyFactory proxyFactory = new GenericProxyFactory();
/* 584 */     Object dbMetaDataProxy = proxyFactory.createProxy(cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
/*     */ 
/* 587 */     this.databaseMetaDataMap.put(cacheID, dbMetaData);
/* 588 */     log.debug("Created DatabaseMetadata proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", cacheID=" + cacheID);
/*     */ 
/* 590 */     return dbMetaDataProxy;
/*     */   }
/*     */ 
/*     */   private void displayHashes(Map m)
/*     */   {
/* 596 */     if (!this.trace) {
/* 597 */       return;
/*     */     }
/* 599 */     Iterator keys = m.keySet().iterator();
/* 600 */     while (keys.hasNext())
/*     */     {
/* 602 */       Long key = (Long)keys.next();
/* 603 */       log.trace(key + "=" + m.get(key));
/*     */     }
/*     */   }
/*     */ 
/*     */   private Class[] getJavaInterfaces(Class clazz)
/*     */   {
/* 609 */     ArrayList tmp = new ArrayList();
/* 610 */     Classes.getAllInterfaces(tmp, clazz);
/* 611 */     Iterator iter = tmp.iterator();
/* 612 */     while (iter.hasNext())
/*     */     {
/* 614 */       Class c = (Class)iter.next();
/* 615 */       if (!c.getName().startsWith("java"))
/* 616 */         iter.remove();
/*     */     }
/* 618 */     Class[] ifaces = new Class[tmp.size()];
/* 619 */     return (Class[])(Class[])tmp.toArray(ifaces);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.remote.WrapperDataSourceService
 * JD-Core Version:    0.6.0
 */