/*     */ package org.jboss.resource.adapter.jdbc.remote;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.IOException;
/*     */ import java.io.Reader;
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class SerializableReader extends Reader
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = 1244952470388397765L;
/*  37 */   private char[] data = null;
/*     */   protected char[] buf;
/*     */   protected int pos;
/*  41 */   protected int mark = 0;
/*     */   protected int count;
/*     */ 
/*     */   public SerializableReader(Reader reader)
/*     */     throws IOException
/*     */   {
/*  46 */     BufferedReader in = new BufferedReader(reader);
/*  47 */     String line = in.readLine();
/*  48 */     while (line != null)
/*     */     {
/*  50 */       String current = this.data == null ? "" : new String(this.data);
/*  51 */       String newData = current + line;
/*  52 */       this.data = newData.toCharArray();
/*  53 */       line = in.readLine();
/*     */     }
/*     */ 
/*  56 */     reader.close();
/*     */ 
/*  58 */     this.buf = this.data;
/*  59 */     this.pos = 0;
/*  60 */     this.count = this.buf.length;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public int read(char[] cbuf, int off, int len)
/*     */     throws IOException
/*     */   {
/*  90 */     if (cbuf == null)
/*     */     {
/*  92 */       throw new NullPointerException();
/*     */     }
/*  94 */     if ((off < 0) || (off > cbuf.length) || (len < 0) || (off + len > cbuf.length) || (off + len < 0))
/*     */     {
/*  97 */       throw new IndexOutOfBoundsException();
/*     */     }
/*     */ 
/* 100 */     if (this.pos >= this.count)
/*     */     {
/* 102 */       return -1;
/*     */     }
/* 104 */     if (this.pos + len > this.count)
/*     */     {
/* 106 */       len = this.count - this.pos;
/*     */     }
/* 108 */     if (len <= 0)
/*     */     {
/* 110 */       return 0;
/*     */     }
/* 112 */     System.arraycopy(this.buf, this.pos, cbuf, off, len);
/* 113 */     this.pos += len;
/* 114 */     return len;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.remote.SerializableReader
 * JD-Core Version:    0.6.0
 */