/*     */ package org.jboss.resource.adapter.jdbc.remote;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ 
/*     */ public class SerializableInputStream extends InputStream
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = 3364193722688048342L;
/*  40 */   private byte[] data = null;
/*     */   protected byte[] buf;
/*     */   protected int pos;
/*  44 */   protected int mark = 0;
/*     */   protected int count;
/*     */ 
/*     */   public SerializableInputStream(InputStream ins)
/*     */     throws IOException
/*     */   {
/*  50 */     List byteList = new ArrayList();
/*  51 */     int dat = ins.read();
/*  52 */     while (dat != -1)
/*     */     {
/*  54 */       byteList.add(new Byte((byte)dat));
/*  55 */       dat = ins.read();
/*     */     }
/*     */ 
/*  58 */     this.data = new byte[byteList.size()];
/*  59 */     int counter = 0;
/*  60 */     Iterator itr = byteList.iterator();
/*  61 */     while (itr.hasNext())
/*     */     {
/*  63 */       this.data[(counter++)] = ((Byte)itr.next()).byteValue();
/*     */     }
/*  65 */     ins.close();
/*  66 */     this.buf = this.data;
/*  67 */     this.pos = 0;
/*  68 */     this.count = this.buf.length;
/*     */   }
/*     */ 
/*     */   public synchronized int available()
/*     */   {
/*  88 */     return this.count - this.pos;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 102 */     System.err.println("close()");
/*     */   }
/*     */ 
/*     */   public synchronized void reset()
/*     */     throws IOException
/*     */   {
/* 152 */     System.err.println("reset()");
/*     */   }
/*     */ 
/*     */   public boolean markSupported()
/*     */   {
/* 169 */     System.err.println("markSupported()");
/* 170 */     return false;
/*     */   }
/*     */ 
/*     */   public synchronized void mark(int readlimit)
/*     */   {
/* 199 */     System.err.println("mark(int readlimit)");
/*     */   }
/*     */ 
/*     */   public long skip(long n)
/*     */     throws IOException
/*     */   {
/* 222 */     System.err.println("skip(long n)");
/* 223 */     return 0L;
/*     */   }
/*     */ 
/*     */   public int read(byte[] b)
/*     */     throws IOException
/*     */   {
/* 265 */     System.err.println("read(byte b[])");
/* 266 */     return read(b, 0, this.data.length);
/*     */   }
/*     */ 
/*     */   public synchronized int read(byte[] b, int off, int len)
/*     */   {
/* 332 */     if (b == null)
/*     */     {
/* 334 */       throw new NullPointerException();
/*     */     }
/* 336 */     if ((off < 0) || (off > b.length) || (len < 0) || (off + len > b.length) || (off + len < 0))
/*     */     {
/* 339 */       throw new IndexOutOfBoundsException();
/*     */     }
/* 341 */     if (this.pos >= this.count)
/*     */     {
/* 343 */       return -1;
/*     */     }
/* 345 */     if (this.pos + len > this.count)
/*     */     {
/* 347 */       len = this.count - this.pos;
/*     */     }
/* 349 */     if (len <= 0)
/*     */     {
/* 351 */       return 0;
/*     */     }
/* 353 */     System.arraycopy(this.buf, this.pos, b, off, len);
/* 354 */     this.pos += len;
/* 355 */     return len;
/*     */   }
/*     */ 
/*     */   public synchronized int read()
/*     */   {
/* 373 */     return this.pos < this.count ? this.buf[(this.pos++)] & 0xFF : -1;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.remote.SerializableInputStream
 * JD-Core Version:    0.6.0
 */