/*    */ package org.jboss.resource.adapter.jdbc.remote;
/*    */ 
/*    */ import java.io.ByteArrayInputStream;
/*    */ import java.io.ObjectInputStream;
/*    */ import java.rmi.server.UID;
/*    */ import java.util.Hashtable;
/*    */ import javax.naming.BinaryRefAddr;
/*    */ import javax.naming.Context;
/*    */ import javax.naming.Name;
/*    */ import javax.naming.Reference;
/*    */ import javax.naming.StringRefAddr;
/*    */ import javax.naming.spi.ObjectFactory;
/*    */ import org.jboss.util.naming.NonSerializableFactory;
/*    */ 
/*    */ public class DataSourceFactory
/*    */   implements ObjectFactory
/*    */ {
/* 45 */   public static final UID vmID = new UID();
/*    */ 
/*    */   public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env)
/*    */     throws Exception
/*    */   {
/* 50 */     Object instance = null;
/* 51 */     if ((obj instanceof Reference))
/*    */     {
/* 53 */       Reference ref = (Reference)obj;
/*    */ 
/* 55 */       BinaryRefAddr localID = (BinaryRefAddr)ref.get("VMID");
/* 56 */       byte[] idBytes = (byte[])(byte[])localID.getContent();
/* 57 */       ByteArrayInputStream bais = new ByteArrayInputStream(idBytes);
/* 58 */       ObjectInputStream ois = new ObjectInputStream(bais);
/* 59 */       UID id = (UID)ois.readObject();
/* 60 */       if (id.equals(vmID) == true)
/*    */       {
/* 63 */         StringRefAddr jndiAddr = (StringRefAddr)ref.get("JndiName");
/* 64 */         String jndiName = (String)jndiAddr.getContent();
/* 65 */         instance = NonSerializableFactory.lookup(jndiName);
/*    */       }
/*    */       else
/*    */       {
/* 70 */         BinaryRefAddr proxyAddr = (BinaryRefAddr)ref.get("ProxyData");
/* 71 */         byte[] proxyBytes = (byte[])(byte[])proxyAddr.getContent();
/* 72 */         ByteArrayInputStream bais2 = new ByteArrayInputStream(proxyBytes);
/* 73 */         ObjectInputStream ois2 = new ObjectInputStream(bais2);
/* 74 */         instance = ois2.readObject();
/*    */       }
/*    */     }
/* 77 */     return instance;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.remote.DataSourceFactory
 * JD-Core Version:    0.6.0
 */