/*     */ package org.jboss.resource.adapter.jdbc.local;
/*     */ 
/*     */ import java.util.Hashtable;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameParser;
/*     */ import javax.naming.NamingException;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ConnectionManager;
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import javax.resource.spi.ManagedConnectionFactory;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.connectionmanager.CachedConnectionManager;
/*     */ import org.jboss.resource.connectionmanager.CachedConnectionManagerReference;
/*     */ import org.jboss.resource.connectionmanager.InternalManagedConnectionPool.PoolParams;
/*     */ import org.jboss.resource.connectionmanager.JBossManagedConnectionPool.OnePool;
/*     */ import org.jboss.resource.connectionmanager.ManagedConnectionPool;
/*     */ import org.jboss.resource.connectionmanager.TxConnectionManager;
/*     */ import org.jboss.util.naming.NonSerializableFactory;
/*     */ import org.jboss.util.naming.Util;
/*     */ 
/*     */ public class LocalTxDataSource
/*     */ {
/*  52 */   protected static Logger log = Logger.getLogger(LocalTxDataSource.class.getName());
/*     */   private CachedConnectionManager cachedConnectionManager;
/*     */   private TransactionManager transactionManager;
/*     */   private String jndiName;
/*  63 */   private InternalManagedConnectionPool.PoolParams poolParams = new InternalManagedConnectionPool.PoolParams();
/*  64 */   private LocalManagedConnectionFactory mcf = new LocalManagedConnectionFactory();
/*     */ 
/*  66 */   private JBossManagedConnectionPool.OnePool pool = new JBossManagedConnectionPool.OnePool(this.mcf, this.poolParams, false, log);
/*     */   private TxConnectionManager connectionManager;
/*     */   private Object datasource;
/*     */   protected Hashtable initialContextProperties;
/*     */   protected InitialContext initialContext;
/*     */ 
/*     */   public void setInitialContextProperties(Hashtable initialContextProperties)
/*     */   {
/*  84 */     this.initialContextProperties = initialContextProperties;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*  89 */     if (this.initialContextProperties == null) this.initialContext = new InitialContext(); else {
/*  90 */       this.initialContext = new InitialContext(this.initialContextProperties);
/*     */     }
/*  92 */     this.connectionManager = new TxConnectionManager(this.cachedConnectionManager, this.pool, this.transactionManager);
/*  93 */     this.connectionManager.setLocalTransactions(true);
/*  94 */     this.connectionManager.setTrackConnectionByTx(true);
/*  95 */     this.pool.setConnectionListenerFactory(this.connectionManager);
/*  96 */     this.datasource = this.connectionManager.getPoolingStrategy().getManagedConnectionFactory().createConnectionFactory(new ConnectionManagerDelegate());
/*  97 */     bindConnectionFactory();
/*     */   }
/*     */ 
/*     */   protected void bindConnectionFactory()
/*     */     throws Exception
/*     */   {
/* 106 */     InitialContext ctx = this.initialContext;
/*     */     try
/*     */     {
/* 109 */       Name name = ctx.getNameParser("").parse(this.jndiName);
/* 110 */       String key = name.toString();
/* 111 */       if (name.size() > 1)
/*     */       {
/* 113 */         int size = name.size() - 1;
/* 114 */         Util.createSubcontext(this.initialContext, name.getPrefix(size));
/*     */       }
/* 116 */       NonSerializableFactory.rebind(this.initialContext, key, this.datasource);
/* 117 */       log.info("Bound datasource to JNDI name '" + this.jndiName + "'");
/*     */     }
/*     */     catch (NamingException ne)
/*     */     {
/* 121 */       throw new DeploymentException("Could not bind ConnectionFactory into jndi: " + this.jndiName, ne);
/*     */     }
/*     */     finally
/*     */     {
/* 125 */       ctx.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void unbindConnectionFactory() throws Exception
/*     */   {
/* 131 */     InitialContext ctx = this.initialContext;
/*     */     try
/*     */     {
/* 134 */       ctx.unbind(this.jndiName);
/* 135 */       NonSerializableFactory.unbind(this.jndiName);
/* 136 */       log.info("Unbound datasource for JNDI name '" + this.jndiName + "'");
/*     */     }
/*     */     catch (NamingException ne)
/*     */     {
/* 140 */       log.error("Could not unbind datasource from jndi: " + this.jndiName, ne);
/*     */     }
/*     */     finally
/*     */     {
/* 144 */       ctx.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getDatasource()
/*     */   {
/* 150 */     return this.datasource;
/*     */   }
/*     */ 
/*     */   public void setCachedConnectionManager(CachedConnectionManagerReference cachedConnectionManager)
/*     */   {
/* 155 */     this.cachedConnectionManager = cachedConnectionManager.getCachedConnectionManager();
/*     */   }
/*     */ 
/*     */   public TransactionManager getTransactionManager()
/*     */   {
/* 160 */     return this.transactionManager;
/*     */   }
/*     */ 
/*     */   public void setTransactionManager(TransactionManager transactionManager)
/*     */   {
/* 165 */     this.transactionManager = transactionManager;
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/* 170 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/* 175 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public int getMinSize()
/*     */   {
/* 180 */     return this.poolParams.minSize;
/*     */   }
/*     */ 
/*     */   public void setMinSize(int minSize)
/*     */   {
/* 185 */     this.poolParams.minSize = minSize;
/*     */   }
/*     */ 
/*     */   public int getMaxSize()
/*     */   {
/* 190 */     return this.poolParams.maxSize;
/*     */   }
/*     */ 
/*     */   public void setMaxSize(int maxSize)
/*     */   {
/* 195 */     this.poolParams.maxSize = maxSize;
/*     */   }
/*     */ 
/*     */   public int getBlockingTimeout()
/*     */   {
/* 200 */     return this.poolParams.blockingTimeout;
/*     */   }
/*     */ 
/*     */   public void setBlockingTimeout(int blockingTimeout)
/*     */   {
/* 205 */     this.poolParams.blockingTimeout = blockingTimeout;
/*     */   }
/*     */ 
/*     */   public long getIdleTimeout()
/*     */   {
/* 210 */     return this.poolParams.idleTimeout;
/*     */   }
/*     */ 
/*     */   public void setIdleTimeout(long idleTimeout)
/*     */   {
/* 215 */     this.poolParams.idleTimeout = idleTimeout;
/*     */   }
/*     */ 
/*     */   public String getDriverClass()
/*     */   {
/* 220 */     return this.mcf.getDriverClass();
/*     */   }
/*     */ 
/*     */   public void setDriverClass(String driverClass)
/*     */   {
/* 225 */     this.mcf.setDriverClass(driverClass);
/*     */   }
/*     */ 
/*     */   public String getConnectionURL()
/*     */   {
/* 230 */     return this.mcf.getConnectionURL();
/*     */   }
/*     */ 
/*     */   public void setConnectionURL(String connectionURL)
/*     */   {
/* 235 */     this.mcf.setConnectionURL(connectionURL);
/*     */   }
/*     */ 
/*     */   public void setUserName(String userName)
/*     */   {
/* 240 */     this.mcf.setUserName(userName);
/*     */   }
/*     */ 
/*     */   public void setPassword(String password)
/*     */   {
/* 245 */     this.mcf.setPassword(password);
/*     */   }
/*     */ 
/*     */   public void setPreparedStatementCacheSize(int size)
/*     */   {
/* 250 */     this.mcf.setPreparedStatementCacheSize(size);
/*     */   }
/*     */ 
/*     */   public int getPreparedStatementCacheSize()
/*     */   {
/* 255 */     return this.mcf.getPreparedStatementCacheSize();
/*     */   }
/*     */ 
/*     */   public boolean getSharePreparedStatements()
/*     */   {
/* 260 */     return this.mcf.getSharePreparedStatements();
/*     */   }
/*     */ 
/*     */   public void setSharePreparedStatements(boolean sharePS)
/*     */   {
/* 265 */     this.mcf.setSharePreparedStatements(sharePS);
/*     */   }
/*     */ 
/*     */   public boolean getTxQueryTimeout()
/*     */   {
/* 270 */     return this.mcf.isTransactionQueryTimeout();
/*     */   }
/*     */ 
/*     */   public void setTxQueryTimeout(boolean qt)
/*     */   {
/* 275 */     this.mcf.setTransactionQueryTimeout(qt);
/*     */   }
/*     */ 
/*     */   public String getTransactionIsolation()
/*     */   {
/* 280 */     return this.mcf.getTransactionIsolation();
/*     */   }
/*     */ 
/*     */   public void setTransactionIsolation(String transactionIsolation)
/*     */   {
/* 285 */     this.mcf.setTransactionIsolation(transactionIsolation);
/*     */   }
/*     */ 
/*     */   public String getNewConnectionSQL()
/*     */   {
/* 290 */     return this.mcf.getNewConnectionSQL();
/*     */   }
/*     */ 
/*     */   public void setNewConnectionSQL(String newConnectionSQL)
/*     */   {
/* 295 */     this.mcf.setNewConnectionSQL(newConnectionSQL);
/*     */   }
/*     */ 
/*     */   public String getCheckValidConnectionSQL()
/*     */   {
/* 300 */     return this.mcf.getCheckValidConnectionSQL();
/*     */   }
/*     */ 
/*     */   public void setCheckValidConnectionSQL(String checkValidConnectionSQL)
/*     */   {
/* 305 */     this.mcf.setCheckValidConnectionSQL(checkValidConnectionSQL);
/*     */   }
/*     */ 
/*     */   public String getTrackStatements()
/*     */   {
/* 310 */     return this.mcf.getTrackStatements();
/*     */   }
/*     */ 
/*     */   public void setTrackStatements(String value)
/*     */   {
/* 315 */     this.mcf.setTrackStatements(value);
/*     */   }
/*     */ 
/*     */   public String getExceptionSorterClassName()
/*     */   {
/* 320 */     return this.mcf.getExceptionSorterClassName();
/*     */   }
/*     */ 
/*     */   public void setExceptionSorterClassName(String exceptionSorterClassName)
/*     */   {
/* 325 */     this.mcf.setExceptionSorterClassName(exceptionSorterClassName);
/*     */   }
/*     */ 
/*     */   public String getValidConnectionCheckerClassName()
/*     */   {
/* 330 */     return this.mcf.getValidConnectionCheckerClassName();
/*     */   }
/*     */ 
/*     */   public void setValidConnectionCheckerClassName(String value)
/*     */   {
/* 335 */     this.mcf.setValidConnectionCheckerClassName(value);
/*     */   }
/*     */ 
/*     */   public class ConnectionManagerDelegate
/*     */     implements ConnectionManager
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*     */ 
/*     */     public ConnectionManagerDelegate()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo)
/*     */       throws ResourceException
/*     */     {
/*  78 */       return LocalTxDataSource.this.connectionManager.allocateConnection(mcf, cxRequestInfo);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.local.LocalTxDataSource
 * JD-Core Version:    0.6.0
 */