/*     */ package org.jboss.resource.adapter.jdbc.local;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.sql.Connection;
/*     */ import java.sql.Driver;
/*     */ import java.sql.DriverManager;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ConnectionManager;
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import javax.resource.spi.ManagedConnection;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.JBossResourceException;
/*     */ import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnectionFactory;
/*     */ import org.jboss.resource.adapter.jdbc.URLSelectorStrategy;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ 
/*     */ public class LocalManagedConnectionFactory extends BaseWrapperManagedConnectionFactory
/*     */ {
/*     */   static final long serialVersionUID = 4698955390505160469L;
/*     */   private String driverClass;
/*     */   private transient Driver driver;
/*     */   private String connectionURL;
/*     */   private URLSelectorStrategy urlSelector;
/*     */   protected String connectionProperties;
/*     */ 
/*     */   public Object createConnectionFactory(ConnectionManager cm)
/*     */     throws ResourceException
/*     */   {
/*  78 */     if (this.driverClass == null)
/*  79 */       throw new JBossResourceException("driverClass is null");
/*  80 */     if (this.connectionURL == null) {
/*  81 */       throw new JBossResourceException("connectionURL is null");
/*     */     }
/*  83 */     return super.createConnectionFactory(cm);
/*     */   }
/*     */ 
/*     */   public String getConnectionURL()
/*     */   {
/*  93 */     return this.connectionURL;
/*     */   }
/*     */ 
/*     */   public void setConnectionURL(String connectionURL)
/*     */   {
/* 104 */     this.connectionURL = connectionURL;
/* 105 */     if (this.urlDelimiter != null)
/*     */     {
/* 107 */       initUrlSelector();
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getDriverClass()
/*     */   {
/* 118 */     return this.driverClass;
/*     */   }
/*     */ 
/*     */   public synchronized void setDriverClass(String driverClass)
/*     */   {
/* 128 */     this.driverClass = driverClass;
/* 129 */     this.driver = null;
/*     */   }
/*     */ 
/*     */   public String getConnectionProperties()
/*     */   {
/* 139 */     return this.connectionProperties;
/*     */   }
/*     */ 
/*     */   public void setConnectionProperties(String connectionProperties)
/*     */   {
/* 149 */     this.connectionProperties = connectionProperties;
/* 150 */     this.connectionProps.clear();
/* 151 */     if (connectionProperties != null)
/*     */     {
/* 154 */       connectionProperties = connectionProperties.replaceAll("\\\\", "\\\\\\\\");
/*     */ 
/* 156 */       InputStream is = new ByteArrayInputStream(connectionProperties.getBytes());
/*     */       try
/*     */       {
/* 159 */         this.connectionProps.load(is);
/*     */       }
/*     */       catch (IOException ioe)
/*     */       {
/* 163 */         throw new NestedRuntimeException("Could not load connection properties", ioe);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri)
/*     */     throws ResourceException
/*     */   {
/* 171 */     Properties props = getConnectionProperties(subject, cri);
/*     */ 
/* 175 */     Properties copy = (Properties)props.clone();
/* 176 */     boolean trace = this.log.isTraceEnabled();
/* 177 */     if (trace)
/*     */     {
/* 180 */       Properties logCopy = copy;
/* 181 */       if (copy.getProperty("password") != null)
/*     */       {
/* 183 */         logCopy = (Properties)props.clone();
/* 184 */         logCopy.setProperty("password", "--hidden--");
/*     */       }
/* 186 */       this.log.trace("Using properties: " + logCopy);
/*     */     }
/*     */ 
/* 189 */     if (this.urlSelector != null)
/*     */     {
/* 191 */       return getHALocalManagedConnection(props, copy);
/*     */     }
/*     */ 
/* 195 */     return getLocalManagedConnection(props, copy);
/*     */   }
/*     */ 
/*     */   private LocalManagedConnection getLocalManagedConnection(Properties props, Properties copy)
/*     */     throws JBossResourceException
/*     */   {
/*     */     try
/*     */     {
/* 204 */       String url = getConnectionURL();
/* 205 */       Driver d = getDriver(url);
/* 206 */       Connection con = d.connect(url, copy);
/* 207 */       if (con == null) {
/* 208 */         throw new JBossResourceException("Wrong driver class for this connection URL");
/*     */       }
/* 210 */       return new LocalManagedConnection(this, con, props, this.transactionIsolation, this.preparedStatementCacheSize);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 214 */     throw new JBossResourceException("Could not create connection", e);
/*     */   }
/*     */ 
/*     */   private LocalManagedConnection getHALocalManagedConnection(Properties props, Properties copy)
/*     */     throws JBossResourceException
/*     */   {
/* 221 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 224 */     for (int i = 0; i < this.urlSelector.getCustomSortedUrls().size(); i++)
/*     */     {
/* 226 */       String url = (String)this.urlSelector.getUrlObject();
/* 227 */       if (trace)
/*     */       {
/* 229 */         this.log.trace("Trying to create a connection to " + url);
/*     */       }
/*     */       try
/*     */       {
/* 233 */         Driver d = getDriver(url);
/* 234 */         Connection con = d.connect(url, copy);
/* 235 */         if (con == null)
/*     */         {
/* 237 */           this.log.warn("Wrong driver class for this connection URL: " + url);
/* 238 */           this.urlSelector.failedUrlObject(url);
/*     */         }
/*     */         else
/*     */         {
/* 242 */           return new LocalManagedConnection(this, con, props, this.transactionIsolation, this.preparedStatementCacheSize);
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 247 */         this.log.warn("Failed to create connection for " + url + ": " + e.getMessage());
/* 248 */         this.urlSelector.failedUrlObject(url);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 253 */     throw new JBossResourceException("Could not create connection using any of the URLs: " + this.urlSelector.getAllUrlObjects());
/*     */   }
/*     */ 
/*     */   public void setURLDelimiter(String urlDelimiter)
/*     */   {
/* 260 */     this.urlDelimiter = urlDelimiter;
/* 261 */     if (getConnectionURL() != null)
/*     */     {
/* 263 */       initUrlSelector();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initUrlSelector()
/*     */   {
/* 270 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 272 */     List urlsList = new ArrayList();
/* 273 */     String urlsStr = getConnectionURL();
/*     */ 
/* 275 */     int urlStart = 0;
/* 276 */     int urlEnd = urlsStr.indexOf(this.urlDelimiter);
/* 277 */     while (urlEnd > 0)
/*     */     {
/* 279 */       String url = urlsStr.substring(urlStart, urlEnd);
/* 280 */       urlsList.add(url);
/* 281 */       urlEnd++; urlStart = urlEnd;
/* 282 */       urlEnd = urlsStr.indexOf(this.urlDelimiter, urlEnd);
/* 283 */       if (trace) {
/* 284 */         this.log.trace("added HA connection url: " + url);
/*     */       }
/*     */     }
/* 287 */     if (urlStart != urlsStr.length())
/*     */     {
/* 289 */       String url = urlsStr.substring(urlStart, urlsStr.length());
/* 290 */       urlsList.add(url);
/* 291 */       if (trace)
/* 292 */         this.log.trace("added HA connection url: " + url);
/*     */     }
/* 294 */     if (getUrlSelectorStrategyClassName() == null)
/*     */     {
/* 296 */       this.urlSelector = new URLSelector(urlsList);
/* 297 */       this.log.debug("Default URLSelectorStrategy is being used : " + this.urlSelector);
/*     */     }
/*     */     else
/*     */     {
/* 301 */       this.urlSelector = ((URLSelectorStrategy)loadClass(getUrlSelectorStrategyClassName(), urlsList));
/* 302 */       this.log.debug("Customized URLSelectorStrategy is being used : " + this.urlSelector);
/*     */     }
/*     */   }
/*     */ 
/*     */   public ManagedConnection matchManagedConnections(Set mcs, Subject subject, ConnectionRequestInfo cri)
/*     */     throws ResourceException
/*     */   {
/* 366 */     Properties newProps = getConnectionProperties(subject, cri);
/*     */ 
/* 368 */     for (Iterator i = mcs.iterator(); i.hasNext(); )
/*     */     {
/* 370 */       Object o = i.next();
/*     */ 
/* 372 */       if ((o instanceof LocalManagedConnection))
/*     */       {
/* 374 */         LocalManagedConnection mc = (LocalManagedConnection)o;
/*     */ 
/* 377 */         if (mc.getProperties().equals(newProps))
/*     */         {
/* 380 */           if (((getValidateOnMatch()) && (mc.checkValid())) || (!getValidateOnMatch()))
/*     */           {
/* 383 */             return mc;
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 391 */     return null;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 396 */     int result = 17;
/* 397 */     result = result * 37 + (this.connectionURL == null ? 0 : this.connectionURL.hashCode());
/* 398 */     result = result * 37 + (this.driverClass == null ? 0 : this.driverClass.hashCode());
/* 399 */     result = result * 37 + (this.userName == null ? 0 : this.userName.hashCode());
/* 400 */     result = result * 37 + (this.password == null ? 0 : this.password.hashCode());
/* 401 */     result = result * 37 + this.transactionIsolation;
/* 402 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 407 */     if (this == other)
/* 408 */       return true;
/* 409 */     if (getClass() != other.getClass())
/* 410 */       return false;
/* 411 */     LocalManagedConnectionFactory otherMcf = (LocalManagedConnectionFactory)other;
/* 412 */     return (this.connectionURL.equals(otherMcf.connectionURL)) && (this.driverClass.equals(otherMcf.driverClass)) && (this.userName == null ? otherMcf.userName == null : this.userName.equals(otherMcf.userName)) && (this.password == null ? otherMcf.password == null : this.password.equals(otherMcf.password)) && (this.transactionIsolation == otherMcf.transactionIsolation);
/*     */   }
/*     */ 
/*     */   protected synchronized Driver getDriver(String url)
/*     */     throws ResourceException
/*     */   {
/* 427 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 430 */     if (this.driver != null)
/*     */     {
/* 432 */       return this.driver;
/*     */     }
/* 434 */     if (trace) {
/* 435 */       this.log.trace("Checking driver for URL: " + url);
/*     */     }
/* 437 */     if (this.driverClass == null)
/*     */     {
/* 439 */       throw new JBossResourceException("No Driver class specified (url = " + url + ")!");
/*     */     }
/*     */ 
/* 444 */     if (isDriverLoadedForURL(url))
/*     */     {
/* 446 */       return this.driver;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 452 */       Class clazz = Class.forName(this.driverClass, true, Thread.currentThread().getContextClassLoader());
/* 453 */       if (isDriverLoadedForURL(url))
/*     */       {
/* 455 */         return this.driver;
/*     */       }
/*     */ 
/* 459 */       this.driver = ((Driver)clazz.newInstance());
/* 460 */       DriverManager.registerDriver(this.driver);
/* 461 */       if (isDriverLoadedForURL(url)) {
/* 462 */         return this.driver;
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 467 */       throw new JBossResourceException("Failed to register driver for: " + this.driverClass, e);
/*     */     }
/*     */ 
/* 470 */     throw new JBossResourceException("Apparently wrong driver class specified for URL: class: " + this.driverClass + ", url: " + url);
/*     */   }
/*     */ 
/*     */   private boolean isDriverLoadedForURL(String url)
/*     */   {
/* 476 */     boolean trace = this.log.isTraceEnabled();
/*     */     try
/*     */     {
/* 480 */       this.driver = DriverManager.getDriver(url);
/* 481 */       if (trace)
/* 482 */         this.log.trace("Driver already registered for url: " + url);
/* 483 */       return true;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 487 */       if (trace)
/* 488 */         this.log.trace("Driver not yet registered for url: " + url); 
/*     */     }
/* 489 */     return false;
/*     */   }
/*     */ 
/*     */   protected String internalGetConnectionURL()
/*     */   {
/* 495 */     return this.connectionURL;
/*     */   }
/*     */ 
/*     */   public static class URLSelector
/*     */     implements URLSelectorStrategy
/*     */   {
/*     */     private final List urls;
/*     */     private int urlIndex;
/*     */     private String url;
/*     */ 
/*     */     public URLSelector(List urls)
/*     */     {
/* 315 */       if ((urls == null) || (urls.size() == 0))
/*     */       {
/* 317 */         throw new IllegalStateException("Expected non-empty list of connection URLs but got: " + urls);
/*     */       }
/* 319 */       this.urls = Collections.unmodifiableList(urls);
/*     */     }
/*     */ 
/*     */     public synchronized String getUrl()
/*     */     {
/* 324 */       if (this.url == null)
/*     */       {
/* 326 */         if (this.urlIndex == this.urls.size())
/*     */         {
/* 328 */           this.urlIndex = 0;
/*     */         }
/* 330 */         this.url = ((String)this.urls.get(this.urlIndex++));
/*     */       }
/* 332 */       return this.url;
/*     */     }
/*     */ 
/*     */     public synchronized void failedUrl(String url)
/*     */     {
/* 337 */       if (url.equals(this.url))
/*     */       {
/* 339 */         this.url = null;
/*     */       }
/*     */     }
/*     */ 
/*     */     public List getCustomSortedUrls()
/*     */     {
/* 346 */       return this.urls;
/*     */     }
/*     */ 
/*     */     public void failedUrlObject(Object urlObject) {
/* 350 */       failedUrl((String)urlObject);
/*     */     }
/*     */ 
/*     */     public List getAllUrlObjects() {
/* 354 */       return this.urls;
/*     */     }
/*     */ 
/*     */     public Object getUrlObject() {
/* 358 */       return getUrl();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.local.LocalManagedConnectionFactory
 * JD-Core Version:    0.6.0
 */