/*     */ package org.jboss.resource.adapter.jdbc.local;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.LocalTransaction;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import org.jboss.resource.JBossResourceException;
/*     */ import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnection;
/*     */ 
/*     */ public class LocalManagedConnection extends BaseWrapperManagedConnection
/*     */   implements LocalTransaction
/*     */ {
/*     */   public LocalManagedConnection(LocalManagedConnectionFactory mcf, Connection con, Properties props, int transactionIsolation, int psCacheSize)
/*     */     throws SQLException
/*     */   {
/*  47 */     super(mcf, con, props, transactionIsolation, psCacheSize);
/*     */   }
/*     */ 
/*     */   public LocalTransaction getLocalTransaction() throws ResourceException
/*     */   {
/*  52 */     return this;
/*     */   }
/*     */ 
/*     */   public XAResource getXAResource() throws ResourceException
/*     */   {
/*  57 */     throw new JBossResourceException("Local tx only!");
/*     */   }
/*     */ 
/*     */   public void commit() throws ResourceException
/*     */   {
/*  62 */     synchronized (this.stateLock)
/*     */     {
/*  64 */       if (this.inManagedTransaction)
/*  65 */         this.inManagedTransaction = false;
/*     */     }
/*     */     try
/*     */     {
/*  69 */       this.con.commit();
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/*  73 */       checkException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void rollback() throws ResourceException
/*     */   {
/*  79 */     synchronized (this.stateLock)
/*     */     {
/*  81 */       if (this.inManagedTransaction)
/*  82 */         this.inManagedTransaction = false;
/*     */     }
/*     */     try
/*     */     {
/*  86 */       this.con.rollback();
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/*     */       try
/*     */       {
/*  92 */         checkException(e);
/*     */       }
/*     */       catch (Exception e2)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void begin() throws ResourceException
/*     */   {
/* 102 */     synchronized (this.stateLock)
/*     */     {
/* 104 */       if (!this.inManagedTransaction)
/*     */       {
/*     */         try
/*     */         {
/* 108 */           if (this.underlyingAutoCommit)
/*     */           {
/* 110 */             this.underlyingAutoCommit = false;
/* 111 */             this.con.setAutoCommit(false);
/*     */           }
/* 113 */           checkState();
/* 114 */           this.inManagedTransaction = true;
/*     */         }
/*     */         catch (SQLException e)
/*     */         {
/* 118 */           checkException(e);
/*     */         }
/*     */       }
/*     */       else
/* 122 */         throw new JBossResourceException("Trying to begin a nested local tx");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.local.LocalManagedConnection
 * JD-Core Version:    0.6.0
 */