/*     */ package org.jboss.resource.adapter.jdbc.jdk6;
/*     */ 
/*     */ import java.sql.Array;
/*     */ import java.sql.Blob;
/*     */ import java.sql.CallableStatement;
/*     */ import java.sql.Clob;
/*     */ import java.sql.Connection;
/*     */ import java.sql.NClob;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.SQLClientInfoException;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLXML;
/*     */ import java.sql.Statement;
/*     */ import java.sql.Struct;
/*     */ import java.util.Properties;
/*     */ import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnection;
/*     */ import org.jboss.resource.adapter.jdbc.WrappedCallableStatement;
/*     */ import org.jboss.resource.adapter.jdbc.WrappedConnection;
/*     */ import org.jboss.resource.adapter.jdbc.WrappedPreparedStatement;
/*     */ import org.jboss.resource.adapter.jdbc.WrappedStatement;
/*     */ 
/*     */ public class WrappedConnectionJDK6 extends WrappedConnection
/*     */ {
/*     */   public WrappedConnectionJDK6(BaseWrapperManagedConnection mc)
/*     */   {
/*  60 */     super(mc);
/*     */   }
/*     */ 
/*     */   protected WrappedStatement wrapStatement(Statement statement)
/*     */   {
/*  65 */     return new WrappedStatementJDK6(this, statement);
/*     */   }
/*     */ 
/*     */   protected WrappedPreparedStatement wrapPreparedStatement(PreparedStatement statement)
/*     */   {
/*  70 */     return new WrappedPreparedStatementJDK6(this, statement);
/*     */   }
/*     */ 
/*     */   protected WrappedCallableStatement wrapCallableStatement(CallableStatement statement)
/*     */   {
/*  75 */     return new WrappedCallableStatementJDK6(this, statement);
/*     */   }
/*     */ 
/*     */   public Array createArrayOf(String typeName, Object[] elements) throws SQLException
/*     */   {
/*  80 */     Connection c = getUnderlyingConnection();
/*     */     try
/*     */     {
/*  83 */       return c.createArrayOf(typeName, elements);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/*  87 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public Blob createBlob()
/*     */     throws SQLException
/*     */   {
/*  93 */     Connection c = getUnderlyingConnection();
/*     */     try
/*     */     {
/*  96 */       return c.createBlob();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 100 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public Clob createClob()
/*     */     throws SQLException
/*     */   {
/* 106 */     Connection c = getUnderlyingConnection();
/*     */     try
/*     */     {
/* 109 */       return c.createClob();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 113 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public NClob createNClob()
/*     */     throws SQLException
/*     */   {
/* 119 */     Connection c = getUnderlyingConnection();
/*     */     try
/*     */     {
/* 122 */       return c.createNClob();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 126 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public SQLXML createSQLXML()
/*     */     throws SQLException
/*     */   {
/* 132 */     Connection c = getUnderlyingConnection();
/*     */     try
/*     */     {
/* 135 */       return c.createSQLXML();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 139 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public Struct createStruct(String typeName, Object[] attributes)
/*     */     throws SQLException
/*     */   {
/* 145 */     Connection c = getUnderlyingConnection();
/*     */     try
/*     */     {
/* 148 */       return c.createStruct(typeName, attributes);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 152 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public Properties getClientInfo()
/*     */     throws SQLException
/*     */   {
/* 158 */     Connection c = getUnderlyingConnection();
/*     */     try
/*     */     {
/* 161 */       return c.getClientInfo();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 165 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public String getClientInfo(String name)
/*     */     throws SQLException
/*     */   {
/* 171 */     Connection c = getUnderlyingConnection();
/*     */     try
/*     */     {
/* 174 */       return c.getClientInfo(name);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 178 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public boolean isValid(int timeout)
/*     */     throws SQLException
/*     */   {
/* 184 */     Connection c = getUnderlyingConnection();
/*     */     try
/*     */     {
/* 187 */       return c.isValid(timeout);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 191 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void setClientInfo(Properties properties)
/*     */     throws SQLClientInfoException
/*     */   {
/*     */     try
/*     */     {
/* 199 */       Connection c = getUnderlyingConnection();
/*     */       try
/*     */       {
/* 202 */         c.setClientInfo(properties);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 206 */         throw checkException(t);
/*     */       }
/*     */     }
/*     */     catch (SQLClientInfoException e)
/*     */     {
/* 211 */       throw e;
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 215 */       SQLClientInfoException t = new SQLClientInfoException();
/* 216 */       t.initCause(e);
/* 217 */       throw t;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setClientInfo(String name, String value) throws SQLClientInfoException
/*     */   {
/*     */     try
/*     */     {
/* 225 */       Connection c = getUnderlyingConnection();
/*     */       try
/*     */       {
/* 228 */         c.setClientInfo(name, value);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 232 */         throw checkException(t);
/*     */       }
/*     */     }
/*     */     catch (SQLClientInfoException e)
/*     */     {
/* 237 */       throw e;
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 241 */       SQLClientInfoException t = new SQLClientInfoException();
/* 242 */       t.initCause(e);
/* 243 */       throw t;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.jdk6.WrappedConnectionJDK6
 * JD-Core Version:    0.6.0
 */