/*     */ package org.jboss.resource.adapter.jdbc.jdk6;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.sql.Blob;
/*     */ import java.sql.CallableStatement;
/*     */ import java.sql.Clob;
/*     */ import java.sql.NClob;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.RowId;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLXML;
/*     */ import org.jboss.resource.adapter.jdbc.WrappedCallableStatement;
/*     */ import org.jboss.resource.adapter.jdbc.WrappedResultSet;
/*     */ 
/*     */ public class WrappedCallableStatementJDK6 extends WrappedCallableStatement
/*     */ {
/*     */   public WrappedCallableStatementJDK6(WrappedConnectionJDK6 lc, CallableStatement s)
/*     */   {
/*  49 */     super(lc, s);
/*     */   }
/*     */ 
/*     */   protected WrappedResultSet wrapResultSet(ResultSet resultSet)
/*     */   {
/*  54 */     return new WrappedResultSetJDK6(this, resultSet);
/*     */   }
/*     */ 
/*     */   public boolean isClosed() throws SQLException
/*     */   {
/*     */     try
/*     */     {
/*  61 */       PreparedStatement wrapped = getWrappedObject();
/*  62 */       if (wrapped == null)
/*  63 */         return true;
/*  64 */       return wrapped.isClosed();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/*  68 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public boolean isPoolable()
/*     */     throws SQLException
/*     */   {
/*  74 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/*  77 */       return statement.isPoolable();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/*  81 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void setPoolable(boolean poolable)
/*     */     throws SQLException
/*     */   {
/*  87 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/*  90 */       statement.setPoolable(poolable);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  94 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException
/*     */   {
/* 100 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 103 */       statement.setAsciiStream(parameterIndex, x, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 107 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException
/*     */   {
/* 113 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 116 */       statement.setAsciiStream(parameterIndex, x);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 120 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException
/*     */   {
/* 126 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 129 */       statement.setBinaryStream(parameterIndex, x, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 133 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException
/*     */   {
/* 139 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 142 */       statement.setBinaryStream(parameterIndex, x);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 146 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException
/*     */   {
/* 152 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 155 */       statement.setBlob(parameterIndex, inputStream, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 159 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException
/*     */   {
/* 165 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 168 */       statement.setBlob(parameterIndex, inputStream);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 172 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException
/*     */   {
/* 178 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 181 */       statement.setCharacterStream(parameterIndex, reader, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 185 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException
/*     */   {
/* 191 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 194 */       statement.setCharacterStream(parameterIndex, reader);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 198 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setClob(int parameterIndex, Reader reader, long length) throws SQLException
/*     */   {
/* 204 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 207 */       statement.setClob(parameterIndex, reader, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 211 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setClob(int parameterIndex, Reader reader) throws SQLException
/*     */   {
/* 217 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 220 */       statement.setClob(parameterIndex, reader);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 224 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException
/*     */   {
/* 230 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 233 */       statement.setNCharacterStream(parameterIndex, value, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 237 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException
/*     */   {
/* 243 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 246 */       statement.setNCharacterStream(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 250 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNClob(int parameterIndex, NClob value) throws SQLException
/*     */   {
/* 256 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 259 */       statement.setNClob(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 263 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException
/*     */   {
/* 269 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 272 */       statement.setNClob(parameterIndex, reader, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 276 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNClob(int parameterIndex, Reader reader) throws SQLException
/*     */   {
/* 282 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 285 */       statement.setNClob(parameterIndex, reader);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 289 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNString(int parameterIndex, String value) throws SQLException
/*     */   {
/* 295 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 298 */       statement.setNString(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 302 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setRowId(int parameterIndex, RowId x) throws SQLException
/*     */   {
/* 308 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 311 */       statement.setRowId(parameterIndex, x);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 315 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException
/*     */   {
/* 321 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 324 */       statement.setSQLXML(parameterIndex, xmlObject);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 328 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Reader getCharacterStream(int parameterIndex) throws SQLException
/*     */   {
/* 334 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 337 */       return statement.getCharacterStream(parameterIndex);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 341 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public Reader getCharacterStream(String parameterName)
/*     */     throws SQLException
/*     */   {
/* 347 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 350 */       return statement.getCharacterStream(parameterName);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 354 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public Reader getNCharacterStream(int parameterIndex)
/*     */     throws SQLException
/*     */   {
/* 360 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 363 */       return statement.getNCharacterStream(parameterIndex);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 367 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public Reader getNCharacterStream(String parameterName)
/*     */     throws SQLException
/*     */   {
/* 373 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 376 */       return statement.getCharacterStream(parameterName);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 380 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public NClob getNClob(int parameterIndex)
/*     */     throws SQLException
/*     */   {
/* 386 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 389 */       return statement.getNClob(parameterIndex);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 393 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public NClob getNClob(String parameterName)
/*     */     throws SQLException
/*     */   {
/* 399 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 402 */       return statement.getNClob(parameterName);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 406 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public String getNString(int parameterIndex)
/*     */     throws SQLException
/*     */   {
/* 412 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 415 */       return statement.getNString(parameterIndex);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 419 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public String getNString(String parameterName)
/*     */     throws SQLException
/*     */   {
/* 425 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 428 */       return statement.getNString(parameterName);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 432 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public RowId getRowId(int parameterIndex)
/*     */     throws SQLException
/*     */   {
/* 438 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 441 */       return statement.getRowId(parameterIndex);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 445 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public RowId getRowId(String parameterName)
/*     */     throws SQLException
/*     */   {
/* 451 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 454 */       return statement.getRowId(parameterName);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 458 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public SQLXML getSQLXML(int parameterIndex)
/*     */     throws SQLException
/*     */   {
/* 464 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 467 */       return statement.getSQLXML(parameterIndex);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 471 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public SQLXML getSQLXML(String parameterName)
/*     */     throws SQLException
/*     */   {
/* 477 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 480 */       return statement.getSQLXML(parameterName);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 484 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void setAsciiStream(String parameterName, InputStream x, long length)
/*     */     throws SQLException
/*     */   {
/* 490 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 493 */       statement.setAsciiStream(parameterName, x, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 497 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setAsciiStream(String parameterName, InputStream x) throws SQLException
/*     */   {
/* 503 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 506 */       statement.setAsciiStream(parameterName, x);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 510 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException
/*     */   {
/* 516 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 519 */       statement.setBinaryStream(parameterName, x, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 523 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBinaryStream(String parameterName, InputStream x) throws SQLException
/*     */   {
/* 529 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 532 */       statement.setBinaryStream(parameterName, x);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 536 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBlob(String parameterName, Blob x) throws SQLException
/*     */   {
/* 542 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 545 */       statement.setBlob(parameterName, x);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 549 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException
/*     */   {
/* 555 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 558 */       statement.setBlob(parameterName, inputStream, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 562 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBlob(String parameterName, InputStream inputStream) throws SQLException
/*     */   {
/* 568 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 571 */       statement.setBlob(parameterName, inputStream);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 575 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException
/*     */   {
/* 581 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 584 */       statement.setCharacterStream(parameterName, reader, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 588 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setCharacterStream(String parameterName, Reader reader) throws SQLException
/*     */   {
/* 594 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 597 */       statement.setCharacterStream(parameterName, reader);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 601 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setClob(String parameterName, Clob x) throws SQLException
/*     */   {
/* 607 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 610 */       statement.setClob(parameterName, x);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 614 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setClob(String parameterName, Reader reader, long length) throws SQLException
/*     */   {
/* 620 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 623 */       statement.setClob(parameterName, reader, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 627 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setClob(String parameterName, Reader reader) throws SQLException
/*     */   {
/* 633 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 636 */       statement.setClob(parameterName, reader);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 640 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException
/*     */   {
/* 646 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 649 */       statement.setNCharacterStream(parameterName, value, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 653 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNCharacterStream(String parameterName, Reader value) throws SQLException
/*     */   {
/* 659 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 662 */       statement.setNCharacterStream(parameterName, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 666 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNClob(String parameterName, NClob value) throws SQLException
/*     */   {
/* 672 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 675 */       statement.setNClob(parameterName, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 679 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNClob(String parameterName, Reader reader, long length) throws SQLException
/*     */   {
/* 685 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 688 */       statement.setNClob(parameterName, reader, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 692 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNClob(String parameterName, Reader reader) throws SQLException
/*     */   {
/* 698 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 701 */       statement.setNClob(parameterName, reader);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 705 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNString(String parameterName, String value) throws SQLException
/*     */   {
/* 711 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 714 */       statement.setNString(parameterName, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 718 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setRowId(String parameterName, RowId x) throws SQLException
/*     */   {
/* 724 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 727 */       statement.setRowId(parameterName, x);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 731 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException
/*     */   {
/* 737 */     CallableStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 740 */       statement.setSQLXML(parameterName, xmlObject);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 744 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.jdk6.WrappedCallableStatementJDK6
 * JD-Core Version:    0.6.0
 */