/*     */ package org.jboss.resource.adapter.jdbc;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLWarning;
/*     */ import java.sql.Statement;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class WrappedStatement extends JBossWrapper
/*     */   implements Statement, StatementAccess, org.jboss.ejb.plugins.cmp.jdbc.WrappedStatement
/*     */ {
/*     */   private final WrappedConnection lc;
/*     */   private final Statement s;
/*     */   private HashMap<WrappedResultSet, Throwable> resultSets;
/*  52 */   private boolean closed = false;
/*     */ 
/*  55 */   private Object lock = new Object();
/*     */ 
/*     */   public WrappedStatement(WrappedConnection lc, Statement s)
/*     */   {
/*  59 */     this.lc = lc;
/*  60 */     this.s = s;
/*  61 */     lc.registerStatement(this);
/*     */   }
/*     */ 
/*     */   public void close() throws SQLException
/*     */   {
/*  66 */     synchronized (this.lock)
/*     */     {
/*  68 */       if (this.closed) {
/*  69 */         return;
/*     */       }
/*  71 */       this.closed = true;
/*     */     }
/*  73 */     this.lc.unregisterStatement(this);
/*  74 */     internalClose();
/*     */   }
/*     */ 
/*     */   public boolean execute(String sql) throws SQLException
/*     */   {
/*  79 */     checkTransaction();
/*     */     try
/*     */     {
/*  82 */       checkConfiguredQueryTimeout();
/*  83 */       return this.s.execute(sql);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/*  87 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public boolean execute(String sql, int autoGeneratedKeys)
/*     */     throws SQLException
/*     */   {
/*  93 */     checkTransaction();
/*     */     try
/*     */     {
/*  96 */       checkConfiguredQueryTimeout();
/*  97 */       return this.s.execute(sql, autoGeneratedKeys);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 101 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public boolean execute(String sql, int[] columnIndexes)
/*     */     throws SQLException
/*     */   {
/* 107 */     checkTransaction();
/*     */     try
/*     */     {
/* 110 */       checkConfiguredQueryTimeout();
/* 111 */       return this.s.execute(sql, columnIndexes);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 115 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public boolean execute(String sql, String[] columnNames)
/*     */     throws SQLException
/*     */   {
/* 121 */     checkTransaction();
/*     */     try
/*     */     {
/* 124 */       checkConfiguredQueryTimeout();
/* 125 */       return this.s.execute(sql, columnNames);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 129 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public Connection getConnection()
/*     */     throws SQLException
/*     */   {
/* 135 */     return this.lc;
/*     */   }
/*     */ 
/*     */   public SQLWarning getWarnings() throws SQLException
/*     */   {
/* 140 */     checkState();
/*     */     try
/*     */     {
/* 143 */       return this.s.getWarnings();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 147 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void clearWarnings()
/*     */     throws SQLException
/*     */   {
/* 153 */     checkState();
/*     */     try
/*     */     {
/* 156 */       this.s.clearWarnings();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 160 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public ResultSet executeQuery(String sql) throws SQLException
/*     */   {
/* 166 */     checkTransaction();
/*     */     try
/*     */     {
/* 169 */       checkConfiguredQueryTimeout();
/* 170 */       ResultSet result = this.s.executeQuery(sql);
/* 171 */       return registerResultSet(result);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 175 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String sql)
/*     */     throws SQLException
/*     */   {
/* 181 */     checkTransaction();
/*     */     try
/*     */     {
/* 184 */       checkConfiguredQueryTimeout();
/* 185 */       return this.s.executeUpdate(sql);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 189 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String sql, int autoGeneratedKeys)
/*     */     throws SQLException
/*     */   {
/* 195 */     checkTransaction();
/*     */     try
/*     */     {
/* 198 */       checkConfiguredQueryTimeout();
/* 199 */       return this.s.executeUpdate(sql, autoGeneratedKeys);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 203 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String sql, int[] columnIndexes)
/*     */     throws SQLException
/*     */   {
/* 209 */     checkTransaction();
/*     */     try
/*     */     {
/* 212 */       checkConfiguredQueryTimeout();
/* 213 */       return this.s.executeUpdate(sql, columnIndexes);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 217 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String sql, String[] columnNames)
/*     */     throws SQLException
/*     */   {
/* 223 */     checkTransaction();
/*     */     try
/*     */     {
/* 226 */       checkConfiguredQueryTimeout();
/* 227 */       return this.s.executeUpdate(sql, columnNames);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 231 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public int getMaxFieldSize()
/*     */     throws SQLException
/*     */   {
/* 237 */     checkState();
/*     */     try
/*     */     {
/* 240 */       return this.s.getMaxFieldSize();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 244 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void setMaxFieldSize(int max)
/*     */     throws SQLException
/*     */   {
/* 250 */     checkState();
/*     */     try
/*     */     {
/* 253 */       this.s.setMaxFieldSize(max);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 257 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getMaxRows() throws SQLException
/*     */   {
/* 263 */     checkState();
/*     */     try
/*     */     {
/* 266 */       return this.s.getMaxRows();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 270 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void setMaxRows(int max)
/*     */     throws SQLException
/*     */   {
/* 276 */     checkState();
/*     */     try
/*     */     {
/* 279 */       this.s.setMaxRows(max);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 283 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setEscapeProcessing(boolean enable) throws SQLException
/*     */   {
/* 289 */     checkState();
/*     */     try
/*     */     {
/* 292 */       this.s.setEscapeProcessing(enable);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 296 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getQueryTimeout() throws SQLException
/*     */   {
/* 302 */     checkState();
/*     */     try
/*     */     {
/* 305 */       return this.s.getQueryTimeout();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 309 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void setQueryTimeout(int timeout)
/*     */     throws SQLException
/*     */   {
/* 315 */     checkState();
/*     */     try
/*     */     {
/* 318 */       this.s.setQueryTimeout(timeout);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 322 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void cancel() throws SQLException
/*     */   {
/* 328 */     checkState();
/*     */     try
/*     */     {
/* 331 */       this.s.cancel();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 335 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setCursorName(String name) throws SQLException
/*     */   {
/* 341 */     checkState();
/*     */     try
/*     */     {
/* 344 */       this.s.setCursorName(name);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 348 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public ResultSet getResultSet() throws SQLException
/*     */   {
/* 354 */     checkState();
/*     */     try
/*     */     {
/* 357 */       ResultSet result = this.s.getResultSet();
/* 358 */       if (result == null) {
/* 359 */         return null;
/*     */       }
/* 361 */       return registerResultSet(result);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 365 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public int getUpdateCount()
/*     */     throws SQLException
/*     */   {
/* 371 */     checkState();
/*     */     try
/*     */     {
/* 374 */       return this.s.getUpdateCount();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 378 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public boolean getMoreResults()
/*     */     throws SQLException
/*     */   {
/* 384 */     checkState();
/*     */     try
/*     */     {
/* 387 */       return this.s.getMoreResults();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 391 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public boolean getMoreResults(int current)
/*     */     throws SQLException
/*     */   {
/* 397 */     checkState();
/*     */     try
/*     */     {
/* 400 */       return this.s.getMoreResults(current);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 404 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void setFetchDirection(int direction)
/*     */     throws SQLException
/*     */   {
/* 410 */     checkState();
/*     */     try
/*     */     {
/* 413 */       this.s.setFetchDirection(direction);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 417 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getFetchDirection() throws SQLException
/*     */   {
/* 423 */     checkState();
/*     */     try
/*     */     {
/* 426 */       return this.s.getFetchDirection();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 430 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void setFetchSize(int rows)
/*     */     throws SQLException
/*     */   {
/* 436 */     checkState();
/*     */     try
/*     */     {
/* 439 */       this.s.setFetchSize(rows);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 443 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getFetchSize() throws SQLException
/*     */   {
/* 449 */     checkState();
/*     */     try
/*     */     {
/* 452 */       return this.s.getFetchSize();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 456 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public int getResultSetConcurrency()
/*     */     throws SQLException
/*     */   {
/* 462 */     checkState();
/*     */     try
/*     */     {
/* 465 */       return this.s.getResultSetConcurrency();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 469 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public int getResultSetType()
/*     */     throws SQLException
/*     */   {
/* 475 */     checkState();
/*     */     try
/*     */     {
/* 478 */       return this.s.getResultSetType();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 482 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void addBatch(String sql)
/*     */     throws SQLException
/*     */   {
/* 488 */     checkState();
/*     */     try
/*     */     {
/* 491 */       this.s.addBatch(sql);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 495 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void clearBatch() throws SQLException
/*     */   {
/* 501 */     checkState();
/*     */     try
/*     */     {
/* 504 */       this.s.clearBatch();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 508 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int[] executeBatch() throws SQLException
/*     */   {
/* 514 */     checkState();
/*     */     try
/*     */     {
/* 517 */       checkConfiguredQueryTimeout();
/* 518 */       return this.s.executeBatch();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 522 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public ResultSet getGeneratedKeys()
/*     */     throws SQLException
/*     */   {
/* 528 */     checkState();
/*     */     try
/*     */     {
/* 531 */       ResultSet resultSet = this.s.getGeneratedKeys();
/* 532 */       return registerResultSet(resultSet);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 536 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public int getResultSetHoldability()
/*     */     throws SQLException
/*     */   {
/* 542 */     checkState();
/*     */     try
/*     */     {
/* 545 */       return this.s.getResultSetHoldability();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 549 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public Statement getUnderlyingStatement()
/*     */     throws SQLException
/*     */   {
/* 555 */     checkState();
/* 556 */     return this.s;
/*     */   }
/*     */ 
/*     */   protected Statement getWrappedObject() throws SQLException
/*     */   {
/* 561 */     return this.s;
/*     */   }
/*     */ 
/*     */   protected SQLException checkException(Throwable t)
/*     */     throws SQLException
/*     */   {
/* 567 */     throw this.lc.checkException(t);
/*     */   }
/*     */ 
/*     */   protected void checkTransaction()
/*     */     throws SQLException
/*     */   {
/* 573 */     checkState();
/* 574 */     this.lc.checkTransaction();
/*     */   }
/*     */ 
/*     */   protected void checkConfiguredQueryTimeout() throws SQLException
/*     */   {
/* 579 */     this.lc.checkConfiguredQueryTimeout(this);
/*     */   }
/*     */ 
/*     */   protected void internalClose() throws SQLException
/*     */   {
/* 584 */     synchronized (this.lock)
/*     */     {
/* 586 */       this.closed = true;
/*     */     }
/*     */     try
/*     */     {
/* 590 */       closeResultSets();
/*     */     }
/*     */     finally
/*     */     {
/* 594 */       this.s.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   void checkState() throws SQLException
/*     */   {
/* 600 */     synchronized (this.lock)
/*     */     {
/* 602 */       if (this.closed)
/* 603 */         throw new SQLException("The statement is closed.");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract WrappedResultSet wrapResultSet(ResultSet paramResultSet);
/*     */ 
/*     */   protected ResultSet registerResultSet(ResultSet resultSet) {
/* 611 */     if (resultSet != null) {
/* 612 */       resultSet = wrapResultSet(resultSet);
/*     */     }
/* 614 */     if (this.lc.getTrackStatements() == 0) {
/* 615 */       return resultSet;
/*     */     }
/* 617 */     WrappedResultSet wrapped = (WrappedResultSet)resultSet;
/*     */ 
/* 619 */     synchronized (this)
/*     */     {
/* 621 */       if (this.resultSets == null) {
/* 622 */         this.resultSets = new HashMap();
/*     */       }
/* 624 */       if (this.lc.getTrackStatements() == 1)
/* 625 */         this.resultSets.put(wrapped, new Throwable("STACKTRACE"));
/*     */       else
/* 627 */         this.resultSets.put(wrapped, null);
/*     */     }
/* 629 */     return resultSet;
/*     */   }
/*     */ 
/*     */   protected void unregisterResultSet(WrappedResultSet resultSet)
/*     */   {
/* 634 */     if (this.lc.getTrackStatements() == 0) {
/* 635 */       return;
/*     */     }
/* 637 */     synchronized (this)
/*     */     {
/* 639 */       if (this.resultSets != null)
/* 640 */         this.resultSets.remove(resultSet);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void closeResultSets()
/*     */   {
/* 646 */     if (this.lc.getTrackStatements() == 0) {
/* 647 */       return;
/*     */     }
/* 649 */     synchronized (this)
/*     */     {
/* 651 */       if (this.resultSets == null)
/* 652 */         return;
/* 653 */       for (Iterator i = this.resultSets.entrySet().iterator(); i.hasNext(); )
/*     */       {
/* 655 */         Map.Entry entry = (Map.Entry)i.next();
/* 656 */         WrappedResultSet resultSet = (WrappedResultSet)entry.getKey();
/* 657 */         if (this.lc.getTrackStatements() == 1)
/*     */         {
/* 659 */           Throwable stackTrace = (Throwable)entry.getValue();
/* 660 */           this.lc.getLogger().warn("Closing a result set you left open! Please close it yourself.", stackTrace);
/*     */         }
/*     */         try
/*     */         {
/* 664 */           resultSet.internalClose();
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 668 */           this.lc.getLogger().warn("Error closing a result set you left open! Please close it yourself.", t);
/*     */         }
/*     */       }
/* 671 */       this.resultSets.clear();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.WrappedStatement
 * JD-Core Version:    0.6.0
 */