/*     */ package org.jboss.resource.adapter.jdbc;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.math.BigDecimal;
/*     */ import java.net.URL;
/*     */ import java.sql.Array;
/*     */ import java.sql.Blob;
/*     */ import java.sql.Clob;
/*     */ import java.sql.Date;
/*     */ import java.sql.ParameterMetaData;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.Ref;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.ResultSetMetaData;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Calendar;
/*     */ 
/*     */ public abstract class WrappedPreparedStatement extends WrappedStatement
/*     */   implements PreparedStatement
/*     */ {
/*     */   private final PreparedStatement ps;
/*     */ 
/*     */   public WrappedPreparedStatement(WrappedConnection lc, PreparedStatement ps)
/*     */   {
/*  55 */     super(lc, ps);
/*  56 */     this.ps = ps;
/*     */   }
/*     */ 
/*     */   public PreparedStatement getUnderlyingStatement() throws SQLException
/*     */   {
/*  61 */     checkState();
/*  62 */     if ((this.ps instanceof CachedPreparedStatement))
/*     */     {
/*  64 */       return ((CachedPreparedStatement)this.ps).getUnderlyingPreparedStatement();
/*     */     }
/*     */ 
/*  68 */     return this.ps;
/*     */   }
/*     */ 
/*     */   public void setBoolean(int parameterIndex, boolean value)
/*     */     throws SQLException
/*     */   {
/*  74 */     checkState();
/*     */     try
/*     */     {
/*  77 */       this.ps.setBoolean(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  81 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setByte(int parameterIndex, byte value) throws SQLException
/*     */   {
/*  87 */     checkState();
/*     */     try
/*     */     {
/*  90 */       this.ps.setByte(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  94 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setShort(int parameterIndex, short value) throws SQLException
/*     */   {
/* 100 */     checkState();
/*     */     try
/*     */     {
/* 103 */       this.ps.setShort(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 107 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setInt(int parameterIndex, int value) throws SQLException
/*     */   {
/* 113 */     checkState();
/*     */     try
/*     */     {
/* 116 */       this.ps.setInt(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 120 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setLong(int parameterIndex, long value) throws SQLException
/*     */   {
/* 126 */     checkState();
/*     */     try
/*     */     {
/* 129 */       this.ps.setLong(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 133 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setFloat(int parameterIndex, float value) throws SQLException
/*     */   {
/* 139 */     checkState();
/*     */     try
/*     */     {
/* 142 */       this.ps.setFloat(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 146 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setDouble(int parameterIndex, double value) throws SQLException
/*     */   {
/* 152 */     checkState();
/*     */     try
/*     */     {
/* 155 */       this.ps.setDouble(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 159 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setURL(int parameterIndex, URL value) throws SQLException
/*     */   {
/* 165 */     checkState();
/*     */     try
/*     */     {
/* 168 */       this.ps.setURL(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 172 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setTime(int parameterIndex, Time value) throws SQLException
/*     */   {
/* 178 */     checkState();
/*     */     try
/*     */     {
/* 181 */       this.ps.setTime(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 185 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setTime(int parameterIndex, Time value, Calendar calendar) throws SQLException
/*     */   {
/* 191 */     checkState();
/*     */     try
/*     */     {
/* 194 */       this.ps.setTime(parameterIndex, value, calendar);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 198 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean execute() throws SQLException
/*     */   {
/* 204 */     checkTransaction();
/*     */     try
/*     */     {
/* 207 */       checkConfiguredQueryTimeout();
/* 208 */       return this.ps.execute();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 212 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public ResultSetMetaData getMetaData()
/*     */     throws SQLException
/*     */   {
/* 218 */     checkState();
/*     */     try
/*     */     {
/* 221 */       return this.ps.getMetaData();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 225 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public ResultSet executeQuery()
/*     */     throws SQLException
/*     */   {
/* 231 */     checkTransaction();
/*     */     try
/*     */     {
/* 234 */       checkConfiguredQueryTimeout();
/* 235 */       ResultSet resultSet = this.ps.executeQuery();
/* 236 */       return registerResultSet(resultSet);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 240 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public int executeUpdate()
/*     */     throws SQLException
/*     */   {
/* 246 */     checkTransaction();
/*     */     try
/*     */     {
/* 249 */       checkConfiguredQueryTimeout();
/* 250 */       return this.ps.executeUpdate();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 254 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void addBatch()
/*     */     throws SQLException
/*     */   {
/* 260 */     checkState();
/*     */     try
/*     */     {
/* 263 */       this.ps.addBatch();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 267 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNull(int parameterIndex, int sqlType) throws SQLException
/*     */   {
/* 273 */     checkState();
/*     */     try
/*     */     {
/* 276 */       this.ps.setNull(parameterIndex, sqlType);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 280 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException
/*     */   {
/* 286 */     checkState();
/*     */     try
/*     */     {
/* 289 */       this.ps.setNull(parameterIndex, sqlType, typeName);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 293 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException
/*     */   {
/* 299 */     checkState();
/*     */     try
/*     */     {
/* 302 */       this.ps.setBigDecimal(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 306 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setString(int parameterIndex, String value) throws SQLException
/*     */   {
/* 312 */     checkState();
/*     */     try
/*     */     {
/* 315 */       this.ps.setString(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 319 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBytes(int parameterIndex, byte[] value) throws SQLException
/*     */   {
/* 325 */     checkState();
/*     */     try
/*     */     {
/* 328 */       this.ps.setBytes(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 332 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setDate(int parameterIndex, Date value) throws SQLException
/*     */   {
/* 338 */     checkState();
/*     */     try
/*     */     {
/* 341 */       this.ps.setDate(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 345 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setDate(int parameterIndex, Date value, Calendar calendar) throws SQLException
/*     */   {
/* 351 */     checkState();
/*     */     try
/*     */     {
/* 354 */       this.ps.setDate(parameterIndex, value, calendar);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 358 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException
/*     */   {
/* 364 */     checkState();
/*     */     try
/*     */     {
/* 367 */       this.ps.setTimestamp(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 371 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setTimestamp(int parameterIndex, Timestamp value, Calendar calendar) throws SQLException
/*     */   {
/* 377 */     checkState();
/*     */     try
/*     */     {
/* 380 */       this.ps.setTimestamp(parameterIndex, value, calendar);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 384 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public void setAsciiStream(int parameterIndex, InputStream stream, int length) throws SQLException {
/* 391 */     checkState();
/*     */     try
/*     */     {
/* 394 */       this.ps.setAsciiStream(parameterIndex, stream, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 398 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public void setUnicodeStream(int parameterIndex, InputStream stream, int length) throws SQLException {
/* 405 */     checkState();
/*     */     try
/*     */     {
/* 408 */       this.ps.setUnicodeStream(parameterIndex, stream, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 412 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBinaryStream(int parameterIndex, InputStream stream, int length) throws SQLException
/*     */   {
/* 418 */     checkState();
/*     */     try
/*     */     {
/* 421 */       this.ps.setBinaryStream(parameterIndex, stream, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 425 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void clearParameters() throws SQLException
/*     */   {
/* 431 */     checkState();
/*     */     try
/*     */     {
/* 434 */       this.ps.clearParameters();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 438 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setObject(int parameterIndex, Object value, int sqlType, int scale) throws SQLException
/*     */   {
/* 444 */     checkState();
/*     */     try
/*     */     {
/* 447 */       this.ps.setObject(parameterIndex, value, sqlType, scale);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 451 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setObject(int parameterIndex, Object value, int sqlType) throws SQLException
/*     */   {
/* 457 */     checkState();
/*     */     try
/*     */     {
/* 460 */       this.ps.setObject(parameterIndex, value, sqlType);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 464 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setObject(int parameterIndex, Object value) throws SQLException
/*     */   {
/* 470 */     checkState();
/*     */     try
/*     */     {
/* 473 */       this.ps.setObject(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 477 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException
/*     */   {
/* 483 */     checkState();
/*     */     try
/*     */     {
/* 486 */       this.ps.setCharacterStream(parameterIndex, reader, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 490 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setRef(int parameterIndex, Ref value) throws SQLException
/*     */   {
/* 496 */     checkState();
/*     */     try
/*     */     {
/* 499 */       this.ps.setRef(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 503 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBlob(int parameterIndex, Blob value) throws SQLException
/*     */   {
/* 509 */     checkState();
/*     */     try
/*     */     {
/* 512 */       this.ps.setBlob(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 516 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setClob(int parameterIndex, Clob value) throws SQLException
/*     */   {
/* 522 */     checkState();
/*     */     try
/*     */     {
/* 525 */       this.ps.setClob(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 529 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setArray(int parameterIndex, Array value) throws SQLException
/*     */   {
/* 535 */     checkState();
/*     */     try
/*     */     {
/* 538 */       this.ps.setArray(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 542 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public ParameterMetaData getParameterMetaData() throws SQLException
/*     */   {
/* 548 */     checkState();
/*     */     try
/*     */     {
/* 551 */       return this.ps.getParameterMetaData();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 555 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   protected PreparedStatement getWrappedObject()
/*     */     throws SQLException
/*     */   {
/* 561 */     return this.ps;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.WrappedPreparedStatement
 * JD-Core Version:    0.6.0
 */