/*     */ package org.jboss.resource.adapter.jdbc;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ConnectionManager;
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import javax.resource.spi.ManagedConnectionFactory;
/*     */ import javax.resource.spi.ValidatingManagedConnectionFactory;
/*     */ import javax.resource.spi.security.PasswordCredential;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.JBossResourceException;
/*     */ 
/*     */ public abstract class BaseWrapperManagedConnectionFactory
/*     */   implements ManagedConnectionFactory, ValidatingManagedConnectionFactory, Serializable
/*     */ {
/*     */   static final long serialVersionUID = -84923705377702088L;
/*     */   public static final int TRACK_STATEMENTS_FALSE_INT = 0;
/*     */   public static final int TRACK_STATEMENTS_TRUE_INT = 1;
/*     */   public static final int TRACK_STATEMENTS_NOWARN_INT = 2;
/*     */   public static final String TRACK_STATEMENTS_FALSE = "false";
/*     */   public static final String TRACK_STATEMENTS_TRUE = "true";
/*     */   public static final String TRACK_STATEMENTS_NOWARN = "nowarn";
/*  73 */   protected final Logger log = Logger.getLogger(getClass());
/*     */   protected String userName;
/*     */   protected String password;
/*  81 */   protected final Properties connectionProps = new Properties();
/*     */ 
/*  83 */   protected int transactionIsolation = -1;
/*     */ 
/*  85 */   protected int preparedStatementCacheSize = 0;
/*     */ 
/*  87 */   protected boolean doQueryTimeout = false;
/*     */   protected String newConnectionSQL;
/*     */   protected String checkValidConnectionSQL;
/*     */   protected String validConnectionCheckerClassName;
/*     */   protected ValidConnectionChecker connectionChecker;
/*     */   protected StaleConnectionChecker staleConnectionChecker;
/*     */   private String staleConnectionCheckerClassName;
/*     */   private String exceptionSorterClassName;
/*     */   private ExceptionSorter exceptionSorter;
/* 125 */   protected int trackStatements = 2;
/*     */ 
/* 128 */   protected boolean sharePS = false;
/*     */ 
/* 130 */   protected boolean isTransactionQueryTimeout = false;
/*     */ 
/* 132 */   protected int queryTimeout = 0;
/*     */   protected String urlDelimiter;
/*     */   protected String urlSelectorStrategyClassName;
/*     */   private URLSelectorStrategy urlSelectorStrategy;
/* 144 */   private boolean validateOnMatch = true;
/*     */ 
/*     */   public PrintWriter getLogWriter()
/*     */     throws ResourceException
/*     */   {
/* 153 */     return null;
/*     */   }
/*     */ 
/*     */   public void setLogWriter(PrintWriter param1) throws ResourceException
/*     */   {
/*     */   }
/*     */ 
/*     */   public Object createConnectionFactory(ConnectionManager cm) throws ResourceException
/*     */   {
/* 162 */     return new WrapperDataSource(this, cm);
/*     */   }
/*     */ 
/*     */   public Object createConnectionFactory() throws ResourceException
/*     */   {
/* 167 */     throw new JBossResourceException("Resource Adapter does not currently support running in a non-managed environment.");
/*     */   }
/*     */ 
/*     */   public String getUserName()
/*     */   {
/* 172 */     return this.userName;
/*     */   }
/*     */ 
/*     */   public void setUserName(String userName)
/*     */   {
/* 177 */     this.userName = userName;
/*     */   }
/*     */ 
/*     */   public String getPassword()
/*     */   {
/* 182 */     return this.password;
/*     */   }
/*     */ 
/*     */   public void setPassword(String password)
/*     */   {
/* 187 */     this.password = password;
/*     */   }
/*     */ 
/*     */   public int getPreparedStatementCacheSize()
/*     */   {
/* 192 */     return this.preparedStatementCacheSize;
/*     */   }
/*     */ 
/*     */   public void setPreparedStatementCacheSize(int size)
/*     */   {
/* 197 */     this.preparedStatementCacheSize = size;
/*     */   }
/*     */ 
/*     */   public boolean getSharePreparedStatements()
/*     */   {
/* 202 */     return this.sharePS;
/*     */   }
/*     */ 
/*     */   public void setSharePreparedStatements(boolean sharePS)
/*     */   {
/* 207 */     this.sharePS = sharePS;
/*     */   }
/*     */ 
/*     */   public String getTransactionIsolation()
/*     */   {
/* 212 */     switch (this.transactionIsolation)
/*     */     {
/*     */     case 0:
/* 215 */       return "TRANSACTION_NONE";
/*     */     case 2:
/* 217 */       return "TRANSACTION_READ_COMMITTED";
/*     */     case 1:
/* 219 */       return "TRANSACTION_READ_UNCOMMITTED";
/*     */     case 4:
/* 221 */       return "TRANSACTION_REPEATABLE_READ";
/*     */     case 8:
/* 223 */       return "TRANSACTION_SERIALIZABLE";
/*     */     case -1:
/* 225 */       return "DEFAULT";
/*     */     case 3:
/*     */     case 5:
/*     */     case 6:
/* 227 */     case 7: } return Integer.toString(this.transactionIsolation);
/*     */   }
/*     */ 
/*     */   public void setTransactionIsolation(String transactionIsolation)
/*     */   {
/* 233 */     if (transactionIsolation.equals("TRANSACTION_NONE"))
/* 234 */       this.transactionIsolation = 0;
/* 235 */     else if (transactionIsolation.equals("TRANSACTION_READ_COMMITTED"))
/* 236 */       this.transactionIsolation = 2;
/* 237 */     else if (transactionIsolation.equals("TRANSACTION_READ_UNCOMMITTED"))
/* 238 */       this.transactionIsolation = 1;
/* 239 */     else if (transactionIsolation.equals("TRANSACTION_REPEATABLE_READ"))
/* 240 */       this.transactionIsolation = 4;
/* 241 */     else if (transactionIsolation.equals("TRANSACTION_SERIALIZABLE")) {
/* 242 */       this.transactionIsolation = 8;
/*     */     }
/*     */     else
/*     */       try
/*     */       {
/* 247 */         this.transactionIsolation = Integer.parseInt(transactionIsolation);
/*     */       }
/*     */       catch (NumberFormatException nfe)
/*     */       {
/* 251 */         throw new IllegalArgumentException("Setting Isolation level to unknown state: " + transactionIsolation);
/*     */       }
/*     */   }
/*     */ 
/*     */   public String getNewConnectionSQL()
/*     */   {
/* 258 */     return this.newConnectionSQL;
/*     */   }
/*     */ 
/*     */   public void setNewConnectionSQL(String newConnectionSQL)
/*     */   {
/* 263 */     this.newConnectionSQL = newConnectionSQL;
/*     */   }
/*     */ 
/*     */   public String getCheckValidConnectionSQL()
/*     */   {
/* 268 */     return this.checkValidConnectionSQL;
/*     */   }
/*     */ 
/*     */   public void setCheckValidConnectionSQL(String checkValidConnectionSQL)
/*     */   {
/* 273 */     this.checkValidConnectionSQL = checkValidConnectionSQL;
/*     */   }
/*     */ 
/*     */   public void setStaleConnectionCheckerClassName(String value)
/*     */   {
/* 278 */     this.staleConnectionCheckerClassName = value;
/*     */   }
/*     */ 
/*     */   public String getStaleConnectionCheckerClassName()
/*     */   {
/* 284 */     return this.staleConnectionCheckerClassName;
/*     */   }
/*     */ 
/*     */   public String getTrackStatements()
/*     */   {
/* 290 */     if (this.trackStatements == 0)
/* 291 */       return "false";
/* 292 */     if (this.trackStatements == 1)
/* 293 */       return "true";
/* 294 */     return "nowarn";
/*     */   }
/*     */ 
/*     */   public boolean getValidateOnMatch()
/*     */   {
/* 299 */     return this.validateOnMatch;
/*     */   }
/*     */ 
/*     */   public void setValidateOnMatch(boolean validateOnMatch)
/*     */   {
/* 304 */     this.validateOnMatch = validateOnMatch;
/*     */   }
/*     */ 
/*     */   public void setTrackStatements(String value)
/*     */   {
/* 309 */     if (value == null)
/* 310 */       throw new IllegalArgumentException("Null value for trackStatements");
/* 311 */     String trimmed = value.trim();
/* 312 */     if (trimmed.equalsIgnoreCase("false"))
/* 313 */       this.trackStatements = 0;
/* 314 */     else if (trimmed.equalsIgnoreCase("true"))
/* 315 */       this.trackStatements = 1;
/*     */     else
/* 317 */       this.trackStatements = 2;
/*     */   }
/*     */ 
/*     */   public String getExceptionSorterClassName()
/*     */   {
/* 322 */     return this.exceptionSorterClassName;
/*     */   }
/*     */ 
/*     */   public void setExceptionSorterClassName(String exceptionSorterClassName)
/*     */   {
/* 327 */     this.exceptionSorterClassName = exceptionSorterClassName;
/*     */   }
/*     */ 
/*     */   public String getValidConnectionCheckerClassName()
/*     */   {
/* 332 */     return this.validConnectionCheckerClassName;
/*     */   }
/*     */ 
/*     */   public void setValidConnectionCheckerClassName(String value)
/*     */   {
/* 337 */     this.validConnectionCheckerClassName = value;
/*     */   }
/*     */ 
/*     */   public boolean isTransactionQueryTimeout()
/*     */   {
/* 342 */     return this.isTransactionQueryTimeout;
/*     */   }
/*     */ 
/*     */   public void setTransactionQueryTimeout(boolean value)
/*     */   {
/* 347 */     this.isTransactionQueryTimeout = value;
/*     */   }
/*     */ 
/*     */   public int getQueryTimeout()
/*     */   {
/* 352 */     return this.queryTimeout;
/*     */   }
/*     */ 
/*     */   public void setQueryTimeout(int timeout)
/*     */   {
/* 357 */     this.queryTimeout = timeout;
/*     */   }
/*     */ 
/*     */   public String getURLDelimiter()
/*     */   {
/* 367 */     return this.urlDelimiter;
/*     */   }
/*     */ 
/*     */   public void setURLDelimiter(String urlDelimiter)
/*     */     throws ResourceException
/*     */   {
/* 373 */     this.urlDelimiter = urlDelimiter;
/*     */   }
/*     */ 
/*     */   public void setUrlSelectorStrategyClassName(String urlSelectorStrategyClassName)
/*     */   {
/* 378 */     this.urlSelectorStrategyClassName = urlSelectorStrategyClassName;
/*     */   }
/*     */ 
/*     */   public String getUrlSelectorStrategyClassName()
/*     */   {
/* 383 */     return this.urlSelectorStrategyClassName;
/*     */   }
/*     */ 
/*     */   public URLSelectorStrategy getUrlSelectorStrategy()
/*     */   {
/* 388 */     return this.urlSelectorStrategy;
/*     */   }
/*     */ 
/*     */   public Object loadClass(String className, Object constructorParameter)
/*     */   {
/* 395 */     Object result = null;
/*     */     try
/*     */     {
/* 398 */       Class clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
/* 399 */       Class[] param = { List.class };
/* 400 */       Constructor cnstructor = clazz.getDeclaredConstructor(param);
/* 401 */       Object[] consParameter = { constructorParameter };
/* 402 */       result = cnstructor.newInstance(consParameter);
/*     */     }
/*     */     catch (ClassNotFoundException cnfe)
/*     */     {
/* 406 */       this.log.error("Class not found for URLSelectStrategy :" + className);
/*     */     }
/*     */     catch (InstantiationException ie)
/*     */     {
/* 411 */       this.log.error("Could not instantiate URLSelectorStrategy type :" + className);
/*     */     }
/*     */     catch (IllegalAccessException iae)
/*     */     {
/* 416 */       this.log.error("Check for the constructor with List parameter for URLSelectStrategy class as " + className);
/*     */     }
/*     */     catch (InvocationTargetException ite)
/*     */     {
/* 422 */       this.log.error("Constructor Invocation failing for URLSelectorStrategy " + className);
/*     */     }
/*     */     catch (NoSuchMethodException nsme)
/*     */     {
/* 427 */       this.log.error("Constructor or Method mismatch in URLSelectorStrategy :" + className);
/*     */     }
/*     */ 
/* 431 */     return result;
/*     */   }
/*     */ 
/*     */   public Set getInvalidConnections(Set connectionSet) throws ResourceException
/*     */   {
/* 436 */     Set invalid = new HashSet();
/*     */ 
/* 438 */     for (Iterator iter = connectionSet.iterator(); iter.hasNext(); )
/*     */     {
/* 440 */       Object anonymous = iter.next();
/*     */ 
/* 442 */       if ((anonymous instanceof BaseWrapperManagedConnection))
/*     */       {
/* 444 */         BaseWrapperManagedConnection mc = (BaseWrapperManagedConnection)anonymous;
/*     */ 
/* 446 */         if (!mc.checkValid())
/*     */         {
/* 448 */           invalid.add(mc);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 456 */     return invalid;
/*     */   }
/*     */ 
/*     */   protected Properties getConnectionProperties(Subject subject, ConnectionRequestInfo cri)
/*     */     throws ResourceException
/*     */   {
/* 473 */     if ((cri != null) && (cri.getClass() != WrappedConnectionRequestInfo.class)) {
/* 474 */       throw new JBossResourceException("Wrong kind of ConnectionRequestInfo: " + cri.getClass());
/*     */     }
/* 476 */     Properties props = new Properties();
/* 477 */     props.putAll(this.connectionProps);
/* 478 */     if (subject != null)
/*     */     {
/* 480 */       if (SubjectActions.addMatchingProperties(subject, props, this) == true)
/* 481 */         return props;
/* 482 */       throw new JBossResourceException("No matching credentials in Subject!");
/*     */     }
/* 484 */     WrappedConnectionRequestInfo lcri = (WrappedConnectionRequestInfo)cri;
/* 485 */     if (lcri != null)
/*     */     {
/* 487 */       props.setProperty("user", lcri.getUserName() == null ? "" : lcri.getUserName());
/* 488 */       props.setProperty("password", lcri.getPassword() == null ? "" : lcri.getPassword());
/* 489 */       return props;
/*     */     }
/* 491 */     if (this.userName != null)
/*     */     {
/* 493 */       props.setProperty("user", this.userName);
/* 494 */       props.setProperty("password", this.password == null ? "" : this.password);
/*     */     }
/* 496 */     return props;
/*     */   }
/*     */ 
/*     */   boolean isExceptionFatal(SQLException e)
/*     */   {
/*     */     try
/*     */     {
/* 503 */       if (this.exceptionSorter != null) {
/* 504 */         return this.exceptionSorter.isExceptionFatal(e);
/*     */       }
/* 506 */       if (this.exceptionSorterClassName != null)
/*     */       {
/*     */         try
/*     */         {
/* 510 */           ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 511 */           Class clazz = cl.loadClass(this.exceptionSorterClassName);
/* 512 */           this.exceptionSorter = ((ExceptionSorter)clazz.newInstance());
/* 513 */           return this.exceptionSorter.isExceptionFatal(e);
/*     */         }
/*     */         catch (Exception e2)
/*     */         {
/* 517 */           this.log.warn("exception trying to create exception sorter (disabling):", e2);
/* 518 */           this.exceptionSorter = new NullExceptionSorter();
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 524 */       this.log.warn("Error checking exception fatality: ", t);
/*     */     }
/* 526 */     return false;
/*     */   }
/*     */ 
/*     */   SQLException isValidConnection(Connection c)
/*     */   {
/* 535 */     if (this.connectionChecker != null) {
/* 536 */       return this.connectionChecker.isValidConnection(c);
/*     */     }
/*     */ 
/* 539 */     if (this.validConnectionCheckerClassName != null)
/*     */     {
/*     */       try
/*     */       {
/* 543 */         ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 544 */         Class clazz = cl.loadClass(this.validConnectionCheckerClassName);
/* 545 */         this.connectionChecker = ((ValidConnectionChecker)clazz.newInstance());
/* 546 */         return this.connectionChecker.isValidConnection(c);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 550 */         this.log.warn("Exception trying to create connection checker (disabling):", e);
/* 551 */         this.connectionChecker = new NullValidConnectionChecker();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 556 */     if (this.checkValidConnectionSQL != null)
/*     */     {
/* 558 */       this.connectionChecker = new CheckValidConnectionSQL(this.checkValidConnectionSQL);
/* 559 */       return this.connectionChecker.isValidConnection(c);
/*     */     }
/*     */ 
/* 563 */     return null;
/*     */   }
/*     */ 
/*     */   boolean isStaleConnection(SQLException e)
/*     */   {
/* 568 */     boolean isStale = false;
/*     */ 
/* 570 */     if (this.staleConnectionChecker != null)
/*     */     {
/* 573 */       isStale = this.staleConnectionChecker.isStaleConnection(e);
/*     */     }
/*     */ 
/* 577 */     if (this.staleConnectionCheckerClassName != null)
/*     */     {
/*     */       try
/*     */       {
/* 583 */         ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 584 */         Class clazz = cl.loadClass(this.staleConnectionCheckerClassName);
/* 585 */         this.staleConnectionChecker = ((StaleConnectionChecker)clazz.newInstance());
/* 586 */         isStale = this.staleConnectionChecker.isStaleConnection(e);
/*     */       }
/*     */       catch (Exception ex2)
/*     */       {
/* 590 */         this.log.warn("exception trying to create stale connection checker (disabling)" + this.staleConnectionCheckerClassName, ex2);
/* 591 */         this.staleConnectionChecker = new NullStaleConnectionChecker();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 597 */     return isStale;
/*     */   }
/*     */ 
/*     */   static class SubjectActions
/*     */     implements PrivilegedAction
/*     */   {
/*     */     Subject subject;
/*     */     Properties props;
/*     */     ManagedConnectionFactory mcf;
/*     */ 
/*     */     SubjectActions(Subject subject, Properties props, ManagedConnectionFactory mcf)
/*     */     {
/* 612 */       this.subject = subject;
/* 613 */       this.props = props;
/* 614 */       this.mcf = mcf;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 619 */       Iterator i = this.subject.getPrivateCredentials().iterator();
/* 620 */       while (i.hasNext())
/*     */       {
/* 622 */         Object o = i.next();
/* 623 */         if ((o instanceof PasswordCredential))
/*     */         {
/* 625 */           PasswordCredential cred = (PasswordCredential)o;
/* 626 */           if (cred.getManagedConnectionFactory().equals(this.mcf))
/*     */           {
/* 628 */             this.props.setProperty("user", cred.getUserName() == null ? "" : cred.getUserName());
/* 629 */             if (cred.getPassword() != null)
/* 630 */               this.props.setProperty("password", new String(cred.getPassword()));
/* 631 */             return Boolean.TRUE;
/*     */           }
/*     */         }
/*     */       }
/* 635 */       return Boolean.FALSE;
/*     */     }
/*     */ 
/*     */     static boolean addMatchingProperties(Subject subject, Properties props, ManagedConnectionFactory mcf)
/*     */     {
/* 640 */       SubjectActions action = new SubjectActions(subject, props, mcf);
/* 641 */       Boolean matched = (Boolean)AccessController.doPrivileged(action);
/* 642 */       return matched.booleanValue();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnectionFactory
 * JD-Core Version:    0.6.0
 */