/*     */ package org.jboss.resource;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import javax.resource.ResourceException;
/*     */ import org.jboss.util.NestedThrowable;
/*     */ import org.jboss.util.NestedThrowable.Util;
/*     */ 
/*     */ public class JBossResourceException extends ResourceException
/*     */   implements NestedThrowable
/*     */ {
/*     */   private static final long serialVersionUID = 6614203184612359692L;
/*     */ 
/*     */   public static void rethrowAsResourceException(String message, Throwable t)
/*     */     throws ResourceException
/*     */   {
/*  58 */     if ((t instanceof ResourceException)) {
/*  59 */       throw ((ResourceException)t);
/*     */     }
/*  61 */     throw new JBossResourceException(message, t);
/*     */   }
/*     */ 
/*     */   public JBossResourceException(String msg)
/*     */   {
/*  72 */     super(msg);
/*     */   }
/*     */ 
/*     */   public JBossResourceException(String msg, String code)
/*     */   {
/*  84 */     super(msg, code);
/*     */   }
/*     */ 
/*     */   public JBossResourceException(String msg, String code, Throwable linked)
/*     */   {
/*  97 */     super(msg, code);
/*  98 */     setLinkedException(process(linked));
/*     */   }
/*     */ 
/*     */   public JBossResourceException(String msg, Throwable linked)
/*     */   {
/* 110 */     super(msg);
/* 111 */     setLinkedException(process(linked));
/*     */   }
/*     */ 
/*     */   public JBossResourceException(Throwable linked)
/*     */   {
/* 122 */     this(linked.getMessage(), linked);
/*     */   }
/*     */ 
/*     */   public Throwable getNested()
/*     */   {
/* 132 */     return getLinkedException();
/*     */   }
/*     */ 
/*     */   public Throwable getCause()
/*     */   {
/* 144 */     return getLinkedException();
/*     */   }
/*     */ 
/*     */   public String getMessage()
/*     */   {
/* 154 */     return NestedThrowable.Util.getMessage(super.getMessage(), getLinkedException());
/*     */   }
/*     */ 
/*     */   public void printStackTrace(PrintStream stream)
/*     */   {
/* 165 */     Exception linked = getLinkedException();
/* 166 */     if ((linked == null) || (NestedThrowable.PARENT_TRACE_ENABLED))
/*     */     {
/* 168 */       super.printStackTrace(stream);
/*     */     }
/* 170 */     NestedThrowable.Util.print(linked, stream);
/*     */   }
/*     */ 
/*     */   public void printStackTrace(PrintWriter writer)
/*     */   {
/* 181 */     Exception linked = getLinkedException();
/* 182 */     if ((linked == null) || (NestedThrowable.PARENT_TRACE_ENABLED))
/*     */     {
/* 184 */       super.printStackTrace(writer);
/*     */     }
/* 186 */     NestedThrowable.Util.print(linked, writer);
/*     */   }
/*     */ 
/*     */   public void printStackTrace()
/*     */   {
/* 195 */     printStackTrace(System.err);
/*     */   }
/*     */ 
/*     */   private Exception process(Throwable t)
/*     */   {
/* 200 */     if ((t instanceof Exception))
/*     */     {
/* 202 */       return (Exception)t;
/*     */     }
/* 204 */     return new UndeclaredThrowableException(t);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.JBossResourceException
 * JD-Core Version:    0.6.0
 */