/*    */ package org.jboss.remoting.util;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.Iterator;
/*    */ import java.util.Timer;
/*    */ import java.util.TimerTask;
/*    */ import org.apache.log4j.Logger;
/*    */ 
/*    */ public class TimerUtil
/*    */ {
/* 16 */   private static Timer timer = null;
/* 17 */   private static ArrayList stoppableTasks = new ArrayList();
/* 18 */   private static Logger log = Logger.getLogger(TimerUtil.class);
/*    */ 
/*    */   private static synchronized void init()
/*    */   {
/* 22 */     timer = new Timer(true);
/*    */   }
/*    */ 
/*    */   public static synchronized void schedule(TimerTask task, long period)
/*    */   {
/* 27 */     if (timer == null)
/*    */     {
/* 29 */       init();
/*    */     }
/*    */ 
/* 32 */     if ((task instanceof StoppableTimerTask))
/*    */     {
/* 34 */       stoppableTasks.add(task);
/*    */     }
/*    */ 
/* 38 */     timer.schedule(task, period, period);
/*    */   }
/*    */ 
/*    */   public static synchronized void unschedule(TimerTask task)
/*    */   {
/* 43 */     if (!(task instanceof StoppableTimerTask))
/*    */     {
/* 45 */       log.warn("TimerUtil only remembers StoppableTimerTasks");
/* 46 */       return;
/*    */     }
/*    */ 
/* 49 */     StoppableTimerTask stoppableTask = (StoppableTimerTask)task;
/* 50 */     if (!stoppableTasks.remove(stoppableTask)) {
/* 51 */       log.warn("unrecognized StoppableTimerTask: " + task);
/*    */     }
/*    */     try
/*    */     {
/* 55 */       stoppableTask.stop();
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 59 */       log.warn("error calling stop() on: " + stoppableTask, e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public static synchronized void destroy()
/*    */   {
/* 65 */     if (timer != null)
/*    */     {
/* 67 */       timer.cancel();
/* 68 */       timer = null;
/*    */     }
/*    */ 
/* 71 */     Iterator it = new ArrayList(stoppableTasks).iterator();
/* 72 */     while (it.hasNext())
/*    */     {
/* 74 */       StoppableTimerTask task = (StoppableTimerTask)it.next();
/*    */       try
/*    */       {
/* 77 */         task.stop();
/*    */       }
/*    */       catch (Exception e)
/*    */       {
/* 81 */         log.warn("unable to stop TimerTask: " + task);
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.util.TimerUtil
 * JD-Core Version:    0.6.0
 */