/*     */ package org.jboss.remoting.transporter;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.detection.multicast.MulticastDetector;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class TransporterServer
/*     */ {
/*  45 */   private Connector connector = null;
/*     */ 
/*     */   public TransporterServer(InvokerLocator locator, Object target, String subsystem)
/*     */     throws Exception
/*     */   {
/*  58 */     this.connector = getConnector(locator, null, null);
/*  59 */     ServerInvocationHandler handler = new TransporterHandler(target);
/*  60 */     if (subsystem != null)
/*     */     {
/*  62 */       this.connector.addInvocationHandler(subsystem.toUpperCase(), handler);
/*     */     }
/*     */     else
/*     */     {
/*  66 */       addInterfaceSubsystems(this.connector, handler, target);
/*     */     }
/*     */   }
/*     */ 
/*     */   public TransporterServer(Element xmlConfig, Object target, String subsystem)
/*     */     throws Exception
/*     */   {
/*  81 */     this.connector = getConnector(null, null, xmlConfig);
/*  82 */     ServerInvocationHandler handler = new TransporterHandler(target);
/*  83 */     if (subsystem != null)
/*     */     {
/*  85 */       this.connector.addInvocationHandler(subsystem.toUpperCase(), handler);
/*     */     }
/*     */     else
/*     */     {
/*  89 */       addInterfaceSubsystems(this.connector, handler, target);
/*     */     }
/*     */   }
/*     */ 
/*     */   public TransporterServer(InvokerLocator locator, Object target, String subsystem, Map config)
/*     */     throws Exception
/*     */   {
/* 105 */     this.connector = getConnector(locator, config, null);
/* 106 */     ServerInvocationHandler handler = new TransporterHandler(target);
/* 107 */     if (subsystem != null)
/*     */     {
/* 109 */       this.connector.addInvocationHandler(subsystem.toUpperCase(), handler);
/*     */     }
/*     */     else
/*     */     {
/* 113 */       addInterfaceSubsystems(this.connector, handler, target);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addInterfaceSubsystems(Connector connector, ServerInvocationHandler handler, Object target) throws Exception
/*     */   {
/* 119 */     Class targetClass = target.getClass();
/*     */ 
/* 122 */     List interfaceNames = new ArrayList();
/* 123 */     populateInterfaceNames(interfaceNames, targetClass);
/*     */ 
/* 125 */     for (int i = 0; i < interfaceNames.size(); i++)
/*     */     {
/* 127 */       String interfaceClassName = (String)interfaceNames.get(i);
/* 128 */       connector.addInvocationHandler(interfaceClassName.toUpperCase(), handler);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void populateInterfaceNames(List interfaceNames, Class targetClass)
/*     */   {
/* 134 */     Class[] interfaces = targetClass.getInterfaces();
/* 135 */     if (interfaces != null)
/*     */     {
/* 137 */       for (int x = 0; x < interfaces.length; x++)
/*     */       {
/* 139 */         interfaceNames.add(interfaces[x].getName());
/* 140 */         populateInterfaceNames(interfaceNames, interfaces[x]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Connector getConnector(InvokerLocator locator, Map config, Element xmlConfig)
/*     */     throws Exception
/*     */   {
/* 158 */     Connector c = new Connector(locator, config);
/* 159 */     if (xmlConfig != null)
/*     */     {
/* 161 */       c.setConfiguration(xmlConfig);
/*     */     }
/* 163 */     c.create();
/*     */ 
/* 165 */     return c;
/*     */   }
/*     */ 
/*     */   public void addHandler(Object target, String proxyclassname)
/*     */     throws Exception
/*     */   {
/* 176 */     if (this.connector != null)
/*     */     {
/* 178 */       this.connector.addInvocationHandler(proxyclassname, new TransporterHandler(target));
/*     */     }
/*     */     else
/*     */     {
/* 182 */       throw new Exception("Can not add handler to transporter server as has not be initialized yet.");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 193 */     this.connector.start();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 202 */     this.connector.stop();
/*     */   }
/*     */ 
/*     */   private static void setupDetector()
/*     */     throws Exception
/*     */   {
/* 213 */     InternalTransporterServices services = InternalTransporterServices.getInstance();
/*     */ 
/* 216 */     if (!services.isSetup())
/*     */     {
/* 219 */       MBeanServer server = MBeanServerFactory.createMBeanServer();
/*     */ 
/* 222 */       MulticastDetector detector = new MulticastDetector();
/* 223 */       services.setup(server, detector, null, null, null, true, false);
/* 224 */       detector.start();
/*     */     }
/* 226 */     else if (services.getDetector() == null)
/*     */     {
/* 229 */       MulticastDetector detector = new MulticastDetector();
/* 230 */       services.assignDetector(detector, null, true);
/* 231 */       detector.start();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static TransporterServer createTransporterServer(InvokerLocator locator, Object target, String subsystem, boolean isClustered)
/*     */     throws Exception
/*     */   {
/* 260 */     return createTransporterServer(locator, target, subsystem, null, isClustered);
/*     */   }
/*     */ 
/*     */   public static TransporterServer createTransporterServer(InvokerLocator locator, Object target, String subsystem, Map config, boolean isClustered)
/*     */     throws Exception
/*     */   {
/* 287 */     if ((isClustered) && (InternalTransporterServices.getInstance().getDetector() == null))
/*     */     {
/* 289 */       setupDetector();
/*     */     }
/*     */ 
/* 292 */     TransporterServer server = new TransporterServer(locator, target, subsystem, config);
/* 293 */     server.start();
/* 294 */     return server;
/*     */   }
/*     */ 
/*     */   public static TransporterServer createTransporterServer(String locatorURI, Object target, String subsystem, boolean isClustered)
/*     */     throws Exception
/*     */   {
/* 320 */     return createTransporterServer(new InvokerLocator(locatorURI), target, subsystem, null, isClustered);
/*     */   }
/*     */ 
/*     */   public static TransporterServer createTransporterServer(String locatorURI, Object target, String subsystem, Map config, boolean isClustered)
/*     */     throws Exception
/*     */   {
/* 347 */     return createTransporterServer(new InvokerLocator(locatorURI), target, subsystem, config, isClustered);
/*     */   }
/*     */ 
/*     */   public static TransporterServer createTransporterServer(Element xmlconfig, Object target, String subsystem, boolean isClustered)
/*     */     throws Exception
/*     */   {
/* 373 */     if ((isClustered) && (InternalTransporterServices.getInstance().getDetector() == null))
/*     */     {
/* 375 */       setupDetector();
/*     */     }
/*     */ 
/* 378 */     TransporterServer server = new TransporterServer(xmlconfig, target, subsystem);
/* 379 */     server.start();
/* 380 */     return server;
/*     */   }
/*     */ 
/*     */   public static TransporterServer createTransporterServer(InvokerLocator locator, Object target, String subsystem)
/*     */     throws Exception
/*     */   {
/* 400 */     return createTransporterServer(locator, target, subsystem, false);
/*     */   }
/*     */ 
/*     */   public static TransporterServer createTransporterServer(InvokerLocator locator, Object target)
/*     */     throws Exception
/*     */   {
/* 418 */     return createTransporterServer(locator, target, false);
/*     */   }
/*     */ 
/*     */   public static TransporterServer createTransporterServer(InvokerLocator locator, Object target, boolean isClustered)
/*     */     throws Exception
/*     */   {
/* 437 */     if ((isClustered) && (InternalTransporterServices.getInstance().getDetector() == null))
/*     */     {
/* 439 */       setupDetector();
/*     */     }
/*     */ 
/* 442 */     TransporterServer server = new TransporterServer(locator, target, null, null);
/* 443 */     server.start();
/* 444 */     return server;
/*     */   }
/*     */ 
/*     */   public static TransporterServer createTransporterServer(String locator, Object target)
/*     */     throws Exception
/*     */   {
/* 463 */     return createTransporterServer(new InvokerLocator(locator), target, false);
/*     */   }
/*     */ 
/*     */   public static TransporterServer createTransporterServer(String locator, Object target, boolean isClustered)
/*     */     throws Exception
/*     */   {
/* 482 */     return createTransporterServer(new InvokerLocator(locator), target, isClustered);
/*     */   }
/*     */ 
/*     */   public static TransporterServer createTransporterServer(String locatorURI, Object target, String subsystem)
/*     */     throws Exception
/*     */   {
/* 502 */     return createTransporterServer(new InvokerLocator(locatorURI), target, subsystem, false);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transporter.TransporterServer
 * JD-Core Version:    0.6.0
 */