/*     */ package org.jboss.remoting.transporter;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.ArrayList;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.CannotConnectException;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.detection.ServerInvokerMetadata;
/*     */ import org.jboss.remoting.detection.multicast.MulticastDetector;
/*     */ import org.jboss.remoting.invocation.NameBasedInvocation;
/*     */ import org.jboss.remoting.network.NetworkInstance;
/*     */ import org.jboss.remoting.network.NetworkRegistry;
/*     */ import org.jboss.remoting.transport.ClientInvoker;
/*     */ 
/*     */ public class TransporterClient
/*     */   implements InvocationHandler, Serializable
/*     */ {
/*  53 */   private Client remotingClient = null;
/*  54 */   private boolean isClustered = false;
/*  55 */   private String subSystem = null;
/*     */ 
/*  57 */   private LoadBalancer loadBalancer = new DefaultLoadBalancer();
/*     */ 
/*  59 */   private final Logger log = Logger.getLogger(TransporterClient.class);
/*     */   private static final long serialVersionUID = 7418567482011657189L;
/*     */ 
/*     */   private TransporterClient(InvokerLocator locator)
/*     */     throws Exception
/*     */   {
/*  71 */     this.remotingClient = new Client(locator);
/*  72 */     this.remotingClient.connect();
/*     */   }
/*     */ 
/*     */   private TransporterClient(InvokerLocator locator, String targetSubsystem)
/*     */     throws Exception
/*     */   {
/*  85 */     this.remotingClient = new Client(locator, targetSubsystem);
/*  86 */     this.remotingClient.connect();
/*  87 */     this.isClustered = true;
/*  88 */     this.subSystem = targetSubsystem;
/*     */   }
/*     */ 
/*     */   private TransporterClient(InvokerLocator locator, String targetSubsystem, LoadBalancer loadbalancer)
/*     */     throws Exception
/*     */   {
/* 102 */     this.loadBalancer = loadbalancer;
/* 103 */     this.remotingClient = new Client(locator, targetSubsystem);
/* 104 */     this.remotingClient.connect();
/* 105 */     this.isClustered = true;
/* 106 */     this.subSystem = targetSubsystem;
/*     */   }
/*     */ 
/*     */   private void disconnect()
/*     */   {
/* 114 */     if (this.remotingClient != null)
/*     */     {
/* 116 */       this.remotingClient.disconnect();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void setupDetector()
/*     */     throws Exception
/*     */   {
/* 128 */     InternalTransporterServices services = InternalTransporterServices.getInstance();
/*     */ 
/* 131 */     if (!services.isSetup())
/*     */     {
/* 134 */       MBeanServer server = MBeanServerFactory.createMBeanServer();
/*     */ 
/* 137 */       MulticastDetector detector = new MulticastDetector();
/* 138 */       NetworkRegistry registry = NetworkRegistry.getInstance();
/* 139 */       services.setup(server, detector, null, registry, null, true, true);
/* 140 */       detector.start();
/*     */     }
/*     */     else
/*     */     {
/* 145 */       if (services.getDetector() == null)
/*     */       {
/* 147 */         MulticastDetector detector = new MulticastDetector();
/* 148 */         services.assignDetector(detector, null, true);
/* 149 */         detector.start();
/*     */       }
/*     */ 
/* 152 */       if (services.getNetworkRegistry() == null)
/*     */       {
/* 154 */         NetworkRegistry registry = NetworkRegistry.getInstance();
/* 155 */         services.assignNetworkRegistry(registry, null, true);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Object createTransporterClient(String locatorURI, Class targetClass, boolean clustered)
/*     */     throws Exception
/*     */   {
/* 175 */     if (!clustered)
/*     */     {
/* 177 */       return createTransporterClient(locatorURI, targetClass);
/*     */     }
/*     */ 
/* 181 */     if (InternalTransporterServices.getInstance().getNetworkRegistry() == null)
/*     */     {
/* 183 */       setupDetector();
/*     */     }
/* 185 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/* 186 */     TransporterClient client = new TransporterClient(locator, targetClass.getName());
/* 187 */     return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[] { targetClass }, client);
/*     */   }
/*     */ 
/*     */   public static Object createTransporterClient(String locatorURI, Class targetClass, LoadBalancer loadBalancer)
/*     */     throws Exception
/*     */   {
/* 203 */     if (InternalTransporterServices.getInstance().getNetworkRegistry() == null)
/*     */     {
/* 205 */       setupDetector();
/*     */     }
/* 207 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/* 208 */     TransporterClient client = new TransporterClient(locator, targetClass.getName(), loadBalancer);
/* 209 */     return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[] { targetClass }, client);
/*     */   }
/*     */ 
/*     */   public static Object createTransporterClient(String locatorURI, Class targetClass)
/*     */     throws Exception
/*     */   {
/* 223 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/* 224 */     return createTransporterClient(locator, targetClass);
/*     */   }
/*     */ 
/*     */   public static Object createTransporterClient(InvokerLocator locator, Class targetClass)
/*     */     throws Exception
/*     */   {
/* 237 */     TransporterClient client = new TransporterClient(locator, targetClass.getName());
/* 238 */     return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[] { targetClass }, client);
/*     */   }
/*     */ 
/*     */   public static void destroyTransporterClient(Object transporterClient)
/*     */   {
/* 250 */     if ((transporterClient instanceof Proxy))
/*     */     {
/* 252 */       InvocationHandler handler = Proxy.getInvocationHandler(transporterClient);
/* 253 */       if ((handler instanceof TransporterClient))
/*     */       {
/* 255 */         TransporterClient client = (TransporterClient)handler;
/* 256 */         client.disconnect();
/*     */       }
/*     */       else
/*     */       {
/* 260 */         throw new IllegalArgumentException("Object is not a transporter client.");
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 265 */       throw new IllegalArgumentException("Object is not a transporter client.");
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 282 */     String methodName = method.getName();
/* 283 */     String[] paramSig = createParamSignature(method.getParameterTypes());
/*     */ 
/* 285 */     NameBasedInvocation request = new NameBasedInvocation(methodName, args, paramSig);
/*     */ 
/* 288 */     Object response = null;
/*     */ 
/* 290 */     boolean failOver = false;
/*     */     do
/*     */     {
/*     */       try
/*     */       {
/* 296 */         failOver = false;
/* 297 */         response = this.remotingClient.invoke(request);
/*     */       }
/*     */       catch (CannotConnectException cnc)
/*     */       {
/* 301 */         failOver = findAlternativeTarget();
/* 302 */         if (!failOver)
/*     */         {
/* 304 */           throw cnc;
/*     */         }
/*     */       }
/*     */       catch (InvocationTargetException itex)
/*     */       {
/* 309 */         Throwable rootEx = itex.getCause();
/* 310 */         throw rootEx;
/*     */       }
/*     */     }
/* 313 */     while (failOver);
/*     */ 
/* 315 */     return response;
/*     */   }
/*     */ 
/*     */   private boolean findAlternativeTarget()
/*     */   {
/* 328 */     boolean failover = false;
/* 329 */     ArrayList availableList = new ArrayList();
/* 330 */     NetworkRegistry registry = InternalTransporterServices.getInstance().getNetworkRegistry();
/* 331 */     if (registry != null)
/*     */     {
/* 333 */       NetworkInstance[] instances = registry.getServers();
/* 334 */       if (instances != null)
/*     */       {
/* 336 */         for (int x = 0; x < instances.length; x++)
/*     */         {
/* 338 */           NetworkInstance netInstance = instances[x];
/* 339 */           ServerInvokerMetadata[] metadata = netInstance.getServerInvokers();
/* 340 */           for (int i = 0; i < metadata.length; i++)
/*     */           {
/* 342 */             ServerInvokerMetadata data = metadata[i];
/* 343 */             String[] subsystems = data.getSubSystems();
/* 344 */             for (int z = 0; z < subsystems.length; z++)
/*     */             {
/* 346 */               if (!this.subSystem.equalsIgnoreCase(subsystems[z]))
/*     */                 continue;
/* 348 */               availableList.add(data);
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 355 */         if (availableList.size() > 0)
/*     */         {
/* 357 */           int index = this.loadBalancer.selectServer(availableList);
/* 358 */           if (this.log.isDebugEnabled())
/*     */           {
/* 360 */             this.log.debug("Total of " + availableList.size() + " available servers found.");
/* 361 */             this.log.debug("Using server number " + index);
/*     */           }
/*     */ 
/* 364 */           ServerInvokerMetadata data = (ServerInvokerMetadata)availableList.get(index);
/* 365 */           InvokerLocator newLocator = data.getInvokerLocator();
/*     */ 
/* 367 */           if (!this.remotingClient.getInvoker().getLocator().equals(newLocator))
/*     */           {
/*     */             try
/*     */             {
/* 371 */               this.remotingClient = new Client(newLocator);
/* 372 */               this.remotingClient.connect();
/* 373 */               return true;
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 377 */               this.log.warn("Problem connecting to newly found alternate target.", e);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 384 */     return failover;
/*     */   }
/*     */ 
/*     */   private String[] createParamSignature(Class[] args)
/*     */   {
/* 398 */     if ((args == null) || (args.length == 0))
/*     */     {
/* 400 */       return new String[0];
/*     */     }
/* 402 */     String[] paramSig = new String[args.length];
/* 403 */     for (int x = 0; x < args.length; x++)
/*     */     {
/* 405 */       paramSig[x] = args[x].getName();
/*     */     }
/* 407 */     return paramSig;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transporter.TransporterClient
 * JD-Core Version:    0.6.0
 */