/*     */ package org.jboss.remoting.transporter;
/*     */ 
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ import org.jboss.remoting.detection.Detector;
/*     */ import org.jboss.remoting.network.NetworkRegistry;
/*     */ 
/*     */ public class InternalTransporterServices
/*     */ {
/*  41 */   public static final ObjectName DEFAULT_DETECTOR_OBJECTNAME = ObjectNameFactory.create("remoting:type=Detector");
/*     */ 
/*  46 */   public static final ObjectName DEFAULT_NETWORKREGISTRY_OBJECTNAME = ObjectNameFactory.create("remoting:type=NetworkRegistry");
/*     */ 
/*  51 */   private static final InternalTransporterServices SINGLETON = new InternalTransporterServices();
/*     */   private MBeanServer m_mBeanServer;
/*     */   private Detector m_detector;
/*     */   private ObjectName m_detectorName;
/*     */   private NetworkRegistry m_networkRegistry;
/*     */   private ObjectName m_networkRegistryName;
/*     */ 
/*     */   public static InternalTransporterServices getInstance()
/*     */   {
/*  61 */     return SINGLETON;
/*     */   }
/*     */ 
/*     */   private InternalTransporterServices()
/*     */   {
/*  94 */     this.m_mBeanServer = null;
/*  95 */     this.m_detector = null;
/*  96 */     this.m_detectorName = null;
/*  97 */     this.m_networkRegistry = null;
/*  98 */     this.m_networkRegistryName = null;
/*     */   }
/*     */ 
/*     */   public MBeanServer getMBeanServer()
/*     */   {
/* 108 */     return this.m_mBeanServer;
/*     */   }
/*     */ 
/*     */   public Detector getDetector()
/*     */   {
/* 118 */     return this.m_detector;
/*     */   }
/*     */ 
/*     */   public ObjectName getDetectorName()
/*     */   {
/* 128 */     return this.m_detectorName;
/*     */   }
/*     */ 
/*     */   public NetworkRegistry getNetworkRegistry()
/*     */   {
/* 138 */     return this.m_networkRegistry;
/*     */   }
/*     */ 
/*     */   public ObjectName getNetworkRegistryName()
/*     */   {
/* 149 */     return this.m_networkRegistryName;
/*     */   }
/*     */ 
/*     */   public boolean isSetup()
/*     */   {
/* 163 */     synchronized (this)
/*     */     {
/* 165 */       return this.m_mBeanServer != null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 176 */     synchronized (this)
/*     */     {
/* 178 */       this.m_mBeanServer = null;
/* 179 */       this.m_detector = null;
/* 180 */       this.m_detectorName = null;
/* 181 */       this.m_networkRegistry = null;
/* 182 */       this.m_networkRegistryName = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void assignDetector(Detector detector, ObjectName detectorName, boolean registerDetector)
/*     */     throws IllegalArgumentException, IllegalStateException, Exception
/*     */   {
/* 211 */     synchronized (this)
/*     */     {
/* 213 */       if (detector == null)
/*     */       {
/* 215 */         throw new IllegalArgumentException("Detector was null");
/*     */       }
/*     */ 
/* 218 */       if (this.m_mBeanServer == null)
/*     */       {
/* 220 */         throw new IllegalStateException("There is no MBeanServer setup yet");
/*     */       }
/*     */ 
/* 223 */       if (this.m_detector != null)
/*     */       {
/* 225 */         throw new IllegalStateException("A detector is already assigned");
/*     */       }
/*     */ 
/* 228 */       if (detectorName == null)
/*     */       {
/* 230 */         detectorName = DEFAULT_DETECTOR_OBJECTNAME;
/*     */       }
/*     */ 
/* 233 */       this.m_detector = detector;
/* 234 */       this.m_detectorName = detectorName;
/*     */ 
/* 236 */       if (registerDetector)
/*     */       {
/* 238 */         this.m_mBeanServer.registerMBean(this.m_detector, this.m_detectorName);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void assignNetworkRegistry(NetworkRegistry registry, ObjectName registryName, boolean registerRegistry)
/*     */     throws IllegalArgumentException, IllegalStateException, Exception
/*     */   {
/* 270 */     synchronized (this)
/*     */     {
/* 272 */       if (registry == null)
/*     */       {
/* 274 */         throw new IllegalArgumentException("Registry was null");
/*     */       }
/*     */ 
/* 277 */       if (this.m_mBeanServer == null)
/*     */       {
/* 279 */         throw new IllegalStateException("There is no MBeanServer setup yet");
/*     */       }
/*     */ 
/* 282 */       if (this.m_networkRegistry != null)
/*     */       {
/* 284 */         throw new IllegalStateException("A network registry is already assigned");
/*     */       }
/*     */ 
/* 287 */       if (registryName == null)
/*     */       {
/* 289 */         registryName = DEFAULT_NETWORKREGISTRY_OBJECTNAME;
/*     */       }
/*     */ 
/* 292 */       this.m_networkRegistry = registry;
/* 293 */       this.m_networkRegistryName = registryName;
/*     */ 
/* 295 */       if (registerRegistry)
/*     */       {
/* 297 */         this.m_mBeanServer.registerMBean(this.m_networkRegistry, this.m_networkRegistryName);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setup(MBeanServer mbs)
/*     */     throws IllegalArgumentException, IllegalStateException
/*     */   {
/* 317 */     synchronized (this)
/*     */     {
/* 319 */       if (this.m_mBeanServer != null)
/*     */       {
/* 321 */         throw new IllegalStateException("The internal transporter services have already been setup");
/*     */       }
/*     */ 
/* 324 */       if (mbs == null)
/*     */       {
/* 326 */         throw new IllegalArgumentException("MBeanServer must not be null");
/*     */       }
/*     */ 
/* 329 */       this.m_mBeanServer = mbs;
/* 330 */       this.m_detector = null;
/* 331 */       this.m_detectorName = null;
/* 332 */       this.m_networkRegistry = null;
/* 333 */       this.m_networkRegistryName = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setup(MBeanServer mbs, Detector detector, ObjectName detectorName, NetworkRegistry registry, ObjectName registryName, boolean registerDetector, boolean registerRegistry)
/*     */     throws Exception
/*     */   {
/* 371 */     synchronized (this)
/*     */     {
/* 373 */       setup(mbs);
/*     */ 
/* 375 */       if (detector != null)
/*     */       {
/* 377 */         assignDetector(detector, detectorName, registerDetector);
/*     */       }
/*     */ 
/* 380 */       if (registry != null)
/*     */       {
/* 382 */         assignNetworkRegistry(registry, registryName, registerRegistry);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transporter.InternalTransporterServices
 * JD-Core Version:    0.6.0
 */