/*     */ package org.jboss.remoting.transport.sslbisocket;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.util.Map;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import javax.net.SocketFactory;
/*     */ import javax.net.ssl.SSLServerSocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.security.SSLSocketBuilder;
/*     */ import org.jboss.remoting.socketfactory.SocketFactoryWrapper;
/*     */ import org.jboss.remoting.transport.bisocket.BisocketServerInvoker;
/*     */ import org.jboss.remoting.transport.sslsocket.SSLSocketServerInvokerMBean;
/*     */ 
/*     */ public class SSLBisocketServerInvoker extends BisocketServerInvoker
/*     */   implements SSLSocketServerInvokerMBean
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(SSLBisocketServerInvoker.class);
/*     */ 
/*     */   public SSLBisocketServerInvoker(InvokerLocator locator)
/*     */   {
/*  53 */     super(locator);
/*     */   }
/*     */ 
/*     */   public SSLBisocketServerInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/*  58 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   protected ServerSocketFactory getDefaultServerSocketFactory()
/*     */   {
/*  63 */     return SSLServerSocketFactory.getDefault();
/*     */   }
/*     */ 
/*     */   protected ServerSocketFactory createServerSocketFactory() throws IOException
/*     */   {
/*  68 */     if (this.isCallbackServer) {
/*  69 */       return null;
/*     */     }
/*  71 */     return super.createServerSocketFactory();
/*     */   }
/*     */ 
/*     */   protected void setup() throws Exception
/*     */   {
/*  76 */     super.setup();
/*  77 */     if (this.isCallbackServer)
/*     */     {
/*  79 */       this.socketFactory = createSocketFactory(this.configuration);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected SocketFactory createSocketFactory(Map configuration)
/*     */   {
/*  85 */     SocketFactory sf = super.createSocketFactory(configuration);
/*     */ 
/*  87 */     if (isCompleteSocketFactory(sf)) {
/*  88 */       return sf;
/*     */     }
/*  90 */     SocketFactory wrapper = sf;
/*     */     try
/*     */     {
/*  94 */       SSLSocketBuilder server = new SSLSocketBuilder(configuration);
/*  95 */       sf = server.createSSLSocketFactory();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  99 */       log.error("Error creating SSL Socket Factory for client invoker.", e);
/*     */     }
/*     */ 
/* 102 */     if (wrapper != null)
/*     */     {
/* 104 */       ((SocketFactoryWrapper)wrapper).setSocketFactory(sf);
/* 105 */       return wrapper;
/*     */     }
/*     */ 
/* 108 */     return sf;
/*     */   }
/*     */ 
/*     */   protected ServerSocket createServerSocket(int serverBindPort, int backlog, InetAddress bindAddress)
/*     */     throws IOException
/*     */   {
/* 114 */     ServerSocket svrSocket = getServerSocketFactory().createServerSocket(serverBindPort, backlog, bindAddress);
/* 115 */     return svrSocket;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.sslbisocket.SSLBisocketServerInvoker
 * JD-Core Version:    0.6.0
 */