/*     */ package org.jboss.remoting.transport.sslbisocket;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.Socket;
/*     */ import java.util.Map;
/*     */ import javax.net.SocketFactory;
/*     */ import javax.net.ssl.HandshakeCompletedListener;
/*     */ import javax.net.ssl.SSLSocket;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.security.SSLSocketBuilder;
/*     */ import org.jboss.remoting.socketfactory.SocketFactoryWrapper;
/*     */ import org.jboss.remoting.transport.bisocket.BisocketClientInvoker;
/*     */ import org.jboss.remoting.util.socket.HandshakeRepeater;
/*     */ 
/*     */ public class SSLBisocketClientInvoker extends BisocketClientInvoker
/*     */ {
/*  48 */   private static final Logger log = Logger.getLogger(SSLBisocketClientInvoker.class);
/*     */ 
/*     */   public SSLBisocketClientInvoker(InvokerLocator locator) throws IOException
/*     */   {
/*  52 */     super(locator);
/*     */     try
/*     */     {
/*  55 */       setup();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  59 */       log.error("Error setting up ssl bisocket client invoker.", ex);
/*  60 */       throw new RuntimeException(ex.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public SSLBisocketClientInvoker(InvokerLocator locator, Map configuration) throws IOException
/*     */   {
/*  66 */     super(locator, configuration);
/*     */     try
/*     */     {
/*  69 */       setup();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  73 */       log.error("Error setting up ssl bisocket client invoker.", ex);
/*  74 */       throw new RuntimeException(ex.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected SocketFactory createSocketFactory(Map configuration)
/*     */   {
/*  80 */     SocketFactory sf = super.createSocketFactory(configuration);
/*     */ 
/*  82 */     if (isCompleteSocketFactory(sf)) {
/*  83 */       return sf;
/*     */     }
/*  85 */     SocketFactory wrapper = sf;
/*     */     try
/*     */     {
/*  89 */       SSLSocketBuilder server = new SSLSocketBuilder(configuration);
/*  90 */       sf = server.createSSLSocketFactory();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  94 */       log.error("Error creating SSL Socket Factory for client invoker.", e);
/*     */     }
/*     */ 
/*  97 */     if (wrapper != null)
/*     */     {
/*  99 */       ((SocketFactoryWrapper)wrapper).setSocketFactory(sf);
/* 100 */       return wrapper;
/*     */     }
/*     */ 
/* 103 */     return sf;
/*     */   }
/*     */ 
/*     */   protected Socket createSocket(String address, int port, int timeout)
/*     */     throws IOException
/*     */   {
/* 110 */     if (this.isCallbackInvoker) {
/* 111 */       return super.createSocket(address, port, timeout);
/*     */     }
/* 113 */     SocketFactory sf = getSocketFactory();
/*     */ 
/* 115 */     if (sf == null) {
/* 116 */       sf = createSocketFactory(this.configuration);
/*     */     }
/* 118 */     Socket s = sf.createSocket();
/*     */ 
/* 120 */     s.setReuseAddress(getReuseAddress());
/* 121 */     InetSocketAddress inetAddr = new InetSocketAddress(address, port);
/*     */ 
/* 123 */     if (timeout < 0)
/*     */     {
/* 125 */       timeout = getTimeout();
/* 126 */       if (timeout < 0) {
/* 127 */         timeout = 0;
/*     */       }
/*     */     }
/* 130 */     s.connect(inetAddr, timeout);
/*     */ 
/* 132 */     if ((s instanceof SSLSocket))
/*     */     {
/* 135 */       Object obj = this.configuration.get("handshakeCompletedListener");
/* 136 */       if ((obj != null) && ((obj instanceof HandshakeCompletedListener)))
/*     */       {
/* 138 */         SSLSocket sslSocket = (SSLSocket)s;
/* 139 */         HandshakeCompletedListener listener = (HandshakeCompletedListener)obj;
/* 140 */         establishHandshake(sslSocket, listener);
/*     */       }
/*     */     }
/*     */ 
/* 144 */     return s;
/*     */   }
/*     */ 
/*     */   private void establishHandshake(SSLSocket sslSocket, HandshakeCompletedListener listener)
/*     */     throws IOException
/*     */   {
/* 150 */     HandshakeRepeater repeater = new HandshakeRepeater(listener);
/* 151 */     sslSocket.addHandshakeCompletedListener(repeater);
/* 152 */     sslSocket.getSession();
/* 153 */     repeater.waitForHandshake();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.sslbisocket.SSLBisocketClientInvoker
 * JD-Core Version:    0.6.0
 */