/*     */ package org.jboss.remoting.transport.socket;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class SocketWrapper
/*     */ {
/*  40 */   private static final Logger log = Logger.getLogger(SocketWrapper.class);
/*     */   public static final String MARSHALLER = "marshaller";
/*     */   public static final String UNMARSHALLER = "unmarshaller";
/*     */   public static final String TEMP_TIMEOUT = "temptimeout";
/*     */   protected static final int CLOSING = 254;
/*  50 */   private static boolean trace = log.isTraceEnabled();
/*     */   private Socket socket;
/*     */   private int timeout;
/*     */ 
/*     */   protected SocketWrapper(Socket socket)
/*     */   {
/*  61 */     if (trace) log.trace("constructing " + getClass().getName() + " instance for " + socket);
/*  62 */     this.socket = socket;
/*     */   }
/*     */ 
/*     */   protected SocketWrapper(Socket socket, Integer timeoutInt) throws SocketException
/*     */   {
/*  67 */     if (trace) log.trace("constructing " + getClass().getName() + " instance for " + socket + ", using timeout " + timeoutInt);
/*  68 */     this.socket = socket;
/*     */ 
/*  70 */     if (timeoutInt != null)
/*     */     {
/*  72 */       this.timeout = timeoutInt.intValue();
/*  73 */       setTimeout(this.timeout);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setTimeout(int timeout)
/*     */     throws SocketException
/*     */   {
/*  81 */     if (trace) log.trace(this + " setting timeout to " + timeout);
/*  82 */     this.timeout = timeout;
/*  83 */     if (this.socket != null)
/*     */     {
/*  85 */       this.socket.setSoTimeout(timeout);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getTimeout()
/*     */   {
/*  91 */     return this.timeout;
/*     */   }
/*     */ 
/*     */   public void close() throws IOException
/*     */   {
/*  96 */     InputStream in = getInputStream();
/*  97 */     if (in != null)
/*     */     {
/*     */       try
/*     */       {
/* 101 */         in.close();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 105 */         log.debug("unable to close input stream");
/*     */       }
/*     */     }
/* 108 */     OutputStream out = getOutputStream();
/* 109 */     if (out != null)
/*     */     {
/*     */       try
/*     */       {
/* 113 */         out.close();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 117 */         log.debug("unable to close output stream");
/*     */       }
/*     */     }
/*     */ 
/* 121 */     if (this.socket != null)
/*     */     {
/* 123 */       log.debug(this + " closing");
/* 124 */       this.socket.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Socket getSocket()
/*     */   {
/* 130 */     return this.socket;
/*     */   }
/*     */ 
/*     */   public abstract OutputStream getOutputStream()
/*     */     throws IOException;
/*     */ 
/*     */   public abstract InputStream getInputStream() throws IOException;
/*     */ 
/*     */   public abstract void checkConnection() throws IOException;
/*     */ 
/*     */   protected void finalize()
/*     */   {
/* 145 */     if (this.socket != null)
/*     */     {
/*     */       try
/*     */       {
/* 149 */         this.socket.close();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 153 */         log.debug(this + " failed to close socket", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.socket.SocketWrapper
 * JD-Core Version:    0.6.0
 */