/*     */ package org.jboss.remoting.transport.socket;
/*     */ 
/*     */ import java.io.EOFException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InterruptedIOException;
/*     */ import java.io.OutputStream;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.net.InetAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketAddress;
/*     */ import java.net.SocketException;
/*     */ import java.net.SocketTimeoutException;
/*     */ import java.util.HashMap;
/*     */ import java.util.LinkedList;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvocationResponse;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.Version;
/*     */ import org.jboss.remoting.marshal.MarshalFactory;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.remoting.marshal.VersionedMarshaller;
/*     */ import org.jboss.remoting.marshal.VersionedUnMarshaller;
/*     */ import org.jboss.remoting.serialization.ClassLoaderUtility;
/*     */ 
/*     */ public class ServerThread extends Thread
/*     */ {
/*  76 */   private static final Logger log = Logger.getLogger(ServerThread.class);
/*     */ 
/*  80 */   private static boolean trace = log.isTraceEnabled();
/*     */ 
/*  82 */   private static int idGenerator = 0;
/*     */   protected volatile boolean running;
/*     */   protected volatile boolean handlingResponse;
/*     */   protected volatile boolean shutdown;
/*     */   protected LRUPool clientpool;
/*     */   protected LinkedList threadpool;
/*     */   protected String serverSocketClassName;
/*     */   protected Class serverSocketClass;
/*     */   private Socket socket;
/*     */   private int timeout;
/*     */   protected SocketServerInvoker invoker;
/*     */   private Constructor serverSocketConstructor;
/*     */   protected SocketWrapper socketWrapper;
/*     */   protected Marshaller marshaller;
/*     */   protected UnMarshaller unmarshaller;
/* 112 */   private int id = -2147483648;
/*     */   private boolean shouldCheckConnection;
/* 120 */   private long lastRequestHandledTimestamp = System.currentTimeMillis();
/*     */ 
/*     */   public static synchronized int nextID()
/*     */   {
/*  86 */     return idGenerator++;
/*     */   }
/*     */ 
/*     */   public ServerThread(Socket socket, SocketServerInvoker invoker, LRUPool clientpool, LinkedList threadpool, int timeout, String serverSocketClassName)
/*     */     throws Exception
/*     */   {
/* 130 */     this.running = true;
/* 131 */     this.handlingResponse = true;
/*     */ 
/* 133 */     setName(getWorkerThreadName(socket));
/*     */ 
/* 135 */     this.socket = socket;
/* 136 */     this.timeout = timeout;
/* 137 */     this.serverSocketClassName = serverSocketClassName;
/* 138 */     this.invoker = invoker;
/* 139 */     this.clientpool = clientpool;
/* 140 */     this.threadpool = threadpool;
/* 141 */     processNewSocket();
/*     */ 
/* 143 */     if (invoker != null)
/*     */     {
/* 145 */       Map configMap = invoker.getConfiguration();
/* 146 */       String checkValue = (String)configMap.get("socket.check_connection");
/* 147 */       if ((checkValue != null) && (checkValue.length() > 0))
/*     */       {
/* 149 */         this.shouldCheckConnection = Boolean.valueOf(checkValue).booleanValue();
/*     */       }
/* 151 */       else if (Version.getDefaultVersion() == 1)
/*     */       {
/* 153 */         this.shouldCheckConnection = true;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*     */     try
/*     */     {
/*     */       while (true)
/*     */       {
/* 166 */         dorun();
/*     */ 
/* 184 */         synchronized (this)
/*     */         {
/* 186 */           synchronized (this.clientpool)
/*     */           {
/* 188 */             synchronized (this.threadpool)
/*     */             {
/* 190 */               if (this.shutdown)
/*     */               {
/* 192 */                 this.invoker = null;
/* 193 */                 return;
/*     */               }
/*     */ 
/* 197 */               if (trace) log.trace(this + " removing itself from clientpool and going to threadpool");
/* 198 */               this.clientpool.remove(this);
/* 199 */               this.threadpool.add(this);
/* 200 */               Thread.interrupted();
/* 201 */               this.clientpool.notify();
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */           while (true)
/*     */           {
/*     */             try
/*     */             {
/* 210 */               if (!trace) continue; log.trace(this + " begins to wait");
/*     */ 
/* 212 */               wait();
/*     */ 
/* 214 */               if (!trace) continue; log.trace(this + " woke up after wait");
/*     */             }
/*     */             catch (InterruptedException e)
/*     */             {
/* 220 */               if (this.shutdown)
/*     */               {
/* 222 */                 this.invoker = null;
/* 223 */                 return;
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 232 */       log.debug(this + " exiting run on exception, definitively thrown out of the threadpool", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void wakeup(Socket socket, int timeout, SocketServerInvoker invoker)
/*     */     throws Exception
/*     */   {
/* 242 */     setName(getWorkerThreadName(socket));
/*     */ 
/* 244 */     this.socket = socket;
/* 245 */     this.timeout = timeout;
/* 246 */     this.invoker = invoker;
/*     */ 
/* 248 */     this.running = true;
/* 249 */     this.handlingResponse = true;
/* 250 */     processNewSocket();
/* 251 */     notify();
/*     */ 
/* 253 */     if (trace) log.trace(this + " has notified on mutex");
/*     */   }
/*     */ 
/*     */   public long getLastRequestTimestamp()
/*     */   {
/* 258 */     return this.lastRequestHandledTimestamp;
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 263 */     this.shutdown = true;
/* 264 */     this.running = false;
/*     */ 
/* 272 */     if (!this.handlingResponse)
/*     */     {
/*     */       try
/*     */       {
/* 276 */         interrupt();
/* 277 */         Thread.interrupted();
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void shouldCheckConnection(boolean checkConnection)
/*     */   {
/* 292 */     this.shouldCheckConnection = checkConnection;
/*     */   }
/*     */ 
/*     */   public boolean getCheckingConnection()
/*     */   {
/* 300 */     return this.shouldCheckConnection;
/*     */   }
/*     */ 
/*     */   public void evict()
/*     */   {
/* 305 */     this.running = false;
/*     */ 
/* 314 */     if (!this.handlingResponse)
/*     */     {
/*     */       try
/*     */       {
/* 318 */         interrupt();
/* 319 */         Thread.interrupted();
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void unblock()
/*     */   {
/*     */     try
/*     */     {
/* 335 */       this.socket.close();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 339 */       log.warn("Error closing socket when attempting to unblock I/O", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 345 */     return getName();
/*     */   }
/*     */ 
/*     */   protected void dorun()
/*     */   {
/* 357 */     if (trace) log.trace("beginning dorun()");
/*     */ 
/* 359 */     this.running = true;
/* 360 */     this.handlingResponse = true;
/*     */     try
/*     */     {
/* 366 */       if (trace) log.trace("creating the socket wrapper");
/*     */ 
/* 368 */       this.socketWrapper = createServerSocketWrapper(this.socket, this.timeout, this.invoker.getLocator().getParameters());
/*     */ 
/* 372 */       if (trace) log.trace("processing first invocation without acknowledging");
/* 373 */       processInvocation(this.socketWrapper);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 377 */       log.error("Worker thread initialization failure", ex);
/* 378 */       this.running = false;
/*     */     }
/*     */ 
/* 382 */     while (this.running)
/*     */     {
/*     */       try
/*     */       {
/* 386 */         acknowledge(this.socketWrapper);
/* 387 */         processInvocation(this.socketWrapper);
/*     */       }
/*     */       catch (AcknowledgeFailure e)
/*     */       {
/* 391 */         if ((!this.shutdown) && (trace))
/*     */         {
/* 393 */           log.trace("keep alive acknowledge failed!");
/*     */         }
/* 395 */         this.running = false;
/*     */       }
/*     */       catch (SocketTimeoutException ste)
/*     */       {
/* 399 */         if (!this.shutdown)
/*     */         {
/* 401 */           if (trace)
/*     */           {
/* 403 */             log.trace(ste);
/*     */           }
/*     */         }
/* 406 */         this.running = false;
/*     */       }
/*     */       catch (InterruptedIOException e)
/*     */       {
/* 410 */         if (!this.shutdown)
/*     */         {
/* 412 */           log.error("Socket IO interrupted", e);
/*     */         }
/* 414 */         this.running = false;
/*     */       }
/*     */       catch (InterruptedException e)
/*     */       {
/* 419 */         if (trace)
/*     */         {
/* 421 */           log.trace(e);
/*     */         }
/* 423 */         if (!this.shutdown)
/*     */         {
/* 425 */           log.error("interrupted", e);
/*     */         }
/*     */       }
/*     */       catch (EOFException eof)
/*     */       {
/* 430 */         if ((!this.shutdown) && (trace))
/*     */         {
/* 432 */           log.trace("EOFException received. This is likely due to client finishing communication.", eof);
/*     */         }
/* 434 */         this.running = false;
/*     */       }
/*     */       catch (SocketException sex)
/*     */       {
/* 438 */         if ((!this.shutdown) && (trace))
/*     */         {
/* 440 */           log.trace("SocketException received. This is likely due to client disconnecting and resetting connection.", sex);
/*     */         }
/* 442 */         this.running = false;
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 446 */         if (!this.shutdown)
/*     */         {
/* 448 */           log.error("failed", ex);
/* 449 */           this.running = false;
/*     */         }
/*     */       }
/*     */ 
/* 453 */       this.handlingResponse = false;
/* 454 */       Thread.interrupted();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 482 */       if (this.socketWrapper != null)
/*     */       {
/* 484 */         log.debug(this + " closing socketWrapper: " + this.socketWrapper);
/* 485 */         this.socketWrapper.close();
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 490 */       log.error("failed to close socket wrapper", ex);
/*     */     }
/* 492 */     this.socketWrapper = null;
/*     */   }
/*     */ 
/*     */   protected void processInvocation(SocketWrapper socketWrapper) throws Exception
/*     */   {
/* 497 */     if (trace) log.trace("preparing to process next invocation invocation");
/*     */ 
/* 499 */     this.handlingResponse = true;
/*     */ 
/* 504 */     int version = Version.getDefaultVersion();
/* 505 */     boolean performVersioning = Version.performVersioning();
/* 506 */     InputStream inputStream = socketWrapper.getInputStream();
/*     */ 
/* 508 */     if (performVersioning)
/*     */     {
/* 510 */       version = readVersion(inputStream);
/*     */ 
/* 527 */       if (version == -1)
/*     */       {
/* 530 */         throw new EOFException();
/*     */       }
/*     */     }
/*     */ 
/* 534 */     Object obj = versionedRead(inputStream, this.invoker, getClass().getClassLoader(), version);
/*     */ 
/* 537 */     this.lastRequestHandledTimestamp = System.currentTimeMillis();
/*     */ 
/* 539 */     InvocationRequest req = null;
/* 540 */     boolean createdInvocationRequest = false;
/* 541 */     boolean isError = false;
/*     */ 
/* 543 */     if ((obj instanceof InvocationRequest))
/*     */     {
/* 545 */       req = (InvocationRequest)obj;
/*     */     }
/*     */     else
/*     */     {
/* 549 */       req = createInvocationRequest(obj, socketWrapper);
/* 550 */       createdInvocationRequest = true;
/* 551 */       performVersioning = false;
/*     */     }
/*     */ 
/* 554 */     Object resp = null;
/*     */     try
/*     */     {
/* 559 */       Thread.interrupted();
/*     */ 
/* 561 */       if (trace) log.trace("about to call " + this.invoker + ".invoke()");
/*     */ 
/* 564 */       if ("$GET_CLIENT_LOCAL_ADDRESS$".equals(req.getParameter()))
/*     */       {
/* 566 */         Socket s = socketWrapper.getSocket();
/* 567 */         InetAddress a = s.getInetAddress();
/* 568 */         resp = new InvocationResponse(req.getSessionId(), a, false, null);
/*     */       }
/*     */       else
/*     */       {
/* 573 */         resp = this.invoker.invoke(req);
/*     */       }
/*     */ 
/* 576 */       if (trace) log.trace(this.invoker + ".invoke() returned " + resp);
/*     */     }
/*     */     catch (Throwable ex)
/*     */     {
/* 580 */       resp = ex;
/* 581 */       isError = true;
/* 582 */       if (trace) log.trace(this.invoker + ".invoke() call failed", ex);
/*     */     }
/*     */ 
/* 585 */     Thread.interrupted();
/*     */ 
/* 587 */     if (isOneway(req.getRequestPayload()))
/*     */     {
/* 589 */       if (trace) log.trace("oneway request, writing no reply on the wire");
/*     */     }
/*     */     else
/*     */     {
/* 593 */       if (!createdInvocationRequest)
/*     */       {
/* 596 */         if (trace) log.trace("creating response instance");
/* 597 */         resp = new InvocationResponse(req.getSessionId(), resp, isError, req.getReturnPayload());
/*     */       }
/*     */ 
/* 600 */       OutputStream outputStream = socketWrapper.getOutputStream();
/* 601 */       if (performVersioning)
/*     */       {
/* 603 */         writeVersion(outputStream, version);
/*     */       }
/*     */ 
/* 606 */       versionedWrite(outputStream, this.invoker, getClass().getClassLoader(), resp, version);
/*     */     }
/*     */ 
/* 609 */     this.handlingResponse = false;
/*     */ 
/* 612 */     this.lastRequestHandledTimestamp = System.currentTimeMillis();
/*     */   }
/*     */ 
/*     */   protected void acknowledge(SocketWrapper socketWrapper) throws Exception
/*     */   {
/* 617 */     if (this.shouldCheckConnection)
/*     */     {
/* 624 */       this.handlingResponse = true;
/*     */       try
/*     */       {
/* 628 */         if (trace) log.trace("checking connection");
/* 629 */         socketWrapper.checkConnection();
/*     */       }
/*     */       catch (EOFException e)
/*     */       {
/* 633 */         throw new AcknowledgeFailure();
/*     */       }
/*     */       catch (SocketException se)
/*     */       {
/* 637 */         throw new AcknowledgeFailure();
/*     */       }
/*     */       catch (IOException ioe)
/*     */       {
/* 641 */         throw new AcknowledgeFailure();
/*     */       }
/*     */ 
/* 644 */       this.handlingResponse = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Object versionedRead(InputStream inputStream, ServerInvoker invoker, ClassLoader classLoader, int version)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 654 */     switch (version)
/*     */     {
/*     */     case 1:
/*     */     case 2:
/*     */     case 22:
/* 660 */       if (trace) log.trace("blocking to read invocation from unmarshaller");
/*     */ 
/* 662 */       Object o = null;
/* 663 */       if ((this.unmarshaller instanceof VersionedUnMarshaller))
/* 664 */         o = ((VersionedUnMarshaller)this.unmarshaller).read(inputStream, null, version);
/*     */       else {
/* 666 */         o = this.unmarshaller.read(inputStream, null);
/*     */       }
/* 668 */       if (trace) log.trace("read " + o + " from unmarshaller");
/*     */ 
/* 670 */       return o;
/*     */     }
/*     */ 
/* 674 */     throw new IOException("Can not read data for version " + version + ".  Supported versions: " + 1 + "," + 2 + "," + 22);
/*     */   }
/*     */ 
/*     */   private SocketWrapper createServerSocketWrapper(Socket socket, int timeout, Map metadata)
/*     */     throws Exception
/*     */   {
/* 685 */     if (this.serverSocketConstructor == null)
/*     */     {
/* 687 */       if (this.serverSocketClass == null)
/*     */       {
/* 689 */         this.serverSocketClass = ClassLoaderUtility.loadClass(this.serverSocketClassName, getClass());
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 694 */         this.serverSocketConstructor = this.serverSocketClass.getConstructor(new Class[] { Socket.class, Map.class, Integer.class });
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/* 699 */         this.serverSocketConstructor = this.serverSocketClass.getConstructor(new Class[] { Socket.class });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 704 */     SocketWrapper serverSocketWrapper = null;
/*     */ 
/* 706 */     if (this.serverSocketConstructor.getParameterTypes().length == 3)
/*     */     {
/* 708 */       Map localMetadata = null;
/* 709 */       if (metadata == null)
/*     */       {
/* 711 */         localMetadata = new HashMap(2);
/*     */       }
/*     */       else
/*     */       {
/* 715 */         localMetadata = new HashMap(metadata);
/*     */       }
/* 717 */       localMetadata.put("marshaller", this.marshaller);
/* 718 */       localMetadata.put("unmarshaller", this.unmarshaller);
/*     */ 
/* 720 */       serverSocketWrapper = (SocketWrapper)this.serverSocketConstructor.newInstance(new Object[] { socket, localMetadata, new Integer(timeout) });
/*     */     }
/*     */     else
/*     */     {
/* 725 */       serverSocketWrapper = (SocketWrapper)this.serverSocketConstructor.newInstance(new Object[] { socket });
/*     */ 
/* 728 */       serverSocketWrapper.setTimeout(timeout);
/*     */     }
/* 730 */     return serverSocketWrapper;
/*     */   }
/*     */ 
/*     */   private boolean isOneway(Map metadata)
/*     */   {
/* 735 */     boolean isOneway = false;
/*     */ 
/* 737 */     if (metadata != null)
/*     */     {
/* 739 */       Object val = metadata.get("oneway");
/* 740 */       if ((val != null) && ((val instanceof String)) && (Boolean.valueOf((String)val).booleanValue()))
/*     */       {
/* 742 */         isOneway = true;
/*     */       }
/*     */     }
/* 745 */     return isOneway;
/*     */   }
/*     */ 
/*     */   private InvocationRequest createInvocationRequest(Object obj, SocketWrapper socketWrapper)
/*     */   {
/* 750 */     if ((obj instanceof InvocationRequest))
/*     */     {
/* 752 */       return (InvocationRequest)obj;
/*     */     }
/*     */ 
/* 757 */     SocketAddress remoteAddress = socketWrapper.getSocket().getRemoteSocketAddress();
/*     */ 
/* 759 */     return new InvocationRequest(remoteAddress.toString(), this.invoker.getSupportedSubsystems()[0], obj, null, null, null);
/*     */   }
/*     */ 
/*     */   private void processNewSocket()
/*     */   {
/* 767 */     InvokerLocator locator = this.invoker.getLocator();
/* 768 */     ClassLoader classLoader = getClass().getClassLoader();
/* 769 */     String dataType = this.invoker.getDataType();
/* 770 */     String serializationType = this.invoker.getSerializationType();
/*     */ 
/* 774 */     if (this.unmarshaller == null)
/*     */     {
/* 776 */       this.unmarshaller = MarshalFactory.getUnMarshaller(locator, classLoader);
/*     */     }
/* 778 */     if (this.unmarshaller == null)
/*     */     {
/* 780 */       this.unmarshaller = MarshalFactory.getUnMarshaller(dataType, serializationType);
/*     */     }
/*     */ 
/* 783 */     if (this.marshaller == null)
/*     */     {
/* 785 */       this.marshaller = MarshalFactory.getMarshaller(locator, classLoader);
/*     */     }
/* 787 */     if (this.marshaller == null)
/*     */     {
/* 789 */       this.marshaller = MarshalFactory.getMarshaller(dataType, serializationType);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void versionedWrite(OutputStream outputStream, SocketServerInvoker invoker, ClassLoader classLoader, Object resp, int version)
/*     */     throws IOException
/*     */   {
/* 799 */     switch (version)
/*     */     {
/*     */     case 1:
/*     */     case 2:
/*     */     case 22:
/* 805 */       if ((this.marshaller instanceof VersionedMarshaller))
/* 806 */         ((VersionedMarshaller)this.marshaller).write(resp, outputStream, version);
/*     */       else
/* 808 */         this.marshaller.write(resp, outputStream);
/* 809 */       if (trace) log.trace("wrote response to the output stream");
/* 810 */       return;
/*     */     }
/*     */ 
/* 814 */     throw new IOException("Can not write data for version " + version + ".  Supported version: " + 1 + ", " + 2 + ", " + 22);
/*     */   }
/*     */ 
/*     */   private int readVersion(InputStream inputStream)
/*     */     throws IOException
/*     */   {
/* 822 */     if (trace) log.trace("blocking to read version from input stream");
/*     */ 
/* 824 */     int version = inputStream.read();
/*     */ 
/* 826 */     if (trace) log.trace("read version " + version + " from input stream");
/*     */ 
/* 828 */     return version;
/*     */   }
/*     */ 
/*     */   private void writeVersion(OutputStream outputStream, int version) throws IOException
/*     */   {
/* 833 */     outputStream.write(version);
/*     */   }
/*     */ 
/*     */   private String getWorkerThreadName(Socket currentSocket)
/*     */   {
/* 838 */     if (this.id == -2147483648)
/*     */     {
/* 840 */       this.id = nextID();
/*     */     }
/*     */ 
/* 843 */     StringBuffer sb = new StringBuffer("WorkerThread#");
/* 844 */     sb.append(this.id).append('[');
/* 845 */     sb.append(currentSocket.getInetAddress().getHostAddress());
/* 846 */     sb.append(':');
/* 847 */     sb.append(currentSocket.getPort());
/* 848 */     sb.append(']');
/*     */ 
/* 850 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public static class AcknowledgeFailure extends Exception
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.socket.ServerThread
 * JD-Core Version:    0.6.0
 */