/*     */ package org.jboss.remoting.transport.socket;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class ServerAddress
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -7206359745950445445L;
/*     */   public String address;
/*     */   public int port;
/*  58 */   public boolean enableTcpNoDelay = false;
/*     */ 
/*  63 */   public int timeout = 60000;
/*     */   public int maxPoolSize;
/*     */   private transient int hashCode;
/*     */ 
/*     */   public ServerAddress(String address, int port, boolean enableTcpNoDelay, int timeout, int maxPoolSize)
/*     */   {
/*  80 */     this.address = address;
/*  81 */     this.port = port;
/*  82 */     this.enableTcpNoDelay = enableTcpNoDelay;
/*  83 */     this.hashCode = (address.hashCode() + port);
/*  84 */     if (enableTcpNoDelay)
/*     */     {
/*  86 */       this.hashCode += 1;
/*     */     }
/*  88 */     if (timeout >= 0)
/*     */     {
/*  90 */       this.timeout = timeout;
/*     */     }
/*  92 */     this.hashCode = (7 * this.hashCode + timeout);
/*  93 */     this.maxPoolSize = maxPoolSize;
/*  94 */     this.hashCode = (11 * this.hashCode + maxPoolSize);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  99 */     return "ServerAddress[" + this.address + ":" + this.port + (this.enableTcpNoDelay ? ", enableTcpNoDelay" : ", NO enableTcpNoDelay") + " timeout " + this.timeout + " ms" + ", maxPoolSize=" + this.maxPoolSize + "]";
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*     */     try
/*     */     {
/* 109 */       ServerAddress o = (ServerAddress)obj;
/*     */ 
/* 111 */       if (this.port != o.port)
/*     */       {
/* 113 */         return false;
/*     */       }
/*     */ 
/* 116 */       if (!this.address.equals(o.address))
/*     */       {
/* 118 */         return false;
/*     */       }
/*     */ 
/* 121 */       if (this.enableTcpNoDelay != o.enableTcpNoDelay)
/*     */       {
/* 123 */         return false;
/*     */       }
/*     */ 
/* 126 */       if (this.timeout != o.timeout)
/*     */       {
/* 128 */         return false;
/*     */       }
/*     */ 
/* 133 */       return this.maxPoolSize == o.maxPoolSize;
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*     */     }
/*     */ 
/* 140 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 146 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 160 */     in.defaultReadObject();
/*     */ 
/* 162 */     this.hashCode = (this.address.hashCode() + this.port);
/* 163 */     if (this.enableTcpNoDelay)
/*     */     {
/* 165 */       this.hashCode += 1;
/*     */     }
/* 167 */     this.hashCode = (7 * this.hashCode + this.timeout);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.socket.ServerAddress
 * JD-Core Version:    0.6.0
 */