/*     */ package org.jboss.remoting.transport.socket;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.net.Socket;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.PreferredStreamMarshaller;
/*     */ import org.jboss.remoting.marshal.PreferredStreamUnMarshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ 
/*     */ public class ClientSocketWrapper extends SocketWrapper
/*     */   implements OpenConnectionChecker
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(ClientSocketWrapper.class);
/*     */ 
/*  48 */   private static boolean trace = log.isTraceEnabled();
/*     */   private InputStream in;
/*     */   private OutputStream out;
/*     */ 
/*     */   public ClientSocketWrapper(Socket socket)
/*     */     throws IOException
/*     */   {
/*  59 */     super(socket);
/*  60 */     createStreams(socket, null);
/*     */   }
/*     */ 
/*     */   public ClientSocketWrapper(Socket socket, Map metadata, Integer timeout) throws Exception
/*     */   {
/*  65 */     super(socket, timeout);
/*  66 */     createStreams(socket, metadata);
/*     */   }
/*     */ 
/*     */   public OutputStream getOutputStream()
/*     */   {
/*  73 */     return this.out;
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream()
/*     */   {
/*  78 */     return this.in;
/*     */   }
/*     */ 
/*     */   public void checkConnection()
/*     */     throws IOException
/*     */   {
/*  84 */     byte ACK = 1;
/*     */ 
/*  91 */     this.out.write(1);
/*  92 */     this.out.flush();
/*  93 */     int i = this.in.read();
/*  94 */     if (trace) log.trace(this + " got " + i + " while checking connection");
/*     */   }
/*     */ 
/*     */   public void checkOpenConnection()
/*     */     throws IOException
/*     */   {
/* 101 */     log.trace("checking open connection");
/* 102 */     if (this.in.available() > 1)
/*     */     {
/* 104 */       log.debug("remote endpoint has closed");
/* 105 */       throw new IOException("remote endpoint has closed");
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 113 */     Socket socket = getSocket();
/* 114 */     return "ClientSocketWrapper[" + socket + "." + Integer.toHexString(System.identityHashCode(socket)) + "]";
/*     */   }
/*     */ 
/*     */   protected void createStreams(Socket socket, Map metadata)
/*     */     throws IOException
/*     */   {
/* 125 */     String serializationType = "java";
/*     */ 
/* 127 */     if (metadata != null)
/*     */     {
/* 129 */       String serializationTypeParam = (String)metadata.get("serializationtype");
/* 130 */       if ((serializationTypeParam == null) || (serializationTypeParam.length() == 0))
/*     */       {
/* 132 */         serializationTypeParam = (String)metadata.get("serializationType");
/*     */       }
/* 134 */       if ((serializationTypeParam != null) && (serializationTypeParam.length() > 0))
/*     */       {
/* 136 */         serializationType = serializationTypeParam;
/*     */       }
/*     */     }
/*     */ 
/* 140 */     Marshaller marshaller = null;
/* 141 */     UnMarshaller unmarshaller = null;
/* 142 */     int tempTimeout = -1;
/* 143 */     int savedTimeout = getTimeout();
/*     */ 
/* 145 */     if (metadata != null)
/*     */     {
/* 147 */       marshaller = (Marshaller)metadata.get("marshaller");
/* 148 */       unmarshaller = (UnMarshaller)metadata.get("unmarshaller");
/* 149 */       Object o = metadata.get("temptimeout");
/* 150 */       if ((o instanceof Integer))
/*     */       {
/* 152 */         tempTimeout = ((Integer)o).intValue();
/* 153 */         if (tempTimeout != -1)
/*     */         {
/* 155 */           socket.setSoTimeout(tempTimeout);
/* 156 */           log.debug("set temp timeout to: " + tempTimeout);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 163 */       this.out = createOutputStream(serializationType, socket, marshaller);
/* 164 */       this.in = createInputStream(serializationType, socket, unmarshaller);
/*     */     }
/*     */     finally
/*     */     {
/* 168 */       setTimeout(savedTimeout);
/* 169 */       log.debug("reset timeout: " + savedTimeout);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected InputStream createInputStream(String serializationType, Socket socket, UnMarshaller unmarshaller)
/*     */     throws IOException
/*     */   {
/* 176 */     if (trace) log.trace(this + " getting input stream from " + socket + ", " + unmarshaller);
/*     */ 
/* 178 */     if (unmarshaller == null) {
/* 179 */       log.warn("got null unmarshaller");
/*     */     }
/* 181 */     InputStream is = socket.getInputStream();
/* 182 */     if ((unmarshaller instanceof PreferredStreamUnMarshaller))
/*     */     {
/* 184 */       PreferredStreamUnMarshaller psum = (PreferredStreamUnMarshaller)unmarshaller;
/* 185 */       is = psum.getMarshallingStream(is);
/*     */     }
/*     */ 
/* 188 */     return is;
/*     */   }
/*     */ 
/*     */   protected OutputStream createOutputStream(String serializationType, Socket socket, Marshaller marshaller)
/*     */     throws IOException
/*     */   {
/* 194 */     if (trace) log.trace(this + " getting output stream from " + socket + ", " + marshaller);
/*     */ 
/* 197 */     if (marshaller == null) {
/* 198 */       log.warn("got null marshaller");
/*     */     }
/* 200 */     OutputStream os = socket.getOutputStream();
/* 201 */     if ((marshaller instanceof PreferredStreamMarshaller))
/*     */     {
/* 203 */       PreferredStreamMarshaller psm = (PreferredStreamMarshaller)marshaller;
/* 204 */       os = psm.getMarshallingStream(os);
/*     */     }
/*     */ 
/* 207 */     return os;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.socket.ClientSocketWrapper
 * JD-Core Version:    0.6.0
 */