/*     */ package org.jboss.remoting.transport.servlet.web;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import javax.management.MBeanServerInvocationHandler;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.servlet.ServletConfig;
/*     */ import javax.servlet.ServletException;
/*     */ import javax.servlet.ServletInputStream;
/*     */ import javax.servlet.ServletOutputStream;
/*     */ import javax.servlet.http.HttpServlet;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import javax.servlet.http.HttpServletResponse;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.InvokerRegistry;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.transport.servlet.ServletServerInvokerMBean;
/*     */ 
/*     */ public class ServerInvokerServlet extends HttpServlet
/*     */ {
/*  54 */   private static Logger log = Logger.getLogger(ServerInvokerServlet.class);
/*     */   private ServletServerInvokerMBean servletInvoker;
/*     */   private static final long serialVersionUID = 8796224225710165263L;
/*     */ 
/*     */   public void init(ServletConfig config)
/*     */     throws ServletException
/*     */   {
/*  63 */     super.init(config);
/*     */ 
/*  66 */     this.servletInvoker = getInvokerFromInvokerUrl(config);
/*     */ 
/*  68 */     if (this.servletInvoker == null)
/*     */     {
/*  70 */       this.servletInvoker = getInvokerFromInvokerName(config);
/*     */ 
/*  72 */       if (this.servletInvoker == null)
/*     */       {
/*  74 */         throw new ServletException("Could not find init parameter for 'locatorUrl' or 'locatorName' - one of which must be supplied for ServerInvokerServlet to function.");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void processRequest(HttpServletRequest request, HttpServletResponse response)
/*     */     throws ServletException, IOException
/*     */   {
/*  97 */     boolean trace = log.isTraceEnabled();
/*  98 */     if (trace)
/*     */     {
/* 100 */       log.trace("processRequest, ContentLength: " + request.getContentLength());
/* 101 */       log.trace("processRequest, ContentType: " + request.getContentType());
/*     */     }
/*     */ 
/* 104 */     int bufferSize = 1024;
/* 105 */     byte[] byteBuffer = new byte[bufferSize];
/* 106 */     ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
/*     */ 
/* 108 */     int pointer = 0;
/* 109 */     int contentLength = request.getContentLength();
/* 110 */     ServletInputStream inputStream = request.getInputStream();
/* 111 */     int amtRead = inputStream.read(byteBuffer);
/*     */ 
/* 113 */     while (amtRead > 0)
/*     */     {
/* 115 */       byteOutputStream.write(byteBuffer, pointer, amtRead);
/*     */ 
/* 117 */       if ((amtRead < bufferSize) && (byteOutputStream.size() >= contentLength))
/*     */       {
/*     */         break;
/*     */       }
/*     */ 
/* 122 */       amtRead = inputStream.read(byteBuffer);
/*     */     }
/* 124 */     byteOutputStream.flush();
/* 125 */     byte[] totalByteArray = byteOutputStream.toByteArray();
/*     */ 
/* 127 */     byte[] out = this.servletInvoker.processRequest(request, totalByteArray, response);
/* 128 */     ServletOutputStream outStream = response.getOutputStream();
/* 129 */     outStream.write(out);
/* 130 */     outStream.flush();
/* 131 */     outStream.close();
/*     */   }
/*     */ 
/*     */   protected void doGet(HttpServletRequest request, HttpServletResponse response)
/*     */     throws ServletException, IOException
/*     */   {
/* 144 */     processRequest(request, response);
/*     */   }
/*     */ 
/*     */   protected void doPost(HttpServletRequest request, HttpServletResponse response)
/*     */     throws ServletException, IOException
/*     */   {
/* 156 */     processRequest(request, response);
/*     */   }
/*     */ 
/*     */   public String getServletInfo()
/*     */   {
/* 164 */     return "Servlet front to JBossRemoting servlet server invoker.";
/*     */   }
/*     */ 
/*     */   protected ServletServerInvokerMBean getInvokerFromInvokerUrl(ServletConfig config)
/*     */     throws ServletException
/*     */   {
/* 179 */     String locatorUrl = config.getInitParameter("locatorUrl");
/* 180 */     if (locatorUrl == null)
/*     */     {
/* 182 */       return null;
/*     */     }
/*     */ 
/* 185 */     ServerInvoker[] serverInvokers = InvokerRegistry.getServerInvokers();
/* 186 */     if ((serverInvokers != null) && (serverInvokers.length > 0))
/*     */     {
/* 188 */       for (int x = 0; x < serverInvokers.length; x++)
/*     */       {
/* 190 */         ServerInvoker svrInvoker = serverInvokers[x];
/* 191 */         InvokerLocator locator = svrInvoker.getLocator();
/* 192 */         if (locatorUrl.equalsIgnoreCase(locator.getOriginalURI()))
/*     */         {
/* 194 */           return (ServletServerInvokerMBean)svrInvoker;
/*     */         }
/*     */       }
/*     */ 
/* 198 */       throw new ServletException("Can not find servlet server invoker with same locator as specified (" + locatorUrl + ")");
/*     */     }
/*     */ 
/* 201 */     throw new ServletException("Can not find any server invokers registered.  Could be that servlet server invoker not registered or has been created using different classloader.");
/*     */   }
/*     */ 
/*     */   protected ServletServerInvokerMBean getInvokerFromInvokerName(ServletConfig config)
/*     */     throws ServletException
/*     */   {
/* 218 */     ObjectName localInvokerName = null;
/*     */ 
/* 220 */     String name = config.getInitParameter("invokerName");
/* 221 */     if (name == null)
/*     */     {
/* 223 */       return null;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 228 */       localInvokerName = new ObjectName(name);
/* 229 */       log.debug("localInvokerName=" + localInvokerName);
/*     */     }
/*     */     catch (MalformedObjectNameException e)
/*     */     {
/* 233 */       throw new ServletException("Failed to build invokerName", e);
/*     */     }
/*     */ 
/* 237 */     MBeanServer mbeanServer = getMBeanServer();
/* 238 */     if (mbeanServer == null)
/*     */     {
/* 240 */       throw new ServletException("Failed to locate the MBeanServer");
/*     */     }
/*     */ 
/* 243 */     return (ServletServerInvokerMBean)MBeanServerInvocationHandler.newProxyInstance(mbeanServer, localInvokerName, ServletServerInvokerMBean.class, false);
/*     */   }
/*     */ 
/*     */   protected MBeanServer getMBeanServer()
/*     */   {
/* 267 */     for (Iterator i = MBeanServerFactory.findMBeanServer(null).iterator(); i.hasNext(); )
/*     */     {
/* 269 */       MBeanServer server = (MBeanServer)i.next();
/* 270 */       if (server.getDefaultDomain().equals("jboss"))
/*     */       {
/* 272 */         return server;
/*     */       }
/*     */     }
/* 275 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.servlet.web.ServerInvokerServlet
 * JD-Core Version:    0.6.0
 */