/*     */ package org.jboss.remoting.transport.multiplex.utility;
/*     */ 
/*     */ public abstract class StoppableThread extends Thread
/*     */ {
/*  40 */   protected boolean running = false;
/*  41 */   protected boolean stopped = true;
/*  42 */   protected boolean terminatedOnError = false;
/*     */ 
/*     */   public void run()
/*     */   {
/*  49 */     this.running = true;
/*  50 */     this.stopped = false;
/*  51 */     doInit();
/*     */ 
/*  53 */     while (this.running) {
/*  54 */       doRun();
/*     */     }
/*  56 */     doShutDown();
/*  57 */     this.stopped = true;
/*     */   }
/*     */ 
/*     */   protected abstract void doInit();
/*     */ 
/*     */   protected abstract void doRun();
/*     */ 
/*     */   protected abstract void doShutDown();
/*     */ 
/*     */   public synchronized boolean isRunning()
/*     */   {
/*  85 */     return this.running;
/*     */   }
/*     */ 
/*     */   public synchronized boolean isStopped()
/*     */   {
/*  95 */     return this.stopped;
/*     */   }
/*     */ 
/*     */   public synchronized void shutdown()
/*     */   {
/* 104 */     this.running = false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.utility.StoppableThread
 * JD-Core Version:    0.6.0
 */