/*     */ package org.jboss.remoting.transport.multiplex.utility;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ 
/*     */ public class ShrinkableByteArrayOutputStream extends ByteArrayOutputStream
/*     */ {
/*  62 */   private static int MIN_LENGTH = 1024;
/*  63 */   private int used = 0;
/*  64 */   private int nextUsed = 0;
/*  65 */   private int bytesReturned = 0;
/*     */ 
/*     */   public ShrinkableByteArrayOutputStream()
/*     */   {
/*  73 */     super(MIN_LENGTH);
/*     */   }
/*     */ 
/*     */   public ShrinkableByteArrayOutputStream(int size)
/*     */   {
/*  82 */     super(size);
/*     */   }
/*     */ 
/*     */   public int available()
/*     */   {
/*  92 */     return this.count - this.nextUsed;
/*     */   }
/*     */ 
/*     */   public int bytesReturned()
/*     */   {
/* 102 */     return this.bytesReturned;
/*     */   }
/*     */ 
/*     */   public int start()
/*     */   {
/* 114 */     return this.used;
/*     */   }
/*     */ 
/*     */   public byte[] toByteArray(int length)
/*     */   {
/* 125 */     this.used = this.nextUsed;
/* 126 */     int currentLength = this.buf.length;
/* 127 */     int quarterLength = currentLength >> 2;
/*     */ 
/* 129 */     if ((currentLength > MIN_LENGTH) && (currentLength - this.used <= quarterLength))
/*     */     {
/* 131 */       byte[] newbuf = new byte[currentLength >> 1];
/* 132 */       System.arraycopy(this.buf, this.used, newbuf, 0, available());
/* 133 */       this.buf = newbuf;
/* 134 */       this.count -= this.used;
/* 135 */       this.used = 0;
/*     */     }
/*     */ 
/* 138 */     this.bytesReturned = Math.min(this.count - this.used, length);
/* 139 */     this.nextUsed = (this.used + this.bytesReturned);
/* 140 */     return this.buf;
/*     */   }
/*     */ 
/*     */   public void write(int b)
/*     */   {
/* 151 */     if ((this.count == this.buf.length) && (this.used > this.buf.length >> 1))
/*     */     {
/* 153 */       System.arraycopy(this.buf, this.used, this.buf, 0, this.count - this.used);
/* 154 */       this.nextUsed -= this.used;
/* 155 */       this.count -= this.used;
/* 156 */       this.used = 0;
/*     */     }
/*     */ 
/* 159 */     super.write(b);
/*     */   }
/*     */ 
/*     */   public void write(byte[] b, int off, int len)
/*     */   {
/* 173 */     if ((this.count + len > this.buf.length) && (this.used > this.buf.length >> 1))
/*     */     {
/* 175 */       System.arraycopy(this.buf, this.used, this.buf, 0, this.count - this.used);
/* 176 */       this.nextUsed -= this.used;
/* 177 */       this.count -= this.used;
/* 178 */       this.used = 0;
/*     */     }
/*     */ 
/* 181 */     super.write(b, off, len);
/*     */   }
/*     */ 
/*     */   protected int getCount()
/*     */   {
/* 187 */     return super.size();
/*     */   }
/*     */ 
/*     */   protected int getLength()
/*     */   {
/* 193 */     return this.buf.length;
/*     */   }
/*     */ 
/*     */   protected int getNextUsed()
/*     */   {
/* 199 */     return this.nextUsed;
/*     */   }
/*     */ 
/*     */   protected int getUsed()
/*     */   {
/* 205 */     return this.used;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.utility.ShrinkableByteArrayOutputStream
 * JD-Core Version:    0.6.0
 */