/*     */ package org.jboss.remoting.transport.multiplex.utility;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ 
/*     */ public class GrowablePipedOutputStream extends OutputStream
/*     */ {
/*     */   private GrowablePipedInputStream sink;
/*     */   private boolean connected;
/*     */ 
/*     */   public GrowablePipedOutputStream()
/*     */   {
/*     */   }
/*     */ 
/*     */   public GrowablePipedOutputStream(GrowablePipedInputStream sink)
/*     */     throws IOException
/*     */   {
/*  76 */     this.sink = sink;
/*  77 */     sink.connect(this);
/*  78 */     this.connected = true;
/*     */   }
/*     */ 
/*     */   public void write(int b)
/*     */     throws IOException
/*     */   {
/*  84 */     if (this.sink == null) {
/*  85 */       throw new IOException("Pipe not connected");
/*     */     }
/*  87 */     this.sink.receive(b);
/*     */   }
/*     */ 
/*     */   public void write(byte[] bytes)
/*     */     throws IOException
/*     */   {
/*  93 */     if (this.sink == null) {
/*  94 */       throw new IOException("Pipe not connected");
/*     */     }
/*  96 */     if (bytes == null) {
/*  97 */       throw new NullPointerException();
/*     */     }
/*  99 */     this.sink.receive(bytes);
/*     */   }
/*     */ 
/*     */   public void write(byte[] bytes, int offset, int length)
/*     */     throws IOException
/*     */   {
/* 105 */     if (this.sink == null) {
/* 106 */       throw new IOException("Pipe not connected");
/*     */     }
/* 108 */     if (bytes == null) {
/* 109 */       throw new NullPointerException();
/*     */     }
/* 111 */     if ((offset < 0) || (offset > bytes.length) || (length < 0) || (offset + length > bytes.length) || (offset + length < 0))
/*     */     {
/* 113 */       throw new IndexOutOfBoundsException("offset = " + offset + ", length = " + length + ", file buffer size: " + bytes.length);
/*     */     }
/*     */ 
/* 117 */     if (length == 0) {
/* 118 */       return;
/*     */     }
/* 120 */     this.sink.receive(bytes, offset, length);
/*     */   }
/*     */ 
/*     */   protected void connect(GrowablePipedInputStream sink)
/*     */     throws IOException
/*     */   {
/* 126 */     if (sink == null) {
/* 127 */       throw new NullPointerException();
/*     */     }
/* 129 */     if (sink.isConnected()) {
/* 130 */       throw new IOException("Already connected");
/*     */     }
/* 132 */     this.sink = sink;
/* 133 */     this.connected = true;
/*     */   }
/*     */ 
/*     */   protected boolean isConnected()
/*     */   {
/* 139 */     return this.connected;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.utility.GrowablePipedOutputStream
 * JD-Core Version:    0.6.0
 */