/*     */ package org.jboss.remoting.transport.multiplex.utility;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ 
/*     */ public class AddressPair
/*     */ {
/*     */   private InetAddress localHost;
/*     */   private int localPort;
/*     */   private InetAddress remoteHost;
/*     */   private int remotePort;
/*  50 */   private boolean hashCodeSet = false;
/*     */   private int hashCode;
/*     */ 
/*     */   public AddressPair(String remoteHost, int remotePort, String localHost, int localPort)
/*     */     throws IOException
/*     */   {
/*  64 */     this.localHost = InetAddress.getByName(localHost);
/*  65 */     this.localPort = localPort;
/*  66 */     this.remoteHost = InetAddress.getByName(remoteHost);
/*  67 */     this.remotePort = remotePort;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/*  76 */     if (o == null) {
/*  77 */       return false;
/*     */     }
/*  79 */     if (!(o instanceof AddressPair)) {
/*  80 */       return false;
/*     */     }
/*  82 */     AddressPair ap = (AddressPair)o;
/*     */ 
/*  84 */     return (this.localHost.equals(ap.localHost)) && (this.localPort == ap.localPort) && (this.remoteHost.equals(ap.remoteHost)) && (this.remotePort == ap.remotePort);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  96 */     if (!this.hashCodeSet)
/*     */     {
/*  98 */       this.hashCode = (this.localHost.hashCode() * this.localPort + this.remoteHost.hashCode() * this.remotePort);
/*  99 */       this.hashCodeSet = true;
/*     */     }
/*     */ 
/* 102 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public String getLocalHost()
/*     */   {
/* 113 */     return this.localHost.getHostName();
/*     */   }
/*     */ 
/*     */   public int getLocalPort()
/*     */   {
/* 124 */     return this.localPort;
/*     */   }
/*     */ 
/*     */   public String getRemoteHost()
/*     */   {
/* 135 */     return this.remoteHost.getHostName();
/*     */   }
/*     */ 
/*     */   public int getRemotePort()
/*     */   {
/* 146 */     return this.remotePort;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.utility.AddressPair
 * JD-Core Version:    0.6.0
 */