/*     */ package org.jboss.remoting.transport.multiplex;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.InetAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.UnknownHostException;
/*     */ import javax.net.SocketFactory;
/*     */ 
/*     */ public class VirtualSocketFactory extends SocketFactory
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 3422810508320563967L;
/*     */ 
/*     */   public static SocketFactory getDefault()
/*     */   {
/*  55 */     return new VirtualSocketFactory();
/*     */   }
/*     */ 
/*     */   public Socket createSocket()
/*     */   {
/*  72 */     return new VirtualSocket();
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String host, int port)
/*     */     throws IOException, UnknownHostException
/*     */   {
/*  81 */     return new VirtualSocket(host, port);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String host, int port, InetAddress localAddress, int localPort)
/*     */     throws IOException, UnknownHostException
/*     */   {
/*  91 */     return new VirtualSocket(host, port, localAddress, localPort);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress address, int port)
/*     */     throws IOException
/*     */   {
/* 100 */     return new VirtualSocket(address, port);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort)
/*     */     throws IOException, UnknownHostException
/*     */   {
/* 110 */     return new VirtualSocket(address, port, localAddress, localPort);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.VirtualSocketFactory
 * JD-Core Version:    0.6.0
 */