/*      */ package org.jboss.remoting.transport.multiplex;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.OutputStream;
/*      */ import java.net.InetAddress;
/*      */ import java.net.InetSocketAddress;
/*      */ import java.net.Socket;
/*      */ import java.net.SocketAddress;
/*      */ import java.net.SocketException;
/*      */ import java.net.SocketImpl;
/*      */ import java.net.SocketTimeoutException;
/*      */ import java.net.UnknownHostException;
/*      */ import java.nio.channels.SocketChannel;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import org.jboss.logging.Logger;
/*      */ 
/*      */ public class VirtualSocket extends Socket
/*      */ {
/*   64 */   protected static final Logger log = Logger.getLogger(VirtualSocket.class);
/*      */   protected static Thread closingThread;
/*   67 */   private Map configuration = new HashMap();
/*      */   private MultiplexingManager manager;
/*      */   private Protocol protocol;
/*      */   private Socket actualSocket;
/*      */   private SocketId remoteSocketId;
/*      */   private SocketId localSocketId;
/*      */   private MultiplexingInputStream inputStream;
/*      */   private MultiplexingOutputStream outputStream;
/*   75 */   private Set disconnectListeners = new HashSet();
/*      */ 
/*   77 */   private boolean bound = false;
/*   78 */   private boolean closed = false;
/*   79 */   private boolean connected = false;
/*   80 */   private boolean inputShutdown = false;
/*   81 */   private boolean outputShutdown = false;
/*   82 */   private boolean receivedDisconnectMessage = false;
/*      */   private int timeout;
/*      */   private Socket dummySocket;
/*   87 */   private boolean functional = true;
/*      */   private boolean trace;
/*      */   private boolean debug;
/*      */   private boolean info;
/*      */ 
/*      */   public VirtualSocket(MultiplexingManager manager, SocketId remoteSocketId, Map configuration)
/*      */     throws IOException
/*      */   {
/*  107 */     this.manager = manager;
/*  108 */     this.actualSocket = manager.getSocket();
/*  109 */     this.remoteSocketId = remoteSocketId;
/*  110 */     this.configuration.putAll(configuration);
/*  111 */     this.protocol = manager.getProtocol();
/*  112 */     this.localSocketId = new SocketId();
/*  113 */     this.inputStream = manager.registerSocket(this);
/*      */ 
/*  115 */     this.outputStream = manager.getAnOutputStream(this, remoteSocketId);
/*  116 */     this.bound = true;
/*  117 */     this.connected = true;
/*      */ 
/*  119 */     this.trace = log.isTraceEnabled();
/*  120 */     this.debug = log.isDebugEnabled();
/*  121 */     this.info = log.isInfoEnabled();
/*  122 */     if (this.debug) log.debug("created virtual socket on port: " + this.localSocketId.getPort());
/*      */   }
/*      */ 
/*      */   public VirtualSocket(Map configuration)
/*      */   {
/*  128 */     this.configuration.putAll(configuration);
/*      */   }
/*      */ 
/*      */   public VirtualSocket()
/*      */   {
/*  141 */     log.debug("created unbound virtual socket");
/*      */   }
/*      */ 
/*      */   public VirtualSocket(String host, int port)
/*      */     throws UnknownHostException, IOException
/*      */   {
/*  150 */     InetSocketAddress address = null;
/*      */ 
/*  152 */     if (host == null)
/*  153 */       address = new InetSocketAddress(InetAddress.getByName(null), port);
/*      */     else {
/*  155 */       address = new InetSocketAddress(host, port);
/*      */     }
/*  157 */     connect(address);
/*  158 */     if (this.debug) log.debug("created virtual socket on port: " + this.localSocketId.getPort());
/*      */   }
/*      */ 
/*      */   public VirtualSocket(String host, int port, boolean stream)
/*      */     throws IOException
/*      */   {
/*  171 */     if (!stream)
/*      */     {
/*  173 */       throw new SocketException("Deprecated: use DataGramSocket instead of stream = false");
/*      */     }
/*      */ 
/*  176 */     InetSocketAddress address = null;
/*      */ 
/*  178 */     if (host == null)
/*  179 */       address = new InetSocketAddress(InetAddress.getByName(null), port);
/*      */     else {
/*  181 */       address = new InetSocketAddress(host, port);
/*      */     }
/*  183 */     connect(address);
/*  184 */     if (this.debug) log.debug("created virtual socket on port: " + this.localSocketId.getPort());
/*      */   }
/*      */ 
/*      */   public VirtualSocket(InetAddress address, int port)
/*      */     throws IOException
/*      */   {
/*  196 */     connect(new InetSocketAddress(address, port));
/*  197 */     if (this.debug) log.debug("created virtual socket on port: " + this.localSocketId.getPort());
/*      */   }
/*      */ 
/*      */   public VirtualSocket(InetAddress host, int port, boolean stream)
/*      */     throws IOException
/*      */   {
/*  210 */     if (!stream)
/*      */     {
/*  212 */       throw new SocketException("Deprecated: use DataGramSocket instead of stream = false");
/*      */     }
/*      */ 
/*  215 */     connect(new InetSocketAddress(host, port));
/*  216 */     if (this.debug) log.debug("created virtual socket on port: " + this.localSocketId.getPort());
/*      */   }
/*      */ 
/*      */   public VirtualSocket(SocketImpl impl)
/*      */     throws SocketException
/*      */   {
/*  228 */     throw new SocketException("VirtualSocket does not use SocketImpl");
/*      */   }
/*      */ 
/*      */   public VirtualSocket(String host, int port, InetAddress localAddr, int localPort)
/*      */     throws IOException
/*      */   {
/*  242 */     this(InetAddress.getByName(host), port, localAddr, localPort);
/*      */   }
/*      */ 
/*      */   public VirtualSocket(InetAddress address, int port, InetAddress localAddr, int localPort)
/*      */     throws IOException
/*      */   {
/*  256 */     this();
/*  257 */     connect(new InetSocketAddress(address, port), new InetSocketAddress(localAddr, localPort), 0);
/*  258 */     if (this.debug) log.debug("created virtual socket on port: " + this.localSocketId.getPort());
/*      */   }
/*      */ 
/*      */   public void bind(SocketAddress address)
/*      */     throws IOException
/*      */   {
/*  319 */     if (isClosed()) {
/*  320 */       throw new SocketException("Socket is closed");
/*      */     }
/*  322 */     if (isBound()) {
/*  323 */       throw new SocketException("Already bound");
/*      */     }
/*  325 */     if ((address != null) && (!(address instanceof InetSocketAddress))) {
/*  326 */       throw new IllegalArgumentException("Unsupported address type");
/*      */     }
/*  328 */     InetSocketAddress inetAddress = (InetSocketAddress)address;
/*      */ 
/*  330 */     if ((inetAddress != null) && (inetAddress.isUnresolved())) {
/*  331 */       throw new SocketException("Unresolved address");
/*      */     }
/*  333 */     this.manager = MultiplexingManager.getaManagerByLocalAddress(inetAddress, this.configuration);
/*  334 */     this.actualSocket = this.manager.getSocket();
/*  335 */     this.localSocketId = new SocketId();
/*  336 */     if (this.debug) log.debug("bound virtual socket to port: " + this.localSocketId.getPort());
/*  337 */     this.bound = true;
/*      */   }
/*      */ 
/*      */   public void close()
/*      */     throws IOException
/*      */   {
/*  346 */     if (this.closed) {
/*  347 */       return;
/*      */     }
/*  349 */     log.debug("closing: " + this.localSocketId);
/*  350 */     this.closed = true;
/*      */ 
/*  352 */     if ((this.connected) && (!this.receivedDisconnectMessage)) {
/*  353 */       this.protocol.disconnect(this.remoteSocketId);
/*      */     }
/*  355 */     if (this.inputStream != null) {
/*  356 */       this.inputStream.close();
/*      */     }
/*  358 */     if (this.outputStream != null)
/*      */     {
/*  360 */       this.outputStream.flush();
/*  361 */       this.outputStream.close();
/*      */     }
/*      */ 
/*  364 */     if (this.localSocketId != null) {
/*  365 */       this.localSocketId.releasePort();
/*      */     }
/*      */ 
/*  368 */     if (this.manager.isSocketRegistered(this.localSocketId))
/*      */     {
/*  370 */       MultiplexingManager.addToPendingActions(new PendingClose(this));
/*      */     }
/*      */ 
/*  373 */     if (this.debug) log.debug("virtual socket closed on port: " + this.localSocketId.getPort());
/*      */   }
/*      */ 
/*      */   public void connect(SocketAddress socketAddress)
/*      */     throws IOException
/*      */   {
/*  382 */     connect(socketAddress, null, this.timeout);
/*      */   }
/*      */ 
/*      */   public void connect(SocketAddress socketAddress, int timeout)
/*      */     throws IOException
/*      */   {
/*  391 */     connect(socketAddress, null, timeout);
/*      */   }
/*      */ 
/*      */   public SocketChannel getChannel()
/*      */   {
/*  400 */     return null;
/*      */   }
/*      */ 
/*      */   public InetAddress getInetAddress()
/*      */   {
/*  409 */     if (this.actualSocket == null) {
/*  410 */       return null;
/*      */     }
/*  412 */     return this.actualSocket.getInetAddress();
/*      */   }
/*      */ 
/*      */   public InputStream getInputStream()
/*      */     throws IOException
/*      */   {
/*  421 */     if (isClosed()) {
/*  422 */       throw new SocketException("Socket is closed");
/*      */     }
/*  424 */     if ((this.actualSocket == null) || (!this.connected)) {
/*  425 */       throw new SocketException("Socket is not connected");
/*      */     }
/*  427 */     if (isInputShutdown()) {
/*  428 */       throw new SocketException("Socket input is shutdown");
/*      */     }
/*  430 */     return this.inputStream;
/*      */   }
/*      */ 
/*      */   public boolean getKeepAlive()
/*      */     throws SocketException
/*      */   {
/*  439 */     if (this.actualSocket == null) {
/*  440 */       return false;
/*      */     }
/*  442 */     return this.actualSocket.getKeepAlive();
/*      */   }
/*      */ 
/*      */   public InetAddress getLocalAddress()
/*      */   {
/*  452 */     if (this.actualSocket == null)
/*      */     {
/*  454 */       if (this.dummySocket == null) {
/*  455 */         this.dummySocket = new Socket();
/*      */       }
/*  457 */       return this.dummySocket.getLocalAddress();
/*      */     }
/*      */ 
/*  462 */     InetAddress address = this.actualSocket.getLocalAddress();
/*      */     try
/*      */     {
/*  465 */       if ("0.0.0.0".equals(address.getHostAddress()))
/*  466 */         return InetAddress.getByName("localhost");
/*      */     }
/*      */     catch (UnknownHostException e)
/*      */     {
/*  470 */       return address;
/*      */     }
/*      */ 
/*  473 */     return address;
/*      */   }
/*      */ 
/*      */   public int getLocalPort()
/*      */   {
/*  482 */     if (this.actualSocket == null) {
/*  483 */       return -1;
/*      */     }
/*  485 */     return this.actualSocket.getLocalPort();
/*      */   }
/*      */ 
/*      */   public SocketAddress getLocalSocketAddress()
/*      */   {
/*  494 */     if (this.actualSocket == null) {
/*  495 */       return null;
/*      */     }
/*  497 */     SocketAddress address = this.actualSocket.getLocalSocketAddress();
/*  498 */     InetSocketAddress socketAddress = null;
/*      */ 
/*  502 */     if ((address instanceof InetSocketAddress))
/*      */     {
/*  504 */       socketAddress = (InetSocketAddress)address;
/*  505 */       if (("0.0.0.0".equals(socketAddress.getHostName())) || (socketAddress.getAddress() == null))
/*      */       {
/*  507 */         return new InetSocketAddress("localhost", socketAddress.getPort());
/*      */       }
/*      */     }
/*  510 */     return address;
/*      */   }
/*      */ 
/*      */   public boolean getOOBInline()
/*      */     throws SocketException
/*      */   {
/*  519 */     return false;
/*      */   }
/*      */ 
/*      */   public OutputStream getOutputStream()
/*      */     throws IOException
/*      */   {
/*  528 */     if (isClosed()) {
/*  529 */       throw new SocketException("Socket is closed");
/*      */     }
/*  531 */     if ((this.actualSocket == null) || (!this.connected)) {
/*  532 */       throw new SocketException("Socket is not connected");
/*      */     }
/*  534 */     if (isOutputShutdown()) {
/*  535 */       throw new SocketException("Socket output is shutdown");
/*      */     }
/*      */ 
/*  539 */     return this.outputStream;
/*      */   }
/*      */ 
/*      */   public int getPort()
/*      */   {
/*  548 */     if (this.actualSocket == null) {
/*  549 */       return 0;
/*      */     }
/*  551 */     return this.actualSocket.getPort();
/*      */   }
/*      */ 
/*      */   public int getReceiveBufferSize()
/*      */     throws SocketException
/*      */   {
/*  560 */     if (this.actualSocket == null)
/*      */     {
/*  562 */       if (this.dummySocket == null) {
/*  563 */         this.dummySocket = new Socket();
/*      */       }
/*  565 */       return this.dummySocket.getReceiveBufferSize();
/*      */     }
/*      */ 
/*  568 */     return this.actualSocket.getReceiveBufferSize();
/*      */   }
/*      */ 
/*      */   public SocketAddress getRemoteSocketAddress()
/*      */   {
/*  577 */     if (this.actualSocket == null) {
/*  578 */       return null;
/*      */     }
/*  580 */     return this.actualSocket.getRemoteSocketAddress();
/*      */   }
/*      */ 
/*      */   public boolean getReuseAddress()
/*      */     throws SocketException
/*      */   {
/*  589 */     if (this.actualSocket == null) {
/*  590 */       return false;
/*      */     }
/*  592 */     return this.actualSocket.getReuseAddress();
/*      */   }
/*      */ 
/*      */   public int getSendBufferSize()
/*      */     throws SocketException
/*      */   {
/*  601 */     if (this.actualSocket == null)
/*      */     {
/*  603 */       if (this.dummySocket == null) {
/*  604 */         this.dummySocket = new Socket();
/*      */       }
/*  606 */       return this.dummySocket.getSendBufferSize();
/*      */     }
/*      */ 
/*  609 */     return this.actualSocket.getSendBufferSize();
/*      */   }
/*      */ 
/*      */   public int getSoLinger()
/*      */     throws SocketException
/*      */   {
/*  618 */     if (this.actualSocket == null) {
/*  619 */       return -1;
/*      */     }
/*  621 */     return this.actualSocket.getSoLinger();
/*      */   }
/*      */ 
/*      */   public int getSoTimeout()
/*      */     throws SocketException
/*      */   {
/*  630 */     if (isClosed()) {
/*  631 */       throw new SocketException("Socket is closed");
/*      */     }
/*  633 */     return this.timeout;
/*      */   }
/*      */ 
/*      */   public boolean getTcpNoDelay()
/*      */     throws SocketException
/*      */   {
/*  642 */     if (this.actualSocket == null) {
/*  643 */       return false;
/*      */     }
/*  645 */     return this.actualSocket.getTcpNoDelay();
/*      */   }
/*      */ 
/*      */   public int getTrafficClass()
/*      */     throws SocketException
/*      */   {
/*  654 */     if (this.actualSocket == null) {
/*  655 */       return 0;
/*      */     }
/*  657 */     return this.actualSocket.getTrafficClass();
/*      */   }
/*      */ 
/*      */   public boolean isBound()
/*      */   {
/*  666 */     return this.bound;
/*      */   }
/*      */ 
/*      */   public boolean isClosed()
/*      */   {
/*  675 */     return this.closed;
/*      */   }
/*      */ 
/*      */   public boolean isConnected()
/*      */   {
/*  684 */     return this.connected;
/*      */   }
/*      */ 
/*      */   public boolean isInputShutdown()
/*      */   {
/*  693 */     return this.inputShutdown;
/*      */   }
/*      */ 
/*      */   public boolean isOutputShutdown()
/*      */   {
/*  702 */     return this.outputShutdown;
/*      */   }
/*      */ 
/*      */   public void sendUrgentData(int data)
/*      */     throws IOException
/*      */   {
/*  713 */     log.warn("sendUrgentData() called: ignored");
/*      */ 
/*  715 */     if (isClosed())
/*  716 */       throw new IOException("Socket Closed");
/*      */   }
/*      */ 
/*      */   public void setKeepAlive(boolean on)
/*      */     throws SocketException
/*      */   {
/*  725 */     if (this.actualSocket != null)
/*  726 */       this.actualSocket.setKeepAlive(on);
/*      */   }
/*      */ 
/*      */   public void setOOBInline(boolean on)
/*      */     throws SocketException
/*      */   {
/*  735 */     log.warn("setOOBInLine() called: ignored");
/*      */ 
/*  737 */     if (isClosed())
/*  738 */       throw new SocketException("Socket is closed");
/*      */   }
/*      */ 
/*      */   public void setReceiveBufferSize(int size)
/*      */     throws SocketException
/*      */   {
/*  747 */     if (this.actualSocket != null)
/*  748 */       this.actualSocket.setReceiveBufferSize(size);
/*      */   }
/*      */ 
/*      */   public void setReuseAddress(boolean on)
/*      */     throws SocketException
/*      */   {
/*  757 */     if (this.actualSocket != null)
/*  758 */       this.actualSocket.setReuseAddress(on);
/*      */   }
/*      */ 
/*      */   public void setSendBufferSize(int size)
/*      */     throws SocketException
/*      */   {
/*  767 */     if (this.actualSocket != null)
/*  768 */       this.actualSocket.setSendBufferSize(size);
/*      */   }
/*      */ 
/*      */   public void setSoLinger(boolean on, int linger)
/*      */     throws SocketException
/*      */   {
/*  777 */     if (this.actualSocket != null)
/*  778 */       this.actualSocket.setSoLinger(on, linger);
/*      */   }
/*      */ 
/*      */   public void setSoTimeout(int timeout)
/*      */     throws SocketException
/*      */   {
/*  787 */     if (isClosed()) {
/*  788 */       throw new SocketException("Socket is closed");
/*      */     }
/*  790 */     if (timeout < 0) {
/*  791 */       throw new IllegalArgumentException("timeout can't be negative");
/*      */     }
/*  793 */     this.timeout = timeout;
/*      */ 
/*  795 */     if (this.inputStream != null)
/*  796 */       this.inputStream.setTimeout(timeout);
/*      */   }
/*      */ 
/*      */   public void setTcpNoDelay(boolean on)
/*      */     throws SocketException
/*      */   {
/*  805 */     if (this.actualSocket != null)
/*  806 */       this.actualSocket.setTcpNoDelay(on);
/*      */   }
/*      */ 
/*      */   public void setTrafficClass(int tc)
/*      */     throws SocketException
/*      */   {
/*  815 */     if (this.actualSocket != null)
/*  816 */       this.actualSocket.setTrafficClass(tc);
/*      */   }
/*      */ 
/*      */   public void shutdownInput()
/*      */     throws IOException
/*      */   {
/*  825 */     if (isClosed()) {
/*  826 */       throw new SocketException("Socket is closed");
/*      */     }
/*  828 */     if (!isConnected()) {
/*  829 */       throw new SocketException("Socket is not connected");
/*      */     }
/*  831 */     if (isInputShutdown()) {
/*  832 */       throw new SocketException("Socket input is already shutdown");
/*      */     }
/*  834 */     this.inputStream.setEOF();
/*  835 */     this.inputShutdown = true;
/*      */   }
/*      */ 
/*      */   public void shutdownOutput()
/*      */     throws IOException
/*      */   {
/*  845 */     if (isClosed()) {
/*  846 */       throw new SocketException("Socket is closed");
/*      */     }
/*  848 */     if (!isConnected()) {
/*  849 */       throw new SocketException("Socket is not connected");
/*      */     }
/*  851 */     if (isOutputShutdown()) {
/*  852 */       throw new SocketException("Socket output is already shutdown");
/*      */     }
/*  854 */     this.outputStream.shutdown();
/*  855 */     this.outputShutdown = true;
/*  856 */     this.protocol.notifyOutputShutdown(this.remoteSocketId);
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*  865 */     StringBuffer answer = new StringBuffer().append("VirtualSocket[");
/*      */ 
/*  867 */     if (this.actualSocket == null)
/*  868 */       answer.append("unbound");
/*      */     else {
/*  870 */       answer.append(this.actualSocket.toString());
/*      */     }
/*  872 */     return "]";
/*      */   }
/*      */ 
/*      */   public void addDisconnectListener(DisconnectListener listener)
/*      */   {
/*  884 */     this.disconnectListeners.add(listener);
/*      */   }
/*      */ 
/*      */   public void connect(SocketAddress remoteAddress, SocketAddress localAddress, int timeout)
/*      */     throws IOException
/*      */   {
/*  893 */     log.debug("entering connect()");
/*  894 */     long start = System.currentTimeMillis();
/*  895 */     int timeLeft = 0;
/*      */ 
/*  897 */     if (remoteAddress == null) {
/*  898 */       throw new IllegalArgumentException("connect: The address can't be null");
/*      */     }
/*  900 */     if (timeout < 0) {
/*  901 */       throw new IllegalArgumentException("connect: timeout can't be negative");
/*      */     }
/*  903 */     if (isClosed()) {
/*  904 */       throw new SocketException("Socket is closed");
/*      */     }
/*  906 */     if (isConnected()) {
/*  907 */       throw new SocketException("already connected");
/*      */     }
/*  909 */     if (!(remoteAddress instanceof InetSocketAddress)) {
/*  910 */       throw new IllegalArgumentException("Unsupported address type");
/*      */     }
/*  912 */     InetSocketAddress remoteInetSocketAddress = (InetSocketAddress)remoteAddress;
/*  913 */     SecurityManager security = System.getSecurityManager();
/*      */ 
/*  915 */     if (security != null)
/*      */     {
/*  917 */       if (remoteInetSocketAddress.isUnresolved())
/*  918 */         security.checkConnect(remoteInetSocketAddress.getHostName(), remoteInetSocketAddress.getPort());
/*      */       else {
/*  920 */         security.checkConnect(remoteInetSocketAddress.getAddress().getHostAddress(), remoteInetSocketAddress.getPort());
/*      */       }
/*      */     }
/*  923 */     if ((timeout > 0) && 
/*  924 */       ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0)) {
/*  925 */       throw new SocketTimeoutException("connect timed out");
/*      */     }
/*  927 */     if (this.manager == null)
/*      */     {
/*  929 */       if (localAddress == null) {
/*  930 */         this.manager = MultiplexingManager.getaShareableManager(remoteInetSocketAddress, timeLeft, this.configuration);
/*      */       }
/*      */       else {
/*  933 */         InetSocketAddress localInetSocketAddress = (InetSocketAddress)localAddress;
/*  934 */         this.manager = MultiplexingManager.getaShareableManagerByAddressPair(remoteInetSocketAddress, localInetSocketAddress, timeLeft, this.configuration);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  943 */       if ((timeout > 0) && 
/*  944 */         ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0)) {
/*  945 */         throw new SocketTimeoutException("connect timed out");
/*      */       }
/*  947 */       this.manager.connect(remoteInetSocketAddress, timeLeft);
/*  948 */       this.actualSocket = this.manager.getSocket();
/*  949 */       this.protocol = this.manager.getProtocol();
/*      */ 
/*  951 */       if (!this.bound)
/*      */       {
/*  953 */         this.localSocketId = new SocketId();
/*  954 */         this.bound = true;
/*      */       }
/*      */ 
/*  957 */       this.inputStream = this.manager.registerSocket(this);
/*  958 */       this.inputStream.setTimeout(timeout);
/*      */ 
/*  960 */       if ((timeout > 0) && 
/*  961 */         ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0)) {
/*  962 */         throw new SocketTimeoutException("connect timed out");
/*      */       }
/*  964 */       this.remoteSocketId = this.protocol.connect(this.inputStream, this.localSocketId, timeLeft);
/*  965 */       this.outputStream = new MultiplexingOutputStream(this.manager, this, this.remoteSocketId);
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*      */       try
/*      */       {
/*  972 */         this.manager.unRegisterSocket(this);
/*      */       }
/*      */       catch (IOException ignored)
/*      */       {
/*      */       }
/*      */ 
/*  979 */       if ((e instanceof SocketTimeoutException)) {
/*  980 */         throw new SocketTimeoutException("connect timed out");
/*      */       }
/*  982 */       throw e;
/*      */     }
/*      */     finally
/*      */     {
/*  986 */       if (this.inputStream != null) {
/*  987 */         this.inputStream.setTimeout(this.timeout);
/*      */       }
/*      */     }
/*  990 */     this.connected = true;
/*      */   }
/*      */ 
/*      */   public MultiplexingManager getMultiplexingManager()
/*      */   {
/*  996 */     return this.manager;
/*      */   }
/*      */ 
/*      */   public int getVirtualPort()
/*      */   {
/* 1002 */     return this.remoteSocketId.getPort();
/*      */   }
/*      */ 
/*      */   public int getLocalVirtualPort()
/*      */   {
/* 1008 */     return this.localSocketId.getPort();
/*      */   }
/*      */ 
/*      */   public SocketId getLocalSocketId()
/*      */   {
/* 1018 */     return this.localSocketId;
/*      */   }
/*      */ 
/*      */   public Socket getRealSocket()
/*      */   {
/* 1027 */     return this.actualSocket;
/*      */   }
/*      */ 
/*      */   public SocketId getRemoteSocketId()
/*      */   {
/* 1037 */     return this.localSocketId;
/*      */   }
/*      */ 
/*      */   public boolean isFunctional()
/*      */   {
/* 1050 */     return this.functional;
/*      */   }
/*      */ 
/*      */   public void removeDisconnectListener(DisconnectListener listener)
/*      */   {
/* 1059 */     if (!this.disconnectListeners.remove(listener))
/* 1060 */       log.error("attempt to remove unregistered DisconnectListener: " + listener);
/*      */   }
/*      */ 
/*      */   public void setConfiguration(Map configuration)
/*      */   {
/* 1069 */     this.configuration.putAll(configuration);
/*      */   }
/*      */ 
/*      */   protected Socket getActualSocket()
/*      */   {
/* 1080 */     return this.actualSocket;
/*      */   }
/*      */ 
/*      */   protected void setActualSocket(Socket actualSocket)
/*      */   {
/* 1088 */     this.actualSocket = actualSocket;
/*      */   }
/*      */ 
/*      */   protected void setBound(boolean bound)
/*      */   {
/* 1105 */     this.bound = bound;
/*      */   }
/*      */ 
/*      */   protected void setClosed(boolean closed)
/*      */   {
/* 1113 */     this.closed = closed;
/*      */   }
/*      */ 
/*      */   protected void setConnected(boolean connected)
/*      */   {
/* 1121 */     this.connected = connected;
/*      */   }
/*      */ 
/*      */   protected void setInputShutdown(boolean inputShutdown)
/*      */   {
/* 1129 */     this.inputShutdown = inputShutdown;
/*      */   }
/*      */ 
/*      */   protected void setInputStream(MultiplexingInputStream inputStream)
/*      */   {
/* 1137 */     this.inputStream = inputStream;
/*      */   }
/*      */ 
/*      */   protected void setLocalSocketId(SocketId localSocketId)
/*      */   {
/* 1145 */     this.localSocketId = localSocketId;
/*      */   }
/*      */ 
/*      */   protected MultiplexingManager getManager()
/*      */   {
/* 1154 */     return this.manager;
/*      */   }
/*      */ 
/*      */   protected void setManager(MultiplexingManager manager)
/*      */   {
/* 1162 */     this.manager = manager;
/*      */   }
/*      */ 
/*      */   protected void setOutputShutdown(boolean outputShutdown)
/*      */   {
/* 1170 */     this.outputShutdown = outputShutdown;
/*      */   }
/*      */ 
/*      */   protected void setOutputStream(MultiplexingOutputStream outputStream)
/*      */   {
/* 1178 */     this.outputStream = outputStream;
/*      */   }
/*      */ 
/*      */   protected Protocol getProtocol()
/*      */   {
/* 1186 */     return this.protocol;
/*      */   }
/*      */ 
/*      */   protected void setProtocol(Protocol protocol)
/*      */   {
/* 1194 */     this.protocol = protocol;
/*      */   }
/*      */ 
/*      */   protected boolean hasReceivedDisconnectMessage()
/*      */   {
/* 1203 */     return this.receivedDisconnectMessage;
/*      */   }
/*      */ 
/*      */   protected void setReceivedDisconnectMessage(boolean receivedDisconnectMessage)
/*      */   {
/* 1212 */     this.receivedDisconnectMessage = receivedDisconnectMessage;
/*      */   }
/*      */ 
/*      */   protected void setRemoteSocketId(SocketId remoteSocketId)
/*      */   {
/* 1220 */     this.remoteSocketId = remoteSocketId;
/*      */   }
/*      */ 
/*      */   protected void doClose()
/*      */   {
/* 1235 */     if (this.debug) log.debug("doClose()" + this.localSocketId.getPort());
/*      */ 
/*      */     try
/*      */     {
/* 1242 */       if (this.manager.isSocketRegistered(getLocalSocketId())) {
/* 1243 */         this.manager.unRegisterSocket(this);
/*      */       }
/* 1245 */       if (this.debug) log.debug("virtual socket closed on port: " + this.remoteSocketId.getPort());
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1249 */       log.error("error closing socket: " + this);
/* 1250 */       log.error(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void handleRemoteOutputShutDown()
/*      */     throws IOException
/*      */   {
/*      */     try
/*      */     {
/* 1265 */       this.inputStream.handleRemoteShutdown();
/*      */     }
/*      */     catch (NullPointerException ignored)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void handleRemoteDisconnect()
/*      */     throws IOException
/*      */   {
/* 1279 */     if (isClosed()) {
/* 1280 */       return;
/*      */     }
/* 1282 */     if (this.debug) log.debug("remote virtual socket disconnecting: local port: " + getLocalVirtualPort());
/* 1283 */     this.receivedDisconnectMessage = true;
/*      */ 
/* 1286 */     if (this.inputStream != null) {
/* 1287 */       this.inputStream.handleRemoteShutdown();
/*      */     }
/*      */ 
/* 1290 */     if (this.outputStream != null)
/*      */     {
/* 1292 */       this.outputStream.flush();
/* 1293 */       this.outputStream.handleRemoteDisconnect();
/*      */     }
/*      */ 
/* 1296 */     MultiplexingManager.addToPendingActions(new PendingRemoteDisconnect(this));
/*      */ 
/* 1298 */     log.debug("handleRemoteDisconnect(): done.");
/*      */   }
/*      */ 
/*      */   protected void notifyOfException()
/*      */   {
/* 1311 */     this.functional = false;
/*      */   }
/*      */ 
/*      */   protected class PendingClose extends PendingAction
/*      */   {
/*      */     public PendingClose(Object o)
/*      */     {
/* 1337 */       super();
/*      */     }
/*      */ 
/*      */     public void doAction()
/*      */     {
/* 1342 */       ((VirtualSocket)this.o).doClose();
/*      */     }
/*      */   }
/*      */ 
/*      */   protected class PendingRemoteDisconnect extends PendingAction
/*      */   {
/*      */     public PendingRemoteDisconnect(Object o)
/*      */     {
/* 1318 */       super();
/*      */     }
/*      */ 
/*      */     void doAction()
/*      */     {
/* 1323 */       VirtualSocket vs = (VirtualSocket)this.o;
/* 1324 */       Set disconnectListeners = vs.disconnectListeners;
/*      */ 
/* 1326 */       Iterator it = disconnectListeners.iterator();
/* 1327 */       while (it.hasNext())
/* 1328 */         ((VirtualSocket.DisconnectListener)it.next()).notifyDisconnected(vs);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static abstract interface DisconnectListener
/*      */   {
/*      */     public abstract void notifyDisconnected(VirtualSocket paramVirtualSocket);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.VirtualSocket
 * JD-Core Version:    0.6.0
 */