/*     */ package org.jboss.remoting.transport.multiplex;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class VirtualServerSocketFactory extends ServerSocketFactory
/*     */ {
/*  58 */   protected static final Logger log = Logger.getLogger(VirtualServerSocketFactory.class);
/*  59 */   boolean onClient = false;
/*     */ 
/*     */   public static ServerSocketFactory getDefault()
/*     */   {
/*  63 */     return new VirtualServerSocketFactory();
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port)
/*     */     throws IOException
/*     */   {
/*  81 */     if (isOnClient()) {
/*  82 */       return new VirtualServerSocket(port);
/*     */     }
/*  84 */     return new MasterServerSocket(port);
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port, int backlog)
/*     */     throws IOException
/*     */   {
/*  93 */     if (isOnClient())
/*     */     {
/*  95 */       log.warn("backlog parameter is ignored");
/*  96 */       return new VirtualServerSocket(port, backlog);
/*     */     }
/*     */ 
/*  99 */     return new MasterServerSocket(port, backlog);
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port, int backlog, InetAddress address)
/*     */     throws IOException
/*     */   {
/* 108 */     if (isOnClient())
/*     */     {
/* 110 */       log.warn("backlog parameter is ignored");
/* 111 */       return new VirtualServerSocket(port, backlog, address);
/*     */     }
/*     */ 
/* 114 */     return new MasterServerSocket(port, backlog, address);
/*     */   }
/*     */ 
/*     */   public boolean isOnClient()
/*     */   {
/* 128 */     return this.onClient;
/*     */   }
/*     */ 
/*     */   public boolean isOnServer()
/*     */   {
/* 137 */     return !this.onClient;
/*     */   }
/*     */ 
/*     */   public boolean setOnClient()
/*     */   {
/* 146 */     boolean temp = this.onClient;
/* 147 */     this.onClient = true;
/* 148 */     return temp;
/*     */   }
/*     */ 
/*     */   public boolean setOnServer()
/*     */   {
/* 157 */     boolean temp = this.onClient;
/* 158 */     this.onClient = false;
/* 159 */     return !temp;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.VirtualServerSocketFactory
 * JD-Core Version:    0.6.0
 */