/*     */ package org.jboss.remoting.transport.multiplex;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InterruptedIOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.InetAddress;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketAddress;
/*     */ import java.net.SocketException;
/*     */ import java.net.SocketTimeoutException;
/*     */ import java.nio.channels.ServerSocketChannel;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class VirtualServerSocket extends ServerSocket
/*     */   implements Serializable
/*     */ {
/*  69 */   private static final Logger log = Logger.getLogger(VirtualServerSocket.class);
/*  70 */   private List acceptingThreads = Collections.synchronizedList(new LinkedList());
/*     */ 
/*  72 */   private Map configuration = new HashMap();
/*     */   private MultiplexingManager manager;
/*     */   private MultiplexingInputStream is;
/*     */   private MultiplexingInputStream cis;
/*     */   private Protocol protocol;
/*     */   private Socket actualSocket;
/*     */   private int timeout;
/*  79 */   private boolean bound = false;
/*  80 */   private boolean connected = false;
/*  81 */   private boolean closed = false;
/*     */   private Socket dummySocket;
/*     */   private static final long serialVersionUID = -5320724929164012313L;
/*     */ 
/*     */   public VirtualServerSocket()
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public VirtualServerSocket(int port)
/*     */     throws IOException
/*     */   {
/* 106 */     bind(new InetSocketAddress(port));
/* 107 */     log.debug("created VirtualServerSocket: " + toString());
/*     */   }
/*     */ 
/*     */   public VirtualServerSocket(int port, int backlog)
/*     */     throws IOException
/*     */   {
/* 120 */     this(port);
/* 121 */     log.warn("backlog parameter is ignored");
/* 122 */     log.debug("created VirtualServerSocket: " + toString());
/*     */   }
/*     */ 
/*     */   public VirtualServerSocket(int port, int backlog, InetAddress bindAddr)
/*     */     throws IOException
/*     */   {
/* 135 */     bind(new InetSocketAddress(bindAddr, port));
/* 136 */     log.warn("backlog parameter is ignored");
/* 137 */     log.debug("created VirtualServerSocket: " + toString());
/*     */   }
/*     */ 
/*     */   public VirtualServerSocket(VirtualSocket socket, Map configuration)
/*     */     throws IOException
/*     */   {
/* 151 */     this.actualSocket = socket.getActualSocket();
/* 152 */     if (configuration != null)
/* 153 */       this.configuration.putAll(configuration);
/* 154 */     this.manager = socket.getManager();
/* 155 */     this.manager.incrementReferences();
/* 156 */     bind(new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort()));
/* 157 */     log.debug("created VirtualServerSocket: " + toString());
/*     */   }
/*     */ 
/*     */   public VirtualServerSocket(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout, Map configuration)
/*     */     throws IOException
/*     */   {
/* 173 */     if (configuration != null) {
/* 174 */       this.configuration.putAll(configuration);
/*     */     }
/* 176 */     connect(remoteAddress, localAddress, timeout);
/* 177 */     log.debug("created VirtualServerSocket: " + toString());
/*     */   }
/*     */ 
/*     */   public synchronized Socket accept()
/*     */     throws IOException
/*     */   {
/* 210 */     log.debug("entering accept()");
/* 211 */     long start = System.currentTimeMillis();
/* 212 */     int timeout = getSoTimeout();
/* 213 */     int timeLeft = 0;
/*     */ 
/* 215 */     if (isClosed()) {
/* 216 */       throw new SocketException("Socket is closed");
/*     */     }
/* 218 */     if (!isBound()) {
/* 219 */       throw new SocketException("Socket is not bound yet");
/*     */     }
/* 221 */     SecurityManager security = System.getSecurityManager();
/*     */ 
/* 223 */     if (security != null)
/*     */     {
/* 225 */       security.checkAccept(this.actualSocket.getInetAddress().getHostAddress(), this.actualSocket.getPort());
/*     */     }
/*     */ 
/* 228 */     Thread currentThread = Thread.currentThread();
/* 229 */     this.acceptingThreads.add(currentThread);
/* 230 */     VirtualSocket virtualSocket = null;
/*     */     try
/*     */     {
/* 234 */       if ((timeout > 0) && 
/* 235 */         ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0))
/*     */       {
/* 237 */         log.error("timed out");
/* 238 */         throw new SocketTimeoutException("Accept timed out");
/*     */       }
/*     */ 
/* 241 */       log.debug("timeLeft: " + timeLeft);
/* 242 */       SocketId clientPort = this.protocol.acceptConnect(this.is, timeLeft);
/* 243 */       log.debug("clientPort:  " + clientPort.getPort());
/*     */ 
/* 245 */       virtualSocket = new VirtualSocket(this.manager, clientPort, this.configuration);
/* 246 */       this.manager.incrementReferences();
/* 247 */       int localPort = virtualSocket.getLocalVirtualPort();
/* 248 */       this.protocol.answerConnect((MultiplexingOutputStream)virtualSocket.getOutputStream(), localPort);
/* 249 */       localVirtualSocket1 = virtualSocket;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*     */       VirtualSocket localVirtualSocket1;
/* 253 */       if (((e instanceof InterruptedIOException)) || ("Socket closed".equals(e.getMessage())) || ("An existing connection was forcibly closed by the remote host".equals(e.getMessage())))
/*     */       {
/* 256 */         log.debug(e);
/*     */       }
/* 258 */       else log.error(e);
/*     */ 
/* 260 */       if (virtualSocket != null) {
/* 261 */         virtualSocket.close();
/*     */       }
/* 263 */       if (isClosed()) {
/* 264 */         throw new SocketException("Socket closed");
/*     */       }
/* 266 */       if ((e instanceof SocketTimeoutException)) {
/* 267 */         throw new SocketTimeoutException("Accept timed out");
/*     */       }
/* 269 */       throw e;
/*     */     }
/*     */     finally
/*     */     {
/* 273 */       this.acceptingThreads.remove(currentThread);
/*     */ 
/* 275 */       if (isClosed())
/*     */       {
/* 277 */         if (virtualSocket != null) {
/* 278 */           virtualSocket.close();
/*     */         }
/* 280 */         throw new SocketException("Socket closed");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void bind(SocketAddress socketAddress)
/*     */     throws IOException
/*     */   {
/* 291 */     bind(socketAddress, 1);
/*     */   }
/*     */ 
/*     */   public void bind(SocketAddress socketAddress, int backlog)
/*     */     throws IOException
/*     */   {
/* 300 */     if (backlog != 1)
/*     */     {
/* 302 */       log.warn("backlog != 1: ignored");
/*     */     }
/*     */ 
/* 305 */     if (isClosed()) {
/* 306 */       throw new SocketException("Socket is closed");
/*     */     }
/* 308 */     if (isBound()) {
/* 309 */       throw new SocketException("Already bound");
/*     */     }
/* 311 */     if (socketAddress == null) {
/* 312 */       socketAddress = new InetSocketAddress(0);
/*     */     }
/* 314 */     if (!(socketAddress instanceof InetSocketAddress)) {
/* 315 */       throw new IllegalArgumentException("Unsupported address type");
/*     */     }
/* 317 */     InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
/*     */ 
/* 319 */     if (inetSocketAddress.isUnresolved()) {
/* 320 */       throw new SocketException("Unresolved address");
/*     */     }
/* 322 */     SecurityManager security = System.getSecurityManager();
/*     */ 
/* 324 */     if (security != null) {
/* 325 */       security.checkListen(inetSocketAddress.getPort());
/*     */     }
/* 327 */     if (this.manager == null)
/*     */     {
/* 329 */       this.manager = MultiplexingManager.getaManagerByLocalAddress(inetSocketAddress, this.configuration);
/* 330 */       this.actualSocket = this.manager.getSocket();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 335 */       this.bound = true;
/* 336 */       this.is = this.manager.registerServerSocket(this);
/* 337 */       this.cis = this.manager.getAnInputStream(SocketId.SERVER_SOCKET_CONNECT_ID, null);
/* 338 */       this.is.setTimeout(this.timeout);
/* 339 */       this.cis.setTimeout(this.timeout);
/*     */ 
/* 341 */       if (this.manager.isConnected())
/*     */       {
/* 343 */         this.protocol = this.manager.getProtocol();
/*     */ 
/* 346 */         this.protocol.registerRemoteServerSocket(getSoTimeout());
/* 347 */         this.connected = true;
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 352 */       this.bound = false;
/*     */ 
/* 354 */       if (this.manager.isServerSocketRegistered()) {
/* 355 */         this.manager.unRegisterServerSocket(this);
/*     */       }
/* 357 */       throw e;
/*     */     }
/*     */ 
/* 360 */     log.debug(toString());
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 369 */     if (isClosed()) {
/* 370 */       return;
/*     */     }
/* 372 */     this.closed = true;
/*     */ 
/* 375 */     if (!this.acceptingThreads.isEmpty())
/*     */     {
/* 379 */       LinkedList threads = new LinkedList(this.acceptingThreads);
/* 380 */       Iterator it = threads.iterator();
/*     */ 
/* 382 */       while (it.hasNext())
/*     */       {
/* 384 */         Thread t = (Thread)it.next();
/* 385 */         t.interrupt();
/* 386 */         log.debug("interrupting accepting thread: " + t.getName());
/*     */       }
/*     */ 
/* 389 */       if (!this.acceptingThreads.isEmpty())
/*     */       {
/* 391 */         MultiplexingManager.addToPendingActions(new PendingClose(this));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 400 */     if (this.protocol != null) {
/* 401 */       this.protocol.unregisterRemoteServerSocket();
/*     */     }
/* 403 */     if (this.manager != null)
/* 404 */       this.manager.unRegisterServerSocket(this);
/*     */   }
/*     */ 
/*     */   public InetAddress getInetAddress()
/*     */   {
/* 413 */     if (this.actualSocket == null) {
/* 414 */       return null;
/*     */     }
/* 416 */     return this.actualSocket.getInetAddress();
/*     */   }
/*     */ 
/*     */   public int getLocalPort()
/*     */   {
/* 425 */     if (this.actualSocket == null) {
/* 426 */       return -1;
/*     */     }
/* 428 */     return this.actualSocket.getLocalPort();
/*     */   }
/*     */ 
/*     */   public ServerSocketChannel getChannel()
/*     */   {
/* 437 */     return null;
/*     */   }
/*     */ 
/*     */   public SocketAddress getLocalSocketAddress()
/*     */   {
/* 446 */     if (this.actualSocket == null) {
/* 447 */       return null;
/*     */     }
/* 449 */     return this.actualSocket.getLocalSocketAddress();
/*     */   }
/*     */ 
/*     */   public int getReceiveBufferSize()
/*     */     throws SocketException
/*     */   {
/* 458 */     if (this.actualSocket == null)
/*     */     {
/* 460 */       if (this.dummySocket == null) {
/* 461 */         this.dummySocket = new Socket();
/*     */       }
/* 463 */       return this.dummySocket.getReceiveBufferSize();
/*     */     }
/*     */ 
/* 466 */     return this.actualSocket.getReceiveBufferSize();
/*     */   }
/*     */ 
/*     */   public boolean getReuseAddress()
/*     */     throws SocketException
/*     */   {
/* 475 */     if (this.actualSocket == null) {
/* 476 */       return true;
/*     */     }
/* 478 */     return this.actualSocket.getReuseAddress();
/*     */   }
/*     */ 
/*     */   public int getSoTimeout()
/*     */     throws SocketException
/*     */   {
/* 487 */     if (isClosed()) {
/* 488 */       throw new SocketException("Socket is closed");
/*     */     }
/* 490 */     return this.timeout;
/*     */   }
/*     */ 
/*     */   public boolean isBound()
/*     */   {
/* 499 */     return this.bound;
/*     */   }
/*     */ 
/*     */   public boolean isClosed()
/*     */   {
/* 508 */     return this.closed;
/*     */   }
/*     */ 
/*     */   public void setReceiveBufferSize(int size)
/*     */     throws SocketException
/*     */   {
/* 517 */     if (this.actualSocket != null)
/* 518 */       this.actualSocket.setReceiveBufferSize(size);
/*     */   }
/*     */ 
/*     */   public void setReuseAddress(boolean on)
/*     */     throws SocketException
/*     */   {
/* 527 */     if (this.actualSocket != null)
/* 528 */       this.actualSocket.setReuseAddress(on);
/*     */   }
/*     */ 
/*     */   public void setSoTimeout(int timeout)
/*     */     throws SocketException
/*     */   {
/* 537 */     if (isClosed()) {
/* 538 */       throw new SocketException("Socket is closed");
/*     */     }
/* 540 */     if (timeout < 0) {
/* 541 */       throw new IllegalArgumentException("timeout can't be negative");
/*     */     }
/* 543 */     this.timeout = timeout;
/*     */ 
/* 545 */     if (this.is != null) {
/* 546 */       this.is.setTimeout(timeout);
/*     */     }
/* 548 */     if (this.cis != null)
/* 549 */       this.cis.setTimeout(timeout);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 558 */     StringBuffer answer = new StringBuffer().append("VirtualServerSocket[");
/*     */ 
/* 560 */     if (this.actualSocket == null)
/* 561 */       answer.append("unbound");
/*     */     else {
/* 563 */       answer.append(this.actualSocket.toString());
/*     */     }
/* 565 */     return "]";
/*     */   }
/*     */ 
/*     */   public void connect(SocketAddress remoteAddress)
/*     */     throws IOException
/*     */   {
/* 578 */     connect(remoteAddress, null, this.timeout);
/*     */   }
/*     */ 
/*     */   public void connect(SocketAddress remoteAddress, SocketAddress localAddress)
/*     */     throws IOException
/*     */   {
/* 589 */     connect(remoteAddress, localAddress, this.timeout);
/*     */   }
/*     */ 
/*     */   public void connect(SocketAddress remoteAddress, SocketAddress localAddress, int timeout)
/*     */     throws IOException
/*     */   {
/* 598 */     long start = System.currentTimeMillis();
/* 599 */     int timeLeft = 0;
/*     */ 
/* 601 */     if (remoteAddress == null) {
/* 602 */       throw new IllegalArgumentException("connect: The address can't be null");
/*     */     }
/* 604 */     if (timeout < 0) {
/* 605 */       throw new IllegalArgumentException("connect: timeout can't be negative");
/*     */     }
/* 607 */     if (isClosed()) {
/* 608 */       throw new SocketException("Socket is closed");
/*     */     }
/* 610 */     if (!(remoteAddress instanceof InetSocketAddress)) {
/* 611 */       throw new IllegalArgumentException("Unsupported address type");
/*     */     }
/* 613 */     InetSocketAddress remoteInetSocketAddress = (InetSocketAddress)remoteAddress;
/* 614 */     SecurityManager security = System.getSecurityManager();
/*     */ 
/* 616 */     if (security != null)
/*     */     {
/* 618 */       if (remoteInetSocketAddress.isUnresolved())
/* 619 */         security.checkConnect(remoteInetSocketAddress.getHostName(), remoteInetSocketAddress.getPort());
/*     */       else {
/* 621 */         security.checkConnect(remoteInetSocketAddress.getAddress().getHostAddress(), remoteInetSocketAddress.getPort());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 628 */     if (isConnected()) {
/* 629 */       if (getRemoteAddress().equals(remoteInetSocketAddress.getAddress())) {
/* 630 */         return;
/*     */       }
/* 632 */       throw new SocketException("already connected");
/*     */     }
/* 634 */     if (this.manager == null)
/*     */     {
/* 636 */       if ((timeout > 0) && 
/* 637 */         ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0)) {
/* 638 */         throw new SocketTimeoutException("connect timed out");
/*     */       }
/* 640 */       if (localAddress == null) {
/* 641 */         this.manager = MultiplexingManager.getaManagerByRemoteAddress(remoteInetSocketAddress, timeLeft, this.configuration);
/*     */       }
/*     */       else
/*     */       {
/* 645 */         InetSocketAddress localInetSocketAddress = (InetSocketAddress)localAddress;
/* 646 */         this.manager = MultiplexingManager.getaManagerByAddressPair(remoteInetSocketAddress, localInetSocketAddress, timeLeft, this.configuration);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 653 */     this.actualSocket = this.manager.getSocket();
/*     */     try
/*     */     {
/* 657 */       if (!isBound())
/*     */       {
/* 659 */         log.debug("calling registerServerSocket()");
/* 660 */         this.is = this.manager.registerServerSocket(this);
/* 661 */         this.cis = this.manager.getAnInputStream(SocketId.SERVER_SOCKET_CONNECT_ID, null);
/* 662 */         this.is.setTimeout(this.timeout);
/* 663 */         this.cis.setTimeout(this.timeout);
/* 664 */         this.bound = true;
/*     */       }
/*     */ 
/* 669 */       if (!this.manager.isConnected())
/*     */       {
/* 671 */         if ((timeout > 0) && 
/* 672 */           ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0)) {
/* 673 */           throw new SocketTimeoutException("connect timed out");
/*     */         }
/* 675 */         this.manager.connect(remoteInetSocketAddress, timeLeft);
/* 676 */         this.protocol = this.manager.getProtocol();
/*     */ 
/* 678 */         if ((timeout > 0) && 
/* 679 */           ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0)) {
/* 680 */           throw new SocketTimeoutException("connect timed out");
/*     */         }
/* 682 */         this.cis.setTimeout(timeout);
/* 683 */         this.protocol.connect(this.cis, SocketId.SERVER_SOCKET_ID, timeLeft);
/*     */ 
/* 687 */         if ((timeout > 0) && 
/* 688 */           ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0))
/* 689 */           throw new SocketTimeoutException("connect timed out");
/*     */       }
/*     */       else {
/* 692 */         this.protocol = this.manager.getProtocol();
/*     */       }
/* 694 */       if ((timeout > 0) && 
/* 695 */         ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0)) {
/* 696 */         throw new SocketTimeoutException("connect timed out");
/*     */       }
/* 698 */       this.protocol.registerRemoteServerSocket(timeLeft);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 702 */       log.error("i/o exception in VirtualServerSocket.connect()", e);
/*     */ 
/* 704 */       if (this.manager.isServerSocketRegistered()) {
/* 705 */         this.manager.unRegisterServerSocket(this);
/*     */       }
/* 707 */       if ((e instanceof SocketTimeoutException)) {
/* 708 */         throw new SocketTimeoutException("connect timed out");
/*     */       }
/* 710 */       throw e;
/*     */     }
/*     */     finally
/*     */     {
/* 714 */       if (this.cis != null) {
/* 715 */         this.cis.setTimeout(this.timeout);
/*     */       }
/*     */     }
/* 718 */     this.connected = true;
/* 719 */     log.debug(toString());
/*     */   }
/*     */ 
/*     */   public MultiplexingManager getMultiplexingManager()
/*     */   {
/* 728 */     return this.manager;
/*     */   }
/*     */ 
/*     */   public boolean isConnected()
/*     */   {
/* 738 */     return this.connected;
/*     */   }
/*     */ 
/*     */   public InetAddress getRemoteAddress()
/*     */   {
/* 747 */     if (this.actualSocket == null) {
/* 748 */       return null;
/*     */     }
/* 750 */     return this.actualSocket.getInetAddress();
/*     */   }
/*     */ 
/*     */   public int getRemotePort()
/*     */   {
/* 759 */     if (this.actualSocket == null) {
/* 760 */       return 0;
/*     */     }
/* 762 */     return this.actualSocket.getPort();
/*     */   }
/*     */ 
/*     */   public void setConfiguration(Map configuration)
/*     */   {
/* 771 */     this.configuration.putAll(configuration);
/*     */   }
/*     */ 
/*     */   protected void doClose()
/*     */   {
/* 782 */     LinkedList threads = new LinkedList(this.acceptingThreads);
/* 783 */     Iterator it = threads.iterator();
/*     */ 
/* 785 */     while (it.hasNext())
/*     */     {
/* 787 */       Thread t = (Thread)it.next();
/* 788 */       t.interrupt();
/* 789 */       log.debug("interrupting accepting thread: " + t.getName());
/*     */ 
/* 792 */       while (this.acceptingThreads.contains(t))
/*     */       {
/*     */         try
/*     */         {
/* 796 */           log.debug("waiting for accepting thread to catch interrupt: " + t.getName());
/* 797 */           Thread.sleep(500L);
/* 798 */           t.interrupt();
/* 799 */           log.debug("interrupting accepting thread: " + t.getName());
/*     */         }
/*     */         catch (InterruptedException ignored)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class PendingClose extends PendingAction
/*     */   {
/*     */     public PendingClose(Object o) {
/* 811 */       super();
/*     */     }
/*     */ 
/*     */     public void doAction()
/*     */     {
/* 816 */       ((VirtualServerSocket)this.o).doClose();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.VirtualServerSocket
 * JD-Core Version:    0.6.0
 */