/*     */ package org.jboss.remoting.transport.multiplex;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.util.HashSet;
/*     */ import org.apache.log4j.Logger;
/*     */ 
/*     */ public class SocketId
/*     */   implements Serializable
/*     */ {
/*  52 */   protected static final Logger log = Logger.getLogger(SocketId.class);
/*     */   private static final String ISO_8859_1 = "ISO-8859-1";
/*     */   public static final int PROTOCOL_PORT = -1;
/*     */   public static final int SERVER_SOCKET_PORT = -2;
/*     */   public static final int SERVER_SOCKET_CONNECT_PORT = -3;
/*     */   public static final int SERVER_SOCKET_VERIFY_PORT = -4;
/*     */   public static final int BACKCHANNEL_PORT = -5;
/*     */   public static final int DEADLETTER_PORT = -6;
/*     */   public static final int INITIAL_OUTPUT_PORT = -7;
/*     */   private static final int MIN_PORT = -7;
/*  63 */   private static int maxPort = 2147483646;
/*     */ 
/*  65 */   public static final SocketId PROTOCOL_SOCKET_ID = new SocketId(-1);
/*  66 */   public static final SocketId SERVER_SOCKET_ID = new SocketId(-2);
/*  67 */   public static final SocketId SERVER_SOCKET_CONNECT_ID = new SocketId(-3);
/*  68 */   public static final SocketId SERVER_SOCKET_VERIFY_ID = new SocketId(-4);
/*  69 */   public static final SocketId BACKCHANNEL_SOCKET_ID = new SocketId(-5);
/*  70 */   public static final SocketId DEADLETTER_SOCKET_ID = new SocketId(-6);
/*  71 */   public static final SocketId INITIAL_OUTPUT_SOCKET_ID = new SocketId(-7);
/*     */ 
/*  73 */   private static HashSet portsInUse = new HashSet();
/*  74 */   private static int nextNewPort = 1;
/*  75 */   private static boolean hasWrapped = false;
/*     */   private int port;
/*     */   byte[] bytes;
/*     */   private static final long serialVersionUID = 1126328489938867931L;
/*     */ 
/*     */   public SocketId()
/*     */   {
/*  86 */     this.port = getFreePort();
/*  87 */     setBytes(this.port);
/*     */   }
/*     */ 
/*     */   public SocketId(int port)
/*     */     throws IOException
/*     */   {
/*  97 */     checkPortValue(port);
/*  98 */     this.port = port;
/*  99 */     setBytes(port);
/*     */   }
/*     */ 
/*     */   public SocketId(byte[] bytes)
/*     */     throws IOException
/*     */   {
/* 109 */     this.bytes = bytes;
/* 110 */     setPort(bytes);
/* 111 */     checkPortValue(this.port);
/*     */   }
/*     */ 
/*     */   protected SocketId(short port)
/*     */   {
/* 121 */     this.port = port;
/* 122 */     setBytes(port);
/*     */   }
/*     */ 
/*     */   public byte[] toByteArray()
/*     */   {
/* 128 */     return this.bytes;
/*     */   }
/*     */ 
/*     */   public int getPort()
/*     */   {
/* 134 */     return this.port;
/*     */   }
/*     */ 
/*     */   public void releasePort()
/*     */   {
/* 140 */     freePort(this.port);
/*     */   }
/*     */ 
/*     */   public static void setMaxPort(int max)
/*     */   {
/* 146 */     maxPort = max;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 152 */     if (!(o instanceof SocketId)) {
/* 153 */       return false;
/*     */     }
/*     */ 
/* 156 */     return this.port == ((SocketId)o).port;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 164 */     return this.port;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 170 */     return Integer.toString(this.port);
/*     */   }
/*     */ 
/*     */   protected void checkPortValue(int port)
/*     */     throws IOException
/*     */   {
/* 176 */     if (port < -7)
/*     */     {
/* 178 */       log.error("attempt to create port with illegal value: " + port);
/* 179 */       throw new IOException("attempt to create port with illegal value: " + port);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setPort(byte[] bytes)
/*     */   {
/*     */     try
/*     */     {
/* 188 */       this.port = Integer.parseInt(new String(bytes, "ISO-8859-1"));
/*     */     }
/*     */     catch (UnsupportedEncodingException e)
/*     */     {
/* 194 */       log.fatal("org.jboss.remoting.transport.multiplex.OutputMultiplexor(): charset ISO-8859-1 not found", e);
/* 195 */       throw new RuntimeException("org.jboss.remoting.transport.multiplex.OutputMultiplexor(): charset ISO-8859-1 not found", e);
/*     */     }
/*     */     catch (RuntimeException r)
/*     */     {
/* 199 */       log.error("problem with port: ");
/* 200 */       for (int i = 0; i < bytes.length; i++) log.error("" + bytes[i]);
/* 201 */       throw r;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setBytes(int port)
/*     */   {
/*     */     try
/*     */     {
/* 210 */       this.bytes = Integer.toString(port).getBytes("ISO-8859-1");
/*     */     }
/*     */     catch (UnsupportedEncodingException e)
/*     */     {
/* 215 */       log.fatal("org.jboss.remoting.transport.multiplex.OutputMultiplexor(): charset ISO-8859-1 not found", e);
/* 216 */       throw new RuntimeException("org.jboss.remoting.transport.multiplex.OutputMultiplexor(): charset ISO-8859-1 not found", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static synchronized void freePort(int port)
/*     */   {
/* 223 */     portsInUse.remove(new Integer(port));
/* 224 */     SocketId.class.notifyAll();
/*     */   }
/*     */ 
/*     */   protected static synchronized int getFreePort()
/*     */   {
/* 231 */     if (nextNewPort > maxPort)
/*     */     {
/* 233 */       nextNewPort = 1;
/* 234 */       hasWrapped = true;
/*     */     }
/*     */ 
/* 237 */     if (hasWrapped)
/*     */     {
/* 239 */       if (portsInUse.size() >= maxPort) {
/*     */         try
/*     */         {
/* 242 */           SocketId.class.wait();
/*     */         }
/*     */         catch (InterruptedException ignored)
/*     */         {
/*     */         }
/*     */       }
/*     */       while (true)
/*     */       {
/* 250 */         int port = nextNewPort > maxPort ? 1 : nextNewPort++;
/* 251 */         Integer portInteger = new Integer(port);
/*     */ 
/* 253 */         if (!portsInUse.contains(portInteger))
/*     */         {
/* 255 */           portsInUse.add(portInteger);
/* 256 */           return port;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 262 */     int port = nextNewPort++;
/* 263 */     Integer portInteger = new Integer(port);
/* 264 */     portsInUse.add(portInteger);
/* 265 */     return port;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.SocketId
 * JD-Core Version:    0.6.0
 */