/*     */ package org.jboss.remoting.transport.multiplex;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketException;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.nio.channels.ClosedChannelException;
/*     */ import java.nio.channels.SocketChannel;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.ListIterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.transport.multiplex.utility.StoppableThread;
/*     */ 
/*     */ public class OutputMultiplexor
/*     */ {
/*  93 */   protected static final Logger log = Logger.getLogger(OutputMultiplexor.class);
/*     */   protected static final int BRACKETS_ALL = -1;
/*     */   protected static final int BRACKETS_NONE = -2;
/*     */   protected static final int HEADER_SIZE = 7;
/*     */   private int messagePoolSize;
/*     */   private int messageSize;
/*     */   private int maxChunkSize;
/*     */   private int maxTimeSlice;
/*     */   private int maxDataSlice;
/*     */   private int maxErrors;
/* 106 */   private Map configuration = new HashMap();
/* 107 */   private Map writeQueues = Collections.synchronizedMap(new HashMap());
/* 108 */   private Map readyQueues = Collections.synchronizedMap(new HashMap());
/* 109 */   private Map previousDestinationIds = Collections.synchronizedMap(new HashMap());
/* 110 */   private Set unregisteredClients = Collections.synchronizedSet(new HashSet());
/*     */   private List messagePool;
/*     */   private ByteBuffer buffer;
/* 113 */   private byte[] header = new byte[7];
/*     */   private int errorCount;
/*     */   private boolean trace;
/*     */   private boolean debug;
/*     */   private boolean info;
/*     */ 
/*     */   protected OutputMultiplexor(Map configuration)
/*     */     throws IOException
/*     */   {
/* 127 */     this.configuration.putAll(configuration);
/*     */ 
/* 129 */     this.messagePoolSize = Multiplex.getOneParameter(configuration, "messagePoolSize", "multiplex.outputMessagePoolSize", 1024);
/*     */ 
/* 134 */     this.messageSize = Multiplex.getOneParameter(configuration, "messageSize", "multiplex.outputMessageSize", 256);
/*     */ 
/* 139 */     this.maxChunkSize = Multiplex.getOneParameter(configuration, "maxChunkSize", "multiplex.outputMaxChunkSize", 2048);
/*     */ 
/* 144 */     this.maxTimeSlice = Multiplex.getOneParameter(configuration, "maxTimeSlice", "multiplex.outputMaxTimeSlice", 500);
/*     */ 
/* 149 */     this.maxDataSlice = Multiplex.getOneParameter(configuration, "maxDataSlice", "multiplex.outputMaxDataSlice", 16384);
/*     */ 
/* 155 */     this.maxErrors = Multiplex.getOneParameter(configuration, "maxErrors", "multiplex.outputMaxErrors", 3);
/*     */ 
/* 161 */     log.debug("messagePoolSize: " + this.messagePoolSize);
/* 162 */     log.debug("messageSize:     " + this.messageSize);
/* 163 */     log.debug("maxChunkSize:    " + this.maxChunkSize);
/* 164 */     log.debug("maxTimeSlice:    " + this.maxTimeSlice);
/* 165 */     log.debug("maxDataSlice:    " + this.maxDataSlice);
/* 166 */     log.debug("maxErrors:       " + this.maxErrors);
/*     */ 
/* 168 */     this.messagePool = Collections.synchronizedList(new ArrayList(this.messagePoolSize));
/* 169 */     for (int i = 0; i < this.messagePoolSize; i++) {
/* 170 */       this.messagePool.add(new Message(this.messageSize));
/*     */     }
/* 172 */     this.buffer = ByteBuffer.allocate(this.maxChunkSize + 7);
/*     */ 
/* 174 */     this.trace = log.isTraceEnabled();
/* 175 */     this.debug = log.isDebugEnabled();
/* 176 */     this.info = log.isInfoEnabled();
/*     */   }
/*     */ 
/*     */   public OutputThread getAnOutputThread()
/*     */   {
/* 195 */     return new OutputThread();
/*     */   }
/*     */ 
/*     */   public void write(MultiplexingManager manager, SocketId socketId, byte[] content)
/*     */     throws IOException
/*     */   {
/* 208 */     write(manager, socketId, content, -2);
/*     */   }
/*     */ 
/*     */   public void write(MultiplexingManager manager, SocketId socketId, byte[] content, int brackets)
/*     */     throws IOException
/*     */   {
/* 222 */     log.debug("entering write()");
/* 223 */     if (this.trace)
/*     */     {
/* 225 */       String messageEnd = "";
/*     */ 
/* 227 */       if (content.length > 0) {
/* 228 */         messageEnd = ": [" + (0xFF & content[0]) + "]";
/*     */       }
/* 230 */       log.trace("OutputMultiplexor.write(): queueing " + content.length + " bytes for \n  manager: " + manager + "\n  socket: " + socketId.getPort() + messageEnd);
/*     */     }
/*     */ 
/* 235 */     if (content.length == 0) {
/* 236 */       return;
/*     */     }
/* 238 */     synchronized (this.readyQueues)
/*     */     {
/* 240 */       List writeQueue = (List)this.writeQueues.get(manager);
/* 241 */       if (writeQueue == null)
/*     */       {
/* 243 */         log.error("unregistered client: " + manager);
/* 244 */         return;
/*     */       }
/*     */ 
/* 247 */       synchronized (writeQueue)
/*     */       {
/* 249 */         if (!writeQueue.isEmpty())
/*     */         {
/* 251 */           Message message = (Message)writeQueue.get(writeQueue.size() - 1);
/* 252 */           if ((message.getDestination().equals(socketId)) && (message.hasCompatibleBrackets(brackets)))
/*     */           {
/* 254 */             message.addContent(content);
/*     */           }
/*     */           else
/* 257 */             writeQueue.add(getaMessage(socketId, content, brackets));
/*     */         }
/*     */         else {
/* 260 */           writeQueue.add(getaMessage(socketId, content, brackets));
/*     */         }
/*     */       }
/* 263 */       this.readyQueues.put(manager, writeQueue);
/* 264 */       this.readyQueues.notifyAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void register(OutputMultiplexorClient client)
/*     */   {
/* 277 */     if (this.debug) log.debug("registering: " + client);
/* 278 */     synchronized (this.writeQueues)
/*     */     {
/* 280 */       List writeQueue = Collections.synchronizedList(new LinkedList());
/* 281 */       this.writeQueues.put(client, writeQueue);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void unregister(OutputMultiplexorClient client)
/*     */   {
/* 293 */     if (this.debug) log.debug("unregistering: " + client);
/* 294 */     synchronized (this.writeQueues)
/*     */     {
/* 296 */       List writeQueue = (List)this.writeQueues.get(client);
/* 297 */       if (writeQueue == null)
/*     */       {
/* 299 */         log.debug("attempt to unregister unknown Listener: " + client);
/* 300 */         client.outputFlushed();
/* 301 */         return;
/*     */       }
/*     */ 
/* 304 */       if (writeQueue.isEmpty())
/*     */       {
/* 306 */         this.writeQueues.remove(client);
/* 307 */         this.previousDestinationIds.remove(client);
/* 308 */         client.outputFlushed();
/*     */       }
/*     */       else
/*     */       {
/* 312 */         this.unregisteredClients.add(client);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Message getaMessage(SocketId socketId, byte[] content, int brackets)
/*     */     throws IOException
/*     */   {
/* 320 */     Message m = null;
/*     */ 
/* 322 */     if (this.messagePool.isEmpty())
/* 323 */       m = new Message(this.messageSize);
/*     */     else {
/* 325 */       m = (Message)this.messagePool.remove(0);
/*     */     }
/* 327 */     m.set(socketId, content, brackets);
/* 328 */     return m;
/*     */   }
/*     */ 
/*     */   protected void releaseMessage(Message m)
/*     */   {
/* 334 */     if (this.messagePool.size() < this.messagePoolSize)
/*     */     {
/* 336 */       this.messagePool.add(m);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getMaxChunkSize()
/*     */   {
/* 801 */     return this.maxChunkSize;
/*     */   }
/*     */ 
/*     */   public void setMaxChunkSize(int maxChunkSize)
/*     */   {
/* 807 */     this.maxChunkSize = maxChunkSize;
/*     */   }
/*     */ 
/*     */   public int getMessagePoolSize()
/*     */   {
/* 813 */     return this.messagePoolSize;
/*     */   }
/*     */ 
/*     */   public void setMessagePoolSize(int messagePoolSize)
/*     */   {
/* 819 */     this.messagePoolSize = messagePoolSize;
/*     */   }
/*     */ 
/*     */   public int getMessageSize()
/*     */   {
/* 825 */     return this.messageSize;
/*     */   }
/*     */ 
/*     */   public void setMessageSize(int messageSize)
/*     */   {
/* 831 */     this.messageSize = messageSize;
/*     */   }
/*     */ 
/*     */   private static class Message
/*     */   {
/*     */     private SocketId socketId;
/*     */     private ByteArrayOutputStream baos;
/*     */     private int start;
/*     */     private int length;
/*     */     private int brackets;
/*     */ 
/*     */     public Message(int size)
/*     */     {
/* 712 */       this.baos = new ByteArrayOutputStream(size);
/*     */     }
/*     */ 
/*     */     public void set(SocketId socketId, byte[] content, int brackets) throws IOException
/*     */     {
/* 717 */       this.socketId = socketId;
/* 718 */       this.baos.reset();
/* 719 */       this.baos.write(content);
/* 720 */       this.start = 0;
/* 721 */       this.length = content.length;
/* 722 */       this.brackets = brackets;
/*     */     }
/*     */ 
/*     */     public SocketId getDestination()
/*     */     {
/* 727 */       return this.socketId;
/*     */     }
/*     */ 
/*     */     public byte[] getContent()
/*     */     {
/* 732 */       return this.baos.toByteArray();
/*     */     }
/*     */ 
/*     */     public void addContent(byte[] bytes) throws IOException
/*     */     {
/* 737 */       this.baos.write(bytes);
/* 738 */       this.length += bytes.length;
/*     */     }
/*     */ 
/*     */     public void addContent(byte[] bytes, int start, int length)
/*     */     {
/* 743 */       this.baos.write(bytes, start, length);
/* 744 */       this.length += length;
/*     */     }
/*     */ 
/*     */     public int getStart()
/*     */     {
/* 749 */       return this.start;
/*     */     }
/*     */ 
/*     */     public int getLength()
/*     */     {
/* 754 */       return this.length;
/*     */     }
/*     */ 
/*     */     public int getBrackets()
/*     */     {
/* 759 */       return this.brackets;
/*     */     }
/*     */ 
/*     */     public void markUsed(int used)
/*     */     {
/* 764 */       this.length -= used;
/*     */ 
/* 766 */       if (this.length <= 0)
/*     */       {
/* 768 */         this.start = 0;
/* 769 */         this.length = 0;
/* 770 */         this.baos.reset();
/*     */       }
/*     */       else
/*     */       {
/* 774 */         this.start += used;
/*     */       }
/*     */     }
/*     */ 
/*     */     public boolean brackets(int b)
/*     */     {
/* 780 */       if (this.brackets == -1) {
/* 781 */         return true;
/*     */       }
/* 783 */       if (this.brackets == -2) {
/* 784 */         return false;
/*     */       }
/* 786 */       return this.brackets == b;
/*     */     }
/*     */ 
/*     */     public boolean hasCompatibleBrackets(int b)
/*     */     {
/* 791 */       if ((this.brackets == -1) || (b == -2)) {
/* 792 */         return true;
/*     */       }
/* 794 */       return this.brackets == b;
/*     */     }
/*     */   }
/*     */ 
/*     */   class OutputThread extends StoppableThread
/*     */   {
/* 345 */     private final Logger log = Logger.getLogger(OutputThread.class);
/*     */ 
/* 347 */     private boolean socketIsOpen = true;
/* 348 */     private Map localWriteQueues = new HashMap();
/*     */     private OutputMultiplexor.Message pendingMessage;
/*     */ 
/*     */     public OutputThread()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void shutdown()
/*     */     {
/* 362 */       super.shutdown();
/* 363 */       interrupt();
/*     */     }
/*     */ 
/*     */     protected void doInit()
/*     */     {
/* 369 */       this.log.debug("output thread starting");
/*     */     }
/*     */ 
/*     */     protected void doRun()
/*     */     {
/* 375 */       while (isRunning())
/*     */       {
/* 377 */         this.log.debug("STARTING new output round");
/* 378 */         this.localWriteQueues.clear();
/*     */ 
/* 382 */         synchronized (OutputMultiplexor.this.readyQueues)
/*     */         {
/* 384 */           while (OutputMultiplexor.this.readyQueues.isEmpty())
/*     */           {
/*     */             try
/*     */             {
/* 388 */               this.log.debug("waiting");
/* 389 */               OutputMultiplexor.this.readyQueues.wait();
/*     */             }
/*     */             catch (InterruptedException e)
/*     */             {
/* 393 */               if (!isRunning()) {
/* 394 */                 return;
/*     */               }
/*     */             }
/*     */           }
/* 398 */           this.localWriteQueues.putAll(OutputMultiplexor.this.readyQueues);
/* 399 */           OutputMultiplexor.this.readyQueues.clear();
/*     */         }
/*     */ 
/* 403 */         Iterator it = this.localWriteQueues.keySet().iterator();
/* 404 */         while (it.hasNext())
/*     */         {
/*     */           try
/*     */           {
/* 408 */             MultiplexingManager manager = (MultiplexingManager)it.next();
/* 409 */             List writeQueue = (List)this.localWriteQueues.get(manager);
/* 410 */             OutputStream os = manager.getOutputStream();
/* 411 */             SocketId destination = null;
/* 412 */             int dataOutCount = 0;
/* 413 */             long startTime = System.currentTimeMillis();
/*     */ 
/* 416 */             while (!writeQueue.isEmpty())
/*     */             {
/* 418 */               long timeSpent = System.currentTimeMillis() - startTime;
/* 419 */               if ((timeSpent > OutputMultiplexor.this.maxTimeSlice) || (dataOutCount > OutputMultiplexor.this.maxDataSlice))
/*     */               {
/* 421 */                 if (OutputMultiplexor.this.debug)
/*     */                 {
/* 423 */                   this.log.debug("returning queue: data out: " + dataOutCount + ", time spent: " + timeSpent);
/*     */                 }
/* 425 */                 synchronized (OutputMultiplexor.this.readyQueues)
/*     */                 {
/* 427 */                   OutputMultiplexor.this.readyQueues.put(manager, writeQueue);
/*     */                 }
/*     */ 
/*     */               }
/*     */ 
/* 432 */               this.pendingMessage = ((OutputMultiplexor.Message)writeQueue.remove(0));
/* 433 */               destination = this.pendingMessage.getDestination();
/*     */ 
/* 448 */               int start = this.pendingMessage.getStart();
/* 449 */               int length = Math.min(this.pendingMessage.getLength(), OutputMultiplexor.this.maxChunkSize);
/*     */               try
/*     */               {
/* 452 */                 encode(destination, this.pendingMessage.getContent(), start, length, os, manager.getSocket().getChannel());
/*     */               }
/*     */               catch (ClosedChannelException e)
/*     */               {
/* 457 */                 this.log.info(e);
/* 458 */                 writeQueue.clear();
/* 459 */                 manager.setWriteException(e);
/* 460 */                 break;
/*     */               }
/*     */               catch (IOException e)
/*     */               {
/* 464 */                 String message = e.getMessage();
/* 465 */                 if (("An existing connection was forcibly closed by the remote host".equals(message)) || ("An established connection was aborted by the software in your host machine".equals(message)) || ("Broken pipe".equals(message)))
/*     */                 {
/* 469 */                   this.log.debug(e);
/* 470 */                   writeQueue.clear();
/* 471 */                   manager.setWriteException(e);
/* 472 */                   break;
/*     */                 }
/* 474 */                 if (OutputMultiplexor.access$504(OutputMultiplexor.this) > OutputMultiplexor.this.maxErrors)
/*     */                 {
/* 476 */                   this.log.error(e);
/* 477 */                   manager.setWriteException(e);
/* 478 */                   throw e;
/*     */                 }
/*     */ 
/* 483 */                 throw e;
/*     */               }
/*     */ 
/* 488 */               if (length < this.pendingMessage.getLength())
/* 489 */                 returnLongMessageToQueue(writeQueue, this.pendingMessage);
/*     */               else {
/* 491 */                 OutputMultiplexor.this.releaseMessage(this.pendingMessage);
/*     */               }
/* 493 */               dataOutCount += length;
/* 494 */               this.pendingMessage = null;
/*     */ 
/* 496 */               if (OutputMultiplexor.this.trace) {
/* 497 */                 this.log.trace("output thread wrote: " + length + " bytes to socket " + destination.getPort());
/*     */               }
/*     */             }
/* 500 */             if ((writeQueue.isEmpty()) && (OutputMultiplexor.this.unregisteredClients.contains(manager)))
/*     */             {
/* 502 */               OutputMultiplexor.this.writeQueues.remove(writeQueue);
/* 503 */               OutputMultiplexor.this.previousDestinationIds.remove(manager);
/* 504 */               OutputMultiplexor.this.unregisteredClients.remove(manager);
/* 505 */               manager.outputFlushed();
/*     */ 
/* 529 */               it.remove(); continue;
/*     */             }
/* 509 */             OutputMultiplexor.this.previousDestinationIds.put(manager, destination);
/*     */ 
/* 511 */             if (interrupted()) {
/* 512 */               throw new InterruptedException();
/*     */             }
/*     */ 
/* 529 */             it.remove();
/* 530 */             continue;
/*     */           }
/*     */           catch (InterruptedException e)
/*     */           {
/* 516 */             handleError("output thread: interrupted", e);
/*     */ 
/* 529 */             it.remove();
/* 530 */             continue;
/*     */           }
/*     */           catch (SocketException e)
/*     */           {
/* 520 */             handleError("output thread: socket exception", e);
/*     */ 
/* 529 */             it.remove();
/* 530 */             continue;
/*     */           }
/*     */           catch (IOException e)
/*     */           {
/* 524 */             handleError("output thread: i/o error", e);
/*     */ 
/* 529 */             it.remove();
/* 530 */             continue;
/*     */           }
/*     */           finally
/*     */           {
/* 529 */             it.remove();
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 534 */       this.log.debug("output thread: socketIsConnected: " + this.socketIsOpen);
/* 535 */       this.log.debug("output thread: running: " + this.running);
/* 536 */       this.log.debug("output thread: pendingMessage ==  " + this.pendingMessage);
/*     */     }
/*     */ 
/*     */     protected void doShutDown()
/*     */     {
/* 545 */       this.log.debug("output thread shutting down");
/*     */     }
/*     */ 
/*     */     protected void encode(SocketId destination, byte[] bytes, int start, int length, OutputStream os, SocketChannel channel)
/*     */       throws IOException
/*     */     {
/* 563 */       int port = destination.getPort();
/*     */ 
/* 566 */       OutputMultiplexor.this.header[0] = 0;
/*     */ 
/* 569 */       OutputMultiplexor.this.header[1] = (byte)(port >>> 24 & 0xFF);
/* 570 */       OutputMultiplexor.this.header[2] = (byte)(port >>> 16 & 0xFF);
/* 571 */       OutputMultiplexor.this.header[3] = (byte)(port >>> 8 & 0xFF);
/* 572 */       OutputMultiplexor.this.header[4] = (byte)(port & 0xFF);
/*     */ 
/* 575 */       OutputMultiplexor.this.header[5] = (byte)(length >> 8 & 0xFF);
/* 576 */       OutputMultiplexor.this.header[6] = (byte)(length & 0xFF);
/*     */ 
/* 578 */       if (channel == null)
/*     */       {
/* 580 */         os.write(OutputMultiplexor.this.header);
/* 581 */         os.write(bytes, start, length);
/* 582 */         os.flush();
/*     */       }
/*     */       else
/*     */       {
/* 586 */         OutputMultiplexor.this.buffer.clear();
/* 587 */         OutputMultiplexor.this.buffer.put(OutputMultiplexor.this.header);
/* 588 */         OutputMultiplexor.this.buffer.put(bytes, start, length);
/* 589 */         OutputMultiplexor.this.buffer.flip();
/* 590 */         while (OutputMultiplexor.this.buffer.hasRemaining()) {
/* 591 */           channel.write(OutputMultiplexor.this.buffer);
/*     */         }
/*     */       }
/* 594 */       if (OutputMultiplexor.this.trace)
/*     */       {
/* 596 */         this.log.trace("encode(): wrote " + length + " bytes to: " + destination);
/* 597 */         this.log.trace("header: " + OutputMultiplexor.this.header[0] + " " + OutputMultiplexor.this.header[1] + " " + OutputMultiplexor.this.header[2] + " " + OutputMultiplexor.this.header[3] + " " + OutputMultiplexor.this.header[4] + " " + OutputMultiplexor.this.header[5] + " " + OutputMultiplexor.this.header[6]);
/*     */ 
/* 600 */         for (int i = 0; i < length; i++)
/* 601 */           this.log.trace("" + (0xFF & bytes[i]));
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void returnLongMessageToQueue(List writeQueue, OutputMultiplexor.Message pendingMessage)
/*     */     {
/* 608 */       SocketId destination = pendingMessage.getDestination();
/* 609 */       pendingMessage.markUsed(OutputMultiplexor.this.maxChunkSize);
/*     */ 
/* 611 */       synchronized (writeQueue)
/*     */       {
/* 613 */         if (!writeQueue.isEmpty())
/*     */         {
/* 615 */           ListIterator lit = writeQueue.listIterator();
/* 616 */           boolean processed = false;
/* 617 */           int remotePort = destination.getPort();
/* 618 */           int brackets = pendingMessage.getBrackets();
/*     */ 
/* 620 */           while (lit.hasNext())
/*     */           {
/* 622 */             OutputMultiplexor.Message message = (OutputMultiplexor.Message)lit.next();
/*     */ 
/* 624 */             if (message.brackets(remotePort))
/*     */             {
/* 626 */               lit.previous();
/* 627 */               lit.add(pendingMessage);
/* 628 */               processed = true;
/* 629 */               break;
/*     */             }
/*     */ 
/* 632 */             if ((message.getDestination().equals(destination)) && ((-2 == message.getBrackets()) || (brackets == message.getBrackets())))
/*     */             {
/* 635 */               pendingMessage.addContent(message.getContent(), message.getStart(), message.getLength());
/* 636 */               lit.set(pendingMessage);
/* 637 */               processed = true;
/* 638 */               break;
/*     */             }
/*     */           }
/*     */ 
/* 642 */           if (!processed)
/*     */           {
/* 644 */             writeQueue.add(pendingMessage);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 649 */           writeQueue.add(pendingMessage);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void handleError(String message, Throwable e)
/*     */     {
/* 662 */       if (this.log != null)
/*     */       {
/* 664 */         if ((e instanceof InterruptedException))
/*     */         {
/* 666 */           if (OutputMultiplexor.this.trace)
/* 667 */             this.log.trace(message, e);
/*     */         }
/*     */         else
/* 670 */           this.log.error(message, e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface OutputMultiplexorClient
/*     */   {
/*     */     public abstract void outputFlushed();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.OutputMultiplexor
 * JD-Core Version:    0.6.0
 */