/*     */ package org.jboss.remoting.transport.multiplex;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.net.SocketException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class MultiplexingOutputStream extends OutputStream
/*     */ {
/*  48 */   protected static final Logger log = Logger.getLogger(MultiplexingOutputStream.class);
/*     */   private MultiplexingManager manager;
/*     */   private OutputMultiplexor outputMultiplexor;
/*     */   private VirtualSocket virtualSocket;
/*     */   private SocketId socketId;
/*  53 */   private boolean outputShutdown = false;
/*  54 */   private boolean closed = false;
/*     */   private IOException writeException;
/*     */   private static final int OPEN = 0;
/*     */   private static final int CONNECTION_RESET = 1;
/*     */   private static final int CLOSED = 2;
/*  60 */   private int connectionState = 0;
/*     */ 
/*  62 */   private byte[] oneByte = new byte[1];
/*  63 */   private byte[] fourBytes = new byte[4];
/*     */ 
/*     */   public MultiplexingOutputStream(MultiplexingManager manager, SocketId socketId)
/*     */   {
/*  72 */     this(manager, null, socketId);
/*     */   }
/*     */ 
/*     */   public MultiplexingOutputStream(MultiplexingManager manager, VirtualSocket virtualSocket, SocketId socketId)
/*     */   {
/*  84 */     this.manager = manager;
/*  85 */     this.virtualSocket = virtualSocket;
/*  86 */     this.socketId = socketId;
/*  87 */     this.outputMultiplexor = manager.getOutputMultiplexor();
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 108 */     log.debug("MultiplexingOutputStream.close() entered");
/*     */ 
/* 110 */     if (this.closed) {
/* 111 */       return;
/*     */     }
/* 113 */     this.closed = true;
/*     */ 
/* 115 */     if (this.virtualSocket != null)
/* 116 */       this.virtualSocket.close();
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void write(int i)
/*     */     throws IOException
/*     */   {
/* 134 */     checkStatus();
/* 135 */     this.oneByte[0] = (byte)i;
/* 136 */     this.outputMultiplexor.write(this.manager, this.socketId, this.oneByte);
/*     */   }
/*     */ 
/*     */   public void write(byte[] array)
/*     */     throws IOException, NullPointerException
/*     */   {
/* 144 */     checkStatus();
/* 145 */     this.outputMultiplexor.write(this.manager, this.socketId, array);
/*     */   }
/*     */ 
/*     */   public void write(byte[] array, int off, int len)
/*     */     throws IOException, NullPointerException, IndexOutOfBoundsException
/*     */   {
/* 155 */     checkStatus();
/*     */ 
/* 157 */     if (array == null) {
/* 158 */       throw new NullPointerException();
/*     */     }
/* 160 */     if ((off < 0) || (len < 0) || (off + len > array.length)) {
/* 161 */       throw new IndexOutOfBoundsException();
/*     */     }
/* 163 */     byte[] subArray = new byte[len];
/*     */ 
/* 165 */     for (int i = 0; i < len; i++) {
/* 166 */       subArray[i] = array[(off + i)];
/*     */     }
/* 168 */     this.outputMultiplexor.write(this.manager, this.socketId, subArray);
/*     */   }
/*     */ 
/*     */   protected void setWriteException(IOException e)
/*     */   {
/* 178 */     this.writeException = e;
/*     */   }
/*     */ 
/*     */   public void writeInt(int i)
/*     */     throws IOException
/*     */   {
/* 190 */     this.fourBytes[0] = (byte)(i >>> 24 & 0xFF);
/* 191 */     this.fourBytes[1] = (byte)(i >>> 16 & 0xFF);
/* 192 */     this.fourBytes[2] = (byte)(i >>> 8 & 0xFF);
/* 193 */     this.fourBytes[3] = (byte)(i >>> 0 & 0xFF);
/* 194 */     this.outputMultiplexor.write(this.manager, this.socketId, this.fourBytes);
/*     */   }
/*     */ 
/*     */   protected void checkStatus()
/*     */     throws IOException
/*     */   {
/* 227 */     if (this.closed) {
/* 228 */       throw new SocketException("Socket closed");
/*     */     }
/* 230 */     if (this.outputShutdown) {
/* 231 */       throw new SocketException("Broken pipe");
/*     */     }
/* 233 */     if (this.writeException != null) {
/* 234 */       throw this.writeException;
/*     */     }
/* 236 */     switch (this.connectionState)
/*     */     {
/*     */     case 0:
/* 239 */       return;
/*     */     case 1:
/* 242 */       this.connectionState = 2;
/* 243 */       return;
/*     */     case 2:
/* 246 */       throw new SocketException("Broken pipe");
/*     */     }
/*     */ 
/* 249 */     log.error("unrecognized connection state: " + this.connectionState);
/*     */   }
/*     */ 
/*     */   protected void handleRemoteDisconnect()
/*     */   {
/* 259 */     log.debug("entering handleRemoteDisconnect()");
/*     */ 
/* 261 */     switch (this.connectionState)
/*     */     {
/*     */     case 0:
/* 264 */       this.connectionState = 1;
/* 265 */       return;
/*     */     }
/*     */ 
/* 268 */     this.connectionState = 2;
/* 269 */     log.error("invalid connection state in handleRemoteDisconnect(): " + this.connectionState);
/*     */   }
/*     */ 
/*     */   protected void shutdown()
/*     */   {
/* 279 */     this.outputShutdown = true;
/*     */   }
/*     */ 
/*     */   protected void write(int i, int brackets)
/*     */     throws IOException
/*     */   {
/* 290 */     log.debug("brackets: " + brackets);
/* 291 */     this.oneByte[0] = (byte)i;
/* 292 */     this.outputMultiplexor.write(this.manager, this.socketId, this.oneByte, brackets);
/*     */   }
/*     */ 
/*     */   protected void writeInt(int i, int brackets)
/*     */     throws IOException
/*     */   {
/* 303 */     log.debug("brackets: " + brackets);
/* 304 */     this.fourBytes[0] = (byte)(i >>> 24 & 0xFF);
/* 305 */     this.fourBytes[1] = (byte)(i >>> 16 & 0xFF);
/* 306 */     this.fourBytes[2] = (byte)(i >>> 8 & 0xFF);
/* 307 */     this.fourBytes[3] = (byte)(i >>> 0 & 0xFF);
/* 308 */     this.outputMultiplexor.write(this.manager, this.socketId, this.fourBytes, brackets);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.MultiplexingOutputStream
 * JD-Core Version:    0.6.0
 */