/*      */ package org.jboss.remoting.transport.multiplex;
/*      */ 
/*      */ import java.io.ByteArrayOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.OutputStream;
/*      */ import java.net.InetAddress;
/*      */ import java.net.InetSocketAddress;
/*      */ import java.net.ServerSocket;
/*      */ import java.net.Socket;
/*      */ import java.net.SocketTimeoutException;
/*      */ import java.nio.channels.Channels;
/*      */ import java.nio.channels.SocketChannel;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.Date;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import java.util.Timer;
/*      */ import java.util.TimerTask;
/*      */ import javax.net.SocketFactory;
/*      */ import javax.net.ssl.HandshakeCompletedEvent;
/*      */ import javax.net.ssl.HandshakeCompletedListener;
/*      */ import javax.net.ssl.SSLSocket;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.remoting.transport.multiplex.utility.GrowablePipedOutputStream;
/*      */ import org.jboss.remoting.transport.multiplex.utility.StoppableThread;
/*      */ import org.jboss.remoting.transport.multiplex.utility.VirtualSelector;
/*      */ 
/*      */ public class MultiplexingManager
/*      */   implements OutputMultiplexor.OutputMultiplexorClient, HandshakeCompletedListener
/*      */ {
/*   87 */   private static final Logger log = Logger.getLogger(MultiplexingManager.class);
/*      */   private static int staticThreadsMonitorPeriod;
/*      */   private static boolean staticThreadsRunning;
/*   98 */   private static Object shareableMapLock = new Object();
/*      */ 
/*  103 */   private static Map shareableManagers = new HashMap();
/*      */ 
/*  106 */   private static Object localAddressMapLock = new Object();
/*      */ 
/*  110 */   private static Map managersByLocalAddress = new HashMap();
/*      */ 
/*  113 */   private static Object remoteAddressMapLock = new Object();
/*      */ 
/*  118 */   private static Map managersByRemoteAddress = new HashMap();
/*      */ 
/*  121 */   private static Set allManagers = Collections.synchronizedSet(new HashSet());
/*      */   private static InputMultiplexor inputMultiplexor;
/*      */   private static OutputMultiplexor outputMultiplexor;
/*      */   private static OutputMultiplexor.OutputThread outputThread;
/*      */   private static InputMultiplexor.MultiGroupInputThread multiGroupInputThread;
/*      */   private static VirtualSelector virtualSelector;
/*      */   private static Protocol.BackChannelThread backChannelThread;
/*  143 */   private static List pendingActions = new ArrayList();
/*      */   private static PendingActionThread pendingActionThread;
/*      */   private static Timer timer;
/*      */   private static boolean hasBeenIdle;
/*  155 */   private static final short time = (short)(int)System.currentTimeMillis();
/*      */   private int shutdownRequestTimeout;
/*      */   private int shutdownMonitorPeriod;
/*      */   private int shutdownRefusalsMaximum;
/*  170 */   private static Map configuration = new HashMap();
/*      */ 
/*  173 */   private Map socketMap = Collections.synchronizedMap(new HashMap());
/*      */ 
/*  176 */   private Set registeredSockets = Collections.synchronizedSet(new HashSet());
/*      */ 
/*  179 */   private Map outputStreamMap = Collections.synchronizedMap(new HashMap());
/*      */ 
/*  182 */   private Map inputStreamMap = Collections.synchronizedMap(new HashMap());
/*      */ 
/*  185 */   private Set outputStreamSet = Collections.synchronizedSet(new HashSet());
/*      */   private OutputStream backchannelOutputStream;
/*  191 */   private Set threadsWaitingForRemoteServerSocket = new HashSet();
/*      */   private Protocol protocol;
/*      */   private Socket socket;
/*      */   String description;
/*  203 */   private boolean bound = false;
/*      */ 
/*  206 */   private boolean connected = false;
/*      */   private InetSocketAddress remoteSocketAddress;
/*      */   private InetSocketAddress localSocketAddress;
/*      */   private InetSocketAddress localWildCardAddress;
/*      */   private InputStream inputStream;
/*      */   private OutputStream outputStream;
/*      */   private ServerSocket serverSocket;
/*  227 */   private boolean remoteServerSocketRegistered = false;
/*      */   private boolean createdForRemoteServerSocket;
/*      */   private InputMultiplexor.SingleGroupInputThread inputThread;
/*  237 */   private OutputStream deadLetterOutputStream = new ByteArrayOutputStream();
/*      */ 
/*  240 */   private ShutdownManager shutdownManager = new ShutdownManager();
/*      */   private ShutdownThread shutdownThread;
/*  246 */   private boolean shutdown = false;
/*      */   private boolean trace;
/*      */   private boolean debug;
/*      */   private boolean info;
/*      */   private long id;
/*      */   private SocketFactory socketFactory;
/*      */   private HandshakeCompletedEvent handshakeCompletedEvent;
/*      */   private IOException readException;
/*      */   private IOException writeException;
/*      */ 
/*      */   protected static synchronized void init(Map configuration)
/*      */     throws IOException
/*      */   {
/*      */     try
/*      */     {
/*  276 */       if (staticThreadsRunning) {
/*  277 */         return;
/*      */       }
/*  279 */       log.info("starting static threads");
/*      */ 
/*  282 */       outputMultiplexor = new OutputMultiplexor(configuration);
/*  283 */       outputThread = outputMultiplexor.getAnOutputThread();
/*  284 */       outputThread.setName("output:" + time);
/*  285 */       outputThread.setDaemon(true);
/*  286 */       outputThread.start();
/*  287 */       log.debug("started output thread");
/*      */ 
/*  290 */       inputMultiplexor = new InputMultiplexor(configuration);
/*  291 */       multiGroupInputThread = inputMultiplexor.getaMultiGroupInputThread();
/*  292 */       multiGroupInputThread.setName("input:" + time);
/*  293 */       multiGroupInputThread.setDaemon(true);
/*  294 */       multiGroupInputThread.start();
/*  295 */       log.debug("started input thread");
/*      */ 
/*  298 */       virtualSelector = new VirtualSelector();
/*  299 */       backChannelThread = Protocol.getBackChannelThread(virtualSelector);
/*  300 */       backChannelThread.setName("backchannel:" + time);
/*  301 */       backChannelThread.setDaemon(true);
/*  302 */       backChannelThread.start();
/*  303 */       log.debug("started backchannel thread");
/*      */ 
/*  306 */       timer = new Timer(true);
/*  307 */       TimerTask shutdownMonitorTask = new TimerTask()
/*      */       {
/*      */         public void run()
/*      */         {
/*  311 */           MultiplexingManager.log.trace("allManagers.isEmpty(): " + MultiplexingManager.allManagers.isEmpty());
/*  312 */           MultiplexingManager.log.trace("hasBeenIdle: " + MultiplexingManager.hasBeenIdle);
/*  313 */           if (MultiplexingManager.allManagers.isEmpty())
/*      */           {
/*  315 */             if (MultiplexingManager.hasBeenIdle)
/*      */             {
/*  317 */               MultiplexingManager.shutdownThreads();
/*  318 */               cancel();
/*      */             }
/*      */             else {
/*  321 */               MultiplexingManager.access$202(true);
/*      */             }
/*      */           }
/*      */           else
/*  325 */             MultiplexingManager.access$202(false);
/*      */         }
/*      */       };
/*  330 */       timer.scheduleAtFixedRate(shutdownMonitorTask, staticThreadsMonitorPeriod, staticThreadsMonitorPeriod);
/*      */ 
/*  333 */       pendingActionThread = new PendingActionThread();
/*  334 */       pendingActionThread.setName("pending actions:" + time);
/*  335 */       pendingActionThread.setDaemon(true);
/*  336 */       pendingActionThread.start();
/*  337 */       log.debug("started pendingAction thread");
/*      */ 
/*  339 */       staticThreadsRunning = true;
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  343 */       log.error(e);
/*  344 */       throw e;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected MultiplexingManager(Map configuration)
/*      */     throws IOException
/*      */   {
/*  351 */     if (configuration != null)
/*  352 */       configuration.putAll(configuration);
/*  353 */     this.socketFactory = ((SocketFactory)configuration.get("multiplex.SocketFactory"));
/*  354 */     this.id = new Date().getTime();
/*  355 */     this.socket = createSocket();
/*  356 */     allManagers.add(this);
/*  357 */     if (this.debug) log.debug("new MultiplexingManager(" + this.id + "): " + this.description);
/*      */   }
/*      */ 
/*      */   protected MultiplexingManager(Socket socket, Map configuration)
/*      */     throws IOException
/*      */   {
/*  369 */     this.socket = socket;
/*  370 */     if (configuration != null)
/*  371 */       configuration.putAll(configuration);
/*  372 */     this.id = new Date().getTime();
/*  373 */     setup();
/*  374 */     allManagers.add(this);
/*  375 */     if (this.debug) log.debug("new MultiplexingManager(" + this.id + "): " + this.description);
/*      */   }
/*      */ 
/*      */   protected MultiplexingManager(InetSocketAddress address, int timeout, Map configuration)
/*      */     throws IOException
/*      */   {
/*  389 */     if (configuration != null)
/*  390 */       configuration.putAll(configuration);
/*  391 */     this.socketFactory = ((SocketFactory)configuration.get("multiplex.SocketFactory"));
/*  392 */     this.id = new Date().getTime();
/*  393 */     this.socket = createSocket(address, timeout);
/*  394 */     setup();
/*  395 */     allManagers.add(this);
/*  396 */     if (this.debug) log.debug("new MultiplexingManager(" + this.id + "): " + this.description);
/*      */   }
/*      */ 
/*      */   protected synchronized void setup()
/*      */     throws IOException
/*      */   {
/*  405 */     this.description = this.socket.toString();
/*  406 */     this.trace = log.isTraceEnabled();
/*  407 */     this.debug = log.isDebugEnabled();
/*  408 */     this.info = log.isInfoEnabled();
/*      */ 
/*  411 */     initParameters(configuration);
/*      */ 
/*  414 */     synchronized (MultiplexingManager.class)
/*      */     {
/*  416 */       if (!staticThreadsRunning) {
/*  417 */         init(configuration);
/*      */       }
/*      */     }
/*      */ 
/*  421 */     if (this.socket.getChannel() == null)
/*      */     {
/*  425 */       this.inputStream = this.socket.getInputStream();
/*  426 */       this.outputStream = this.socket.getOutputStream();
/*      */     }
/*      */     else
/*      */     {
/*  430 */       this.inputStream = Channels.newInputStream(this.socket.getChannel());
/*  431 */       this.outputStream = Channels.newOutputStream(this.socket.getChannel());
/*  432 */       this.socket.setTcpNoDelay(false);
/*      */     }
/*      */ 
/*  436 */     this.outputStreamMap.put(SocketId.DEADLETTER_SOCKET_ID, this.deadLetterOutputStream);
/*      */ 
/*  439 */     this.registeredSockets.add(SocketId.PROTOCOL_SOCKET_ID);
/*  440 */     this.registeredSockets.add(SocketId.SERVER_SOCKET_ID);
/*  441 */     this.registeredSockets.add(SocketId.SERVER_SOCKET_CONNECT_ID);
/*  442 */     this.registeredSockets.add(SocketId.SERVER_SOCKET_VERIFY_ID);
/*  443 */     this.registeredSockets.add(SocketId.BACKCHANNEL_SOCKET_ID);
/*      */ 
/*  446 */     getAnInputStream(SocketId.PROTOCOL_SOCKET_ID, null);
/*  447 */     getAnInputStream(SocketId.SERVER_SOCKET_ID, null);
/*  448 */     getAnInputStream(SocketId.SERVER_SOCKET_CONNECT_ID, null);
/*  449 */     getAnInputStream(SocketId.SERVER_SOCKET_VERIFY_ID, null);
/*      */ 
/*  452 */     this.protocol = new Protocol(this);
/*  453 */     MultiplexingInputStream bcis = getAnInputStream(SocketId.BACKCHANNEL_SOCKET_ID, null);
/*  454 */     bcis.register(virtualSelector, this);
/*  455 */     if (this.debug) log.debug("registered backchannel input stream");
/*  456 */     this.backchannelOutputStream = new MultiplexingOutputStream(this, SocketId.PROTOCOL_SOCKET_ID);
/*      */ 
/*  459 */     outputMultiplexor.register(this);
/*      */ 
/*  462 */     if (this.socket.getChannel() == null)
/*      */     {
/*  465 */       log.debug("creating single group input thread");
/*      */ 
/*  467 */       if (inputMultiplexor == null) {
/*  468 */         inputMultiplexor = new InputMultiplexor(configuration);
/*      */       }
/*  470 */       this.inputThread = inputMultiplexor.getaSingleGroupInputThread(this, this.socket, this.deadLetterOutputStream);
/*  471 */       this.inputThread.setName(this.inputThread.getName() + ":input(" + this.description + ")");
/*  472 */       this.inputThread.start();
/*      */     }
/*      */     else
/*      */     {
/*  476 */       this.socket.getChannel().configureBlocking(false);
/*  477 */       multiGroupInputThread.registerSocketGroup(this);
/*  478 */       log.debug("registered socket group");
/*      */     }
/*      */ 
/*  481 */     registerByLocalAddress(new InetSocketAddress(this.socket.getLocalAddress(), this.socket.getLocalPort()));
/*  482 */     registerByRemoteAddress(new InetSocketAddress(this.socket.getInetAddress(), this.socket.getPort()));
/*  483 */     this.bound = true;
/*  484 */     this.connected = true;
/*      */ 
/*  486 */     if ((this.socket instanceof SSLSocket))
/*      */     {
/*  494 */       ((SSLSocket)this.socket).addHandshakeCompletedListener(this);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initParameters(Map configuration)
/*      */   {
/*  501 */     configuration = configuration;
/*      */ 
/*  503 */     staticThreadsMonitorPeriod = Multiplex.getOneParameter(configuration, "staticThreadsMonitorPeriod", "multiplex.staticThreadsMonitorPeriod", 5000);
/*      */ 
/*  509 */     this.shutdownRequestTimeout = Multiplex.getOneParameter(configuration, "shutdownRequestTimeout", "multiplex.shutdownRequestTimeout", 5000);
/*      */ 
/*  515 */     this.shutdownRefusalsMaximum = Multiplex.getOneParameter(configuration, "shutdownRefusalsMaximum", "multiplex.shutdownRefusalsMaximum", 5);
/*      */ 
/*  521 */     this.shutdownMonitorPeriod = Multiplex.getOneParameter(configuration, "shutdownMonitorPeriod", "multiplex.shutdownMonitorPeriod", 1000);
/*      */   }
/*      */ 
/*      */   public static MultiplexingManager getaManager(Socket socket, Map configuration)
/*      */     throws IOException
/*      */   {
/*  540 */     log.debug("entering getaManager(Socket socket)");
/*  541 */     return new MultiplexingManager(socket, configuration);
/*      */   }
/*      */ 
/*      */   public static synchronized MultiplexingManager getaManagerByLocalAddress(InetSocketAddress address)
/*      */     throws IOException
/*      */   {
/*  553 */     return getaManagerByLocalAddress(address, null);
/*      */   }
/*      */ 
/*      */   public static synchronized MultiplexingManager getaManagerByLocalAddress(InetSocketAddress address, Map conf)
/*      */     throws IOException
/*      */   {
/*  567 */     log.debug("entering getaManagerByLocalAddress(InetSocketAddress address)");
/*  568 */     MultiplexingManager m = null;
/*      */ 
/*  570 */     synchronized (localAddressMapLock)
/*      */     {
/*  572 */       HashSet managers = (HashSet)managersByLocalAddress.get(address);
/*      */ 
/*  574 */       if (managers != null)
/*      */       {
/*  576 */         Iterator it = managers.iterator();
/*  577 */         while (it.hasNext())
/*      */         {
/*  579 */           m = (MultiplexingManager)it.next();
/*      */           try
/*      */           {
/*  582 */             m.shutdownManager.incrementReferences();
/*  583 */             return m;
/*      */           }
/*      */           catch (IOException e)
/*      */           {
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  592 */     log.debug("There is no joinable MultiplexingManager. Creating new one.");
/*  593 */     m = new MultiplexingManager(conf);
/*  594 */     m.bind(address);
/*  595 */     return m;
/*      */   }
/*      */ 
/*      */   public static synchronized MultiplexingManager getaManagerByRemoteAddress(InetSocketAddress address, int timeout)
/*      */     throws IOException
/*      */   {
/*  609 */     return getaManagerByRemoteAddress(address, timeout, null);
/*      */   }
/*      */ 
/*      */   public static synchronized MultiplexingManager getaManagerByRemoteAddress(InetSocketAddress address, int timeout, Map conf)
/*      */     throws IOException
/*      */   {
/*  625 */     log.debug("entering getaManagerByRemoteAddress(InetSocketAddress address)");
/*      */ 
/*  632 */     synchronized (remoteAddressMapLock)
/*      */     {
/*  634 */       HashSet managers = (HashSet)managersByRemoteAddress.get(address);
/*      */ 
/*  636 */       if ((managers != null) && (!managers.isEmpty()))
/*      */       {
/*  638 */         Iterator it = managers.iterator();
/*  639 */         while (it.hasNext())
/*      */         {
/*  641 */           MultiplexingManager m = (MultiplexingManager)it.next();
/*      */           try
/*      */           {
/*  644 */             m.shutdownManager.incrementReferences();
/*  645 */             return m;
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*  649 */             log.debug("manager shutting down: " + m);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  655 */     return new MultiplexingManager(address, timeout, conf);
/*      */   }
/*      */ 
/*      */   public static synchronized MultiplexingManager getaManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout)
/*      */     throws IOException
/*      */   {
/*  671 */     return getaManagerByAddressPair(remoteAddress, localAddress, timeout, null);
/*      */   }
/*      */ 
/*      */   public static synchronized MultiplexingManager getaManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout, Map conf)
/*      */     throws IOException
/*      */   {
/*  688 */     log.debug("entering getaManagerByRemoteAddress(InetSocketAddress address)");
/*      */ 
/*  693 */     synchronized (remoteAddressMapLock)
/*      */     {
/*  695 */       HashSet managers = (HashSet)managersByRemoteAddress.get(remoteAddress);
/*      */ 
/*  697 */       if ((managers != null) && (!managers.isEmpty()))
/*      */       {
/*  699 */         Iterator it = managers.iterator();
/*      */ 
/*  701 */         while (it.hasNext())
/*      */         {
/*  703 */           MultiplexingManager m = (MultiplexingManager)it.next();
/*  704 */           if ((!m.getSocket().getLocalAddress().equals(localAddress.getAddress())) || (m.getSocket().getLocalPort() != localAddress.getPort())) {
/*      */             continue;
/*      */           }
/*      */           try
/*      */           {
/*  709 */             m.shutdownManager.incrementReferences();
/*  710 */             return m;
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*  714 */             log.debug("manager shutting down: " + m);
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  721 */     log.debug("There is no joinable MultiplexingManager. Creating new one.");
/*  722 */     MultiplexingManager m = new MultiplexingManager(conf);
/*  723 */     m.bind(localAddress);
/*  724 */     return m;
/*      */   }
/*      */ 
/*      */   public static synchronized MultiplexingManager getaShareableManager(InetSocketAddress address, int timeout)
/*      */     throws IOException
/*      */   {
/*  737 */     return getaShareableManager(address, timeout, null);
/*      */   }
/*      */ 
/*      */   public static synchronized MultiplexingManager getaShareableManager(InetSocketAddress address, int timeout, Map conf)
/*      */     throws IOException
/*      */   {
/*  751 */     log.debug("entering getaShareableManager(InetSocketAddress address)");
/*      */ 
/*  755 */     synchronized (shareableMapLock)
/*      */     {
/*  757 */       HashSet managers = (HashSet)shareableManagers.get(address);
/*      */ 
/*  759 */       if ((managers != null) && (!managers.isEmpty()))
/*      */       {
/*  761 */         Iterator it = managers.iterator();
/*  762 */         while (it.hasNext())
/*      */         {
/*  764 */           MultiplexingManager m = (MultiplexingManager)it.next();
/*      */           try
/*      */           {
/*  767 */             m.shutdownManager.incrementReferences();
/*  768 */             return m;
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*  772 */             log.debug("manager shutting down: " + m);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  778 */     return new MultiplexingManager(address, timeout, conf);
/*      */   }
/*      */ 
/*      */   public static MultiplexingManager getAnExistingShareableManager(InetSocketAddress address, Map conf)
/*      */     throws IOException
/*      */   {
/*  793 */     log.debug("entering getAnExistingShareableManager()");
/*      */ 
/*  797 */     synchronized (shareableMapLock)
/*      */     {
/*  799 */       HashSet managers = (HashSet)shareableManagers.get(address);
/*      */ 
/*  801 */       if ((managers != null) && (!managers.isEmpty()))
/*      */       {
/*  803 */         Iterator it = managers.iterator();
/*      */ 
/*  805 */         while (it.hasNext())
/*      */         {
/*  807 */           MultiplexingManager m = (MultiplexingManager)it.next();
/*      */           try
/*      */           {
/*  810 */             m.shutdownManager.incrementReferences();
/*  811 */             return m;
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*  815 */             log.debug("manager shutting down: " + m);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  821 */     return null;
/*      */   }
/*      */ 
/*      */   public static synchronized MultiplexingManager getaShareableManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout)
/*      */     throws IOException
/*      */   {
/*  836 */     return getaShareableManagerByAddressPair(remoteAddress, localAddress, timeout, null);
/*      */   }
/*      */ 
/*      */   public static synchronized MultiplexingManager getaShareableManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout, Map conf)
/*      */     throws IOException
/*      */   {
/*  857 */     synchronized (shareableMapLock)
/*      */     {
/*  859 */       HashSet managers = (HashSet)shareableManagers.get(remoteAddress);
/*  860 */       if ((managers != null) && (!managers.isEmpty()))
/*      */       {
/*  862 */         Iterator it = managers.iterator();
/*      */ 
/*  864 */         while (it.hasNext())
/*      */         {
/*  866 */           MultiplexingManager m = (MultiplexingManager)it.next();
/*  867 */           if ((!m.getSocket().getLocalAddress().equals(localAddress.getAddress())) || (m.getSocket().getLocalPort() != localAddress.getPort())) {
/*      */             continue;
/*      */           }
/*      */           try
/*      */           {
/*  872 */             m.shutdownManager.incrementReferences();
/*  873 */             return m;
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*  877 */             log.debug("manager shutting down: " + m);
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  884 */     log.debug("There is no joinable MultiplexingManager. Creating new one.");
/*  885 */     MultiplexingManager m = new MultiplexingManager(conf);
/*  886 */     m.bind(localAddress);
/*  887 */     return m;
/*      */   }
/*      */ 
/*      */   public static MultiplexingManager getAnExistingShareableManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, Map conf)
/*      */     throws IOException
/*      */   {
/*  904 */     log.debug("entering getaShareableManager(InetSocketAddress address)");
/*      */ 
/*  909 */     synchronized (shareableMapLock)
/*      */     {
/*  911 */       HashSet managers = (HashSet)shareableManagers.get(remoteAddress);
/*      */ 
/*  913 */       if ((managers != null) && (!managers.isEmpty()))
/*      */       {
/*  915 */         Iterator it = managers.iterator();
/*      */ 
/*  917 */         while (it.hasNext())
/*      */         {
/*  919 */           MultiplexingManager m = (MultiplexingManager)it.next();
/*  920 */           if ((!m.getSocket().getLocalAddress().equals(localAddress.getAddress())) || (m.getSocket().getLocalPort() != localAddress.getPort())) {
/*      */             continue;
/*      */           }
/*      */           try
/*      */           {
/*  925 */             m.shutdownManager.incrementReferences();
/*  926 */             return m;
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*  930 */             log.debug("manager shutting down: " + m);
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  937 */     return null;
/*      */   }
/*      */ 
/*      */   public static boolean checkForShareableManager(InetSocketAddress address)
/*      */     throws IOException
/*      */   {
/*  949 */     log.debug("entering checkForShareableManager(InetSocketAddress address)");
/*      */ 
/*  952 */     synchronized (shareableMapLock)
/*      */     {
/*  954 */       HashSet managers = (HashSet)shareableManagers.get(address);
/*      */ 
/*  957 */       return (managers != null) && (!managers.isEmpty());
/*      */     }
/*      */   }
/*      */ 
/*      */   public static boolean checkForManagerByAddressPair(InetSocketAddress localAddress, InetSocketAddress remoteAddress)
/*      */   {
/*  972 */     log.debug("entering checkForManagerByAddressPair()");
/*      */ 
/*  976 */     synchronized (remoteAddressMapLock)
/*      */     {
/*  978 */       HashSet managers = (HashSet)managersByRemoteAddress.get(remoteAddress);
/*      */ 
/*  980 */       if ((managers != null) && (!managers.isEmpty()))
/*      */       {
/*  982 */         Iterator it = managers.iterator();
/*      */ 
/*  984 */         while (it.hasNext())
/*      */         {
/*  986 */           MultiplexingManager m = (MultiplexingManager)it.next();
/*      */ 
/*  988 */           if (m.localSocketAddress.equals(localAddress)) {
/*  989 */             return true;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*  994 */     return false;
/*      */   }
/*      */ 
/*      */   public static boolean checkForShareableManagerByAddressPair(InetSocketAddress localAddress, InetSocketAddress remoteAddress)
/*      */   {
/* 1006 */     log.debug("entering checkForShareableManagerByAddressPair()");
/*      */ 
/* 1010 */     synchronized (shareableMapLock)
/*      */     {
/* 1012 */       HashSet managers = (HashSet)shareableManagers.get(remoteAddress);
/*      */ 
/* 1014 */       if ((managers != null) && (!managers.isEmpty()))
/*      */       {
/* 1016 */         Iterator it = managers.iterator();
/*      */ 
/* 1018 */         while (it.hasNext())
/*      */         {
/* 1020 */           MultiplexingManager m = (MultiplexingManager)it.next();
/*      */ 
/* 1022 */           if (m.localSocketAddress.equals(localAddress)) {
/* 1023 */             return true;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 1028 */     return false;
/*      */   }
/*      */ 
/*      */   public static int getStaticThreadMonitorPeriod()
/*      */   {
/* 1037 */     return staticThreadsMonitorPeriod;
/*      */   }
/*      */ 
/*      */   public static void setStaticThreadsMonitorPeriod(int period)
/*      */   {
/* 1046 */     staticThreadsMonitorPeriod = period;
/*      */   }
/*      */ 
/*      */   protected static synchronized void shutdownThreads()
/*      */   {
/* 1055 */     log.info("entering shutdownThreads");
/* 1056 */     if (outputThread != null) {
/* 1057 */       outputThread.shutdown();
/*      */     }
/* 1059 */     if (multiGroupInputThread != null) {
/* 1060 */       multiGroupInputThread.shutdown();
/*      */     }
/* 1062 */     if (backChannelThread != null) {
/* 1063 */       backChannelThread.shutdown();
/*      */     }
/* 1065 */     if (pendingActionThread != null) {
/* 1066 */       pendingActionThread.shutdown();
/*      */     }
/* 1068 */     log.info("cancelling timer");
/* 1069 */     if (timer != null) {
/* 1070 */       timer.cancel();
/*      */     }
/*      */     while (true)
/*      */     {
/*      */       try
/*      */       {
/* 1076 */         if (outputThread != null) {
/* 1077 */           outputThread.join();
/*      */         }
/* 1079 */         if (multiGroupInputThread != null) {
/* 1080 */           multiGroupInputThread.join();
/*      */         }
/* 1082 */         if (backChannelThread != null) {
/* 1083 */           backChannelThread.join();
/*      */         }
/* 1085 */         if (pendingActionThread != null) {
/* 1086 */           pendingActionThread.join();
/*      */         }
/*      */       }
/*      */       catch (InterruptedException ignored)
/*      */       {
/*      */       }
/*      */     }
/* 1093 */     staticThreadsRunning = false;
/* 1094 */     log.info("static threads shut down");
/*      */   }
/*      */ 
/*      */   protected static void addToPendingActions(PendingAction pendingAction)
/*      */   {
/* 1104 */     synchronized (pendingActions)
/*      */     {
/* 1106 */       pendingActions.add(pendingAction);
/* 1107 */       pendingActions.notifyAll();
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void bind(InetSocketAddress address)
/*      */     throws IOException
/*      */   {
/* 1119 */     if (this.bound) {
/* 1120 */       throw new IOException("socket is already bound");
/*      */     }
/* 1122 */     if (this.socket == null) {
/* 1123 */       this.socket = createSocket();
/*      */     }
/* 1125 */     if (this.socket == null)
/* 1126 */       this.localSocketAddress = address;
/*      */     else {
/* 1128 */       this.socket.bind(address);
/*      */     }
/* 1130 */     this.bound = true;
/*      */   }
/*      */ 
/*      */   public synchronized void connect(InetSocketAddress address, int timeout)
/*      */     throws IOException
/*      */   {
/* 1141 */     if (this.connected)
/*      */     {
/* 1143 */       if (this.socket.getRemoteSocketAddress().equals(address)) {
/* 1144 */         return;
/*      */       }
/* 1146 */       throw new IOException("socket is already connected");
/*      */     }
/*      */ 
/* 1149 */     if (this.debug) log.debug("connecting to: " + address);
/*      */ 
/* 1151 */     if (this.socket == null)
/* 1152 */       this.socket = createSocket(address, timeout);
/*      */     else {
/* 1154 */       this.socket.connect(address, timeout);
/*      */     }
/* 1156 */     this.connected = true;
/* 1157 */     setup();
/*      */   }
/*      */ 
/*      */   public synchronized MultiplexingInputStream registerServerSocket(ServerSocket serverSocket)
/*      */     throws IOException
/*      */   {
/* 1167 */     if ((this.serverSocket != null) && (this.serverSocket != serverSocket))
/*      */     {
/* 1169 */       log.error("[" + this.id + "]: " + "attempt to register a second server socket");
/* 1170 */       log.error("current server socket: " + this.serverSocket.toString());
/* 1171 */       log.error("new server socket:     " + serverSocket.toString());
/* 1172 */       throw new IOException("attempt to register a second server socket");
/*      */     }
/*      */ 
/* 1175 */     if (this.debug) log.debug(serverSocket.toString());
/* 1176 */     this.serverSocket = serverSocket;
/* 1177 */     return getAnInputStream(SocketId.SERVER_SOCKET_ID, null);
/*      */   }
/*      */ 
/*      */   public synchronized void unRegisterServerSocket(ServerSocket serverSocket)
/*      */     throws IOException
/*      */   {
/* 1188 */     if (this.serverSocket != serverSocket)
/*      */     {
/* 1190 */       log.error("server socket attempting unregister but is not registered");
/* 1191 */       throw new IOException("server socket is not registered");
/*      */     }
/*      */ 
/* 1194 */     log.debug("server socket unregistering");
/* 1195 */     removeAnInputStream(SocketId.SERVER_SOCKET_ID);
/* 1196 */     this.serverSocket = null;
/* 1197 */     this.shutdownManager.decrementReferences();
/*      */   }
/*      */ 
/*      */   public synchronized MultiplexingInputStream registerSocket(VirtualSocket socket)
/*      */     throws IOException
/*      */   {
/* 1209 */     SocketId localSocketId = socket.getLocalSocketId();
/* 1210 */     VirtualSocket currentSocket = (VirtualSocket)this.socketMap.put(localSocketId, socket);
/*      */ 
/* 1212 */     if (currentSocket != null)
/*      */     {
/* 1214 */       String errorMessage = "attempting to register socket on currently used port:" + currentSocket.getLocalVirtualPort();
/*      */ 
/* 1216 */       log.error(errorMessage);
/* 1217 */       throw new IOException(errorMessage);
/*      */     }
/*      */ 
/* 1220 */     if (this.debug) log.debug("registering virtual socket on port: " + localSocketId.getPort());
/* 1221 */     this.registeredSockets.add(socket.getLocalSocketId());
/* 1222 */     return getAnInputStream(localSocketId, socket);
/*      */   }
/*      */ 
/*      */   public synchronized void unRegisterSocket(VirtualSocket socket)
/*      */     throws IOException
/*      */   {
/*      */     try
/*      */     {
/* 1235 */       if (this.info) log.info(this + ": entering unRegisterSocket()");
/* 1236 */       this.shutdownManager.decrementReferences();
/*      */ 
/* 1238 */       SocketId localSocketId = socket.getLocalSocketId();
/* 1239 */       if (localSocketId == null)
/*      */         return;
/* 1242 */       VirtualSocket currentSocket = (VirtualSocket)this.socketMap.remove(localSocketId);
/* 1243 */       if (currentSocket == null)
/*      */       {
/* 1245 */         String errorMessage = "attempting to unregister unrecognized socket: " + socket.getLocalSocketId().getPort();
/* 1246 */         log.error(errorMessage);
/* 1247 */         throw new IOException(errorMessage);
/*      */       }
/*      */ 
/* 1250 */       if (this.debug) log.debug("unregistering virtual socket on port: " + localSocketId.getPort());
/* 1251 */       this.registeredSockets.remove(localSocketId);
/* 1252 */       removeAnInputStream(localSocketId);
/* 1253 */       if (this.info) log.info(this + ": leaving unRegisterSocket()");
/*      */     }
/*      */     finally
/*      */     {
/* 1257 */       socket.close();
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void registerRemoteServerSocket()
/*      */     throws IOException
/*      */   {
/* 1271 */     log.debug("registerRemoteServerSocket()");
/* 1272 */     if (this.remoteServerSocketRegistered)
/*      */     {
/* 1274 */       log.error("duplicate remote server socket registration");
/* 1275 */       throw new IOException("duplicate remote server socket registration");
/*      */     }
/*      */ 
/* 1279 */     this.remoteServerSocketRegistered = true;
/*      */ 
/* 1283 */     registerShareable(this.remoteSocketAddress);
/*      */ 
/* 1285 */     synchronized (this.threadsWaitingForRemoteServerSocket)
/*      */     {
/* 1287 */       this.threadsWaitingForRemoteServerSocket.notifyAll();
/*      */     }
/*      */ 
/* 1290 */     if (!this.createdForRemoteServerSocket)
/* 1291 */       incrementReferences();
/*      */   }
/*      */ 
/*      */   public synchronized void unRegisterRemoteServerSocket()
/*      */   {
/* 1303 */     if (!this.remoteServerSocketRegistered) {
/* 1304 */       log.error("no remote server socket is registered");
/*      */     }
/*      */     else {
/* 1307 */       if (this.debug) log.debug(this + ": remote VSS unregistering");
/* 1308 */       this.remoteServerSocketRegistered = false;
/* 1309 */       unregisterShareable();
/*      */ 
/* 1311 */       addToPendingActions(new PendingAction()
/*      */       {
/*      */         void doAction()
/*      */         {
/*      */           try
/*      */           {
/* 1319 */             MultiplexingManager.this.decrementReferences();
/*      */           }
/*      */           catch (IOException e)
/*      */           {
/* 1323 */             MultiplexingManager.log.error(e);
/*      */           }
/*      */         }
/*      */       });
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setCreatedForRemoteServerSocket()
/*      */   {
/* 1334 */     this.createdForRemoteServerSocket = true;
/*      */   }
/*      */ 
/*      */   public synchronized boolean isRemoteServerSocketRegistered()
/*      */   {
/* 1340 */     return this.remoteServerSocketRegistered;
/*      */   }
/*      */ 
/*      */   public boolean waitForRemoteServerSocketRegistered()
/*      */   {
/* 1346 */     if (this.remoteServerSocketRegistered) {
/* 1347 */       return true;
/*      */     }
/* 1349 */     synchronized (this.threadsWaitingForRemoteServerSocket)
/*      */     {
/* 1351 */       this.threadsWaitingForRemoteServerSocket.add(Thread.currentThread());
/*      */ 
/* 1353 */       while (!this.remoteServerSocketRegistered)
/*      */       {
/*      */         try
/*      */         {
/* 1357 */           this.threadsWaitingForRemoteServerSocket.wait();
/*      */         }
/*      */         catch (InterruptedException e)
/*      */         {
/* 1361 */           log.info("interrupted waiting for registration of remote server socket");
/*      */ 
/* 1363 */           if (this.shutdown)
/*      */           {
/* 1365 */             this.threadsWaitingForRemoteServerSocket.remove(Thread.currentThread());
/* 1366 */             return false;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1372 */     this.threadsWaitingForRemoteServerSocket.remove(Thread.currentThread());
/* 1373 */     return true;
/*      */   }
/*      */ 
/*      */   public void incrementReferences()
/*      */     throws IOException
/*      */   {
/* 1382 */     this.shutdownManager.incrementReferences();
/*      */   }
/*      */ 
/*      */   public void decrementReferences()
/*      */     throws IOException
/*      */   {
/* 1392 */     this.shutdownManager.decrementReferences();
/*      */   }
/*      */ 
/*      */   public Collection getAllOutputStreams()
/*      */   {
/* 1402 */     return this.outputStreamMap.values();
/*      */   }
/*      */ 
/*      */   public OutputStream getDeadLetterOutputStream()
/*      */   {
/* 1412 */     return this.deadLetterOutputStream;
/*      */   }
/*      */ 
/*      */   public InputStream getInputStream()
/*      */   {
/* 1422 */     return this.inputStream;
/*      */   }
/*      */ 
/*      */   public OutputStream getOutputStream()
/*      */   {
/* 1432 */     return this.outputStream;
/*      */   }
/*      */ 
/*      */   public MultiplexingInputStream getAnInputStream(SocketId socketId, VirtualSocket socket)
/*      */     throws IOException
/*      */   {
/* 1444 */     if (this.debug) log.debug("getAnInputStream(): " + socketId.getPort());
/* 1445 */     MultiplexingInputStream mis = (MultiplexingInputStream)this.inputStreamMap.get(socketId);
/*      */ 
/* 1447 */     if (mis != null)
/*      */     {
/* 1449 */       if (mis.getSocket() == null)
/* 1450 */         mis.setSocket(socket);
/* 1451 */       return mis;
/*      */     }
/*      */ 
/* 1454 */     GrowablePipedOutputStream pos = (GrowablePipedOutputStream)this.outputStreamMap.get(socketId);
/* 1455 */     if (pos == null)
/*      */     {
/* 1457 */       pos = new GrowablePipedOutputStream();
/* 1458 */       this.outputStreamMap.put(socketId, pos);
/*      */     }
/*      */ 
/* 1461 */     mis = new MultiplexingInputStream(pos, this, socket);
/* 1462 */     this.inputStreamMap.put(socketId, mis);
/* 1463 */     if (this.readException != null) {
/* 1464 */       mis.setReadException(this.readException);
/*      */     }
/* 1466 */     return mis;
/*      */   }
/*      */ 
/*      */   public GrowablePipedOutputStream getAnOutputStream(SocketId socketId)
/*      */   {
/* 1476 */     if (this.debug) log.debug("getAnOutputStream(): " + socketId.getPort());
/*      */ 
/* 1478 */     GrowablePipedOutputStream pos = (GrowablePipedOutputStream)this.outputStreamMap.get(socketId);
/* 1479 */     if (pos == null)
/*      */     {
/* 1481 */       pos = new GrowablePipedOutputStream();
/* 1482 */       this.outputStreamMap.put(socketId, pos);
/*      */     }
/*      */ 
/* 1485 */     return pos;
/*      */   }
/*      */ 
/*      */   public MultiplexingOutputStream getAnOutputStream(VirtualSocket socket, SocketId socketId)
/*      */   {
/* 1495 */     MultiplexingOutputStream mos = new MultiplexingOutputStream(this, socket, socketId);
/* 1496 */     this.outputStreamSet.add(mos);
/* 1497 */     if (this.writeException != null)
/* 1498 */       mos.setWriteException(this.writeException);
/* 1499 */     return mos;
/*      */   }
/*      */ 
/*      */   public GrowablePipedOutputStream getConnectedOutputStream(SocketId socketId)
/*      */     throws IOException
/*      */   {
/* 1520 */     if (this.debug) log.debug("getConnectedOutputStream(): " + socketId.getPort());
/*      */ 
/* 1522 */     MultiplexingInputStream mis = (MultiplexingInputStream)this.inputStreamMap.get(socketId);
/* 1523 */     if (mis != null)
/*      */     {
/* 1525 */       GrowablePipedOutputStream pos = (GrowablePipedOutputStream)this.outputStreamMap.get(socketId);
/* 1526 */       if (pos == null)
/*      */       {
/* 1528 */         StringBuffer message = new StringBuffer();
/* 1529 */         message.append("MultiplexingInputStream exists ").append("without matching GrowablePipedOutputStream: ").append("socketId = ").append(socketId);
/*      */ 
/* 1532 */         throw new IOException(message.toString());
/*      */       }
/* 1534 */       return pos;
/*      */     }
/*      */ 
/* 1537 */     GrowablePipedOutputStream pos = (GrowablePipedOutputStream)this.outputStreamMap.get(socketId);
/* 1538 */     if (pos == null)
/*      */     {
/* 1540 */       pos = new GrowablePipedOutputStream();
/* 1541 */       this.outputStreamMap.put(socketId, pos);
/*      */     }
/*      */ 
/* 1544 */     mis = new MultiplexingInputStream(pos, this);
/* 1545 */     this.inputStreamMap.put(socketId, mis);
/* 1546 */     return pos;
/*      */   }
/*      */ 
/*      */   public OutputStream getBackchannelOutputStream()
/*      */   {
/* 1555 */     return this.backchannelOutputStream;
/*      */   }
/*      */ 
/*      */   public HandshakeCompletedEvent getHandshakeCompletedEvent()
/*      */   {
/* 1564 */     return this.handshakeCompletedEvent;
/*      */   }
/*      */ 
/*      */   public OutputMultiplexor getOutputMultiplexor()
/*      */   {
/* 1572 */     return outputMultiplexor;
/*      */   }
/*      */ 
/*      */   public OutputStream getOutputStreamByLocalSocket(SocketId socketId)
/*      */   {
/* 1583 */     return (OutputStream)this.outputStreamMap.get(socketId);
/*      */   }
/*      */ 
/*      */   public Protocol getProtocol()
/*      */   {
/* 1593 */     return this.protocol;
/*      */   }
/*      */ 
/*      */   public synchronized ServerSocket getServerSocket()
/*      */   {
/* 1602 */     return this.serverSocket;
/*      */   }
/*      */ 
/*      */   public Socket getSocket()
/*      */   {
/* 1612 */     return this.socket;
/*      */   }
/*      */ 
/*      */   public VirtualSocket getSocketByLocalPort(SocketId socketId)
/*      */   {
/* 1623 */     return (VirtualSocket)this.socketMap.get(socketId);
/*      */   }
/*      */ 
/*      */   public SocketFactory getSocketFactory()
/*      */   {
/* 1632 */     return this.socketFactory;
/*      */   }
/*      */ 
/*      */   public void handshakeCompleted(HandshakeCompletedEvent event)
/*      */   {
/* 1641 */     this.description = this.socket.toString();
/*      */ 
/* 1643 */     this.handshakeCompletedEvent = event;
/* 1644 */     Object obj = configuration.get("multiplex.SSLHandshakeListener");
/* 1645 */     if (obj != null)
/*      */     {
/* 1647 */       HandshakeCompletedListener listener = (HandshakeCompletedListener)obj;
/* 1648 */       listener.handshakeCompleted(event);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isBound()
/*      */   {
/* 1658 */     return this.bound;
/*      */   }
/*      */ 
/*      */   public boolean isConnected()
/*      */   {
/* 1667 */     return this.connected;
/*      */   }
/*      */ 
/*      */   public synchronized boolean isServerSocketRegistered()
/*      */   {
/* 1676 */     return this.serverSocket != null;
/*      */   }
/*      */ 
/*      */   public boolean isShutdown()
/*      */   {
/* 1685 */     return this.shutdown;
/*      */   }
/*      */ 
/*      */   public synchronized boolean isSocketRegistered(SocketId socketId)
/*      */   {
/* 1697 */     return this.registeredSockets.contains(socketId);
/*      */   }
/*      */ 
/*      */   public boolean respondToShutdownRequest()
/*      */   {
/* 1706 */     return this.shutdownManager.respondToShutdownRequest();
/*      */   }
/*      */ 
/*      */   public void setSocketFactory(SocketFactory socketFactory)
/*      */   {
/* 1715 */     this.socketFactory = socketFactory;
/*      */   }
/*      */ 
/*      */   public int getShutdownMonitorPeriod()
/*      */   {
/* 1724 */     return this.shutdownMonitorPeriod;
/*      */   }
/*      */ 
/*      */   public int getShutdownRefusalsMaximum()
/*      */   {
/* 1733 */     return this.shutdownRefusalsMaximum;
/*      */   }
/*      */ 
/*      */   public int getShutdownRequestTimeout()
/*      */   {
/* 1742 */     return this.shutdownRequestTimeout;
/*      */   }
/*      */ 
/*      */   public void setShutdownRequestTimeout(int timeout)
/*      */   {
/* 1751 */     this.shutdownRequestTimeout = timeout;
/*      */   }
/*      */ 
/*      */   public void setShutdownRefusalsMaximum(int maximum)
/*      */   {
/* 1760 */     this.shutdownRefusalsMaximum = maximum;
/*      */   }
/*      */ 
/*      */   public void setShutdownMonitorPeriod(int period)
/*      */   {
/* 1769 */     this.shutdownMonitorPeriod = period;
/*      */   }
/*      */ 
/*      */   public synchronized void outputFlushed()
/*      */   {
/* 1778 */     if (this.shutdownThread != null)
/* 1779 */       this.shutdownThread.setSafeToShutdown(true);
/* 1780 */     notifyAll();
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/* 1786 */     if (this.description != null)
/* 1787 */       return this.description;
/* 1788 */     return super.toString();
/*      */   }
/*      */ 
/*      */   protected Socket createSocket(InetSocketAddress endpoint, int timeout)
/*      */     throws IOException
/*      */   {
/* 1798 */     Socket socket = null;
/*      */ 
/* 1800 */     if (this.localSocketAddress == null)
/*      */     {
/* 1802 */       if (this.socketFactory != null)
/* 1803 */         socket = this.socketFactory.createSocket(endpoint.getAddress(), endpoint.getPort());
/*      */       else {
/* 1805 */         socket = SocketChannel.open(endpoint).socket();
/*      */       }
/*      */ 
/*      */     }
/* 1812 */     else if (this.socketFactory != null) {
/* 1813 */       socket = this.socketFactory.createSocket(endpoint.getAddress(), endpoint.getPort(), this.localSocketAddress.getAddress(), this.localSocketAddress.getPort());
/*      */     }
/*      */     else
/*      */     {
/* 1819 */       socket = SocketChannel.open().socket();
/* 1820 */       socket.bind(this.localSocketAddress);
/* 1821 */       socket.connect(endpoint);
/*      */     }
/*      */ 
/* 1825 */     if ((socket instanceof SSLSocket))
/*      */     {
/* 1833 */       ((SSLSocket)socket).addHandshakeCompletedListener(this);
/*      */     }
/*      */ 
/* 1836 */     socket.setSoTimeout(timeout);
/* 1837 */     return socket;
/*      */   }
/*      */ 
/*      */   protected Socket createSocket() throws IOException
/*      */   {
/* 1842 */     Socket socket = null;
/*      */     try
/*      */     {
/* 1846 */       if (this.socketFactory != null)
/* 1847 */         socket = this.socketFactory.createSocket();
/*      */       else {
/* 1849 */         socket = SocketChannel.open().socket();
/*      */       }
/* 1851 */       if ((socket instanceof SSLSocket))
/*      */       {
/* 1859 */         ((SSLSocket)socket).addHandshakeCompletedListener(this);
/*      */       }
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/* 1864 */       if ("Unconnected sockets not implemented".equals(e.getMessage()))
/* 1865 */         return null;
/* 1866 */       throw e;
/*      */     }
/*      */ 
/* 1869 */     return socket;
/*      */   }
/*      */ 
/*      */   protected void registerByLocalAddress(InetSocketAddress address)
/*      */   {
/* 1878 */     synchronized (localAddressMapLock)
/*      */     {
/* 1880 */       this.localSocketAddress = address;
/* 1881 */       HashSet managers = (HashSet)managersByLocalAddress.get(address);
/*      */ 
/* 1883 */       if (managers == null)
/*      */       {
/* 1885 */         managers = new HashSet();
/* 1886 */         managersByLocalAddress.put(address, managers);
/*      */       }
/*      */ 
/* 1889 */       managers.add(this);
/*      */ 
/* 1892 */       this.localWildCardAddress = new InetSocketAddress(address.getPort());
/* 1893 */       managers = (HashSet)managersByLocalAddress.get(this.localWildCardAddress);
/*      */ 
/* 1895 */       if (managers == null)
/*      */       {
/* 1897 */         managers = new HashSet();
/* 1898 */         managersByLocalAddress.put(this.localWildCardAddress, managers);
/*      */       }
/*      */ 
/* 1901 */       managers.add(this);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void unregisterByLocalAddress()
/*      */   {
/* 1911 */     synchronized (localAddressMapLock)
/*      */     {
/* 1913 */       HashSet managers = null;
/*      */ 
/* 1915 */       if (this.localSocketAddress != null)
/*      */       {
/* 1917 */         managers = (HashSet)managersByLocalAddress.get(this.localSocketAddress);
/*      */ 
/* 1919 */         if (managers != null)
/*      */         {
/* 1921 */           managers.remove(this);
/*      */ 
/* 1923 */           if (managers.isEmpty()) {
/* 1924 */             managersByLocalAddress.remove(this.localSocketAddress);
/*      */           }
/*      */         }
/*      */       }
/* 1928 */       if (this.localWildCardAddress != null)
/*      */       {
/* 1930 */         managers = (HashSet)managersByLocalAddress.get(this.localWildCardAddress);
/*      */ 
/* 1932 */         if (managers != null)
/*      */         {
/* 1934 */           managers.remove(this);
/*      */ 
/* 1936 */           if (managers.isEmpty())
/* 1937 */             managersByLocalAddress.remove(this.localWildCardAddress);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void registerByRemoteAddress(InetSocketAddress address)
/*      */   {
/* 1950 */     this.remoteSocketAddress = address;
/*      */ 
/* 1952 */     synchronized (remoteAddressMapLock)
/*      */     {
/* 1954 */       HashSet managers = (HashSet)managersByRemoteAddress.get(address);
/*      */ 
/* 1956 */       if (managers == null)
/*      */       {
/* 1958 */         managers = new HashSet();
/* 1959 */         managers.add(this);
/* 1960 */         managersByRemoteAddress.put(address, managers);
/*      */       }
/*      */       else {
/* 1963 */         managers.add(this);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void unregisterByRemoteAddress()
/*      */   {
/* 1973 */     if (this.remoteSocketAddress != null)
/*      */     {
/* 1975 */       synchronized (remoteAddressMapLock)
/*      */       {
/* 1977 */         HashSet managers = (HashSet)managersByRemoteAddress.get(this.remoteSocketAddress);
/*      */ 
/* 1979 */         if (managers != null)
/*      */         {
/* 1981 */           managers.remove(this);
/*      */ 
/* 1983 */           if (managers.isEmpty())
/* 1984 */             managersByRemoteAddress.remove(this.remoteSocketAddress);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void registerShareable(InetSocketAddress address)
/*      */   {
/* 1997 */     if (this.debug) log.debug("registering as shareable: " + this + ": " + address.toString());
/* 1998 */     synchronized (shareableMapLock)
/*      */     {
/* 2000 */       HashSet managers = (HashSet)shareableManagers.get(address);
/*      */ 
/* 2002 */       if (managers == null)
/*      */       {
/* 2004 */         managers = new HashSet();
/* 2005 */         managers.add(this);
/* 2006 */         shareableManagers.put(address, managers);
/*      */       }
/*      */       else {
/* 2009 */         managers.add(this);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void unregisterShareable()
/*      */   {
/* 2019 */     if (this.debug) log.debug("unregistering remote: " + this + ": " + this.description);
/* 2020 */     if (this.remoteSocketAddress != null)
/*      */     {
/* 2022 */       synchronized (shareableMapLock)
/*      */       {
/* 2024 */         HashSet managers = (HashSet)shareableManagers.get(this.remoteSocketAddress);
/*      */ 
/* 2026 */         if (managers != null)
/*      */         {
/* 2028 */           managers.remove(this);
/*      */ 
/* 2030 */           if (managers.isEmpty())
/* 2031 */             shareableManagers.remove(this.remoteSocketAddress);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void unregisterAllMaps()
/*      */   {
/* 2043 */     unregisterByLocalAddress();
/* 2044 */     unregisterByRemoteAddress();
/* 2045 */     unregisterShareable();
/*      */   }
/*      */ 
/*      */   protected void removeAnInputStream(SocketId socketId)
/*      */   {
/* 2053 */     if (this.debug) log.debug("entering removeAnInputStream(): " + socketId.getPort());
/* 2054 */     InputStream is = (InputStream)this.inputStreamMap.remove(socketId);
/* 2055 */     OutputStream os = (OutputStream)this.outputStreamMap.remove(socketId);
/*      */ 
/* 2057 */     if (is != null)
/*      */     {
/*      */       try
/*      */       {
/* 2061 */         is.close();
/*      */       }
/*      */       catch (Exception ignored)
/*      */       {
/* 2065 */         log.error("error closing PipedInputStream (" + this.socket.getPort() + ")", ignored);
/*      */       }
/*      */     }
/*      */ 
/* 2069 */     if (os != null)
/*      */     {
/*      */       try
/*      */       {
/* 2073 */         os.close();
/*      */       }
/*      */       catch (Exception ignored)
/*      */       {
/* 2077 */         log.error("error closing PipedOutputStream (" + this.socket.getPort() + ")", ignored);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void setReadException(IOException e)
/*      */   {
/* 2094 */     unregisterAllMaps();
/* 2095 */     notifySocketsOfException();
/*      */ 
/* 2098 */     if (multiGroupInputThread != null) {
/* 2099 */       multiGroupInputThread.unregisterSocketGroup(this);
/*      */     }
/* 2101 */     this.readException = e;
/*      */     HashSet tempSet;
/* 2104 */     synchronized (this.inputStreamMap)
/*      */     {
/* 2106 */       tempSet = new HashSet(this.inputStreamMap.values());
/*      */     }
/*      */     HashSet tempSet;
/* 2109 */     Iterator it = tempSet.iterator();
/* 2110 */     while (it.hasNext())
/*      */     {
/* 2112 */       MultiplexingInputStream is = (MultiplexingInputStream)it.next();
/* 2113 */       is.setReadException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void setWriteException(IOException e)
/*      */   {
/* 2122 */     unregisterAllMaps();
/* 2123 */     notifySocketsOfException();
/*      */ 
/* 2126 */     outputMultiplexor.unregister(this);
/*      */ 
/* 2128 */     this.writeException = e;
/*      */     HashSet tempSet;
/* 2131 */     synchronized (this.outputStreamMap)
/*      */     {
/* 2133 */       tempSet = new HashSet(this.outputStreamSet);
/*      */     }
/*      */     HashSet tempSet;
/* 2136 */     Iterator it = tempSet.iterator();
/* 2137 */     while (it.hasNext())
/*      */     {
/* 2139 */       MultiplexingOutputStream os = (MultiplexingOutputStream)it.next();
/* 2140 */       os.setWriteException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void notifySocketsOfException()
/*      */   {
/* 2147 */     synchronized (this.socketMap)
/*      */     {
/* 2149 */       Iterator it = this.socketMap.values().iterator();
/* 2150 */       while (it.hasNext())
/* 2151 */         ((VirtualSocket)it.next()).notifyOfException();
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void setEOF()
/*      */   {
/* 2159 */     log.debug("setEOF()");
/*      */     HashSet tempSet;
/* 2161 */     synchronized (this.inputStreamMap)
/*      */     {
/* 2163 */       tempSet = new HashSet(this.inputStreamMap.values());
/*      */     }
/*      */     HashSet tempSet;
/* 2166 */     Iterator it = tempSet.iterator();
/* 2167 */     while (it.hasNext())
/*      */     {
/* 2169 */       MultiplexingInputStream is = (MultiplexingInputStream)it.next();
/*      */       try
/*      */       {
/* 2172 */         is.handleRemoteShutdown();
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/* 2176 */         log.error(e);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected synchronized void shutdown()
/*      */   {
/* 2187 */     if (this.debug) log.debug(this.description + ": entering shutdown()");
/* 2188 */     this.shutdownThread = new ShutdownThread();
/* 2189 */     this.shutdownThread.setName(this.shutdownThread.getName() + ":shutdown");
/* 2190 */     this.shutdownThread.start();
/*      */   }
/*      */ 
/*      */   protected static class PendingActionThread extends StoppableThread
/*      */   {
/* 2826 */     private List pendingActionsTemp = new ArrayList();
/*      */ 
/*      */     protected void doInit()
/*      */     {
/* 2830 */       MultiplexingManager.log.debug("PendingActionThread starting");
/*      */     }
/*      */ 
/*      */     protected void doRun()
/*      */     {
/* 2835 */       synchronized (MultiplexingManager.pendingActions)
/*      */       {
/* 2837 */         while (MultiplexingManager.pendingActions.isEmpty())
/*      */         {
/*      */           try
/*      */           {
/* 2841 */             MultiplexingManager.pendingActions.wait();
/*      */           }
/*      */           catch (InterruptedException ignored)
/*      */           {
/* 2845 */             if (!isRunning()) {
/* 2846 */               return;
/*      */             }
/*      */           }
/*      */         }
/* 2850 */         this.pendingActionsTemp.addAll(MultiplexingManager.pendingActions);
/* 2851 */         MultiplexingManager.pendingActions.clear();
/*      */       }
/*      */ 
/* 2854 */       Iterator it = this.pendingActionsTemp.iterator();
/*      */ 
/* 2856 */       while (it.hasNext())
/*      */       {
/* 2858 */         Object o = it.next();
/* 2859 */         if ((o instanceof PendingAction))
/* 2860 */           ((PendingAction)o).doAction();
/*      */         else {
/* 2862 */           MultiplexingManager.log.error("object in closePendingSockets has invalid type: " + o.getClass());
/*      */         }
/*      */       }
/* 2865 */       this.pendingActionsTemp.clear();
/*      */     }
/*      */ 
/*      */     public void shutdown()
/*      */     {
/* 2870 */       MultiplexingManager.log.debug("pending action thread beginning shut down");
/* 2871 */       super.shutdown();
/* 2872 */       interrupt();
/*      */     }
/*      */ 
/*      */     protected void doShutDown()
/*      */     {
/* 2877 */       MultiplexingManager.log.debug("PendingActionThread shutting down");
/*      */     }
/*      */   }
/*      */ 
/*      */   protected class ShutdownThread extends Thread
/*      */   {
/*      */     private boolean safeToShutDown;
/*      */ 
/*      */     protected ShutdownThread()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void run()
/*      */     {
/* 2724 */       String message = null;
/* 2725 */       if (MultiplexingManager.this.debug) MultiplexingManager.log.debug(MultiplexingManager.this.description + ": manager shutting down");
/*      */ 
/* 2728 */       MultiplexingManager.this.unregisterByLocalAddress();
/*      */ 
/* 2731 */       MultiplexingManager.this.unregisterByRemoteAddress();
/*      */ 
/* 2734 */       MultiplexingManager.this.unregisterShareable();
/*      */ 
/* 2736 */       if (MultiplexingManager.this.socket != null)
/*      */       {
/*      */         try
/*      */         {
/* 2740 */           if (MultiplexingManager.outputMultiplexor != null)
/*      */           {
/* 2742 */             MultiplexingManager.outputMultiplexor.unregister(MultiplexingManager.this);
/*      */ 
/* 2745 */             synchronized (MultiplexingManager.this)
/*      */             {
/* 2747 */               while (!this.safeToShutDown)
/*      */               {
/* 2749 */                 if (MultiplexingManager.this.debug) MultiplexingManager.log.debug("waiting for safe to shut down");
/*      */                 try
/*      */                 {
/* 2752 */                   MultiplexingManager.this.wait();
/*      */                 }
/*      */                 catch (InterruptedException ignored)
/*      */                 {
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */ 
/* 2761 */           if (MultiplexingManager.this.socket.getChannel() == null) {
/* 2762 */             MultiplexingManager.this.socket.close();
/*      */           }
/*      */           else
/*      */           {
/* 2766 */             message = MultiplexingManager.this.description;
/*      */ 
/* 2768 */             if (MultiplexingManager.multiGroupInputThread != null) {
/* 2769 */               MultiplexingManager.multiGroupInputThread.unregisterSocketGroup(MultiplexingManager.this);
/*      */             }
/* 2771 */             MultiplexingManager.this.socket.close();
/* 2772 */             if (MultiplexingManager.this.debug) MultiplexingManager.log.debug("closed socket: " + MultiplexingManager.this.description);
/*      */ 
/*      */           }
/*      */ 
/* 2777 */           MultiplexingManager.log.debug("manager: closed socket");
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/* 2781 */           MultiplexingManager.log.error("manager: unable to close socket", e);
/*      */         }
/*      */       }
/*      */ 
/* 2785 */       if (MultiplexingManager.this.inputThread != null)
/*      */       {
/* 2787 */         MultiplexingManager.this.inputThread.shutdown();
/*      */         try
/*      */         {
/* 2791 */           MultiplexingManager.this.inputThread.join();
/* 2792 */           MultiplexingManager.log.debug("manager: joined input thread");
/*      */         }
/*      */         catch (InterruptedException ignored)
/*      */         {
/* 2796 */           MultiplexingManager.log.debug("manager: interrupted exception waiting for read thread");
/*      */         }
/*      */       }
/*      */ 
/* 2800 */       MultiplexingManager.this.removeAnInputStream(SocketId.PROTOCOL_SOCKET_ID);
/* 2801 */       MultiplexingManager.this.removeAnInputStream(SocketId.SERVER_SOCKET_ID);
/* 2802 */       MultiplexingManager.this.removeAnInputStream(SocketId.SERVER_SOCKET_CONNECT_ID);
/* 2803 */       MultiplexingManager.this.removeAnInputStream(SocketId.SERVER_SOCKET_VERIFY_ID);
/* 2804 */       MultiplexingManager.this.removeAnInputStream(SocketId.BACKCHANNEL_SOCKET_ID);
/*      */ 
/* 2806 */       MultiplexingManager.access$2302(MultiplexingManager.this, true);
/*      */ 
/* 2809 */       if (MultiplexingManager.this.info) MultiplexingManager.log.info("removing from allManagers: " + MultiplexingManager.this.description + "(" + MultiplexingManager.this.id + ")");
/* 2810 */       MultiplexingManager.allManagers.remove(MultiplexingManager.this);
/*      */ 
/* 2812 */       if (MultiplexingManager.this.info) MultiplexingManager.log.info("manager shut down (: " + MultiplexingManager.this.id + "): " + message);
/* 2813 */       if (MultiplexingManager.this.debug) MultiplexingManager.log.debug("managers left: " + MultiplexingManager.allManagers.size());
/*      */     }
/*      */ 
/*      */     public void setSafeToShutdown(boolean safe)
/*      */     {
/* 2818 */       if (MultiplexingManager.this.debug) MultiplexingManager.log.debug("output flushed");
/* 2819 */       this.safeToShutDown = safe;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected class ShutdownManager
/*      */   {
/*      */     private int referenceCount;
/*      */     private boolean reserved;
/*      */     private boolean shutdownRequestInProgress;
/*      */     private boolean readyToShutdown;
/*      */     ShutdownMonitorTimerTask shutdownMonitorTimerTask;
/*      */     private boolean shutdown;
/*      */     private boolean remoteShutdown;
/*      */     private boolean shutdownHandled;
/*      */     private boolean requestShutdownFailed;
/*      */ 
/*      */     protected ShutdownManager()
/*      */     {
/* 2252 */       this.referenceCount = 1;
/*      */ 
/* 2256 */       this.reserved = false;
/*      */ 
/* 2259 */       this.shutdownRequestInProgress = false;
/*      */ 
/* 2263 */       this.readyToShutdown = false;
/*      */ 
/* 2271 */       this.shutdown = false;
/*      */ 
/* 2277 */       this.remoteShutdown = false;
/*      */     }
/*      */ 
/*      */     public synchronized void reserveManager()
/*      */       throws IOException
/*      */     {
/* 2487 */       if (MultiplexingManager.this.debug) MultiplexingManager.log.debug(MultiplexingManager.this.description + this.referenceCount);
/*      */ 
/* 2491 */       while (this.shutdownRequestInProgress)
/*      */       {
/*      */         try
/*      */         {
/* 2495 */           wait();
/*      */         }
/*      */         catch (InterruptedException e)
/*      */         {
/* 2500 */           MultiplexingManager.log.error("interruption in ShutdownRequestThread");
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 2511 */       if ((this.shutdown) || (this.remoteShutdown)) {
/* 2512 */         throw new IOException("manager shutting down");
/*      */       }
/* 2514 */       this.readyToShutdown = false;
/* 2515 */       this.reserved = true;
/*      */ 
/* 2520 */       if (this.shutdownMonitorTimerTask != null) {
/* 2521 */         this.shutdownMonitorTimerTask.cancel();
/*      */       }
/*      */ 
/* 2524 */       notifyAll();
/*      */     }
/*      */ 
/*      */     public synchronized void unreserveManager()
/*      */     {
/* 2533 */       if (MultiplexingManager.this.debug) MultiplexingManager.log.debug(MultiplexingManager.this.description + this.referenceCount);
/*      */ 
/* 2535 */       if (!this.reserved)
/*      */       {
/* 2537 */         MultiplexingManager.log.error("attempting to unreserve a MultiplexingManager that was not reserved: " + MultiplexingManager.this.description);
/* 2538 */         return;
/*      */       }
/*      */ 
/* 2541 */       this.reserved = false;
/*      */ 
/* 2549 */       if (this.referenceCount == 0)
/*      */       {
/* 2551 */         this.referenceCount += 1;
/* 2552 */         decrementReferences();
/*      */       }
/*      */     }
/*      */ 
/*      */     public synchronized void incrementReferences()
/*      */       throws IOException
/*      */     {
/* 2560 */       if (MultiplexingManager.this.debug) MultiplexingManager.log.debug(MultiplexingManager.this.description + this.referenceCount);
/*      */ 
/* 2564 */       while (this.shutdownRequestInProgress)
/*      */       {
/*      */         try
/*      */         {
/* 2568 */           wait();
/*      */         }
/*      */         catch (InterruptedException e)
/*      */         {
/* 2573 */           MultiplexingManager.log.error("interruption in ShutdownRequestThread");
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 2584 */       if ((this.shutdown) || (this.remoteShutdown)) {
/* 2585 */         throw new IOException("not accepting new clients");
/*      */       }
/* 2587 */       this.readyToShutdown = false;
/* 2588 */       this.reserved = false;
/* 2589 */       this.referenceCount += 1;
/*      */ 
/* 2591 */       if (MultiplexingManager.this.debug) MultiplexingManager.log.debug(MultiplexingManager.this.description + this.referenceCount);
/*      */ 
/* 2596 */       if (this.shutdownMonitorTimerTask != null) {
/* 2597 */         this.shutdownMonitorTimerTask.cancel();
/*      */       }
/*      */ 
/* 2600 */       notifyAll();
/*      */     }
/*      */ 
/*      */     public synchronized void decrementReferences()
/*      */     {
/* 2609 */       this.referenceCount -= 1;
/* 2610 */       if (MultiplexingManager.this.debug) MultiplexingManager.log.debug(MultiplexingManager.this.description + this.referenceCount);
/*      */ 
/* 2612 */       if (this.reserved)
/*      */       {
/* 2614 */         if (MultiplexingManager.this.debug) MultiplexingManager.log.debug(MultiplexingManager.this.description + ": reserved == true");
/* 2615 */         return;
/*      */       }
/*      */ 
/* 2618 */       if (this.referenceCount == 0)
/*      */       {
/* 2620 */         this.readyToShutdown = true;
/*      */ 
/* 2622 */         if (MultiplexingManager.this.isConnected())
/*      */         {
/* 2624 */           ShutdownRequestThread shutdownRequestThread = new ShutdownRequestThread();
/* 2625 */           shutdownRequestThread.setName(shutdownRequestThread.getName() + ":shutdownRequest:" + MultiplexingManager.time);
/* 2626 */           shutdownRequestThread.setDaemon(true);
/* 2627 */           if (MultiplexingManager.this.info) MultiplexingManager.log.info(MultiplexingManager.this.description + "starting ShutdownRequestThread: " + shutdownRequestThread.toString());
/* 2628 */           shutdownRequestThread.start();
/*      */           try
/*      */           {
/* 2634 */             wait(MultiplexingManager.this.shutdownRequestTimeout);
/*      */           }
/*      */           catch (InterruptedException e)
/*      */           {
/* 2639 */             MultiplexingManager.log.error("interrupt in ShutdownRequestThread");
/*      */           }
/*      */ 
/* 2642 */           if (MultiplexingManager.log.isDebugEnabled())
/*      */           {
/* 2644 */             MultiplexingManager.log.debug(MultiplexingManager.this.description + this.shutdown);
/* 2645 */             MultiplexingManager.log.debug(MultiplexingManager.this.description + shutdownRequestThread.isAlive());
/*      */           }
/*      */ 
/* 2650 */           if (this.shutdownRequestInProgress)
/*      */           {
/* 2652 */             this.shutdown = true;
/*      */ 
/* 2656 */             this.shutdownRequestInProgress = false;
/*      */           }
/*      */         }
/*      */         else {
/* 2660 */           this.shutdown = true;
/*      */         }
/*      */ 
/* 2663 */         if (this.shutdown)
/*      */         {
/* 2665 */           MultiplexingManager.this.shutdown();
/*      */ 
/* 2668 */           notifyAll();
/*      */         }
/*      */         else
/*      */         {
/* 2676 */           this.shutdownMonitorTimerTask = new ShutdownMonitorTimerTask(null);
/* 2677 */           if (MultiplexingManager.this.info) MultiplexingManager.log.info(MultiplexingManager.this.description + ": scheduling ShutdownMonitorTask: " + this.shutdownMonitorTimerTask);
/* 2678 */           MultiplexingManager.timer.schedule(this.shutdownMonitorTimerTask, MultiplexingManager.this.shutdownMonitorPeriod, MultiplexingManager.this.shutdownMonitorPeriod);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     protected synchronized boolean respondToShutdownRequest()
/*      */     {
/* 2689 */       if (MultiplexingManager.this.debug)
/*      */       {
/* 2691 */         MultiplexingManager.log.debug(MultiplexingManager.this.description + this.readyToShutdown);
/* 2692 */         MultiplexingManager.log.debug(MultiplexingManager.this.description + this.shutdown);
/*      */       }
/*      */ 
/* 2695 */       if (this.readyToShutdown)
/*      */       {
/* 2697 */         this.remoteShutdown = true;
/* 2698 */         if (MultiplexingManager.this.debug) MultiplexingManager.log.debug(MultiplexingManager.this.description + ": respondToShutdownRequest(): set remoteShutdown to true");
/*      */       }
/*      */ 
/* 2701 */       return this.readyToShutdown;
/*      */     }
/*      */ 
/*      */     protected boolean isShutdown()
/*      */     {
/* 2710 */       return this.shutdown;
/*      */     }
/*      */ 
/*      */     private class ShutdownMonitorTimerTask extends TimerTask
/*      */     {
/*      */       int count;
/*      */       boolean cancelled;
/*      */       private final MultiplexingManager.ShutdownManager this$1;
/*      */ 
/*      */       private ShutdownMonitorTimerTask()
/*      */       {
/*      */       }
/*      */ 
/*      */       public boolean cancel()
/*      */       {
/* 2388 */         MultiplexingManager.log.debug("cancelling ShutdownMonitorTimerTask");
/* 2389 */         this.cancelled = true;
/* 2390 */         return super.cancel();
/*      */       }
/*      */ 
/*      */       public void run()
/*      */       {
/* 2395 */         if (MultiplexingManager.ShutdownManager.access$500(this.this$1).debug) MultiplexingManager.log.debug(this.this$1.this$0.description + ": entering ShutdownMonitorTimerTask");
/* 2396 */         this.count += 1;
/*      */ 
/* 2398 */         synchronized (this.this$1)
/*      */         {
/* 2401 */           if (this.this$1.shutdownHandled)
/*      */           {
/* 2403 */             if (MultiplexingManager.ShutdownManager.access$500(this.this$1).info) MultiplexingManager.log.info(this.this$1.this$0.description + ": shutdownHandled == true");
/* 2404 */             cancel();
/*      */           }
/* 2408 */           else if (this.this$1.shutdown)
/*      */           {
/* 2410 */             if (MultiplexingManager.ShutdownManager.access$500(this.this$1).info) MultiplexingManager.log.info(this.this$1.this$0.description + ": shutdown is true");
/* 2411 */             MultiplexingManager.ShutdownManager.access$1102(this.this$1, true);
/* 2412 */             this.this$1.this$0.shutdown();
/* 2413 */             cancel();
/*      */           }
/* 2417 */           else if ((this.this$1.readyToShutdown) && (this.this$1.remoteShutdown))
/*      */           {
/* 2419 */             if (MultiplexingManager.ShutdownManager.access$500(this.this$1).info) MultiplexingManager.log.info(this.this$1.this$0.description + ": ShutdownMonitorTimerTask: found remoteShutdown == true");
/* 2420 */             MultiplexingManager.ShutdownManager.access$402(this.this$1, true);
/* 2421 */             MultiplexingManager.ShutdownManager.access$1102(this.this$1, true);
/* 2422 */             this.this$1.this$0.shutdown();
/* 2423 */             this.this$1.notifyAll();
/* 2424 */             cancel();
/*      */           }
/* 2428 */           else if (this.this$1.requestShutdownFailed)
/*      */           {
/* 2430 */             if (MultiplexingManager.ShutdownManager.access$500(this.this$1).info) MultiplexingManager.log.info(this.this$1.this$0.description + ": ShutdownMonitorTimerTask: found requestShutdownFailed == true");
/* 2431 */             MultiplexingManager.ShutdownManager.access$402(this.this$1, true);
/* 2432 */             MultiplexingManager.ShutdownManager.access$1102(this.this$1, true);
/* 2433 */             this.this$1.this$0.shutdown();
/* 2434 */             this.this$1.notifyAll();
/* 2435 */             cancel();
/*      */           }
/* 2440 */           else if (this.count > MultiplexingManager.ShutdownManager.access$500(this.this$1).shutdownRefusalsMaximum)
/*      */           {
/* 2442 */             if (MultiplexingManager.ShutdownManager.access$500(this.this$1).info) {
/* 2443 */               MultiplexingManager.log.info(this.this$1.this$0.description + ": ShutdownMonitorTimerTask: " + "shutdown refusal count exceeded maximut: " + MultiplexingManager.ShutdownManager.access$500(this.this$1).shutdownRefusalsMaximum);
/*      */             }
/*      */ 
/* 2446 */             MultiplexingManager.ShutdownManager.access$402(this.this$1, true);
/* 2447 */             MultiplexingManager.ShutdownManager.access$1102(this.this$1, true);
/* 2448 */             this.this$1.this$0.shutdown();
/* 2449 */             this.this$1.notifyAll();
/* 2450 */             cancel();
/*      */           }
/*      */           else
/*      */           {
/* 2454 */             if (this.this$1.shutdownRequestInProgress)
/*      */             {
/* 2456 */               if (MultiplexingManager.ShutdownManager.access$500(this.this$1).info) MultiplexingManager.log.info(this.this$1.this$0.description + ": shutdownRequestInProgress == true");
/* 2457 */               return;
/*      */             }
/*      */ 
/* 2466 */             MultiplexingManager.ShutdownManager.ShutdownRequestThread shutdownRequestThread = new MultiplexingManager.ShutdownManager.ShutdownRequestThread(this.this$1);
/* 2467 */             shutdownRequestThread.setName(shutdownRequestThread.getName() + ":shutdownRequest:" + MultiplexingManager.time);
/* 2468 */             shutdownRequestThread.setDaemon(true);
/* 2469 */             if (MultiplexingManager.ShutdownManager.access$500(this.this$1).info) MultiplexingManager.log.info(this.this$1.this$0.description + ": starting ShutdownRequestThread: " + shutdownRequestThread.toString());
/* 2470 */             shutdownRequestThread.start();
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*      */       public String toString()
/*      */       {
/* 2477 */         return "shutdownRequest:" + MultiplexingManager.time;
/*      */       }
/*      */ 
/*      */       ShutdownMonitorTimerTask(MultiplexingManager.1 x1)
/*      */       {
/* 2381 */         this();
/*      */       }
/*      */     }
/*      */ 
/*      */     private class ShutdownRequestThread extends Thread
/*      */     {
/*      */       public ShutdownRequestThread()
/*      */       {
/* 2292 */         MultiplexingManager.ShutdownManager.access$302(MultiplexingManager.ShutdownManager.this, true);
/*      */       }
/*      */ 
/*      */       public void run()
/*      */       {
/*      */         try
/*      */         {
/* 2302 */           MultiplexingManager.ShutdownManager.access$402(MultiplexingManager.ShutdownManager.this, MultiplexingManager.this.protocol.requestManagerShutdown(MultiplexingManager.this.shutdownRequestTimeout * 2));
/* 2303 */           if (MultiplexingManager.this.info) MultiplexingManager.log.info("shutdown: " + MultiplexingManager.ShutdownManager.this.shutdown);
/*      */         }
/*      */         catch (SocketTimeoutException e)
/*      */         {
/* 2307 */           MultiplexingManager.ShutdownManager.access$902(MultiplexingManager.ShutdownManager.this, true);
/* 2308 */           MultiplexingManager.log.debug("socket timeout exception in manager shutdown request");
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/* 2312 */           MultiplexingManager.ShutdownManager.access$902(MultiplexingManager.ShutdownManager.this, true);
/* 2313 */           MultiplexingManager.log.debug("i/o exception in manager shutdown request", e);
/*      */         }
/*      */ 
/* 2316 */         if (MultiplexingManager.this.info) MultiplexingManager.log.info("ShutdownRequestThread.run() done: " + MultiplexingManager.ShutdownManager.this.shutdown);
/* 2317 */         MultiplexingManager.ShutdownManager.access$302(MultiplexingManager.ShutdownManager.this, false);
/*      */ 
/* 2319 */         synchronized (MultiplexingManager.ShutdownManager.this)
/*      */         {
/* 2321 */           MultiplexingManager.ShutdownManager.this.notifyAll();
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.MultiplexingManager
 * JD-Core Version:    0.6.0
 */