/*     */ package org.jboss.remoting.transport.multiplex;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.Socket;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.ConnectionFailedException;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.remoting.transport.BidirectionalClientInvoker;
/*     */ import org.jboss.remoting.transport.PortUtil;
/*     */ import org.jboss.remoting.transport.multiplex.utility.AddressPair;
/*     */ import org.jboss.remoting.transport.socket.ClientSocketWrapper;
/*     */ import org.jboss.remoting.transport.socket.SocketClientInvoker;
/*     */ 
/*     */ public class MultiplexClientInvoker extends SocketClientInvoker
/*     */   implements BidirectionalClientInvoker
/*     */ {
/*  53 */   private static final Logger log = Logger.getLogger(MultiplexClientInvoker.class);
/*  54 */   private static final boolean isTraceEnabled = log.isTraceEnabled();
/*     */   private InetAddress connectAddress;
/*     */   private String connectHost;
/*     */   private int connectPort;
/*     */   private InetSocketAddress connectSocketAddress;
/*     */   private InetSocketAddress bindSocketAddress;
/*     */   private String socketGroupId;
/*     */   private MultiplexServerInvoker.SocketGroupInfo socketGroupInfo;
/*     */   private AddressPair addressPair;
/*     */   private boolean readyToRun;
/*  66 */   protected String clientSocketClassName = ClientSocketWrapper.class.getName();
/*     */ 
/*     */   public MultiplexClientInvoker(InvokerLocator locator)
/*     */     throws IOException
/*     */   {
/*  76 */     super(locator);
/*     */   }
/*     */ 
/*     */   public MultiplexClientInvoker(InvokerLocator locator, Map configuration)
/*     */     throws IOException
/*     */   {
/*  87 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   protected void handleConnect()
/*     */     throws ConnectionFailedException
/*     */   {
/*     */     try
/*     */     {
/*  95 */       log.debug("configuring MultiplexClientInvoker for: " + this.locator);
/*  96 */       super.handleConnect();
/*     */ 
/*  98 */       this.connectAddress = InetAddress.getByName(this.locator.getHost());
/*  99 */       this.connectHost = this.connectAddress.getHostName();
/* 100 */       this.connectPort = this.locator.getPort();
/* 101 */       this.connectSocketAddress = new InetSocketAddress(this.connectAddress, this.connectPort);
/*     */ 
/* 103 */       if (getSocketFactory() != null) {
/* 104 */         this.configuration.put("multiplex.SocketFactory", getSocketFactory());
/*     */       }
/* 106 */       Map parameters = this.configuration;
/*     */ 
/* 108 */       if (parameters != null)
/*     */       {
/* 110 */         configureSocketGroupParameters(parameters);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 115 */       throw new ConnectionFailedException(e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void finishStart()
/*     */     throws IOException
/*     */   {
/* 127 */     if ((this.socketGroupInfo != null) && (this.socketGroupInfo.getBindAddress() != null) && (this.bindSocketAddress == null))
/*     */     {
/* 131 */       InetAddress bindAddress = this.socketGroupInfo.getBindAddress();
/* 132 */       int bindPort = this.socketGroupInfo.getBindPort();
/* 133 */       this.bindSocketAddress = new InetSocketAddress(bindAddress, bindPort);
/*     */     }
/*     */ 
/* 136 */     if ((this.socketGroupInfo != null) && (this.socketGroupInfo.getBindAddress() != null) && (this.addressPair == null))
/*     */     {
/* 140 */       String bindHost = this.socketGroupInfo.getBindAddress().getHostName();
/* 141 */       int bindPort = this.socketGroupInfo.getBindPort();
/* 142 */       this.addressPair = new AddressPair(this.connectHost, this.connectPort, bindHost, bindPort);
/*     */     }
/*     */ 
/* 145 */     this.readyToRun = true;
/*     */   }
/*     */ 
/*     */   public InvokerLocator getCallbackLocator(Map metadata)
/*     */   {
/* 150 */     Socket socket = this.socketGroupInfo.getPrimingSocket();
/* 151 */     metadata.put("multiplexConnectHost", socket.getInetAddress().getHostAddress());
/*     */ 
/* 153 */     metadata.put("multiplexConnectPort", Integer.toString(socket.getPort()));
/*     */ 
/* 155 */     metadata.put("multiplexBindHost", socket.getInetAddress().getHostAddress());
/*     */ 
/* 157 */     metadata.put("multiplexBindPort", Integer.toString(socket.getPort()));
/*     */ 
/* 159 */     InvokerLocator locator = new InvokerLocator("multiplex", socket.getLocalAddress().getHostAddress(), socket.getLocalPort(), null, metadata);
/*     */ 
/* 164 */     return locator;
/*     */   }
/*     */ 
/*     */   protected void configureSocketGroupParameters(Map parameters)
/*     */     throws IOException
/*     */   {
/* 175 */     int bindPort = -1;
/* 176 */     InetAddress bindAddress = null;
/* 177 */     this.socketGroupId = ((String)parameters.get("clientMultiplexId"));
/* 178 */     log.debug("socketGroupId: " + this.socketGroupId);
/*     */ 
/* 180 */     synchronized (MultiplexServerInvoker.SocketGroupInfo.class)
/*     */     {
/* 182 */       if (this.socketGroupId != null) {
/* 183 */         this.socketGroupInfo = ((MultiplexServerInvoker.SocketGroupInfo)MultiplexServerInvoker.getSocketGroupMap().get(this.socketGroupId));
/*     */       }
/* 185 */       if ((this.socketGroupInfo != null) && (this.socketGroupInfo.getServerInvoker() != null))
/*     */       {
/* 187 */         log.debug("client rule 1");
/*     */ 
/* 192 */         InetAddress socketGroupConnectAddress = this.socketGroupInfo.getConnectAddress();
/* 193 */         int socketGroupConnectPort = this.socketGroupInfo.getConnectPort();
/*     */ 
/* 195 */         if ((socketGroupConnectAddress != null) && (!socketGroupConnectAddress.equals(this.connectAddress)))
/*     */         {
/* 197 */           String message = "socket group connect address (" + socketGroupConnectAddress + ") does not match connect address (" + this.connectAddress + ")";
/*     */ 
/* 199 */           log.error(message);
/* 200 */           throw new IOException(message);
/*     */         }
/*     */ 
/* 203 */         if ((socketGroupConnectPort > 0) && (socketGroupConnectPort != this.connectPort))
/*     */         {
/* 205 */           String message = "socket group connect port (" + socketGroupConnectPort + ") does not match connect port (" + this.connectPort + ")";
/*     */ 
/* 207 */           log.error(message);
/* 208 */           throw new IOException(message);
/*     */         }
/*     */ 
/* 211 */         bindAddress = this.socketGroupInfo.getBindAddress();
/* 212 */         bindPort = this.socketGroupInfo.getBindPort();
/* 213 */         this.bindSocketAddress = new InetSocketAddress(bindAddress, bindPort);
/*     */ 
/* 215 */         if (this.socketGroupInfo.getPrimingSocket() == null)
/*     */         {
/* 217 */           String connectHost = this.connectAddress.getHostName();
/* 218 */           MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, this.connectPort, bindAddress, bindPort, this.configuration, this.timeout);
/*     */         }
/*     */ 
/* 223 */         this.socketGroupInfo.setConnectAddress(this.connectAddress);
/* 224 */         this.socketGroupInfo.setConnectPort(this.connectPort);
/* 225 */         this.socketGroupInfo.addClientInvoker(this);
/*     */ 
/* 228 */         String bindHost = bindAddress.getHostName();
/* 229 */         this.addressPair = new AddressPair(this.connectHost, this.connectPort, bindHost, bindPort);
/* 230 */         MultiplexServerInvoker.getAddressPairMap().put(this.addressPair, this.socketGroupInfo);
/*     */ 
/* 232 */         MultiplexServerInvoker serverInvoker = this.socketGroupInfo.getServerInvoker();
/* 233 */         if (serverInvoker != null) {
/* 234 */           serverInvoker.finishStart();
/*     */         }
/* 236 */         finishStart();
/* 237 */         return;
/*     */       }
/*     */ 
/* 240 */       String bindHost = (String)parameters.get("multiplexBindHost");
/* 241 */       String bindPortString = (String)parameters.get("multiplexBindPort");
/*     */ 
/* 243 */       if ((bindHost != null) && (bindPortString == null))
/*     */       {
/* 245 */         bindPortString = "0";
/*     */       }
/*     */ 
/* 248 */       if ((bindHost == null) && (bindPortString != null))
/*     */       {
/* 250 */         bindHost = "localhost";
/*     */       }
/*     */ 
/* 253 */       if (bindHost != null)
/*     */       {
/* 255 */         log.debug("client rule 2");
/*     */         try
/*     */         {
/* 259 */           bindPort = Integer.parseInt(bindPortString);
/*     */         }
/*     */         catch (NumberFormatException e)
/*     */         {
/* 263 */           throw new IOException("number format error for bindPort: " + bindPortString);
/*     */         }
/*     */ 
/* 266 */         if (bindPort != 0)
/*     */         {
/* 268 */           this.bindSocketAddress = new InetSocketAddress(bindHost, bindPort);
/* 269 */           this.addressPair = new AddressPair(this.connectHost, this.connectPort, bindHost, bindPort);
/* 270 */           this.socketGroupInfo = ((MultiplexServerInvoker.SocketGroupInfo)MultiplexServerInvoker.getAddressPairMap().get(this.addressPair));
/*     */         }
/*     */ 
/* 276 */         if (this.socketGroupInfo != null)
/*     */         {
/* 278 */           this.socketGroupInfo.setConnectAddress(this.connectAddress);
/* 279 */           this.socketGroupInfo.setConnectPort(this.connectPort);
/* 280 */           this.socketGroupInfo.addClientInvoker(this);
/*     */ 
/* 283 */           if (this.socketGroupId != null)
/*     */           {
/* 285 */             String socketGroupSocketGroupId = this.socketGroupInfo.getSocketGroupId();
/*     */ 
/* 287 */             if ((socketGroupSocketGroupId != null) && (!socketGroupSocketGroupId.equals(this.socketGroupId)))
/*     */             {
/* 289 */               String message = "socket group multiplexId (" + socketGroupSocketGroupId + ") does not match multiplexId (" + this.socketGroupId + ")";
/*     */ 
/* 291 */               log.error(message);
/* 292 */               throw new IOException(message);
/*     */             }
/*     */ 
/* 295 */             if (socketGroupSocketGroupId == null)
/*     */             {
/* 297 */               this.socketGroupInfo.setSocketGroupId(this.socketGroupId);
/* 298 */               MultiplexServerInvoker.getSocketGroupMap().put(this.socketGroupId, this.socketGroupInfo);
/*     */             }
/*     */           }
/*     */ 
/* 302 */           finishStart();
/* 303 */           return;
/*     */         }
/*     */ 
/* 306 */         if ((bindPort == 0) && (this.socketGroupId == null))
/*     */         {
/* 308 */           String message = "Can never be found by any MultiplexServerInvoker: bind port == 0 and socketGroupId == null";
/*     */ 
/* 310 */           log.warn(message);
/*     */         }
/*     */ 
/* 314 */         if (bindPort == 0) {
/* 315 */           bindPort = PortUtil.findFreePort(bindHost);
/*     */         }
/* 317 */         this.socketGroupInfo = new MultiplexServerInvoker.SocketGroupInfo();
/* 318 */         this.socketGroupInfo.setConnectAddress(this.connectAddress);
/* 319 */         this.socketGroupInfo.setConnectPort(this.connectPort);
/* 320 */         this.socketGroupInfo.addClientInvoker(this);
/*     */ 
/* 324 */         bindAddress = InetAddress.getByName(bindHost);
/* 325 */         this.socketGroupInfo.setBindAddress(bindAddress);
/* 326 */         this.socketGroupInfo.setBindPort(bindPort);
/*     */ 
/* 328 */         String connectHost = this.connectAddress.getHostName();
/* 329 */         MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, this.connectPort, bindAddress, bindPort, this.configuration, this.timeout);
/*     */ 
/* 331 */         MultiplexServerInvoker.getAddressPairMap().put(this.addressPair, this.socketGroupInfo);
/*     */ 
/* 333 */         if (this.socketGroupId != null)
/*     */         {
/* 335 */           this.socketGroupInfo.setSocketGroupId(this.socketGroupId);
/* 336 */           MultiplexServerInvoker.getSocketGroupMap().put(this.socketGroupId, this.socketGroupInfo);
/*     */         }
/*     */ 
/* 339 */         finishStart();
/* 340 */         return;
/*     */       }
/*     */ 
/* 343 */       if (this.socketGroupId != null)
/*     */       {
/* 345 */         log.debug("client rule 3");
/*     */ 
/* 347 */         if (this.socketGroupInfo == null)
/*     */         {
/* 349 */           this.socketGroupInfo = new MultiplexServerInvoker.SocketGroupInfo();
/* 350 */           this.socketGroupInfo.setSocketGroupId(this.socketGroupId);
/* 351 */           this.socketGroupInfo.setConnectAddress(this.connectAddress);
/* 352 */           this.socketGroupInfo.setConnectPort(this.connectPort);
/* 353 */           MultiplexServerInvoker.getSocketGroupMap().put(this.socketGroupId, this.socketGroupInfo);
/*     */         }
/*     */ 
/* 356 */         this.socketGroupInfo.addClientInvoker(this);
/* 357 */         return;
/*     */       }
/*     */ 
/* 360 */       log.debug("client rule 4");
/* 361 */       String connectHost = this.connectAddress.getHostName();
/* 362 */       this.socketGroupInfo = new MultiplexServerInvoker.SocketGroupInfo();
/* 363 */       MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, connectHost, this.connectPort, this.configuration, this.timeout);
/*     */ 
/* 365 */       finishStart();
/*     */     }
/*     */     String bindPortString;
/*     */     String bindHost;
/*     */   }
/*     */ 
/*     */   protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller)
/*     */     throws IOException, ConnectionFailedException, ClassNotFoundException
/*     */   {
/* 381 */     log.debug("entering transport()");
/* 382 */     if (!this.readyToRun) {
/* 383 */       throw new IOException("connection to server has not been made");
/*     */     }
/* 385 */     return super.transport(sessionId, invocation, metadata, marshaller, unmarshaller);
/*     */   }
/*     */ 
/*     */   protected void handleDisconnect()
/*     */   {
/* 399 */     log.debug("entering handleDisconnect()");
/* 400 */     super.handleDisconnect();
/*     */ 
/* 402 */     synchronized (MultiplexServerInvoker.SocketGroupInfo.class)
/*     */     {
/* 404 */       if (this.socketGroupInfo != null)
/*     */       {
/* 406 */         this.socketGroupInfo.removeClientInvoker(this);
/*     */ 
/* 408 */         if ((this.socketGroupInfo.getClientInvokers().isEmpty()) && (this.socketGroupInfo.getServerInvoker() == null))
/*     */         {
/* 410 */           log.debug("invoker group shutting down: " + this.socketGroupInfo.getSocketGroupId());
/*     */ 
/* 412 */           if (this.socketGroupInfo.getPrimingSocket() != null)
/*     */           {
/* 414 */             log.debug("MultiplexClientInvoker: closing bind priming socket");
/*     */ 
/* 416 */             VirtualSocket ps = this.socketGroupInfo.getPrimingSocket();
/* 417 */             if (ps != null)
/*     */             {
/*     */               try
/*     */               {
/* 426 */                 ps.getManager().unregisterShareable();
/* 427 */                 ps.close();
/*     */               }
/*     */               catch (IOException e)
/*     */               {
/* 431 */                 log.error("Error closing bind priming socket during cleanup upon stopping", e);
/*     */               }
/*     */             }
/*     */           }
/*     */ 
/* 436 */           this.socketGroupId = this.socketGroupInfo.getSocketGroupId();
/*     */ 
/* 438 */           if (this.socketGroupId != null)
/*     */           {
/* 440 */             MultiplexServerInvoker.getSocketGroupMap().remove(this.socketGroupId);
/*     */           }
/*     */ 
/* 444 */           if (this.addressPair != null)
/*     */           {
/* 446 */             MultiplexServerInvoker.getAddressPairMap().remove(this.addressPair);
/*     */           }
/*     */         }
/*     */ 
/* 450 */         this.socketGroupInfo = null;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected InetSocketAddress getBindSocketAddress()
/*     */   {
/* 461 */     return this.bindSocketAddress;
/*     */   }
/*     */ 
/*     */   protected InetSocketAddress getConnectSocketAddress()
/*     */   {
/* 470 */     return this.connectSocketAddress;
/*     */   }
/*     */ 
/*     */   protected String getDefaultDataType()
/*     */   {
/* 483 */     return "serializable";
/*     */   }
/*     */ 
/*     */   protected Socket createSocket(String address, int port, int timeout)
/*     */     throws IOException
/*     */   {
/* 489 */     log.debug("MultiplexClientInvoker.createSocket()");
/*     */ 
/* 491 */     if (timeout < 0)
/*     */     {
/* 493 */       timeout = getTimeout();
/* 494 */       if (timeout < 0) {
/* 495 */         timeout = 0;
/*     */       }
/*     */     }
/*     */ 
/* 499 */     if ((this.socketGroupInfo != null) && (this.socketGroupInfo.getPrimingSocket() != null))
/*     */     {
/* 501 */       VirtualSocket primingSocket = this.socketGroupInfo.getPrimingSocket();
/* 502 */       if ((!primingSocket.isFunctional()) || (primingSocket.hasReceivedDisconnectMessage()))
/*     */       {
/* 504 */         log.info("Current server is inaccessible.  Will try to connect to new server");
/* 505 */         primingSocket.close();
/*     */ 
/* 508 */         if (this.bindSocketAddress != null)
/*     */         {
/* 510 */           InetAddress bindAddress = this.bindSocketAddress.getAddress();
/* 511 */           int bindPort = PortUtil.findFreePort(this.bindSocketAddress.getHostName());
/* 512 */           this.socketGroupInfo.setBindPort(bindPort);
/* 513 */           this.bindSocketAddress = new InetSocketAddress(bindAddress, bindPort);
/* 514 */           MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, this.connectHost, this.connectPort, bindAddress, bindPort, this.configuration, timeout);
/*     */         }
/*     */         else
/*     */         {
/* 520 */           MultiplexServerInvoker.createPrimingSocket(this.socketGroupInfo, this.connectHost, this.connectPort, this.configuration, port);
/*     */         }
/*     */ 
/* 524 */         MultiplexServerInvoker serverInvoker = this.socketGroupInfo.getServerInvoker();
/* 525 */         if (serverInvoker != null)
/*     */         {
/*     */           try
/*     */           {
/* 530 */             serverInvoker.stop();
/* 531 */             this.socketGroupInfo.setServerInvoker(null);
/* 532 */             serverInvoker.resetLocator(this.bindSocketAddress.getPort());
/* 533 */             serverInvoker.refreshServerSocket();
/* 534 */             serverInvoker.setup();
/* 535 */             serverInvoker.start();
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 539 */             log.error(e.getMessage(), e);
/*     */           }
/*     */         }
/*     */ 
/* 543 */         VirtualSocket socket = new VirtualSocket(this.configuration);
/* 544 */         for (int i = 0; i < 3; i++)
/*     */         {
/*     */           try
/*     */           {
/* 548 */             socket.connect(this.connectSocketAddress, this.bindSocketAddress, timeout);
/* 549 */             return socket;
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/*     */             try
/*     */             {
/* 555 */               Thread.sleep(500L);
/*     */             }
/*     */             catch (InterruptedException e1)
/*     */             {
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 565 */     VirtualSocket socket = new VirtualSocket(this.configuration);
/* 566 */     socket.connect(this.connectSocketAddress, this.bindSocketAddress, timeout);
/* 567 */     return socket;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.MultiplexClientInvoker
 * JD-Core Version:    0.6.0
 */