/*     */ package org.jboss.remoting.transport.multiplex;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.InetAddress;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketAddress;
/*     */ import java.net.SocketException;
/*     */ import java.net.SocketTimeoutException;
/*     */ import java.nio.channels.ServerSocketChannel;
/*     */ import java.nio.channels.SocketChannel;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class MasterServerSocket extends ServerSocket
/*     */   implements Serializable
/*     */ {
/*  63 */   private static final Logger log = Logger.getLogger(MasterServerSocket.class);
/*  64 */   private Map configuration = new HashMap();
/*     */   private ServerSocket ss;
/*     */   private ServerSocketChannel ssc;
/*     */   private static final long serialVersionUID = 402293949935889044L;
/*     */ 
/*     */   public MasterServerSocket()
/*     */     throws IOException
/*     */   {
/*  74 */     this(true);
/*     */   }
/*     */ 
/*     */   public MasterServerSocket(int port)
/*     */     throws IOException
/*     */   {
/*  83 */     this(true, port);
/*     */   }
/*     */ 
/*     */   public MasterServerSocket(int port, int backlog)
/*     */     throws IOException
/*     */   {
/*  93 */     this(true, port, backlog);
/*     */   }
/*     */ 
/*     */   public MasterServerSocket(int port, int backlog, InetAddress bindAddr)
/*     */     throws IOException
/*     */   {
/* 104 */     this(true, port, backlog, bindAddr);
/*     */   }
/*     */ 
/*     */   public MasterServerSocket(boolean nio)
/*     */     throws IOException
/*     */   {
/* 112 */     if (nio)
/*     */     {
/* 114 */       this.ssc = ServerSocketChannel.open();
/* 115 */       this.ss = this.ssc.socket();
/*     */     }
/*     */     else
/*     */     {
/* 119 */       this.ss = new ServerSocket();
/*     */     }
/*     */   }
/*     */ 
/*     */   public MasterServerSocket(boolean nio, int port)
/*     */     throws IOException
/*     */   {
/* 129 */     if (nio)
/*     */     {
/* 131 */       this.ssc = ServerSocketChannel.open();
/* 132 */       this.ss = this.ssc.socket();
/* 133 */       this.ss.bind(new InetSocketAddress(port));
/*     */     }
/*     */     else
/*     */     {
/* 137 */       this.ss = new ServerSocket(port);
/*     */     }
/*     */   }
/*     */ 
/*     */   public MasterServerSocket(boolean nio, int port, int backlog)
/*     */     throws IOException
/*     */   {
/* 148 */     if (nio)
/*     */     {
/* 150 */       this.ssc = ServerSocketChannel.open();
/* 151 */       this.ss = this.ssc.socket();
/* 152 */       this.ss.bind(new InetSocketAddress(port), backlog);
/*     */     }
/*     */     else
/*     */     {
/* 156 */       this.ss = new ServerSocket(port, backlog);
/*     */     }
/*     */   }
/*     */ 
/*     */   public MasterServerSocket(boolean nio, int port, int backlog, InetAddress bindAddr)
/*     */     throws IOException
/*     */   {
/* 168 */     if (nio)
/*     */     {
/* 170 */       this.ssc = ServerSocketChannel.open();
/* 171 */       this.ss = this.ssc.socket();
/* 172 */       this.ss.bind(new InetSocketAddress(bindAddr, port), backlog);
/*     */     }
/*     */     else
/*     */     {
/* 176 */       this.ss = new ServerSocket(port, backlog, bindAddr);
/*     */     }
/*     */   }
/*     */ 
/*     */   public MasterServerSocket(int port, int backlog, InetAddress bindAddr, Map conf)
/*     */     throws IOException
/*     */   {
/* 195 */     if (conf != null) {
/* 196 */       this.configuration.putAll(conf);
/*     */     }
/* 198 */     if ((conf == null) || (conf.get("multiplex.ServerSocketFactory") == null))
/*     */     {
/* 200 */       this.ssc = ServerSocketChannel.open();
/* 201 */       this.ss = this.ssc.socket();
/* 202 */       this.ss.bind(new InetSocketAddress(bindAddr, port), backlog);
/*     */     }
/*     */     else
/*     */     {
/* 206 */       Object obj = conf.get("multiplex.ServerSocketFactory");
/* 207 */       if (!(obj instanceof ServerSocketFactory))
/*     */       {
/* 209 */         String msg = "configuration map contains invalid entry for Multiplex.SERVER_SOCKET_FACTORY: " + obj;
/* 210 */         log.error(msg);
/* 211 */         throw new IOException(msg);
/*     */       }
/* 213 */       ServerSocketFactory ssf = (ServerSocketFactory)obj;
/* 214 */       this.ss = ssf.createServerSocket(port, backlog, bindAddr);
/*     */     }
/*     */   }
/*     */ 
/*     */   public MasterServerSocket(ServerSocketFactory ssf)
/*     */     throws IOException
/*     */   {
/* 225 */     this.ss = ssf.createServerSocket();
/*     */   }
/*     */ 
/*     */   public MasterServerSocket(ServerSocketFactory ssf, int port)
/*     */     throws IOException
/*     */   {
/* 236 */     this.ss = ssf.createServerSocket(port);
/*     */   }
/*     */ 
/*     */   public MasterServerSocket(ServerSocketFactory ssf, int port, int backlog)
/*     */     throws IOException
/*     */   {
/* 248 */     this.ss = ssf.createServerSocket(port, backlog);
/*     */   }
/*     */ 
/*     */   public MasterServerSocket(ServerSocketFactory ssf, int port, int backlog, InetAddress bindAddr)
/*     */     throws IOException
/*     */   {
/* 262 */     this.ss = ssf.createServerSocket(port, backlog, bindAddr); } 
/* 297 */   public Socket accept() throws IOException { long start = System.currentTimeMillis();
/* 298 */     int timeout = getSoTimeout();
/* 299 */     int savedTimeout = timeout;
/* 300 */     int timeLeft = 0;
/* 301 */     Socket socket = null;
/* 302 */     SocketTimeoutException savedException = null;
/*     */     MultiplexingManager manager;
/*     */     Protocol protocol;
/*     */     SocketId clientPort;
/*     */     while (true) { if ((timeout > 0) && 
/* 307 */         ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0)) {
/* 308 */         throw new SocketTimeoutException("Accept timed out");
/*     */       }
/* 310 */       setSoTimeout(timeLeft);
/*     */       try
/*     */       {
/* 314 */         socket = this.ss.accept();
/*     */       }
/*     */       catch (SocketTimeoutException e)
/*     */       {
/* 319 */         savedException = new SocketTimeoutException("Accept timed out");
/* 320 */         throw savedException;
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 326 */           setSoTimeout(savedTimeout);
/*     */         }
/*     */         catch (Exception e) {
/*     */         }
/* 330 */         if (savedException != null) {
/* 331 */           throw savedException;
/*     */         }
/*     */       }
/* 334 */       manager = MultiplexingManager.getaManager(socket, this.configuration);
/* 335 */       MultiplexingInputStream is = null;
/* 336 */       protocol = null;
/* 337 */       clientPort = null;
/*     */       try
/*     */       {
/* 341 */         is = manager.getAnInputStream(SocketId.SERVER_SOCKET_ID, null);
/* 342 */         protocol = manager.getProtocol();
/*     */ 
/* 344 */         if ((timeout > 0) && 
/* 345 */           ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0)) {
/* 346 */           throw new SocketTimeoutException("Accept timed out");
/*     */         }
/* 348 */         clientPort = protocol.acceptConnect(is, timeLeft);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 352 */         log.error("i/o exception in MasterServerSocket.accept()");
/* 353 */         manager.decrementReferences();
/* 354 */         throw e;
/*     */       }
/*     */ 
/* 357 */       if (log.isDebugEnabled()) {
/* 358 */         log.debug("accept(): clientPort:  " + clientPort.getPort());
/*     */       }
/*     */ 
/* 361 */       if (clientPort.getPort() >= 0)
/*     */         break;
/* 363 */       MultiplexingOutputStream os = new MultiplexingOutputStream(manager, SocketId.SERVER_SOCKET_CONNECT_ID);
/*     */       try
/*     */       {
/* 367 */         protocol.answerConnect(os, -3);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 372 */         log.error("unable to respond to connect request");
/* 373 */         manager.decrementReferences();
/*     */ 
/* 375 */         if ((e instanceof SocketTimeoutException)) {
/* 376 */           throw new SocketTimeoutException("Accept timed out");
/*     */         }
/* 378 */         throw e;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 385 */     VirtualSocket virtualSocket = null;
/*     */     try
/*     */     {
/* 389 */       virtualSocket = new VirtualSocket(manager, clientPort, this.configuration);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 393 */       manager.decrementReferences();
/* 394 */       throw e;
/*     */     }
/*     */ 
/* 397 */     int localPort = virtualSocket.getLocalVirtualPort();
/*     */     try
/*     */     {
/* 401 */       protocol.answerConnect((MultiplexingOutputStream)virtualSocket.getOutputStream(), localPort);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 406 */       log.error("unable to respond to connect request");
/* 407 */       virtualSocket.close();
/* 408 */       throw e;
/*     */     }
/*     */ 
/* 411 */     return virtualSocket;
/*     */   }
/*     */ 
/*     */   public void bind(SocketAddress endpoint)
/*     */     throws IOException
/*     */   {
/* 421 */     this.ss.bind(endpoint);
/*     */   }
/*     */ 
/*     */   public void bind(SocketAddress endpoint, int backlog)
/*     */     throws IOException
/*     */   {
/* 430 */     this.ss.bind(endpoint, backlog);
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 439 */     log.debug("MasterServerSocket: closing");
/* 440 */     this.ss.close();
/*     */   }
/*     */ 
/*     */   public ServerSocketChannel getChannel()
/*     */   {
/* 448 */     return this.ss.getChannel();
/*     */   }
/*     */ 
/*     */   public InetAddress getInetAddress()
/*     */   {
/* 457 */     return this.ss.getInetAddress();
/*     */   }
/*     */ 
/*     */   public int getLocalPort()
/*     */   {
/* 466 */     return this.ss.getLocalPort();
/*     */   }
/*     */ 
/*     */   public SocketAddress getLocalSocketAddress()
/*     */   {
/* 475 */     return this.ss.getLocalSocketAddress();
/*     */   }
/*     */ 
/*     */   public int getReceiveBufferSize()
/*     */     throws SocketException
/*     */   {
/* 484 */     return this.ss.getReceiveBufferSize();
/*     */   }
/*     */ 
/*     */   public boolean getReuseAddress()
/*     */     throws SocketException
/*     */   {
/* 493 */     return this.ss.getReuseAddress();
/*     */   }
/*     */ 
/*     */   public int getSoTimeout()
/*     */     throws IOException
/*     */   {
/* 502 */     return this.ss.getSoTimeout();
/*     */   }
/*     */ 
/*     */   public boolean isBound()
/*     */   {
/* 511 */     return this.ss.isBound();
/*     */   }
/*     */ 
/*     */   public boolean isClosed()
/*     */   {
/* 520 */     return this.ss.isClosed();
/*     */   }
/*     */ 
/*     */   public void setReceiveBufferSize(int size)
/*     */     throws SocketException
/*     */   {
/* 529 */     this.ss.setReceiveBufferSize(size);
/*     */   }
/*     */ 
/*     */   public void setReuseAddress(boolean on)
/*     */     throws SocketException
/*     */   {
/* 538 */     this.ss.setReuseAddress(on);
/*     */   }
/*     */ 
/*     */   public void setSoTimeout(int timeout)
/*     */     throws SocketException
/*     */   {
/* 547 */     this.ss.setSoTimeout(timeout);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 556 */     if (!isBound()) {
/* 557 */       return "MasterServerSocket[unbound]";
/*     */     }
/* 559 */     return "MasterServerSocket[" + this.ss.toString() + "]";
/*     */   }
/*     */ 
/*     */   public int acceptServerSocketConnection()
/*     */     throws IOException
/*     */   {
/* 572 */     long start = System.currentTimeMillis();
/* 573 */     int timeout = getSoTimeout();
/* 574 */     int savedTimeout = timeout;
/* 575 */     int timeLeft = 0;
/*     */ 
/* 578 */     Socket socket = null;
/*     */ 
/* 580 */     if (this.ssc == null)
/* 581 */       socket = this.ss.accept();
/*     */     else {
/* 583 */       socket = this.ssc.accept().socket();
/*     */     }
/* 585 */     MultiplexingManager manager = MultiplexingManager.getaManager(socket, this.configuration);
/* 586 */     manager.setCreatedForRemoteServerSocket();
/* 587 */     MultiplexingInputStream is = null;
/* 588 */     Protocol protocol = null;
/* 589 */     SocketId clientPort = null;
/*     */     try
/*     */     {
/* 593 */       is = manager.getAnInputStream(SocketId.SERVER_SOCKET_ID, null);
/* 594 */       protocol = manager.getProtocol();
/*     */ 
/* 596 */       if ((timeout > 0) && 
/* 597 */         ((timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0)) {
/* 598 */         throw new SocketTimeoutException("Accept timed out");
/*     */       }
/* 600 */       clientPort = protocol.acceptConnect(is, timeLeft);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 604 */       log.error("i/o exception in MasterServerSocket.acceptServerSocketConnection()", e);
/* 605 */       manager.decrementReferences();
/*     */ 
/* 607 */       if ((e instanceof SocketTimeoutException)) {
/* 608 */         throw new SocketTimeoutException("Accept timed out");
/*     */       }
/* 610 */       throw e;
/*     */     }
/*     */ 
/* 613 */     if (clientPort.getPort() != -2)
/*     */     {
/* 615 */       manager.decrementReferences();
/* 616 */       String message = "received connect request not from a VirtualServerSocket";
/* 617 */       log.error(message);
/* 618 */       throw new IOException(message);
/*     */     }
/*     */ 
/* 621 */     MultiplexingOutputStream os = new MultiplexingOutputStream(manager, SocketId.SERVER_SOCKET_CONNECT_ID);
/*     */     try
/*     */     {
/* 625 */       protocol.answerConnect(os, -3);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 630 */       log.error("unable to respond to connect request");
/* 631 */       manager.decrementReferences();
/* 632 */       throw e;
/*     */     }
/*     */ 
/* 635 */     return manager.getSocket().getLocalPort();
/*     */   }
/*     */ 
/*     */   public void setConfiguration(Map configuration)
/*     */   {
/* 641 */     this.configuration.putAll(configuration);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.MasterServerSocket
 * JD-Core Version:    0.6.0
 */