/*     */ package org.jboss.remoting.transport.http.ssl;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.UnknownHostException;
/*     */ import javax.net.ssl.HandshakeCompletedListener;
/*     */ import javax.net.ssl.SSLSocket;
/*     */ import javax.net.ssl.SSLSocketFactory;
/*     */ import org.jboss.remoting.util.socket.HandshakeRepeater;
/*     */ 
/*     */ public class HTTPSSocketFactory extends SSLSocketFactory
/*     */ {
/*  44 */   private SSLSocketFactory targetFactory = null;
/*  45 */   private HandshakeCompletedListener targetListener = null;
/*     */ 
/*     */   public HTTPSSocketFactory(SSLSocketFactory socketFactory, HandshakeCompletedListener listener)
/*     */   {
/*  49 */     this.targetFactory = socketFactory;
/*  50 */     this.targetListener = listener;
/*  51 */     if (this.targetFactory == null)
/*     */     {
/*  53 */       throw new RuntimeException("Can not create HTTPSSocketFactory with target SSLSocketFactory being null.");
/*     */     }
/*  55 */     if (this.targetListener == null)
/*     */     {
/*  57 */       throw new RuntimeException("Can not create HTTPSSocketFactory with target HandshakeCompletedListener being null.");
/*     */     }
/*     */   }
/*     */ 
/*     */   public String[] getDefaultCipherSuites()
/*     */   {
/*  63 */     return this.targetFactory.getDefaultCipherSuites();
/*     */   }
/*     */ 
/*     */   public String[] getSupportedCipherSuites()
/*     */   {
/*  68 */     return this.targetFactory.getSupportedCipherSuites();
/*     */   }
/*     */ 
/*     */   public Socket createSocket(Socket socket, String string, int i, boolean b) throws IOException
/*     */   {
/*  73 */     Socket retSocket = this.targetFactory.createSocket(socket, string, i, b);
/*     */ 
/*  75 */     if ((retSocket instanceof SSLSocket))
/*     */     {
/*  77 */       establishHandshake((SSLSocket)retSocket, this.targetListener);
/*     */     }
/*     */ 
/*  80 */     return retSocket;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String string, int i) throws IOException, UnknownHostException
/*     */   {
/*  85 */     Socket retSocket = this.targetFactory.createSocket(string, i);
/*     */ 
/*  87 */     if ((retSocket instanceof SSLSocket))
/*     */     {
/*  89 */       establishHandshake((SSLSocket)retSocket, this.targetListener);
/*     */     }
/*     */ 
/*  92 */     return retSocket;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress inetAddress, int i) throws IOException
/*     */   {
/*  97 */     Socket retSocket = this.targetFactory.createSocket(inetAddress, i);
/*     */ 
/*  99 */     if ((retSocket instanceof SSLSocket))
/*     */     {
/* 101 */       establishHandshake((SSLSocket)retSocket, this.targetListener);
/*     */     }
/*     */ 
/* 104 */     return retSocket;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String string, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException
/*     */   {
/* 109 */     Socket retSocket = this.targetFactory.createSocket(string, i, inetAddress, i1);
/*     */ 
/* 111 */     if ((retSocket instanceof SSLSocket))
/*     */     {
/* 113 */       establishHandshake((SSLSocket)retSocket, this.targetListener);
/*     */     }
/*     */ 
/* 116 */     return retSocket;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException
/*     */   {
/* 121 */     Socket retSocket = this.targetFactory.createSocket(inetAddress, i, inetAddress1, i1);
/*     */ 
/* 123 */     if ((retSocket instanceof SSLSocket))
/*     */     {
/* 125 */       establishHandshake((SSLSocket)retSocket, this.targetListener);
/*     */     }
/*     */ 
/* 128 */     return retSocket;
/*     */   }
/*     */ 
/*     */   private void establishHandshake(SSLSocket sslSocket, HandshakeCompletedListener listener)
/*     */     throws IOException
/*     */   {
/* 134 */     HandshakeRepeater repeater = new HandshakeRepeater(listener);
/* 135 */     sslSocket.addHandshakeCompletedListener(repeater);
/* 136 */     sslSocket.getSession();
/* 137 */     repeater.waitForHandshake();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.http.ssl.HTTPSSocketFactory
 * JD-Core Version:    0.6.0
 */