/*     */ package org.jboss.remoting.transport.http.ssl;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.net.HttpURLConnection;
/*     */ import java.util.Map;
/*     */ import javax.net.SocketFactory;
/*     */ import javax.net.ssl.HandshakeCompletedListener;
/*     */ import javax.net.ssl.HostnameVerifier;
/*     */ import javax.net.ssl.HttpsURLConnection;
/*     */ import javax.net.ssl.SSLSession;
/*     */ import javax.net.ssl.SSLSocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.security.CustomSSLSocketFactory;
/*     */ import org.jboss.remoting.security.SSLSocketBuilder;
/*     */ import org.jboss.remoting.security.SSLSocketBuilderMBean;
/*     */ import org.jboss.remoting.serialization.ClassLoaderUtility;
/*     */ import org.jboss.remoting.socketfactory.SocketFactoryWrapper;
/*     */ import org.jboss.remoting.transport.http.HTTPClientInvoker;
/*     */ 
/*     */ public class HTTPSClientInvoker extends HTTPClientInvoker
/*     */ {
/*     */   public static final String IGNORE_HTTPS_HOST = "org.jboss.security.ignoreHttpsHost";
/*     */   public static final String HOSTNAME_VERIFIER = "hostnameVerifier";
/*     */ 
/*     */   public HTTPSClientInvoker(InvokerLocator locator)
/*     */   {
/*  58 */     super(locator);
/*     */   }
/*     */ 
/*     */   public HTTPSClientInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/*  63 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   protected String validateURL(String url)
/*     */   {
/*  68 */     String validatedUrl = url;
/*     */ 
/*  70 */     if (validatedUrl.startsWith("servlet"))
/*     */     {
/*  73 */       validatedUrl = "http" + validatedUrl.substring("servlet".length());
/*     */     }
/*  75 */     else if (validatedUrl.startsWith("sslservlet"))
/*     */     {
/*  78 */       validatedUrl = "https" + validatedUrl.substring("sslservlet".length());
/*     */     }
/*  80 */     return validatedUrl;
/*     */   }
/*     */ 
/*     */   protected HttpURLConnection createURLConnection(String url, Map metadata)
/*     */     throws IOException
/*     */   {
/*  93 */     HttpURLConnection conn = super.createURLConnection(url, metadata);
/*     */ 
/*  95 */     if ((conn instanceof HttpsURLConnection))
/*     */     {
/*  97 */       HttpsURLConnection sconn = (HttpsURLConnection)conn;
/*     */ 
/*  99 */       SocketFactory socketFactory = getSocketFactory();
/* 100 */       if ((socketFactory != null) && ((socketFactory instanceof SSLSocketFactory)))
/*     */       {
/* 102 */         SSLSocketFactory sslSocketFactory = getHandshakeCompatibleFactory((SSLSocketFactory)socketFactory, metadata);
/* 103 */         sconn.setSSLSocketFactory(sslSocketFactory);
/*     */       }
/*     */ 
/* 106 */       setHostnameVerifier(sconn, metadata);
/*     */     }
/*     */ 
/* 109 */     return conn;
/*     */   }
/*     */ 
/*     */   private SSLSocketFactory getHandshakeCompatibleFactory(SSLSocketFactory socketFactory, Map metadata)
/*     */   {
/* 114 */     SSLSocketFactory sslSocketFactory = socketFactory;
/*     */ 
/* 117 */     Object obj = this.configuration.get("handshakeCompletedListener");
/* 118 */     if ((obj != null) && ((obj instanceof HandshakeCompletedListener)))
/*     */     {
/* 120 */       HandshakeCompletedListener listener = (HandshakeCompletedListener)obj;
/* 121 */       sslSocketFactory = new HTTPSSocketFactory(socketFactory, listener);
/*     */     }
/* 123 */     return sslSocketFactory;
/*     */   }
/*     */ 
/*     */   protected SocketFactory createSocketFactory(Map configuration)
/*     */   {
/* 129 */     SocketFactory sf = super.createSocketFactory(configuration);
/*     */ 
/* 131 */     if (isCompleteSocketFactory(sf)) {
/* 132 */       return sf;
/*     */     }
/* 134 */     SocketFactory wrapper = sf;
/*     */     try
/*     */     {
/* 138 */       SSLSocketBuilder server = new SSLSocketBuilder(configuration);
/* 139 */       server.setUseSSLSocketFactory(false);
/* 140 */       sf = server.createSSLSocketFactory();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 144 */       log.error("Error creating SSL Socket Factory for client invoker.", e);
/*     */     }
/*     */ 
/* 147 */     if (wrapper != null)
/*     */     {
/* 149 */       ((SocketFactoryWrapper)wrapper).setSocketFactory(sf);
/* 150 */       return wrapper;
/*     */     }
/*     */ 
/* 153 */     return sf;
/*     */   }
/*     */ 
/*     */   protected void setHostnameVerifier(HttpsURLConnection conn, Map metadata)
/*     */   {
/* 158 */     HostnameVerifier hostnameVerifier = null;
/*     */ 
/* 161 */     String hostnameVerifierString = (String)metadata.get("hostnameVerifier");
/* 162 */     if ((hostnameVerifierString == null) || (hostnameVerifierString.length() == 0))
/* 163 */       hostnameVerifierString = (String)this.configuration.get("hostnameVerifier");
/* 164 */     if ((hostnameVerifierString != null) && (hostnameVerifierString.length() > 0))
/*     */     {
/*     */       try
/*     */       {
/* 168 */         Class cl = ClassLoaderUtility.loadClass(hostnameVerifierString, getClass());
/* 169 */         Constructor constructor = cl.getConstructor(new Class[0]);
/* 170 */         hostnameVerifier = (HostnameVerifier)constructor.newInstance(new Object[0]);
/* 171 */         log.trace("HostnameVerifier (" + hostnameVerifierString + ") loaded");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 175 */         log.debug("Could not create server socket factory by classname (" + hostnameVerifierString + ").  Error message: " + e.getMessage());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 180 */     if (hostnameVerifier == null)
/*     */     {
/* 182 */       boolean ignoreHTTPSHost = Boolean.getBoolean("org.jboss.security.ignoreHttpsHost");
/* 183 */       String ignoreHost = (String)metadata.get("org.jboss.security.ignoreHttpsHost");
/* 184 */       if ((ignoreHost != null) && (ignoreHost.length() > 0))
/*     */       {
/* 186 */         ignoreHTTPSHost = Boolean.valueOf(ignoreHost).booleanValue();
/*     */       }
/*     */       else
/*     */       {
/* 190 */         ignoreHost = (String)this.configuration.get("org.jboss.security.ignoreHttpsHost");
/* 191 */         if ((ignoreHost != null) && (ignoreHost.length() > 0))
/*     */         {
/* 193 */           ignoreHTTPSHost = Boolean.valueOf(ignoreHost).booleanValue();
/*     */         }
/*     */       }
/* 196 */       if (ignoreHTTPSHost)
/*     */       {
/* 198 */         hostnameVerifier = new AnyhostVerifier();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 205 */     if (hostnameVerifier == null)
/*     */     {
/* 207 */       if ((getSocketFactory() instanceof CustomSSLSocketFactory))
/*     */       {
/* 209 */         CustomSSLSocketFactory sf = (CustomSSLSocketFactory)getSocketFactory();
/* 210 */         SSLSocketBuilderMBean builder = sf.getSSLSocketBuilder();
/* 211 */         if (((builder.isSocketUseClientMode()) && (!builder.isServerAuthMode())) || ((!builder.isSocketUseClientMode()) && (builder.isClientAuthModeNone())))
/*     */         {
/* 213 */           hostnameVerifier = new AnyhostVerifier();
/*     */         }
/*     */       }
/*     */     }
/* 217 */     if (hostnameVerifier != null)
/* 218 */       conn.setHostnameVerifier(hostnameVerifier);
/*     */   }
/*     */ 
/*     */   protected class AnyhostVerifier implements HostnameVerifier {
/*     */     protected AnyhostVerifier() {
/*     */     }
/*     */ 
/*     */     public boolean verify(String s, SSLSession sslSession) {
/* 226 */       return true;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.http.ssl.HTTPSClientInvoker
 * JD-Core Version:    0.6.0
 */